/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.utils;

import java.io.File;
import java.util.List;

public class JARFinder {
	
	public static void searchDir(List paths, File file) {
		searchDir(paths,file,".jar",0,4);
	}
	public static void searchDir(List paths, File file, String extension, int max_depth) {
		searchDir(paths,file,extension,0,max_depth);
	}
	
	private static void searchDir(List paths, File file, String extension, int depth, int MAXDEPTH) {
		if (file.isDirectory()) {
			if (depth < MAXDEPTH) {
				File[] sub = file.listFiles();
				for (int i = 0; i < sub.length; i++) {
					searchDir(paths,sub[i],extension,depth+1,MAXDEPTH);	
				}
			}
		} else {
			if (file.getName().toLowerCase().endsWith(extension)) {
				paths.add(file.getAbsolutePath());	
			}
		}
	}
	
}