/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.delete.operations;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.infrastructure.operations.AbstractScribblerOperation;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.Reference;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class DeleteReferenceOperation
extends AbstractScribblerOperation {
    public DeleteReferenceOperation(IDataModel model) {
        super(model);
    }

    protected IStatus doExecute(IProgressMonitor monitor) throws ExecutionException {
        ComponentType cType = (ComponentType)this.model.getProperty("IDeleteReferenceDataModelProperties.COMPONENT_TYPE");
        if (this.model.isPropertySet("IDeleteReferenceDataModelProperties.REFERENCE_NAMES") && this.model.isPropertySet("IDeleteReferenceDataModelProperties.COMPONENT_TYPE")) {
            List references = cType.getReferences();
            if (references.isEmpty()) {
                return OK_STATUS;
            }
            String[] referenceNames = (String[])this.model.getProperty("IDeleteReferenceDataModelProperties.REFERENCE_NAMES");
            Assert.isTrue((references.size() >= referenceNames.length ? 1 : 0) != 0);
            int i = 0;
            while (i < referenceNames.length) {
                Reference reference = null;
                int referenceIndex = 0;
                while (referenceIndex < references.size()) {
                    reference = (Reference)references.get(referenceIndex);
                    if (reference.getName().equals(referenceNames[i])) break;
                    reference = null;
                    ++referenceIndex;
                }
                if (reference != null) {
                    cType.getReferences().remove(reference);
                }
                ++i;
            }
        }
        return OK_STATUS;
    }

    protected IStatus doRedo(IProgressMonitor monitor) throws ExecutionException {
        return null;
    }

    protected IStatus doUndo(IProgressMonitor monitor) throws ExecutionException {
        return null;
    }
}

