/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.internal.introspection.query;

import java.util.Iterator;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stp.core.internal.introspection.AttributeSet;

public class AttributesExpression extends CombinedQuery implements IModelQuery {

   private AttributeSet expectedAttributes;

   public AttributesExpression(AttributeSet theExpectedAttributes) {
      expectedAttributes = theExpectedAttributes;
   }

   public boolean matches(EObject anObject) {
      Object attrdata = null;
      EAttribute[] uniqueAttributes = expectedAttributes.uniqueKeys();
      for (int i = 0; i < uniqueAttributes.length; i++) {
         attrdata = expectedAttributes.getValue(uniqueAttributes[i]);
         if (!attrdata.equals(anObject.eGet(uniqueAttributes[i])))
            return false;
      }
      return matchesChildren(anObject);
   }

   public boolean applyDelta(EObject anObject) {
      EAttribute attr = null;
      Object attrdata = null;
      for (Iterator attrItr = expectedAttributes.iterator(); attrItr.hasNext();) {
         attr = (EAttribute) attrItr.next();
         if (attr.getEContainingClass().equals(anObject.eClass())) {
            attrdata = expectedAttributes.getValue(attr);
            if (!anObject.eIsSet(attr) || !attrdata.equals(anObject.eGet(attr)))
               anObject.eSet(attr, attrdata);
            // getUntouchedElements(anObject).remove(attr);
         } else
            return false;
      }
      return applyChildrenDelta(anObject);
   }

   public String toString() {

      StringBuffer toString = new StringBuffer(" has attributes: { "); //$NON-NLS-1$

      EAttribute attr = null;
      for (Iterator attrItr = expectedAttributes.iterator(); attrItr.hasNext();) {
         attr = (EAttribute) attrItr.next();
         toString
               .append(attr.getName())
               .append("=").append(expectedAttributes.getValue(attr)).append(", "); //$NON-NLS-1$ //$NON-NLS-2$
      }
      toString.append("}"); //$NON-NLS-1$
      return toString
            .append("\n\t[").append(super.toString()).append("]").toString(); //$NON-NLS-1$ //$NON-NLS-2$

   }
}
