/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.sca.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.introspection.FeatureAdapter;
import org.eclipse.stp.core.sca.SCAObject;

public class FeatureAwareList implements EList {

   private final EStructuralFeature  abstractFeature;

   private final FeatureMap.Internal featureMap;

   private final EList               modelList;

   public FeatureAwareList(EStructuralFeature anAbstractFeature,
         FeatureMap.Internal aFeatureMap) {
      abstractFeature = anAbstractFeature;
      featureMap = aFeatureMap;
      modelList = featureMap.list(abstractFeature);
   }

   public void add(int index, Object o) {

      Assert.isTrue(o instanceof SCAObject);
      SCAObject scaObj = (SCAObject) o;

      EStructuralFeature subfeature = FeatureAdapter.getFeature(scaObj);
      Assert.isNotNull(subfeature);

      featureMap.list(subfeature).add(index, scaObj);
   }

   public boolean add(Object o) {
      Assert.isTrue(o instanceof SCAObject);
      SCAObject scaObj = (SCAObject) o;

      EStructuralFeature subfeature = FeatureAdapter.getFeature(scaObj);
      Assert.isNotNull(subfeature);

      return featureMap.list(subfeature).add(scaObj);
   }

   public boolean addAll(Collection c) {
      return addAll(0, c);
   }

   public boolean addAll(int index, Collection c) {

      int initialSize = featureMap.size();
      for (Iterator itr = c.iterator(); itr.hasNext();) {
         Object o = itr.next();
         Assert.isTrue(o instanceof SCAObject);
         SCAObject scaObj = (SCAObject) o;

         EStructuralFeature subfeature = FeatureAdapter.getFeature(scaObj);
         Assert.isNotNull(subfeature);

         featureMap.list(subfeature).add(index,
               Collections.singletonList(scaObj));
      }
      return featureMap.size() > initialSize;
   }

   public void clear() {
      modelList.clear();
   }

   public boolean contains(Object o) {
      return modelList.contains(o);
   }

   public boolean containsAll(Collection c) {
      return modelList.containsAll(c);
   }

   public boolean equals(Object o) {
      return modelList.equals(o);
   }

   public Object get(int index) {
      return modelList.get(index);
   }

   public int hashCode() {
      return modelList.hashCode();
   }

   public int indexOf(Object o) {
      return modelList.indexOf(o);
   }

   public boolean isEmpty() {
      return modelList.isEmpty();
   }

   public Iterator iterator() {
      return modelList.iterator();
   }

   public int lastIndexOf(Object o) {
      return modelList.lastIndexOf(o);
   }

   public ListIterator listIterator() {
      return modelList.listIterator();
   }

   public ListIterator listIterator(int index) {
      return modelList.listIterator(index);
   }

   public Object remove(int index) {
      return modelList.remove(index);
   }

   public boolean remove(Object o) {
      return modelList.remove(o);
   }

   public boolean removeAll(Collection c) {
      return modelList.removeAll(c);
   }

   public boolean retainAll(Collection c) {
      return modelList.retainAll(c);
   }

   public Object set(int index, Object element) {
      return modelList.set(index, element);
   }

   public int size() {
      return modelList.size();
   }

   public List subList(int fromIndex, int toIndex) {
      return modelList.subList(fromIndex, toIndex);
   }

   public Object[] toArray() {
      return modelList.toArray();
   }

   public Object[] toArray(Object[] a) {
      return modelList.toArray(a);
   }

   public void move(int newPosition, Object object) {
      modelList.move(newPosition, object);
   }

   public Object move(int newPosition, int oldPosition) {
      return modelList.move(newPosition, oldPosition);
   }
}
