/**
 * <copyright> </copyright>
 * 
 * $Id: ReferenceValuesSetImpl.java,v 1.2 2006/04/05 14:26:12 melder Exp $
 */
package org.eclipse.stp.core.sca.impl;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.stp.core.internal.sca.SCAInternalObjectImpl;
import org.eclipse.stp.core.sca.Component;
import org.eclipse.stp.core.sca.ReferenceValue;
import org.eclipse.stp.core.sca.ReferenceValuesSet;
import org.eclipse.stp.core.sca.SCAPackage;

/**
 * <!-- begin-user-doc --> An implementation of the model object '<em><b>Reference Values Set</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>{@link org.eclipse.stp.core.sca.impl.ReferenceValuesSetImpl#getReferenceValues <em>Reference Values</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.ReferenceValuesSetImpl#getAnyAttribute <em>Any Attribute</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.ReferenceValuesSetImpl#getComponent <em>Component</em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 */
public class ReferenceValuesSetImpl extends SCAInternalObjectImpl implements
      ReferenceValuesSet {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public static final String copyright       = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * The cached value of the '{@link #getReferenceValues() <em>Reference Values</em>}'
    * containment reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getReferenceValues()
    * @generated
    * @ordered
    */
   protected EList            referenceValues = null;

   /**
    * The cached value of the '{@link #getAnyAttribute() <em>Any Attribute</em>}'
    * attribute list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getAnyAttribute()
    * @generated
    * @ordered
    */
   protected FeatureMap       anyAttribute    = null;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected ReferenceValuesSetImpl() {
      super();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected EClass eStaticClass() {
      return SCAPackage.eINSTANCE.getReferenceValuesSet();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public List getReferenceValues() {
      if (referenceValues == null) {
         referenceValues = new EObjectContainmentWithInverseEList(
               ReferenceValue.class, this,
               SCAPackage.REFERENCE_VALUES_SET__REFERENCE_VALUES,
               SCAPackage.REFERENCE_VALUE__REFERENCE_VALUE_SET);
      }
      return referenceValues;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public FeatureMap getAnyAttribute() {
      if (anyAttribute == null) {
         anyAttribute = new BasicFeatureMap(this,
               SCAPackage.REFERENCE_VALUES_SET__ANY_ATTRIBUTE);
      }
      return anyAttribute;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Component getComponent() {
      if (eContainerFeatureID != SCAPackage.REFERENCE_VALUES_SET__COMPONENT)
         return null;
      return (Component) eContainer;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setComponent(Component newComponent) {
      if (newComponent != eContainer
            || (eContainerFeatureID != SCAPackage.REFERENCE_VALUES_SET__COMPONENT && newComponent != null)) {
         if (EcoreUtil.isAncestor(this, (EObject) newComponent))
            throw new IllegalArgumentException(
                  "Recursive containment not allowed for " + toString()); //$NON-NLS-1$
         NotificationChain msgs = null;
         if (eContainer != null)
            msgs = eBasicRemoveFromContainer(msgs);
         if (newComponent != null)
            msgs = ((InternalEObject) newComponent).eInverseAdd(this,
                  SCAPackage.COMPONENT__REFERENCE_VALUES_SET, Component.class,
                  msgs);
         msgs = eBasicSetContainer((InternalEObject) newComponent,
               SCAPackage.REFERENCE_VALUES_SET__COMPONENT, msgs);
         if (msgs != null)
            msgs.dispatch();
      } else if (eNotificationRequired())
         eNotify(new ENotificationImpl(this, Notification.SET,
               SCAPackage.REFERENCE_VALUES_SET__COMPONENT, newComponent,
               newComponent));
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain eInverseAdd(InternalEObject otherEnd,
         int featureID, Class baseClass, NotificationChain msgs) {
      if (featureID >= 0) {
         switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
            case SCAPackage.REFERENCE_VALUES_SET__REFERENCE_VALUES:
               return ((InternalEList) getReferenceValues()).basicAdd(otherEnd,
                     msgs);
            case SCAPackage.REFERENCE_VALUES_SET__COMPONENT:
               if (eContainer != null)
                  msgs = eBasicRemoveFromContainer(msgs);
               return eBasicSetContainer(otherEnd,
                     SCAPackage.REFERENCE_VALUES_SET__COMPONENT, msgs);
            default:
               return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
         }
      }
      if (eContainer != null)
         msgs = eBasicRemoveFromContainer(msgs);
      return eBasicSetContainer(otherEnd, featureID, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain eInverseRemove(InternalEObject otherEnd,
         int featureID, Class baseClass, NotificationChain msgs) {
      if (featureID >= 0) {
         switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
            case SCAPackage.REFERENCE_VALUES_SET__REFERENCE_VALUES:
               return ((InternalEList) getReferenceValues()).basicRemove(
                     otherEnd, msgs);
            case SCAPackage.REFERENCE_VALUES_SET__ANY_ATTRIBUTE:
               return ((InternalEList) getAnyAttribute()).basicRemove(otherEnd,
                     msgs);
            case SCAPackage.REFERENCE_VALUES_SET__COMPONENT:
               return eBasicSetContainer(null,
                     SCAPackage.REFERENCE_VALUES_SET__COMPONENT, msgs);
            default:
               return eDynamicInverseRemove(otherEnd, featureID, baseClass,
                     msgs);
         }
      }
      return eBasicSetContainer(null, featureID, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
      if (eContainerFeatureID >= 0) {
         switch (eContainerFeatureID) {
            case SCAPackage.REFERENCE_VALUES_SET__COMPONENT:
               return eContainer.eInverseRemove(this,
                     SCAPackage.COMPONENT__REFERENCE_VALUES_SET,
                     Component.class, msgs);
            default:
               return eDynamicBasicRemoveFromContainer(msgs);
         }
      }
      return eContainer.eInverseRemove(this, EOPPOSITE_FEATURE_BASE
            - eContainerFeatureID, null, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Object eGet(EStructuralFeature eFeature, boolean resolve) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.REFERENCE_VALUES_SET__REFERENCE_VALUES:
            return getReferenceValues();
         case SCAPackage.REFERENCE_VALUES_SET__ANY_ATTRIBUTE:
            return getAnyAttribute();
         case SCAPackage.REFERENCE_VALUES_SET__COMPONENT:
            return getComponent();
      }
      return eDynamicGet(eFeature, resolve);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void eSet(EStructuralFeature eFeature, Object newValue) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.REFERENCE_VALUES_SET__REFERENCE_VALUES:
            getReferenceValues().clear();
            getReferenceValues().addAll((Collection) newValue);
            return;
         case SCAPackage.REFERENCE_VALUES_SET__ANY_ATTRIBUTE:
            getAnyAttribute().clear();
            getAnyAttribute().addAll((Collection) newValue);
            return;
         case SCAPackage.REFERENCE_VALUES_SET__COMPONENT:
            setComponent((Component) newValue);
            return;
      }
      eDynamicSet(eFeature, newValue);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void eUnset(EStructuralFeature eFeature) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.REFERENCE_VALUES_SET__REFERENCE_VALUES:
            getReferenceValues().clear();
            return;
         case SCAPackage.REFERENCE_VALUES_SET__ANY_ATTRIBUTE:
            getAnyAttribute().clear();
            return;
         case SCAPackage.REFERENCE_VALUES_SET__COMPONENT:
            setComponent((Component) null);
            return;
      }
      eDynamicUnset(eFeature);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean eIsSet(EStructuralFeature eFeature) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.REFERENCE_VALUES_SET__REFERENCE_VALUES:
            return referenceValues != null && !referenceValues.isEmpty();
         case SCAPackage.REFERENCE_VALUES_SET__ANY_ATTRIBUTE:
            return anyAttribute != null && !anyAttribute.isEmpty();
         case SCAPackage.REFERENCE_VALUES_SET__COMPONENT:
            return getComponent() != null;
      }
      return eDynamicIsSet(eFeature);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public String toString() {
      if (eIsProxy())
         return super.toString();

      StringBuffer result = new StringBuffer(super.toString());
      result.append(" (anyAttribute: "); //$NON-NLS-1$
      result.append(anyAttribute);
      result.append(')');
      return result.toString();
   }

} // ReferenceValuesSetImpl
