/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.saf.handler;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.stp.core.internal.operations.BindingDeletionDataModelProvider;
import org.eclipse.stp.core.internal.operations.IBindingDeletionDataModelProperties;
import org.eclipse.stp.core.internal.saf.impl.Messages;
import org.eclipse.stp.core.saf.exception.InvalidOperationException;
import org.eclipse.stp.core.saf.exception.SAFException;
import org.eclipse.stp.core.sca.ExternalService;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;

/**
 * This class is to be extended by all ExternalService handler contributions.  
 */
public abstract class AbstractExternalServiceHandler extends AbstractHandler implements IExternalServiceHandler {

	/* (non-Javadoc)
	 * @see org.eclipse.stp.core.saf.handler.IExternalServiceHandler#canCreateExternalServiceFor(java.lang.Object)
	 */
	public boolean canCreateExternalServiceFor(Object service)
	{
		// No default support for creating imports from model objects.
		return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.core.saf.handler.IExternalServiceHandler#canCreateExternalServiceBinding()
	 */
	public boolean canCreateExternalServiceBinding()
	{
		return true;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.stp.core.saf.handler.IExternalServiceHandler#canCreateManyExternalServiceBindings()
	 */
	public boolean canCreateManyExternalServiceBindings() {
		return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.core.saf.handler.IExternalServiceHandler#isInterfaceKindSupported(org.eclipse.stp.core.saf.handler.IInterfaceHandler)
	 */
	public boolean isInterfaceKindSupported(IInterfaceHandler interfaceHandler) throws SAFException 
	{
		return true;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.core.saf.handler.IExternalServiceHandler#removeKind(org.eclipse.stp.core.sca.ExternalService)
	 */
	final public IDataModelOperation removeKind(ExternalService theExternalService)
			throws SAFException, InvalidOperationException {
		
		if (theExternalService == null) 
			throw new SAFException(Messages.stp_core_saf_externalServiceMustNotBeNull); 
		
		IDataModel model = DataModelFactory.createDataModel(BindingDeletionDataModelProvider.class);
		model.setProperty(IBindingDeletionDataModelProperties.SCAOBJECT, theExternalService);
		model.setStringProperty(IBindingDeletionDataModelProperties.BINDING_TYPE, getKind());
				
		IStatus status = model.validate();
						
		if (status.isOK())
			return model.getDefaultOperation();	

		throw new SAFException(status.getMessage());
	}
}
