/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.wizards.annotations;

import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.annotations.ScAnnotationSupportUtils;
import org.eclipse.stp.sc.common.utils.JDTUtils;
import org.eclipse.stp.sc.common.wizards.AbstractScWizard;
import org.eclipse.stp.sc.jaxws.ScJaxWsResources;
import org.eclipse.stp.sc.jaxws.preferences.PreferencesAccessor;
import org.eclipse.stp.sc.jaxws.utils.ScJDTUtils;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CreateAnnotationWizard
extends AbstractScWizard {
    public static final String DATA_KEY_COMP_UNIT = "DATA_KEY_COMP_UNIT";
    public static final String DATA_KEY_AST_ROOT = "DATA_KEY_AST_ROOT";
    public static final String DATA_KEY_MEMBER = "DATA_KEY_MEMBER";
    public static final String DATA_KEY_ORIGINAL_TARGET = "DATA_KEY_ORIGINAL_TARGET";
    public static final String DATA_KEY_ANNOTATION_VALUES = "DATA_KEY_ANNOTATION_VALUES";
    private IMember targetMember;
    protected Map<Class<? extends Annotation>, Boolean> ANNOTATION_REQUIRED = new TreeMap<Class<? extends Annotation>, Boolean>(new Comparator(){

        public int compare(Object arg0, Object arg1) {
            String arg0Str = ((Class)arg0).getSimpleName();
            String arg1Str = ((Class)arg1).getSimpleName();
            return arg0Str.compareToIgnoreCase(arg1Str);
        }
    });
    private static final LoggingProxy LOG = LoggingProxy.getlogger(CreateAnnotationWizard.class);

    public CreateAnnotationWizard(Object target) {
        this.setOriginalWizardTargetToData(target);
        if (target instanceof IMember) {
            this.initializeWizardData((IMember)target);
        }
    }

    public void initializeWizardData(IMember aTargetMember) {
        this.targetMember = aTargetMember;
        this.setCuToData(this.targetMember.getCompilationUnit());
        this.setCuAstNodeToData(JDTUtils.getDomRootCompilationUnit((IMember)this.targetMember));
        this.setJavaMemberToData(this.targetMember);
    }

    public boolean performFinish() {
        ICompilationUnit icu = this.getCuFromData();
        CompilationUnit astRoot = this.getCuAstNodeFromData();
        try {
            Document document = new Document(icu.getBuffer().getContents());
            ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
            if (this.updateAST(astRoot, rewrite)) {
                TextEdit edits = rewrite.rewriteAST((IDocument)document, icu.getJavaProject().getOptions(true));
                edits.apply((IDocument)document);
                icu.getBuffer().setContents(document.get());
            }
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
        return true;
    }

    protected boolean verifyUpdateAnnotation(IMember member, org.eclipse.jdt.core.dom.Annotation annotation) {
        boolean update = true;
        if (JDTUtils.hasAnnotation((IMember)member, (org.eclipse.jdt.core.dom.Annotation)annotation)) {
            String strTitle = ScJaxWsResources.getString("ConfirmAnnotationReplace.Title");
            String strDesc = ScJaxWsResources.getFromMsgFormat("ConfirmAnnotationReplace.Exists.Msg", String.valueOf(member.getElementName()) + "," + annotation.getTypeName(), false);
            update = MessageDialog.openConfirm(null, (String)strTitle, (String)strDesc);
        }
        return update;
    }

    protected abstract boolean updateAST(CompilationUnit var1, ASTRewrite var2);

    protected boolean addAnnotationToMethodMember(CompilationUnit astRoot, ASTRewrite astRewrite, IMethod methodMember, Class<? extends Annotation> annClass, boolean supportDefault) {
        String wizDataKey = CreateAnnotationWizard.getAttributesDataKey(annClass);
        Object annotationToAdd = supportDefault && !PreferencesAccessor.areAnnWizardsDisplaied() ? ScAnnotationSupportUtils.getDefaultedAnnotationNode(annClass, (CompilationUnit)astRoot, (IMember)methodMember, null) : (this.getAnnAttributesFromData(wizDataKey) != null ? JDTUtils.newNormalAnnotation((CompilationUnit)astRoot, (String)annClass.getSimpleName(), this.getAnnAttributesFromData(wizDataKey)) : null);
        if (annotationToAdd != null && this.verifyUpdateAnnotation((IMember)methodMember, (org.eclipse.jdt.core.dom.Annotation)annotationToAdd)) {
            ScJDTUtils.addAnnotationOnMethod((CompilationUnit)astRoot, (org.eclipse.jdt.core.dom.Annotation)annotationToAdd, (IMethod)methodMember, (ASTRewrite)astRewrite, (boolean)true);
            return true;
        }
        return false;
    }

    protected boolean addAnnotationToTypeMember(CompilationUnit astRoot, ASTRewrite astRewrite, IType typeMember, Class<? extends Annotation> annClass, boolean supportDefault) {
        String wizDataKey = CreateAnnotationWizard.getAttributesDataKey(annClass);
        Object annotationToAdd = supportDefault && !PreferencesAccessor.areAnnWizardsDisplaied() ? ScAnnotationSupportUtils.getDefaultedAnnotationNode(annClass, (CompilationUnit)astRoot, (IMember)typeMember, null) : (this.getAnnAttributesFromData(wizDataKey) != null ? JDTUtils.newNormalAnnotation((CompilationUnit)astRoot, (String)annClass.getSimpleName(), this.getAnnAttributesFromData(wizDataKey)) : null);
        if (annotationToAdd != null && this.verifyUpdateAnnotation((IMember)typeMember, (org.eclipse.jdt.core.dom.Annotation)annotationToAdd)) {
            ScJDTUtils.addAnnotationOnType((CompilationUnit)astRoot, (org.eclipse.jdt.core.dom.Annotation)annotationToAdd, (IType)typeMember, (ASTRewrite)astRewrite, (boolean)true);
            return true;
        }
        return false;
    }

    public final IMember getJavaMemberFromData() {
        return (IMember)this.wizardData.get(DATA_KEY_MEMBER);
    }

    public final Object getOriginalWizardTargetFromData() {
        return this.wizardData.get(DATA_KEY_ORIGINAL_TARGET);
    }

    public final CompilationUnit getCuAstNodeFromData() {
        return (CompilationUnit)this.wizardData.get(DATA_KEY_AST_ROOT);
    }

    public final ICompilationUnit getCuFromData() {
        return (ICompilationUnit)this.wizardData.get(DATA_KEY_COMP_UNIT);
    }

    public final List<MemberValuePair> getAnnAttributesFromData(String wizDataKey) {
        return (List)this.wizardData.get(wizDataKey);
    }

    public final void setJavaMemberToData(IMember aJavaMember) {
        this.wizardData.put(DATA_KEY_MEMBER, aJavaMember);
    }

    public final void setOriginalWizardTargetToData(Object aTarget) {
        this.wizardData.put(DATA_KEY_ORIGINAL_TARGET, aTarget);
    }

    public final void setCuAstNodeToData(CompilationUnit aCompilationUnitAstNode) {
        this.wizardData.put(DATA_KEY_AST_ROOT, aCompilationUnitAstNode);
    }

    public final void setCuToData(ICompilationUnit aCompilationUnit) {
        this.wizardData.put(DATA_KEY_COMP_UNIT, aCompilationUnit);
    }

    public final void setAnnAttributesToData(String wizDataKey, List<MemberValuePair> someAnnAttributes) {
        this.wizardData.put(wizDataKey, someAnnAttributes);
    }

    public static String getAttributesDataKey(Class<? extends Annotation> annotationClass) {
        return DATA_KEY_ANNOTATION_VALUES + annotationClass.getSimpleName();
    }
}

