/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.actions.CreateActionBase;
import org.eclipse.stp.sc.jaxws.actions.CreateWebServiceAction;
import org.eclipse.stp.sc.jaxws.wizards.handler.NewHandlerCreationWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class CreateHandlerAction
extends CreateActionBase {
    private static LoggingProxy LOG = LoggingProxy.getlogger(CreateWebServiceAction.class);

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        if (this.selection != null && !this.selection.isEmpty()) {
            try {
                NewHandlerCreationWizard wizard = new NewHandlerCreationWizard();
                wizard.init(PlatformUI.getWorkbench(), this.selection);
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                dialog.open();
            }
            catch (Exception e) {
                LOG.debug((Object)"exception on handler wizard run", (Throwable)e);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection sel) {
        block7: {
            if (sel == null) {
                this.selection = null;
            } else if (sel instanceof IStructuredSelection) {
                this.selection = (IStructuredSelection)sel;
                Object selObj = this.selection.getFirstElement();
                IProject project = this.getProject(selObj);
                try {
                    if (project != null && project.hasNature("org.eclipse.stp.sc.jaxws.nature")) {
                        action.setEnabled(true);
                        break block7;
                    }
                    action.setEnabled(false);
                }
                catch (CoreException e) {
                    LOG.error((Object)e);
                }
            } else {
                action.setEnabled(false);
            }
        }
    }

    private IProject getProject(Object obj) {
        IProject rtnValue = null;
        if (obj != null) {
            if (obj instanceof IProject) {
                rtnValue = (IProject)obj;
            } else if (obj instanceof IResource) {
                rtnValue = ((IResource)obj).getProject();
            } else if (obj instanceof IJavaElement) {
                rtnValue = ((IJavaElement)obj).getJavaProject().getProject();
            }
        }
        return rtnValue;
    }
}

