/*******************************************************************************
* Copyright (c) 2007 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.annotations;

import java.lang.annotation.Annotation;

import org.eclipse.stp.sc.common.annotations.ext.IAnnotationResolver;


public class JaxWsAnnotationResolver implements IAnnotationResolver {

	@SuppressWarnings("unchecked")
	public Class<? extends Annotation> loadAnnotationClass(String className) 
	    throws ClassNotFoundException{
		Class tmpUntypedClass = Class.forName(className);
        return (Class <? extends Annotation>)tmpUntypedClass;
	}

}
