/*******************************************************************************
* Copyright (c) 2007 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.internal.wizards;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.internal.model.RuntimeCore;
import org.eclipse.stp.sc.common.internal.viewers.StpRuntimeComposite;
import org.eclipse.stp.sc.jaxws.ScJaxWsResources;
import org.eclipse.stp.sc.jaxws.wizards.StartingPointWizardPage;
import org.eclipse.stp.sc.jaxws.wizards.WebServiceProjectWizard;
import org.eclipse.stp.sc.jaxws.wizards.WsdlFirstProjectWizard;
import org.eclipse.stp.sc.jaxws.wizards.WsdlGenPage;
import org.eclipse.stp.sc.jaxws.wizards.WsdlSettingPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.server.core.IRuntime;

/**
 * this is runtime selection page for jax-ws project.
 * user is required to select one runtime before
 * any more operations during project creation
 * @author jma
 *
 */
public class RuntimeSelectionPage extends WizardPage {

	private static final LoggingProxy LOG = LoggingProxy.getlogger(RuntimeSelectionPage.class);
	
	public StpRuntimeComposite runtimeComp;
	protected IRuntime selectedRuntime = null;
	public RuntimeSelectionPage(String pageName, String title,
			ImageDescriptor titleImage) {
		super(pageName, title, titleImage);
	}
	

	public void createControl(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		
		composite.setLayoutData(GridData.FILL_BOTH);
		composite.setLayout(new GridLayout());
		
		String[] moduleTypes = new String[] {RuntimeCore.JAXWS_MODULE_TYPE};
		
		runtimeComp = new StpRuntimeComposite(composite, SWT.NONE, 
				new StpRuntimeComposite.SelectionListener() {
			public void runtimeSelected(IRuntime runtime) {
				LOG.debug("runtime selected:" + runtime.getId());
				selectedRuntime = runtime;
				setPageComplete(validatePage());
				
				//update java first project wizard pages
				if(RuntimeSelectionPage.this.getWizard() instanceof WebServiceProjectWizard){
					StartingPointWizardPage startPointPage =  (StartingPointWizardPage)RuntimeSelectionPage.this.getWizard().getPage(
							WebServiceProjectWizard.STARTING_POINT_PAGE_NAME);
					startPointPage.updateControl(selectedRuntime.getRuntimeType().getId());
				}
				
				//update wizard buttons
				getWizard().getContainer().updateButtons();
			}
		}, moduleTypes);
		
		runtimeComp.setLayoutData(new GridData(GridData.FILL_HORIZONTAL | GridData.FILL_VERTICAL));
		
		this.setControl(composite);
		setPageComplete(false);

	}
	
	public IWizardPage getNextPage() {
		if (this.getWizard() instanceof WsdlFirstProjectWizard) {
			// update gen page control according to runtime type
			WsdlGenPage genPage = (WsdlGenPage) this.getWizard().getPage(
					WsdlFirstProjectWizard.GENATOR_PAGE);
			genPage.updateControl(selectedRuntime.getRuntimeType().getId());
			WsdlSettingPage wsdlPage = (WsdlSettingPage) this.getWizard()
					.getPage(WsdlFirstProjectWizard.WSDL_PAGE);
			return wsdlPage;
		}
		return super.getNextPage();
	}
	
	public boolean validatePage() {
		setMessage(null);
		setErrorMessage(null);
		if (selectedRuntime == null) {
			setErrorMessage(ScJaxWsResources.getString("runtimepage.error.noruntime"));
			return false;
		}
		return true;
	}
	
	public boolean canFlipToNextPage(){
		if (selectedRuntime == null) {
			return false;
		}
		return super.canFlipToNextPage();
	}
	
	public String getRuntimeType() {
		return selectedRuntime.getRuntimeType().getId();
	}
	
	public String getRuntimeID() {
		return selectedRuntime.getId();
	}

	public void selectRuntimeByIndex(int index) {
		LOG.debug("set select runtime by index:" + index);
		selectedRuntime = runtimeComp.selectRuntimeByIndex(index);
		LOG.debug("result runtime:" + selectedRuntime);
	}
}
