/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.properties;

import org.eclipse.core.resources.IProject;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.internal.model.RuntimeCore;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IPageContentsChangeListener;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IPropertyPageContents;
import org.eclipse.stp.sc.jaxws.runtimeprovider.RuntimeProviderManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.PropertyPage;

/**
 * Johnson: we need to revisit this page to show the runtime information for the selected page later.
 * however, we won't allow user to change runtime from here
 * @author jma
 *
 */
public class ScJaxWsPropertyPage extends PropertyPage implements IPageContentsChangeListener{

	private static final LoggingProxy LOG = LoggingProxy.getlogger(ScJaxWsPropertyPage.class);

	private IPropertyPageContents pageContents = null;

	/**
	 * Constructor for JaxWSPropertyPage.
	 */
	public ScJaxWsPropertyPage() {
		super();
	}

	/**
	 * @see PreferencePage#createContents(Composite)
	 */
	protected Control createContents(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout();
		composite.setLayout(layout);
		GridData data = new GridData(GridData.FILL);
		data.grabExcessHorizontalSpace = true;
		composite.setLayoutData(data);
        
		//get the runtime info
        IProject project = (IProject)getElement();
        String runtimeId = RuntimeCore.getRuntimeType(project);
		
		RuntimeProviderManager rtMgr = RuntimeProviderManager.getInstance();
        pageContents = rtMgr.getPropertyPage(runtimeId);
		if(pageContents == null){
			pageContents = new DefaultProjectPropertiesPageContents();
		}
		
		pageContents.setProject(project);
		pageContents.setChangeListener(this);
		
		pageContents.createContents(composite);
		validatePage();
		
		return composite;
	}
	
	public void whenValidStatusChanged(){
		validatePage();
	}
	
	public boolean validatePage() {
		setMessage(null);
		setErrorMessage(null);
		if (pageContents.isPageValid()) {
			setValid(true);
		    return true;
		} else {
			setValid(false);
			setErrorMessage(pageContents.getErrorMsg());
			return false;
        }
	}
	
	protected void performDefaults() {
		super.performDefaults();
		pageContents.performDefault();
	}
	
	public boolean performOk() {
		super.performOk();
		pageContents.performOK();
		return true;
	}

}