package org.eclipse.stp.sc.jaxws.utils;

import java.io.File;
import java.io.IOException;
import java.util.jar.JarOutputStream;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.utils.JarUtils;
import org.eclipse.stp.sc.jaxws.workspace.JaxWsWorkspaceManager;

public class PackageHelper {

	public static String WEB_INF_DIR = "WEB-INF/";

	public static String WSDL_DIR = WEB_INF_DIR + "wsdl/";

	public static String CLASS_DIR = WEB_INF_DIR + "classes/";

	public static String PATH_SEPERATOR = "/";

	public static String META_INF_DIR = "META-INF/";

	public static String SPRING_DIR = META_INF_DIR + "spring/";

	private static final LoggingProxy LOG = LoggingProxy
			.getlogger(PackageHelper.class);

	private JarOutputStream jos; 
	
	private IProject project;

	private IFile wsdlFile;

	private String packageExt;

	private String targetWarFile;

	public PackageHelper(IFile wsdlFile, String packageExt) {
		this.wsdlFile = wsdlFile;
		this.project = wsdlFile.getProject();
		this.packageExt = packageExt;
	}


	public void addClassFiles() throws CoreException,
			IOException {

		IFolder clsFolder = JaxWsWorkspaceManager.getClassesFolder(project);

		JarUtils.addOneTargetDir(jos, clsFolder, CLASS_DIR);
	}

	public void addWsdlFiles() throws CoreException,
			IOException {
		IContainer wsdlFolder = JaxWsWorkspaceManager.getWSDLFolder(project);
		for (IResource member : wsdlFolder.members()) {
	/*		if (member.getType() == IResource.FOLDER) {
				String targetPath = WSDL_DIR + member.getName();
				JarUtils.addOneTargetDir(jos, (IFolder) member, targetPath);
				continue;
			}*/
			if (member.getType() != IResource.FILE) {
				continue;
			}
			if (member.getFileExtension().equals("xml") && !member.getName().equals("spring.xml")) {
				JarUtils.addToJar(jos, WEB_INF_DIR + member.getName(),
						(IFile) member);
			}

			if (member.getFileExtension().equals("wsdl")
					|| member.getFileExtension().equals("xsd")) {
				JarUtils.addToJar(jos, WSDL_DIR + member.getName(),
						(IFile) member);
			}

		}
	}


	public void addFileToPackage(IResource member,
			String targetDir) throws CoreException, IOException {
		
		if(jos == null){
			return;
		}
		
		if (member.getType() == IResource.FOLDER) {
			String targetPath = targetDir + member.getName();
			
			JarUtils.addOneTargetDir(jos, (IFolder) member, targetPath);

		}
		if (member.getType() != IResource.FILE) {
			return;
		}

		JarUtils.addToJar(jos, targetDir + member.getName(), (IFile) member);
	}

	
	public void startToPackage(IFolder targetFolder)throws Exception{
		try {
			
			if (!new File(targetFolder.getRawLocation().toOSString()).exists()) {
				targetFolder.create(true, true, null);
			}
			targetWarFile = wsdlFile.getName();
			targetWarFile = targetWarFile.substring(0, targetWarFile
					.indexOf("."));
			targetWarFile += packageExt;
			targetWarFile = targetFolder.getRawLocation().toOSString()
					+ File.separator + targetWarFile;

			this.jos = JarUtils.createJarOutputStream(targetWarFile);

			addWsdlFiles();
			addClassFiles();


		} catch (Exception e) {
			LOG.error("deploy error", e);
			throw e;
		}
	}

	public File getPackageFile(){
		return new File(targetWarFile); 
		
	}
	
	public void stopPackage()throws Exception{
		try {
			jos.close();
		} catch (IOException e) {
			LOG.error("deploy error", e);
			throw e;
		}
	}
	 
}
