/*******************************************************************************

* Copyright (c) 2007 IONA Technologies PLC

* All rights reserved. This program and the accompanying materials

* are made available under the terms of the Eclipse Public License v1.0

* which accompanies this distribution, and is available at

* http://www.eclipse.org/legal/epl-v10.html

* 

* Contributors:

*     IONA Technologies PLC - initial API and implementation

*******************************************************************************/
package org.eclipse.stp.sc.jaxws.wizards;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IAdditionalPageContents;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;

/**
 * @author qhuang
 *
 */
public class AdditionalWizardPage extends WizardPageBase<IAdditionalPageContents> {


	/**
	 * the current runtime type that this page is generated
	 * is it is changed. we need to redraw the control
	 */
    
    public AdditionalWizardPage(String pageName, IAdditionalPageContents pageContents) {
        super(pageName, pageContents);
        this.pageContents.setChangeListener(this);
    }

    protected Composite createPage(Composite parent) {
    	pageContents.createContents(parent);
        return parent;
    }
    
    /*
    protected IWizardPageContentsBase getPageContents(){
    	return additionalPage;
    }
    */
    
    public IWizardPage getNextPage(){
    	IAdditionalPageContents nextPageContents = pageContents.getNextPageContents();
    	if(nextPageContents != null){
    		AdditionalWizardPage newWizardPage = new AdditionalWizardPage(nextPageContents.getPageName(), nextPageContents);
    		newWizardPage.setWizard(this.getWizard());
    		return newWizardPage;
    	}else{
    		return null;
    	}
    }
    
    public void createControl(Composite parent){
    	Composite pageComposite = new Composite(parent, SWT.NONE);
    	pageComposite.setLayoutData(new GridData(GridData.FILL_BOTH));
    	pageComposite.setLayout(new GridLayout(1, false));
    	if(pageContents != null){
    		createPage(pageComposite); 
    	}
    	setControl(pageComposite);
        setTitle(pageContents.getTitle());
        setDescription(pageContents.getDescription());
        
        validatePage();
    }
    
    

}
