/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.wizards.annotations.webmethod;

import java.lang.annotation.Annotation;
import java.util.Iterator;

import javax.jws.Oneway;
import javax.jws.WebMethod;
import javax.jws.WebResult;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;

import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.stp.sc.jaxws.ScJaxWsResources;
import org.eclipse.stp.sc.jaxws.preferences.PreferencesAccessor;
import org.eclipse.stp.sc.jaxws.wizards.annotations.AnnotationAttributePage;
import org.eclipse.stp.sc.jaxws.wizards.annotations.CreateAnnotationWizard;


public class CreateWebMethodWizard extends CreateAnnotationWizard {
    // key to wizard data
    public static final String DATA_KEY_SELECTED_METHODS = "DATA_KEY_SELECTED_METHODS";
    public static final String DATA_KEY_RESULT_VALUES = "DATA_KEY_RESULT_VALUES";
    public static final String DATA_KEY_ONEWAY_VALUES = "DATA_KEY_ONEWAY_VALUES";
    public static final String DATA_KEY_REQUEST_VALUES = "DATA_KEY_REQUEST_VALUES";
    public static final String DATA_KEY_RESPONSE_VALUES = "DATA_KEY_RESPONSE_VALUES";

    // page identifiers used by this wizard
    public static final String SELECTION_PAGE = "selectionPage";

    public CreateWebMethodWizard(IMember aMember) {
        super(aMember);

        String title = ScJaxWsResources.getString("CreateWebMethodWizard.Title");
        setWindowTitle(title);
        
        ANNOTATION_REQUIRED.put(WebMethod.class, true);
        ANNOTATION_REQUIRED.put(RequestWrapper.class, true);
        ANNOTATION_REQUIRED.put(WebResult.class, false);
        ANNOTATION_REQUIRED.put(ResponseWrapper.class, true);
        ANNOTATION_REQUIRED.put(Oneway.class, false);
        
    }

    /**
     *
     * @see org.eclipse.stp.sc.common.wizards.AbstractScWizard#initializeWizardData()
     */
    @Override
    public void initializeWizardData(IMember targetMember) {
        super.initializeWizardData(targetMember);

        if (targetMember instanceof IMethod) {
            IMethod[] methods = {(IMethod)targetMember};
            wizardData.put(DATA_KEY_SELECTED_METHODS, methods);
        }
    }

    @Override
    public void addPages() {
        super.addPages();
        
        if (!(getOriginalWizardTargetFromData() instanceof IMember)) {
            // should probably do something more...
            return;
        } 

        IMember member = (IMember)getOriginalWizardTargetFromData();

        if (member instanceof IType) {
            addPage(new MethodSelectionPage2(this, SELECTION_PAGE, null));
        }
        
        if (PreferencesAccessor.areAnnWizardsDisplaied()) {
            // TODO add the help context IDs
            addPage(new AnnotationAttributePage(this,
                                                null,
                                                null,
                                                WebMethod.class,
                                                ANNOTATION_REQUIRED.get(WebMethod.class)));
    
            addPage( new AnnotationAttributePage(this,
                                                 null,
                                                 null,
                                                 RequestWrapper.class,
                                                 ANNOTATION_REQUIRED.get(RequestWrapper.class)));
            
            if ((member instanceof IMethod && hasAResponse((IMethod)member))
                    || !(member instanceof IMethod)) {
                addPage(new AnnotationAttributePage(this,
                                                    null,
                                                    null,
                                                    WebResult.class,
                                                    ANNOTATION_REQUIRED.get(WebResult.class)));
                
                addPage(new AnnotationAttributePage(this,
                        null,
                        null,
                        ResponseWrapper.class,
                        ANNOTATION_REQUIRED.get(ResponseWrapper.class)));
                
            }
    
            if ((member instanceof IMethod && isValidOneway((IMethod)member))
                    || !(member instanceof IMethod)) {
                addPage(new AnnotationAttributePage(this,
                                                    null,
                                                    null,
                                                    Oneway.class,
                                                    ANNOTATION_REQUIRED.get(Oneway.class)));
            }
        }
    }

    
    @SuppressWarnings("unchecked")
    protected boolean updateAST(CompilationUnit astRoot, ASTRewrite astRewrite) {
        int updateCnt = 0;
        
        IMethod[] selMethods = (IMethod[])wizardData.get(DATA_KEY_SELECTED_METHODS);

        for (int i = 0; i < selMethods.length; i++) {
            
            IMethod methodMember = selMethods[i];
            
            Iterator<Class<? extends Annotation>> iter = ANNOTATION_REQUIRED.keySet().iterator();
            while (iter.hasNext()) {
                Class<? extends Annotation> annClass = iter.next();
                
                if (addAnnotationToMethodMember(astRoot,
                                                astRewrite,
                                                methodMember,
                                                annClass,
                                                ANNOTATION_REQUIRED.get(annClass))) {
                    updateCnt++;
                }
            }
        }

        return updateCnt > 0;
    }

    private boolean hasAResponse(IMethod method) {
        try {
            if (method.getReturnType().equals(Signature.SIG_VOID)) {
                return false;
            }
        } catch (JavaModelException e) {
            return false;
        }

        return true;
    }

    private boolean isValidOneway(IMethod method) {
        // for Oneway:
        //    must not have a return value
        //    must be one parameter
        //    must not be any Holder parameters
        //    must not declare any checked exceptions
        try {
            if (!(method.getReturnType().equals(Signature.SIG_VOID))) {
                return false;
            }
        } catch (JavaModelException e) {
            return false;
        }

        String[] params = method.getParameterTypes();

        if (params.length != 1) {
            return false;
        }

        for (int j = 0; j < params.length; j++) {
            String elementType = Signature.getElementType(params[j]);

            if (elementType.equals("QHolder;")) {
                return false;
            }
        }

        try {
            if (method.getExceptionTypes().length != 0) {
                return false;
            }
        } catch (JavaModelException e) {
            return false;
        }

        return true;
    }
}
