/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.cxf.enabler;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.stp.sc.cxf.generators.ToolConstants;
import org.eclipse.stp.sc.cxf.natures.CxfNature;
import org.eclipse.stp.sc.jaxws.properties.ScJaxWsPropertyConstants;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IEnableJaxwsHook;

public class CxfEnableJaxwsHook implements IEnableJaxwsHook {

	public void run(IProject project) throws CoreException{
		CxfNature.addToProject(project);
		
		//add default generator parameter values
		project.setPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_DATA_BINDING, ToolConstants.PROPERTY_VALUE_DATABINDING_JAXB);
		project.setPersistentProperty(ScJaxWsPropertyConstants.PROPERTY_KEY_SOAP_OPTION, ToolConstants.PROPERTY_VALUE_SOAP11);
		project.setPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_WSDL, ToolConstants.PROPERTY_VALUE_TRUE);
		project.setPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_SERVER, ToolConstants.PROPERTY_VALUE_TRUE);
		project.setPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_CLIENT, ToolConstants.PROPERTY_VALUE_TRUE);
		project.setPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_XSD_IMPORT, ToolConstants.PROPERTY_VALUE_FALSE);
		project.setPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_VERBOSE, ToolConstants.PROPERTY_VALUE_FALSE);

	}

}
