/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.cxf.generators;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.jaxws.properties.ScJaxWsPropertyConstants;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IJavaToWsdlGenerator;


/*
 * TODO: remove IJavaToWsdlGenerator later once the refactor has finished.
 */
public class CeltixJavaToWsdlGenerator implements IJavaToWsdlGenerator {
    
    private static final LoggingProxy LOG = LoggingProxy.getlogger(CeltixJavaToWsdlGenerator.class);
    
    public void setInitializationData(IConfigurationElement config,
        String propertyName, Object data) throws CoreException {
    }

    public void run(IPath path, IProject project) throws CoreException {
        try {
    		
        	String fileName = project.getPersistentProperty(ScJaxWsPropertyConstants.PROPERTY_KEY_STARTING_POINT);
    		IFile file = project.getFile(new Path(fileName));
    		LOG.info("generate WSDL for " + file.getLocation().toOSString());

    		
			CxfJava2wsGenerator generator = CxfJava2wsGenerator.getInstance();

			//remember current property
			String genServer = project.getPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_SERVER);
			String genClient = project.getPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_CLIENT);
			String genWsdl = project.getPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_WSDL);
			
			//set to only generate what is required
			project.setPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_WSDL, ToolConstants.PROPERTY_VALUE_TRUE);
			project.setPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_SERVER, ToolConstants.PROPERTY_VALUE_FALSE);
			project.setPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_CLIENT, ToolConstants.PROPERTY_VALUE_FALSE);
			
			//generate
			generator.run(project);

			//roll back to the original values
			project.setPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_WSDL, genWsdl);
			project.setPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_SERVER, genServer);
			project.setPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_CLIENT, genClient);

			project.refreshLocal(IResource.DEPTH_INFINITE, null);
        } catch (Throwable e) {
            LOG.error("Celtix Java To Wsdl Generation failure", e);
        }
    }
}
