/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.cxf.generators;

import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.stp.sc.jaxws.ScJaxWsResources;

public class ToolConstants {

	public static final String PROPERTY_VALUE_TRUE = "true";
	public static final String PROPERTY_VALUE_FALSE = "false";
	public static final String PROPERTY_VALUE_JAXWS_FRONTEND = "jaxws";
	public static final String PROPERTY_VALUE_SIMPLE_FRONTEND = "simple";
	public static final String PROPERTY_VALUE_DATABINDING_JAXB = "jaxb";
	public static final String PROPERTY_VALUE_DATABINDING_AEGIS = "aegis";
	public static final String PROPERTY_VALUE_SOAP11 = ScJaxWsResources.getString("pref.jaxws.cxf.wsdlgen.soap11.label");
	public static final String PROPERTY_VALUE_SOAP12 = ScJaxWsResources.getString("pref.jaxws.cxf.wsdlgen.soap12.label");
	
	//java2wsdl generator class
	public static final String JAVA2WSDL_GENERATOR_CLASS = "org.apache.cxf.tools.java2wsdl.JavaToWSDL";
	
	//java2wsdl parameter symbols
	public static final String JAVA2WSDL_PARA_OUTPUT_FILE = "-o";
	public static final String JAVA2WSDL_PARA_SOURCE_DIR = "-s";
	public static final String JAVA2WSDL_PARA_CLASS_DIR = "-classdir";
	public static final String JAVA2WSDL_PARA_CLASS_PATH = "-cp";
	public static final String JAVA2WSDL_PARA_SOAP12 = "-soap12";
	
	//java2ws generator class
	public static final String JAVA2WS_GENERATOR_CLASS = "org.apache.cxf.tools.java2ws.JavaToWS";
	
	//java2ws generator parameter
	public static final String JAVA2WS_PARA_DATA_BINDING = "-databinding";
	public static final String JAVA2WS_PARA_FRONT_END = "-frontend";
	public static final String JAVA2WS_PARA_WSDL = "-wsdl";
	public static final String JAVA2WS_PARA_WRAPPER_BEAN = "-wrapperbean";
	public static final String JAVA2WS_PARA_CLIENT = "-client";
	public static final String JAVA2WS_PARA_SERVER = "-server";
	public static final String JAVA2WS_PARA_OUTPUT_FILE = "-o";
	public static final String JAVA2WS_PARA_OUTPUT_DIR = "-d";
	public static final String JAVA2WS_PARA_SOURCE_DIR = "-s";
	public static final String JAVA2WS_PARA_CLASS_DIR = "-classdir";
	public static final String JAVA2WS_PARA_CLASSPATH = "-cp";
	public static final String JAVA2WS_PARA_SOAP12 = "-soap12";
	public static final String JAVA2WS_PARA_TARGET_NAMESPACE = "-t";
	public static final String JAVA2WS_PARA_BEAN = "-beans";
	public static final String JAVA2WS_PARA_SERVICE_NAME = "-servicename";
	public static final String JAVA2WS_PARA_PORT_NAME = "-portname";
	public static final String JAVA2WS_PARA_XSD_IMPORT = "-createxsdimports";
	public static final String JAVA2WS_PARA_HELP = "-h";
	public static final String JAVA2WS_PARA_VERSON = "-v";
	public static final String JAVA2WS_PARA_VERBOSE = "-verbose";
	public static final String JAVA2WS_PARA_QUIET = "-quiet";
	
	//java2ws property qualified name
	public static final String JAVA2WS_PARA_NAME_QUALIFIER = "CXF_JAVA2WS_GENERATOR";
	public static final QualifiedName PROPERTY_KEY_JAVA2WS_PARA_DATA_BINDING = new QualifiedName(JAVA2WS_PARA_NAME_QUALIFIER, JAVA2WS_PARA_DATA_BINDING);
	public static final QualifiedName PROPERTY_KEY_JAVA2WS_PARA_FRONT_END = new QualifiedName(JAVA2WS_PARA_NAME_QUALIFIER, JAVA2WS_PARA_FRONT_END);
	public static final QualifiedName PROPERTY_KEY_JAVA2WS_PARA_WSDL = new QualifiedName(JAVA2WS_PARA_NAME_QUALIFIER, JAVA2WS_PARA_WSDL);
	public static final QualifiedName PROPERTY_KEY_JAVA2WS_PARA_WRAPPER_BEAN = new QualifiedName(JAVA2WS_PARA_NAME_QUALIFIER, JAVA2WS_PARA_WRAPPER_BEAN);
	public static final QualifiedName PROPERTY_KEY_JAVA2WS_PARA_CLIENT = new QualifiedName(JAVA2WS_PARA_NAME_QUALIFIER, JAVA2WS_PARA_CLIENT);
	public static final QualifiedName PROPERTY_KEY_JAVA2WS_PARA_SERVER = new QualifiedName(JAVA2WS_PARA_NAME_QUALIFIER, JAVA2WS_PARA_SERVER);
	public static final QualifiedName PROPERTY_KEY_JAVA2WS_PARA_OUTPUT_FILE = new QualifiedName(JAVA2WS_PARA_NAME_QUALIFIER, JAVA2WS_PARA_OUTPUT_FILE);
	public static final QualifiedName PROPERTY_KEY_JAVA2WS_PARA_OUTPUT_DIR = new QualifiedName(JAVA2WS_PARA_NAME_QUALIFIER, JAVA2WS_PARA_OUTPUT_DIR);
	public static final QualifiedName PROPERTY_KEY_JAVA2WS_PARA_SOURCE_DIR = new QualifiedName(JAVA2WS_PARA_NAME_QUALIFIER, JAVA2WS_PARA_SOURCE_DIR);
	public static final QualifiedName PROPERTY_KEY_JAVA2WS_PARA_CLASS_DIR = new QualifiedName(JAVA2WS_PARA_NAME_QUALIFIER, JAVA2WS_PARA_CLASS_DIR);
	public static final QualifiedName PROPERTY_KEY_JAVA2WS_PARA_CLASSPATH = new QualifiedName(JAVA2WS_PARA_NAME_QUALIFIER, JAVA2WS_PARA_CLASSPATH);
	public static final QualifiedName PROPERTY_KEY_JAVA2WS_PARA_SOAP12 = new QualifiedName(JAVA2WS_PARA_NAME_QUALIFIER, JAVA2WS_PARA_SOAP12);
	public static final QualifiedName PROPERTY_KEY_JAVA2WS_PARA_TARGET_NAMESPACE = new QualifiedName(JAVA2WS_PARA_NAME_QUALIFIER, JAVA2WS_PARA_TARGET_NAMESPACE);
	public static final QualifiedName PROPERTY_KEY_JAVA2WS_PARA_BEAN = new QualifiedName(JAVA2WS_PARA_NAME_QUALIFIER, JAVA2WS_PARA_BEAN);
	public static final QualifiedName PROPERTY_KEY_JAVA2WS_PARA_SERVICE_NAME = new QualifiedName(JAVA2WS_PARA_NAME_QUALIFIER, JAVA2WS_PARA_SERVICE_NAME);
	public static final QualifiedName PROPERTY_KEY_JAVA2WS_PARA_PORT_NAME = new QualifiedName(JAVA2WS_PARA_NAME_QUALIFIER, JAVA2WS_PARA_PORT_NAME);
	public static final QualifiedName PROPERTY_KEY_JAVA2WS_PARA_XSD_IMPORT = new QualifiedName(JAVA2WS_PARA_NAME_QUALIFIER, JAVA2WS_PARA_XSD_IMPORT);
	public static final QualifiedName PROPERTY_KEY_JAVA2WS_PARA_HELP = new QualifiedName(JAVA2WS_PARA_NAME_QUALIFIER, JAVA2WS_PARA_HELP);
	public static final QualifiedName PROPERTY_KEY_JAVA2WS_PARA_VERSON = new QualifiedName(JAVA2WS_PARA_NAME_QUALIFIER, JAVA2WS_PARA_VERSON);
	public static final QualifiedName PROPERTY_KEY_JAVA2WS_PARA_VERBOSE = new QualifiedName(JAVA2WS_PARA_NAME_QUALIFIER, JAVA2WS_PARA_VERBOSE);
	public static final QualifiedName PROPERTY_KEY_JAVA2WS_PARA_QUIET = new QualifiedName(JAVA2WS_PARA_NAME_QUALIFIER, JAVA2WS_PARA_QUIET);
    
	
	//wsdl2java generator class
	public static final String WSDL2JAVA_GENERATOR_CLASS = "org.apache.cxf.tools.wsdlto.WSDLToJava";
	
    //wsdl2java parameter symbols
	public static final String WSDL2JAVA_PARA_FRONT_END = "-fe";
	public static final String WSDL2JAVA_PARA_DATA_BINDING = "-db";
	public static final String WSDL2JAVA_PARA_OUTPUT_DIR = "-d";
	public static final String WSDL2JAVA_PARA_GEN_IMPL = "-impl";
	public static final String WSDL2JAVA_PARA_GEN_SERVER = "-server";
	public static final String WSDL2JAVA_PARA_GEN_CLIENT = "-client";
	public static final String WSDL2JAVA_PARA_GEN_ANT = "-ant";
	public static final String WSDL2JAVA_PARA_EXTEND_SOAP_HEADER = "-exsh";
	public static final String WSDL2JAVA_PARA_DEFAULT_NAMESPACE = "-dns";
	public static final String WSDL2JAVA_PARA_DEFAULT_EXCLUDE_NAMESPACE = "-dex";
	public static final String WSDL2JAVA_PARA_VERBOSE = "-verbose";
	public static final String WSDL2JAVA_PARA_PACKAGE = "-p";
	public static final String WSDL2JAVA_PARA_BINDING_NAME = "-b";

}
