/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.cxf.wizard.simplefe;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.cxf.CXFResources;
import org.eclipse.stp.sc.cxf.generators.ToolConstants;
import org.eclipse.stp.sc.cxf.natures.CxfSimpleFrontendNature;
import org.eclipse.stp.sc.cxf.wizard.CxfStartingPointPageContents;
import org.eclipse.stp.sc.jaxws.properties.ScJaxWsPropertyConstants;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IPostProjectProcessor;
import org.eclipse.stp.sc.jaxws.runtimeprovider.RuntimeProviderManager;
import org.eclipse.stp.sc.jaxws.wizards.AdditionalWizardPage;
import org.eclipse.stp.sc.jaxws.workspace.JaxWsWorkspaceManager;
import org.eclipse.stp.sc.jaxws.workspace.ScNature;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class SimpleFrontendProjectWizard extends Wizard implements INewWizard {
	
	private static final LoggingProxy LOG = LoggingProxy.getlogger(SimpleFrontendProjectWizard.class);

	private final String DEFAULT_RUNTIME_TYPE = "org.eclipse.stp.soas.deploy.runtime.cxf.20";
	
	public final String STARTING_POINT_PAGE_NAME = "startingPointPage";
	public final String PARAMETER_PAGE_NAME = "parameterPage";
	public final String PROJECT_PAGE_NAME = "genPage";
	
	StartingPointWizardPageSimple startingPointPage;
	AdditionalWizardPage parameterPage;
	WizardNewProjectCreationPage genPage;
	
	private String runtimeID;
	private String runtimeType = DEFAULT_RUNTIME_TYPE;
	private String projectMode = ScJaxWsPropertyConstants.PROJECT_MODE_JAVAFIRST;
	
	private IProject project;

	public void init(IWorkbench workbench, IStructuredSelection selection) {
        setNeedsProgressMonitor(true);
	}
	
	public void addPages(){
		//check whether the cxf runtime has been installed 
		RuntimeProviderManager mgr = RuntimeProviderManager.getInstance();
		String[] ids = mgr.getRuntimeIDs(runtimeType);
		if(ids == null || ids.length <= 0){
			//display a error dialog and close this wizard
	        MessageDialog.openError(
	        		PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 
	        		"Missing Runtime", 
	        		"There is no corresponding CXF runtime installed. Please add this runtime first.");
	        return;
		}
		runtimeID = ids[0];
		
		genPage = new WizardNewProjectCreationPage(PROJECT_PAGE_NAME);
	    genPage.setTitle(CXFResources.getString("Wizard.Simple.Frontend.Project.Page.Title"));
	    genPage.setDescription(CXFResources.getString("Wizard.Simple.Frontend.Project.Page.Descritption"));

		addPage(genPage);
		
		startingPointPage = new StartingPointWizardPageSimple(STARTING_POINT_PAGE_NAME);
		CxfStartingPointPageContents pageContents = new CxfStartingPointPageContents();
		pageContents.setChangeListener(startingPointPage);
		startingPointPage.setPageContents(pageContents);
		addPage(startingPointPage);
		
		parameterPage = new AdditionalWizardPage(PARAMETER_PAGE_NAME, new CxfJava2wsParameterPageContentsSimple());
		startingPointPage.setNextPage(parameterPage);
		addPage(parameterPage);
	}
	
	public boolean performFinish(){
	    try {
	    	ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.getShell());
	    	IRunnableWithProgress rwp = new IRunnableWithProgress() {
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                	createProject(monitor);
                }
	    	};
	        pmd.run(false, false, rwp);
	        
	        //set front end property
	        project.setPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_FRONT_END, ToolConstants.PROPERTY_VALUE_SIMPLE_FRONTEND);

	        //remove jaxws nature and add simple frontend nature
	        ScNature.removeFromProject(project);
	        CxfSimpleFrontendNature.addToProject(project);
	        
	        startingPointPage.performFinish(project);
	        parameterPage.performFinish(project);
	  
	    } catch (InvocationTargetException e) {
	    	LOG.error(e.getMessage(), e);
	        return false;
	    } catch (InterruptedException e) {
	    	LOG.error(e.getMessage(), e);
			return false;
		} catch (CoreException e) {
	    	LOG.error(e.getMessage(), e);
			return false;
		}
	
	    return true;
	}
	
    protected boolean createProject(IProgressMonitor newMonitor) throws InvocationTargetException {
    	
	    IProgressMonitor checkedMonitor = (newMonitor != null) ? newMonitor
	                                                           : new NullProgressMonitor();
	    checkedMonitor.beginTask("", 100);
	
	    IProgressMonitor createProjectMonitor = new SubProgressMonitor(checkedMonitor, 20);
	    
	    project = JaxWsWorkspaceManager.createProject(createProjectMonitor,
	                                   genPage.getProjectName(),
	                                   genPage.getLocationPath(),
	                                   projectMode,
	                                   runtimeType,
	                                   runtimeID);
    
	     
	    IPostProjectProcessor processor = RuntimeProviderManager.getInstance().getPostProjectProcessor(runtimeType);
	    if(processor != null){
	    	processor.postProcess(project);
	    }
	
	    try {
	        project.refreshLocal(IProject.DEPTH_INFINITE, checkedMonitor);
	    } catch (Exception ce) {
	    	LOG.error(ce.getMessage(), ce);
	    	ce.printStackTrace();
	    }
	    finally {
	    	checkedMonitor.done();
        }
	    return true;
	}

}
