/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/

package org.eclipse.stp.sc.sca.java.tuscany.launchers;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.util.ArrayList;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.preference.IPreferenceStore;

import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.internal.model.RuntimeCore;
import org.eclipse.stp.sc.sca.java.ScaJavaPlugin;
import org.eclipse.stp.sc.sca.java.extensions.IJavaLaunchConfigGenerator;
import org.eclipse.stp.sc.sca.java.preferences.ScaJavaPreferenceConstants;
import org.eclipse.stp.sc.sca.java.workspace.ScaWorkspaceManager;

public class JavaLaunchConfigGenerator  implements IJavaLaunchConfigurationConstants, 
    IJavaLaunchConfigGenerator{
    private static final LoggingProxy LOG = LoggingProxy.getlogger(JavaLaunchConfigGenerator.class);
    
    private static final String NAME_PREFIX = "sca_";
    private static final String DEFAULT_LOG4J_PROPERTIES_FILE = "log4j.properties";
    private static final String SYSTEM_PROPERTY_TAG_LOG4J_CONFIGURATION = "-Dlog4j.configuration";
    private static final String DEFAULT_LOG4J_PROPERTIES = 
    	"# Set root category priority to DEBUG and set its only appender to A1\n" +
    	"log4j.rootCategory=DEBUG, A1\n" +
    	"\n" + 
    	"# A1 is set to be a ConsoleAppender (writes to system console).\n" +
    	"log4j.appender.A1=org.apache.log4j.ConsoleAppender" + 
    	"\n" + 
    	"# A1 uses PatternLayout.\n" +
    	"log4j.appender.A1.layout=org.apache.log4j.PatternLayout\n" +
    	"log4j.appender.A1.layout.ConversionPattern=%-4r [%t] %-5p %c %x - %m%n\n";
    
    private String configBaseName = null;
    private String projectName = null;
    private String jarFilePath = null;
    private String tuscanyKitDir = null;
    private IProject project = null;
    
    //interal variable to create the launch configuration
    private String serverMainClassName = null;
    
    public JavaLaunchConfigGenerator() {
    }
    
    /**
     * create launch configuration for SCA java component project
     * @param project, the project
     * @param configBaseName, the component name
     */
    public void createScaComponentLaunchConfig(IProject project, String componentName, String mainClass) {
    	this.project = project;
    	projectName = project.getName();
//    	IPreferenceStore preferenceStore = ScaJavaPlugin.getDefault()
//	        .getPreferenceStore();
//    	tuscanyKitDir = preferenceStore.getString(ScaJavaPreferenceConstants.KEY_RUNTIME_INSTALL_ROOT);
    	tuscanyKitDir = RuntimeCore.getInstallPath(project).makeAbsolute().toOSString();
    
    	IFile jarFile = ScaWorkspaceManager.getJarOutputFile(project);
    	jarFilePath = jarFile.getProjectRelativePath().toString();
    	configBaseName = componentName;
    	
    	serverMainClassName = mainClass;
    	
		LOG.debug("server config projectName: " + projectName);
		this.createLaunchConfig(NAME_PREFIX + projectName);
		this.createLog4jProperties(project);
	}

    private void createLaunchConfig(String id) {
        String launchConfigName = configBaseName + "_" + id;
        LOG.debug("run/debug config name: " + launchConfigName);

        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(ID_JAVA_APPLICATION);
        
        try {
            ILaunchConfiguration[] configurations = manager.getLaunchConfigurations(type);
            for (int i = 0; i < configurations.length; i++) {
                ILaunchConfiguration configuration = configurations[i];
                if (configuration.getName().equals(launchConfigName)) {
                    configuration.delete();
                    break;
                    
                }
            }

            ILaunchConfigurationWorkingCopy workingCopy = type.newInstance(null, launchConfigName);

            //set project name and main class
            workingCopy.setAttribute(ATTR_PROJECT_NAME, projectName);
            workingCopy.setAttribute(ATTR_MAIN_TYPE_NAME, serverMainClassName);
            workingCopy.setAttribute("org.eclipse.jdt.debug.ui.INCLUDE_EXTERNAL_JARS", true);
            workingCopy.setAttribute(ATTR_VM_ARGUMENTS, 
            		SYSTEM_PROPERTY_TAG_LOG4J_CONFIGURATION+ "=" + DEFAULT_LOG4J_PROPERTIES_FILE);
            setupClassPath(workingCopy);
            //save the run config
            workingCopy.doSave();
        } catch (CoreException ex) {
            LOG.debug("Exception thrown trying to create run config");
        }
    }
    
    private void setupClassPath(ILaunchConfigurationWorkingCopy workingCopy)
			throws CoreException {
		String libJarPath = tuscanyKitDir + File.separator + "lib"
				+ File.separator + "tuscany-sca-manifest.jar";
		String outputJarPath = ScaWorkspaceManager.getJarOutputFile(project).getRawLocation().toOSString();
		ArrayList<String> arrayList = (ArrayList<String>) workingCopy
				.getAttribute(ATTR_CLASSPATH, new ArrayList<String>());

		arrayList.add("<?xml version=\"1.0\" encoding=\"UTF-8\"?>"
						+ "<runtimeClasspathEntry containerPath=\"JRE_LIB\" path=\"1\" type=\"3\"/>");
		//no need to add default class path
		//arrayList.add("<?xml version=\"1.0\" encoding=\"UTF-8\"?>"
		//				+ "<runtimeClasspathEntry id=\"org.eclipse.jdt.launching.classpathentry.defaultClasspath\">"
		//				+ "<memento project=\"" + projectName + "\"/>"
		//				+ "</runtimeClasspathEntry>");
		arrayList.add("<?xml version=\"1.0\" encoding=\"UTF-8\"?>"
				+ "<runtimeClasspathEntry externalArchive=\"" + libJarPath
				+ "\" path=\"3\" type=\"2\"/>");
		//add output jar
		arrayList.add("<?xml version=\"1.0\" encoding=\"UTF-8\"?>"
				+ "<runtimeClasspathEntry externalArchive=\"" + outputJarPath
				+ "\" path=\"3\" type=\"2\"/>");
		
		LOG.debug("set classpath to include license dir.");
		workingCopy.setAttribute(ATTR_DEFAULT_CLASSPATH, false);

		workingCopy.setAttribute(ATTR_CLASSPATH, arrayList);
	}
    
    //create log4j properties file
    private void createLog4jProperties(IProject project){
    	try{
        	IFolder resourcesFoler = ScaWorkspaceManager.getResourcesFolder(project);
        	IFile file = resourcesFoler.getFile(DEFAULT_LOG4J_PROPERTIES_FILE);
        	
        	BufferedWriter buff = new BufferedWriter(
        			new FileWriter(
        					file.getRawLocation().toOSString())); 
        	
        	String str = DEFAULT_LOG4J_PROPERTIES; 
        	
        	for (int i = 0;i < str.length();i++){
        		buff.write(str.charAt(i));
        	}
        	 
        	buff.close();

    	}catch (Exception e){
    		LOG.error(e);
    	}

    }



	public String getConfigBaseName() {
		return configBaseName;
	}

	public void setConfigBaseName(String configBaseName) {
		this.configBaseName = configBaseName;
	}

	public String getJarFilePath() {
		return jarFilePath;
	}

	public void setJarFilePath(String jarFilePath) {
		this.jarFilePath = jarFilePath;
	}

	public String getProjectName() {
		return projectName;
	}

	public void setProjectName(String projectName) {
		this.projectName = projectName;
	}

	public String getTuscanyKitDir() {
		return tuscanyKitDir;
	}

	public void setTuscanyKitDir(String tuscanyKitDir) {
		this.tuscanyKitDir = tuscanyKitDir;
	}

	public void setInitializationData(IConfigurationElement config, 
			String propertyName, Object data) throws CoreException {
			serverMainClassName = config.getAttribute(IJavaLaunchConfigGenerator.PROPERTY_MAIN_CLASS);;
	}

    public void run(IPath path, IProject project) throws CoreException {
        // TODO Auto-generated method stub
        Exception e = new Exception("need to implement this generator!!");
        e.printStackTrace();
        
    }

}
