/*******************************************************************************
 * Copyright (c) 2006-2007 IONA Technologies.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IONA Technologies - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.ui.xef.editor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.stp.ui.xef.XefPlugin;


public final class FieldEditorRegistry {
	static final Map<String, AbstractFieldEditor> fieldEditors = Collections.synchronizedMap(new HashMap<String, AbstractFieldEditor>());
	
	private FieldEditorRegistry() { }
	
	static AbstractFieldEditor getFieldEditor(String name) throws CoreException {
		AbstractFieldEditor fieldEditor = fieldEditors.get(name);
		if (fieldEditor != null) {
			return fieldEditor;
		}
		
		IExtension [] extensions = Platform.getExtensionRegistry().getExtensionPoint(XefPlugin.ID, "xefExtension").getExtensions();
		for (IExtension extension : extensions) {
			IConfigurationElement [] configElements = extension.getConfigurationElements();
			for (IConfigurationElement configEl : configElements) {
				if (configEl.getName().equals("fieldEditor")) {
					if (name.equals(getConfigAttr(configEl, "fieldEditorId", null))) {
						Object obj = configEl.createExecutableExtension("class");
						if (obj instanceof AbstractFieldEditor) {
							AbstractFieldEditor fed = (AbstractFieldEditor) obj;
							fieldEditors.put(name, fed);
							return fed;
						}
					}
				}
			}
		}
		return null;
	}
	
	private static String getConfigAttr(IConfigurationElement configElem, String name, String defaultValue) {
		String value = configElem.getAttribute(name);
		if (value != null) {
			return value;
		}
		if (defaultValue != null) {
			return defaultValue;
		}
		throw new IllegalArgumentException("Missing attribute " + name + " from extension.");
	}
}
