package org.eclipse.stp.ui.xef.editor;

import java.io.ByteArrayInputStream;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jdom.input.SAXBuilder;

public class XMLEditDialog extends Dialog {
    static boolean interactive = true;
    
    private final String rootName;
    private final String initialXML;
    private String xml;
    Text xmlTxt;
    
    public XMLEditDialog(Shell shell, String initial) {
        this(shell, initial, null);
    }
    
    public XMLEditDialog(Shell shell, String initial, String multiRootName) {
        super(shell);
        setShellStyle(SWT.DIALOG_TRIM | SWT.RESIZE | SWT.APPLICATION_MODAL);
        
        initialXML = initial;
        rootName = multiRootName;
    }

    @Override
    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Enter XML");
        newShell.setMinimumSize(500, 500);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite) super.createDialogArea(parent);
        
        xmlTxt = new Text(composite, SWT.MULTI | SWT.H_SCROLL | SWT.V_SCROLL | SWT.BORDER);
        xmlTxt.setLayoutData(new GridData(
                GridData.FILL_BOTH |
                GridData.GRAB_HORIZONTAL | GridData.GRAB_VERTICAL));
        xmlTxt.setText(initialXML);
        
        return composite;
    }
    
    public String getXML() {
        return xml;
    }

    @Override
    protected void okPressed() {
        SAXBuilder builder = new SAXBuilder();
        
        String toParse;
        if (rootName != null) {
            toParse = "<" + rootName + ">" + xmlTxt.getText() + "</" + rootName + ">";
        } else {
            toParse = xmlTxt.getText();
        }
        
        try {            
            builder.build(new ByteArrayInputStream(toParse.getBytes()));
            xml = xmlTxt.getText();
            super.okPressed();
        } catch (Exception e) {
            if (interactive) {
                MessageDialog.openError(getShell(), "Error parsing XML", 
                    "There was an error parsing the XML: " + e.getMessage());
            }
            xml = null;
        }
    }
}
