/*******************************************************************************
 * Copyright (c) 2006-2007 IONA Technologies.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IONA Technologies - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.ui.xef.editor;

import java.util.LinkedList;
import java.util.List;


import org.eclipse.jface.text.IDocument;
import org.eclipse.stp.xef.ISchemaProvider;
import org.eclipse.stp.xef.XMLInstanceElement;
import org.eclipse.stp.xef.XMLModelFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.jdom.Element;

public class XefEditPage extends FormPage implements IFormPage {
    final XefEditMasterDetailsBlock block;

    public XefEditPage(XefEditor editor, String id, String title) {
        super(editor, id, title);

        block = new XefEditMasterDetailsBlock(this);
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);

        ScrolledForm form = getManagedForm().getForm();
        form.setText("Policies");
        block.createContent(getManagedForm());

        getEditorSite().getActionBars().setGlobalActionHandler(
                ActionFactory.DELETE.getId(), block.getAction(ActionFactory.DELETE.getId()));
    }

    public void setActive(boolean active) {
        super.setActive(active);
        
        if (active) {
            IDocument doc = ((XefEditor) getEditor()).xmlEditPage.getDocumentProvider().getDocument(
                    getEditorInput());
            try {
                List<XMLInstanceElement> elements = new LinkedList<XMLInstanceElement>();
                ISchemaProvider [] schemaProviders = new ISchemaProvider[0];
                if (getEditorInput() instanceof XMLProviderEditorInput) {
                    XMLProviderEditorInput xmlEditorInput = (XMLProviderEditorInput) getEditorInput();
                    
                    ISchemaProvider schemaProvider = xmlEditorInput.getSchemaProvider();
                    if (schemaProvider != null) {
                        schemaProviders = new ISchemaProvider[] { schemaProvider };                        
                    } else {
                        schemaProviders = new ISchemaProvider[] {};
                    }

                    String rootElementQName = xmlEditorInput.getXMLProvider().getRootElementQName();
                    Element base = XMLModelFactory.createFromXML(doc.get(), rootElementQName, 
                        elements, true, schemaProviders);
                    block.initializePolicies(doc.get(), base, rootElementQName, elements);                    
                }
            } catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e); // TODO do something decent here.
            }
        }
    }

    public XefEditMasterDetailsBlock getBlock() {
        return block;
    }
    
    String getXML() {
        return block.getXML();
    }

    public void clearDirty() {
        block.setDirty(false);
    }

    @Override
    public boolean isDirty() {        
        return super.isDirty() | block.isDirty();
    }
}
