/*******************************************************************************
 * Copyright (c) 2006-2007 IONA Technologies.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IONA Technologies - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.xef.util;

import java.util.Map;
import java.util.regex.Pattern;


/** This utility class contains helper functions for dealing with QNames.
 */
public final class QNameHelper {
    static final String SEPARATOR = ":";
    private final static String FULLNAME_PATTERN = "\\{.*\\}.*";
    private final static String FULLNAME_START = "{";
    private final static String FULLNAME_END = "}";
    
    private QNameHelper() {}

    /** Generates a QName based on prefix and local part.
     * @param prefix The prefix of the QName.
     * @param local The local name of the QName.
     */
    public static String convertToQName(String prefix, String local) {
        return prefix + SEPARATOR + local;
    }

    public static String getPrefixFromQName(String qname) {
        String prefix = "";
        if (qname.contains(SEPARATOR)) {
            prefix = qname.substring(0, qname.indexOf(SEPARATOR));
        }
        return prefix;
    }
    
    public static String getLocalFromQName(String qname) {
        String local = qname;
        if (qname.lastIndexOf(SEPARATOR) != -1) {
            local = qname.substring(qname.lastIndexOf(SEPARATOR) + 1);
        }
        return local;
    }
    
    public static String getNamespaceFromFullName(String fullName) {
        if (!Pattern.matches(FULLNAME_PATTERN, fullName)) {
            return "";
        }
        return fullName.substring(fullName.indexOf(FULLNAME_START) + 1,
                                  fullName.lastIndexOf(FULLNAME_END));
    }
    
    public static String getLocalNameFromFullName(String fullName) {
        String localName = "";
        if (fullName.contains(FULLNAME_END)) {
            localName = fullName.substring(fullName.indexOf(FULLNAME_END) + 1);
        }
        return localName;        
    }
    
    public static String convertToFullName(String ns, String local) {
        String name = "";
        if (ns != null && ns.length() != 0) {
            name = name + "{" + ns + "}";
        }
        return name + local;
    }
    
    public static String getNamespaceFromQName(Map<String, String> map, String qname) {
        String namespace = "";
        String prefix = getPrefixFromQName(qname);
        if (map != null && map.get(prefix) != null) {
            namespace = map.get(prefix);
        }
        return namespace;
    }
    
}
