/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core;

import org.eclipse.core.resources.IFile;


/**
 * This interface is used for accessing functionality and information provided
 * by a logicalPackage or physicalPackage extension point implementation.
 * 
 * @author rcernich
 *
 * Created on Mar 24, 2004
 */
public interface IPackageExtension {

	/**
	 * @return the id of this package extension.
	 */
	String getID();
	
	/**
	 * @return file extension used by files supported by this package extension.
	 */
	String getFileExtension();
	
	/**
	 * Verifies that this extension is capable of supporting the file resource
	 * in the workspace.  The extension may open the file during verifiecation.
	 * 
	 * @param file the file to verify
	 * 
	 * @return true if this extensions provides support for the specified file.
	 */
	boolean supportsFile(IFile file);
	
	/**
	 * Adapt the specified file to a package representation.  If the
	 * file cannot be adapted, null must be returned.
	 * 
	 * @param file the file to adapt.
	 * 
	 * @return an IPackage representation of the file.
	 */
	IPackage adaptFile(IFile file);

}
