/*******************************************************************************
 * Copyright (c) 2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core.ui.actions;

import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;

/**
 * @author rcernich
 * 
 * Created on Apr 11, 2006
 */
public class DeployActionProvider extends CommonActionProvider {

	public static final String DEPLOY_GROUP_START = DeployCorePlugin
			.getDefault().getBundle().getSymbolicName()
			+ ".DeployGroupStart"; //$NON-NLS-1$
	public static final String DEPLOY_GROUP_END = DeployCorePlugin
			.getDefault().getBundle().getSymbolicName()
			+ ".DeployGroupEnd"; //$NON-NLS-1$

	/**
	 * 
	 */
	public DeployActionProvider() {
		super();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.navigator.CommonActionProvider#init(org.eclipse.ui.navigator.ICommonActionExtensionSite)
	 */
	public void init(ICommonActionExtensionSite aConfig) {
	}

	public void fillActionBars(IActionBars actionBars) {
		super.fillActionBars(actionBars);
	}

	public void fillContextMenu(IMenuManager menu) {
		super.fillContextMenu(menu);

		menu.insertBefore(IWorkbenchActionConstants.MB_ADDITIONS,
				new Separator(DEPLOY_GROUP_START));
		menu.insertAfter(DEPLOY_GROUP_START, new CreatePackageFileAction("foo"));
		menu.insertAfter(DEPLOY_GROUP_START, new Separator(
				DEPLOY_GROUP_END));
	}

}
