/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.tests.model;

import java.io.IOException;
import java.util.List;
import javax.xml.namespace.QName;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.stp.core.infrastructure.emf.IEditModelFactory;
import org.eclipse.stp.core.infrastructure.emf.IEditModelScribbler;
import org.eclipse.stp.core.infrastructure.emf.IScribblerDomain;
import org.eclipse.stp.core.introspection.FeatureAdapter;
import org.eclipse.stp.core.resources.GeneralScribblerDomain;
import org.eclipse.stp.core.sca.AbstractReference;
import org.eclipse.stp.core.sca.AbstractService;
import org.eclipse.stp.core.sca.Component;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.EntryPoint;
import org.eclipse.stp.core.sca.ExternalService;
import org.eclipse.stp.core.sca.Implementation;
import org.eclipse.stp.core.sca.Interface;
import org.eclipse.stp.core.sca.JavaInterface;
import org.eclipse.stp.core.sca.Module;
import org.eclipse.stp.core.sca.Property;
import org.eclipse.stp.core.sca.Reference;
import org.eclipse.stp.core.sca.SCACoreRoot;
import org.eclipse.stp.core.sca.SCAFactory;
import org.eclipse.stp.core.sca.SCAObject;
import org.eclipse.stp.core.sca.SCAPackage;
import org.eclipse.stp.core.sca.Service;
import org.eclipse.stp.core.sca.WSDLPortType;
import org.eclipse.stp.core.sca.impl.ImplementationComponentImpl;
import org.eclipse.stp.core.tests.introspection.PropertiesSharedModel;
import org.eclipse.stp.core.tests.properties.PropertiesImplementation;
import org.eclipse.stp.core.tests.properties.PropsFactory;
import org.eclipse.stp.core.tests.properties.PropsPackage;
import org.eclipse.stp.core.tests.util.AssertionSAXHandler;
import org.eclipse.stp.core.tests.util.TestWorkspace;
import org.eclipse.stp.core.tests.util.XMLAssertions;

public class ComponentTypeTest
extends TestCase {
    private IProject project;

    public static void main(String[] args) {
        TestRunner.run(ComponentTypeTest.class);
    }

    public ComponentTypeTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject("Test");
        if (!this.project.exists()) {
            this.project.create((IProgressMonitor)new NullProgressMonitor());
            this.project.open((IProgressMonitor)new NullProgressMonitor());
        }
    }

    protected void tearDown() throws Exception {
    }

    public void testJavaInteraces() throws Exception {
        URI uri = URI.createPlatformResourceURI((String)"/Test/MyValue.java.componentType");
        Resource res = WorkbenchResourceHelperBase.createResource((URI)uri);
        SCAFactory fact = SCAFactory.eINSTANCE;
        SCACoreRoot root = fact.createSCACoreRoot();
        res.getContents().add((Object)((EObject)root));
        ComponentType contract = fact.createComponentType();
        root.setComponentType(contract);
        Service s1 = fact.createService();
        s1.setName("S1");
        JavaInterface jInt = this.createJavaInterface("com.acme.models.MyValue");
        s1.setInterface((Interface)jInt);
        contract.getServices().add(s1);
        Reference r1 = fact.createReference();
        r1.setName("R1");
        jInt = this.createJavaInterface("com.acme.models.ServiceManager");
        r1.setInterface((Interface)jInt);
        contract.getReferences().add(r1);
        Property prop = fact.createProperty();
        prop.setName("MyValueProperties");
        prop.setType((Object)"com.acme.models.properties.MyValueProperties");
        contract.getProperties().add(prop);
        res.save(null);
        XMLAssertions xmlAssert = AssertionSAXHandler.parseFile(res, true);
        xmlAssert.assertNoXSITypeAttributes();
        res.unload();
        contract = null;
        s1 = null;
        r1 = null;
        jInt = null;
        prop = null;
        res.load(null);
        ComponentTypeTest.assertTrue((res.getContents().size() == 1 ? 1 : 0) != 0);
        ComponentTypeTest.assertTrue((boolean)(res.getContents().get(0) instanceof SCACoreRoot));
        root = (SCACoreRoot)res.getContents().get(0);
        contract = root.getComponentType();
        ComponentTypeTest.assertNotNull((Object)contract);
        ComponentTypeTest.assertTrue((contract.getServices().size() == 1 ? 1 : 0) != 0);
        s1 = (Service)contract.getServices().get(0);
        ComponentTypeTest.assertEquals((String)"S1", (String)s1.getName());
        ComponentTypeTest.assertTrue((boolean)(s1.getInterface() instanceof JavaInterface));
        ComponentTypeTest.assertEquals((String)"com.acme.models.MyValue", (String)((JavaInterface)s1.getInterface()).getInterface());
        ComponentTypeTest.assertTrue((contract.getReferences().size() == 1 ? 1 : 0) != 0);
        r1 = (Reference)contract.getReferences().get(0);
        ComponentTypeTest.assertEquals((String)"R1", (String)r1.getName());
        ComponentTypeTest.assertTrue((boolean)(r1.getInterface() instanceof JavaInterface));
        ComponentTypeTest.assertEquals((String)"com.acme.models.ServiceManager", (String)((JavaInterface)r1.getInterface()).getInterface());
        ComponentTypeTest.assertTrue((contract.getProperties().size() == 1 ? 1 : 0) != 0);
        ComponentTypeTest.assertTrue((boolean)(contract.getProperties().get(0) instanceof Property));
        prop = (Property)contract.getProperties().get(0);
        ComponentTypeTest.assertEquals((String)"MyValueProperties", (String)prop.getName());
        ComponentTypeTest.assertEquals((String)"com.acme.models.properties.MyValueProperties", (String)prop.getType().toString());
    }

    public void testWSDLInteraces() throws IOException {
        URI uri = URI.createPlatformResourceURI((String)"/Test/MyTestWSDL.wsdl.componentType");
        Resource res = WorkbenchResourceHelperBase.createResource((URI)uri);
        SCAFactory fact = SCAFactory.eINSTANCE;
        SCACoreRoot root = fact.createSCACoreRoot();
        root.getXMLNSPrefixMap().put("acme", "http://acmeModels.com/ServiceManager.wsdl");
        res.getContents().add((Object)((EObject)root));
        ComponentType contract = fact.createComponentType();
        root.setComponentType(contract);
        Service s1 = fact.createService();
        s1.setName("S1");
        WSDLPortType wInt = this.createWSDLPortType("acme:MyValuePortType");
        s1.setInterface((Interface)wInt);
        contract.getServices().add(s1);
        Reference r1 = fact.createReference();
        r1.setName("R1");
        wInt = this.createWSDLPortType("acme:ServiceManagerPortType");
        r1.setInterface((Interface)wInt);
        contract.getReferences().add(r1);
        Property prop = fact.createProperty();
        prop.setName("ServiceManagerProperties");
        prop.setType((Object)"acme:ServiceManager");
        contract.getProperties().add(prop);
        res.save(null);
        res.unload();
        contract = null;
        s1 = null;
        r1 = null;
        wInt = null;
        prop = null;
        res.load(null);
        ComponentTypeTest.assertTrue((res.getContents().size() == 1 ? 1 : 0) != 0);
        ComponentTypeTest.assertTrue((boolean)(res.getContents().get(0) instanceof SCACoreRoot));
        root = (SCACoreRoot)res.getContents().get(0);
        contract = root.getComponentType();
        ComponentTypeTest.assertNotNull((Object)contract);
        ComponentTypeTest.assertTrue((contract.getServices().size() == 1 ? 1 : 0) != 0);
        s1 = (Service)contract.getServices().get(0);
        ComponentTypeTest.assertEquals((String)"S1", (String)s1.getName());
        ComponentTypeTest.assertTrue((boolean)(s1.getInterface() instanceof WSDLPortType));
        ComponentTypeTest.assertEquals((String)"acme:MyValuePortType", (String)((WSDLPortType)s1.getInterface()).getInterface());
        ComponentTypeTest.assertTrue((contract.getReferences().size() == 1 ? 1 : 0) != 0);
        r1 = (Reference)contract.getReferences().get(0);
        ComponentTypeTest.assertEquals((String)"R1", (String)r1.getName());
        ComponentTypeTest.assertTrue((boolean)(r1.getInterface() instanceof WSDLPortType));
        ComponentTypeTest.assertEquals((String)"acme:ServiceManagerPortType", (String)((WSDLPortType)r1.getInterface()).getInterface());
        ComponentTypeTest.assertTrue((contract.getProperties().size() == 1 ? 1 : 0) != 0);
        ComponentTypeTest.assertTrue((boolean)(contract.getProperties().get(0) instanceof Property));
        prop = (Property)contract.getProperties().get(0);
        ComponentTypeTest.assertEquals((String)"ServiceManagerProperties", (String)prop.getName());
        ComponentTypeTest.assertEquals((String)"acme", (String)((QName)prop.getType()).getPrefix());
        ComponentTypeTest.assertEquals((String)"ServiceManager", (String)((QName)prop.getType()).getLocalPart());
    }

    public void testsetSpecializedImplementation() throws Exception {
        IEditModelScribbler scribbler = IEditModelFactory.eINSTANCE.createScribblerForWrite(TestWorkspace.getComponentTypeIntrospectorTestProject(), (IScribblerDomain)new GeneralScribblerDomain(TestWorkspace.getComponentTypeIntrospectorTestProject()));
        Resource res = scribbler.getResource((IPath)new Path("/Test/MyCoolModule.module"), 0);
        SCAFactory fact = SCAFactory.eINSTANCE;
        SCACoreRoot root = fact.createSCACoreRoot();
        Component component = fact.createComponent();
        Module module = fact.createModule();
        module.getComponents().add(component);
        root.setModule(module);
        res.getContents().add((Object)((EObject)root));
        ComponentType contract = fact.createComponentType();
        Service s1 = fact.createService();
        s1.setName("S1");
        JavaInterface jInt = fact.createJavaInterface();
        jInt.setInterface("com.acme.models.MyValue");
        s1.setInterface((Interface)jInt);
        contract.getServices().add(s1);
        Reference r1 = fact.createReference();
        r1.setName("R1");
        jInt = fact.createJavaInterface();
        jInt.setInterface("com.acme.models.ServiceManager");
        r1.setInterface((Interface)jInt);
        contract.getReferences().add(r1);
        Property prop = fact.createProperty();
        prop.setName("MyValueProperties");
        prop.setType((Object)"com.acme.models.properties.MyValueProperties");
        prop.setDefault("com.acme.models.properties.MyValueProperties");
        contract.getProperties().add(prop);
        component.setAbstractImplementation(contract);
        Implementation abstractImplementation = component.getImplementation();
        ComponentTypeTest.assertTrue((abstractImplementation != null ? 1 : 0) != 0);
        ComponentTypeTest.assertTrue((boolean)abstractImplementation.getEObject().eClass().equals(SCAPackage.eINSTANCE.getAbstractImplementation()));
        ComponentTypeTest.assertEquals((String)"The state should be abstract", (int)1, (int)component.getState());
        ComponentTypeTest.assertEquals((String)"The type should be implementation.abstract", (String)"implementation.abstract", (String)component.getType());
        scribbler.save(true, null);
        XMLAssertions xmlAssert = AssertionSAXHandler.parseFile(res, true);
        xmlAssert.assertNoXSITypeAttributes();
        IFile propertiesFile = TestWorkspace.getComponentTypeIntrospectorTestProject().getFile("MyCoolComponent.properties");
        PropertiesSharedModel.NotifyingProperties realImplementation = PropertiesSharedModel.getProperties(propertiesFile);
        ComponentType currentContract = component.resolveComponentType();
        List services = currentContract.getServices();
        int i = 0;
        while (i < services.size()) {
            Service service = (Service)services.get(i);
            JavaInterface jInterface = (JavaInterface)service.getInterface();
            PropertiesSharedModel.createNewService(realImplementation, service.getName(), jInterface.getInterface());
            ++i;
        }
        List references = currentContract.getReferences();
        int i2 = 0;
        while (i2 < references.size()) {
            Reference reference = (Reference)references.get(i2);
            JavaInterface jInterface = (JavaInterface)reference.getInterface();
            PropertiesSharedModel.createNewReference(realImplementation, reference.getName(), jInterface.getInterface());
            ++i2;
        }
        List properties = currentContract.getProperties();
        int i3 = 0;
        while (i3 < properties.size()) {
            Property property = (Property)properties.get(i3);
            String defaultValue = property.getDefault();
            PropertiesSharedModel.createNewProperty(realImplementation, property.getName(), defaultValue);
            ++i3;
        }
        PropertiesSharedModel.saveProperties(realImplementation);
        PropertiesImplementation pImpl = PropsFactory.eINSTANCE.createPropertiesImplementation();
        pImpl.setProperties(propertiesFile.getProjectRelativePath().toString());
        FeatureAdapter.setFeature((SCAObject)pImpl, (EStructuralFeature)PropsPackage.eINSTANCE.getDocumentRoot_ImplementationProperties());
        component.setSpecializedImplementation((Implementation)pImpl);
        FeatureMap implementationGroup = ((ImplementationComponentImpl)component).getImplementationGroup();
        ComponentTypeTest.assertEquals((int)1, (int)implementationGroup.size());
        Implementation currentImplementation = component.getImplementation();
        ComponentTypeTest.assertNotNull((Object)currentImplementation);
        ComponentTypeTest.assertEquals((Object)PropsPackage.eINSTANCE.getPropertiesImplementation(), (Object)currentImplementation.getEObject().eClass());
        ComponentTypeTest.assertEquals((String)"The state should be IMPLEMENTED", (int)3, (int)component.getState());
        ComponentTypeTest.assertEquals((String)"The type should be implementation.properties", (String)"implementation.properties", (String)component.getType());
        ComponentType newComponentType = component.resolveComponentType();
        ComponentTypeTest.assertNotNull((Object)newComponentType);
        ComponentTypeTest.assertTrue((newComponentType.getServices().size() == 1 ? 1 : 0) != 0);
        s1 = (Service)newComponentType.getServices().get(0);
        ComponentTypeTest.assertEquals((String)"S1", (String)s1.getName());
        ComponentTypeTest.assertTrue((boolean)(s1.getInterface() instanceof JavaInterface));
        ComponentTypeTest.assertEquals((String)"com.acme.models.MyValue", (String)((JavaInterface)s1.getInterface()).getInterface());
        ComponentTypeTest.assertTrue((newComponentType.getReferences().size() == 1 ? 1 : 0) != 0);
        r1 = (Reference)newComponentType.getReferences().get(0);
        ComponentTypeTest.assertEquals((String)"R1", (String)r1.getName());
        ComponentTypeTest.assertTrue((boolean)(r1.getInterface() instanceof JavaInterface));
        ComponentTypeTest.assertEquals((String)"com.acme.models.ServiceManager", (String)((JavaInterface)r1.getInterface()).getInterface());
        ComponentTypeTest.assertTrue((newComponentType.getProperties().size() == 1 ? 1 : 0) != 0);
        ComponentTypeTest.assertTrue((boolean)(newComponentType.getProperties().get(0) instanceof Property));
        prop = (Property)newComponentType.getProperties().get(0);
        ComponentTypeTest.assertEquals((String)"MyValueProperties", (String)prop.getName());
        ComponentTypeTest.assertEquals((String)"com.acme.models.properties.MyValueProperties", (String)prop.getDefault().toString());
        Implementation oldImplementation = component.setAbstractImplementation(newComponentType);
        ComponentTypeTest.assertNotNull((Object)oldImplementation);
        ComponentTypeTest.assertEquals((Object)PropsPackage.eINSTANCE.getPropertiesImplementation(), (Object)oldImplementation.getEObject().eClass());
        abstractImplementation = component.getImplementation();
        ComponentTypeTest.assertTrue((abstractImplementation != null ? 1 : 0) != 0);
        ComponentTypeTest.assertTrue((boolean)abstractImplementation.getEObject().eClass().equals(SCAPackage.eINSTANCE.getAbstractImplementation()));
        ComponentTypeTest.assertEquals((String)"The state should be abstract", (int)1, (int)component.getState());
        ComponentTypeTest.assertEquals((String)"The type should be implementation.abstract", (String)"implementation.abstract", (String)component.getType());
        scribbler.close(null);
    }

    public void testSimpleAbstractServiceMatch() throws Exception {
        URI uri = URI.createPlatformResourceURI((String)"/Test/Foo.java.componentType");
        Resource res = WorkbenchResourceHelperBase.createResource((URI)uri);
        SCAFactory fact = SCAFactory.eINSTANCE;
        SCACoreRoot root = fact.createSCACoreRoot();
        res.getContents().add((Object)((EObject)root));
        JavaInterface jInt1 = this.createJavaInterface("com.acme.models.Foo");
        JavaInterface jInt2 = this.createJavaInterface("com.acme.models.Foo2");
        JavaInterface jInt3 = this.createJavaInterface("com.acme.models.Bar");
        JavaInterface jInt4 = this.createJavaInterface("com.acme.models.Bar2");
        ComponentType contract = fact.createComponentType();
        root.setComponentType(contract);
        Service s1 = fact.createService();
        s1.setName("S1");
        s1.setInterface((Interface)jInt1);
        contract.getServices().add(s1);
        Service s2 = fact.createService();
        s2.setName("S2");
        s2.setInterface((Interface)jInt2);
        contract.getServices().add(s2);
        Reference r1 = fact.createReference();
        r1.setName("R1");
        r1.setInterface((Interface)jInt3);
        contract.getReferences().add(r1);
        Reference r2 = fact.createReference();
        r2.setName("R2");
        r2.setInterface((Interface)jInt4);
        contract.getReferences().add(r1);
        EntryPoint ep = fact.createEntryPoint();
        ep.setName("Entry1");
        ep.setInterface((Interface)this.createJavaInterface(jInt1.getInterface()));
        ExternalService es = fact.createExternalService();
        es.setName("External1");
        es.setInterface((Interface)this.createJavaInterface(jInt3.getInterface()));
        this.assertServicesMatch((AbstractReference)ep, (AbstractService)s1);
        this.assertServicesNotMatch((AbstractReference)ep, (AbstractService)s2);
        this.assertServicesNotMatch((AbstractReference)ep, (AbstractService)es);
        this.assertReferencesMatch((AbstractService)es, (AbstractReference)r1);
        this.assertReferencesNotMatch((AbstractService)es, (AbstractReference)r2);
        this.assertReferencesNotMatch((AbstractService)es, (AbstractReference)ep);
        res.save(null);
        res.unload();
        XMLAssertions xmlAssert = AssertionSAXHandler.parseFile(res, true);
        xmlAssert.assertNoXSITypeAttributes();
    }

    private JavaInterface createJavaInterface(String qualifiedName) {
        JavaInterface jInt = SCAFactory.eINSTANCE.createJavaInterface();
        jInt.setInterface(qualifiedName);
        return jInt;
    }

    private WSDLPortType createWSDLPortType(String portType) {
        WSDLPortType port = SCAFactory.eINSTANCE.createWSDLPortType();
        port.setInterface(portType);
        return port;
    }

    private void assertServicesMatch(AbstractReference ref, AbstractService serv) {
        ComponentTypeTest.assertNotNull((Object)ref);
        ComponentTypeTest.assertNotNull((Object)serv);
        ComponentTypeTest.assertTrue((boolean)ref.matches(serv));
    }

    private void assertServicesNotMatch(AbstractReference ref, AbstractService serv) {
        ComponentTypeTest.assertNotNull((Object)ref);
        ComponentTypeTest.assertNotNull((Object)serv);
        ComponentTypeTest.assertFalse((boolean)ref.matches(serv));
    }

    private void assertReferencesMatch(AbstractService serv, AbstractReference ref) {
        ComponentTypeTest.assertNotNull((Object)ref);
        ComponentTypeTest.assertNotNull((Object)serv);
        ComponentTypeTest.assertTrue((boolean)serv.matches(ref));
    }

    private void assertReferencesNotMatch(AbstractService serv, AbstractReference ref) {
        ComponentTypeTest.assertNotNull((Object)ref);
        ComponentTypeTest.assertNotNull((Object)serv);
        ComponentTypeTest.assertFalse((boolean)serv.matches(ref));
    }
}

