/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.tests.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import junit.framework.Assert;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.stp.core.infrastructure.emf.WorkbenchResourceHelper;
import org.eclipse.stp.core.tests.util.XMLAssertions;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class AssertionSAXHandler
extends DefaultHandler
implements XMLAssertions {
    private static final String XSI_TYPE = "xsi:type";
    private final List xsiElements = new ArrayList();

    public static XMLAssertions parseFile(IFile aFile, boolean toValidate) throws CoreException, IOException, SAXException, ParserConfigurationException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(toValidate);
        factory.setNamespaceAware(true);
        SAXParser parser = factory.newSAXParser();
        XMLReader reader = parser.getXMLReader();
        AssertionSAXHandler handler = new AssertionSAXHandler();
        try {
            reader.setFeature("http://xml.org/sax/features/validation", toValidate);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {}
        try {
            reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {}
        try {
            reader.setFeature("http://apache.org/xml/features/validation/schema", toValidate);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            try {
                reader.setFeature("http://xml.org/sax/features/validation", false);
            }
            catch (SAXNotRecognizedException e1) {
                e1.printStackTrace();
            }
            catch (SAXNotSupportedException e1) {
                e1.printStackTrace();
            }
            Logger.getLogger().log((Object)"Warning: Parser does not support \"http://apache.org/xml/features/validation/schema\". Validation will be disabled.");
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            try {
                reader.setFeature("http://xml.org/sax/features/validation", false);
            }
            catch (SAXNotRecognizedException e1) {
                e1.printStackTrace();
            }
            catch (SAXNotSupportedException e1) {
                e1.printStackTrace();
            }
            Logger.getLogger().log((Object)"Warning: Parser does not support \"http://apache.org/xml/features/validation/schema\". Validation will be disabled.");
        }
        try {
            reader.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            Logger.getLogger().log((Object)"Warning: Parser does not support \"http://apache.org/xml/features/allow-java-encodings\".");
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            Logger.getLogger().log((Object)"Warning: Parser does not support \"http://apache.org/xml/features/allow-java-encodings\".");
        }
        reader.setContentHandler(handler);
        reader.setErrorHandler(handler);
        reader.setEntityResolver(handler);
        InputStream inStream = aFile.getContents();
        InputSource testsource = new InputSource(inStream);
        reader.parse(testsource);
        return handler;
    }

    public static XMLAssertions parseFile(Resource aResource, boolean toValidate) throws CoreException, IOException, SAXException, ParserConfigurationException {
        IFile actualFile = WorkbenchResourceHelper.getFile((Resource)aResource);
        return AssertionSAXHandler.parseFile(actualFile, toValidate);
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        int i = 0;
        while (i < atts.getLength()) {
            String attQName = atts.getQName(i);
            if (XSI_TYPE.equals(attQName)) {
                this.xsiElements.add(String.valueOf(qName) + "{xsi:type='" + atts.getValue(i) + "'}");
            }
            ++i;
        }
    }

    public void assertNoXSITypeAttributes() {
        if (this.xsiElements.size() > 0) {
            StringBuffer buffer = new StringBuffer("There should be no xsi:type attributes in the output: ");
            int i = 0;
            while (i < this.xsiElements.size()) {
                buffer.append(" [").append(this.xsiElements.get(i));
                if (i < this.xsiElements.size() - 1) {
                    buffer.append("],");
                } else {
                    buffer.append("]");
                }
                ++i;
            }
            Assert.assertTrue((String)buffer.toString(), (this.xsiElements.size() == 0 ? 1 : 0) != 0);
        }
    }
}

