/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.tests.util;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.stp.core.tests.util.ProjectUnzipUtil;

public class TestWorkspace {
    public static final String TEST_RESOURCE_PROJECT_NAME = "TestResourceProject";
    private static final String TEST_RESOURCE_PROJECT_TESTDATA = "/testdata/TestResourceProject.zip";
    public static final String TEST_COMPONENT_PROJECT_NAME = "ComponentTest";
    public static final String TEST_COMPONENT_PROJECT_TESTDATA = "/testdata/ComponentTest.zip";
    public static final String MODULE1_PROJECT_NAME = "module1";
    public static final String MODULE1_PROJECT_TESTDATA = "/testdata/module1.zip";
    public static final String COMPONENT_TYPE_INTROSPECTOR_PROJECT_NAME = "Test";
    public static final String COMPONENT_TYPE_INTROSPECTOR_TESTDATA = "/testdata/Test.zip";

    public static void init() {
        ProjectUnzipUtil util = new ProjectUnzipUtil((IPath)new Path(TEST_RESOURCE_PROJECT_TESTDATA), new String[]{TEST_RESOURCE_PROJECT_NAME});
        if (!TestWorkspace.getResourceTestProject().isAccessible()) {
            util.createProjects();
        } else {
            util.reset();
        }
        util = new ProjectUnzipUtil((IPath)new Path(MODULE1_PROJECT_TESTDATA), new String[]{MODULE1_PROJECT_NAME});
        if (!TestWorkspace.getModuleTestProject().isAccessible()) {
            util.createProjects();
        } else {
            util.reset();
        }
        util = new ProjectUnzipUtil((IPath)new Path(COMPONENT_TYPE_INTROSPECTOR_TESTDATA), new String[]{COMPONENT_TYPE_INTROSPECTOR_PROJECT_NAME});
        if (!TestWorkspace.getComponentTypeIntrospectorTestProject().isAccessible()) {
            util.createProjects();
        } else {
            util.reset();
        }
        util = new ProjectUnzipUtil((IPath)new Path(TEST_COMPONENT_PROJECT_TESTDATA), new String[]{TEST_COMPONENT_PROJECT_NAME});
        if (!TestWorkspace.getComponentTestProject().isAccessible()) {
            util.createProjects();
        } else {
            util.reset();
        }
    }

    public static IProject getResourceTestProject() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(TEST_RESOURCE_PROJECT_NAME);
    }

    public static IProject getComponentTestProject() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(TEST_COMPONENT_PROJECT_NAME);
    }

    public static IProject getModuleTestProject() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(MODULE1_PROJECT_NAME);
    }

    public static IProject getComponentTypeIntrospectorTestProject() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(COMPONENT_TYPE_INTROSPECTOR_PROJECT_NAME);
    }
}

