/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.utils;

import junit.framework.Assert;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.stp.sc.common.internal.model.RuntimeCore;
import org.eclipse.stp.sc.common.utils.WorkbenchUtils;
import org.eclipse.stp.sc.jaxws.workspace.ScNature;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.wst.server.core.IRuntime;

public final class TestUtilities
extends WorkbenchUtils {
    static String TEST_CXF_RUNTIME_ID = "test_cxf_runtime";
    static String TEST_CXF_RUNTIME_TYPE = "org.eclipse.stp.soas.deploy.runtime.cxf.20";

    private TestUtilities() {
    }

    public static void checkTable(Table table, String[] columns) {
        Assert.assertEquals((String)"Wrong number of columns", (int)columns.length, (int)table.getColumns().length);
        Assert.assertTrue((String)"Table should be visible", (boolean)table.getVisible());
        int expectedColumnWidth = table.getSize().x / columns.length;
        int i = 0;
        while (i < columns.length) {
            Assert.assertEquals((String)("Wrong title for column " + i), (String)columns[i], (String)table.getColumn(i).getText());
            Assert.assertTrue((String)("Column " + i + " should be resizeable"), (boolean)table.getColumn(i).getResizable());
            Assert.assertTrue((String)("Column " + i + " width " + table.getColumn(i).getWidth() + " not within +/- 25% of " + expectedColumnWidth), ((double)table.getColumn(i).getWidth() >= (double)expectedColumnWidth * 0.8 && (double)table.getColumn(i).getWidth() <= (double)expectedColumnWidth * 1.4 ? 1 : 0) != 0);
            ++i;
        }
        Assert.assertTrue((String)"Header should be visible", (boolean)table.getHeaderVisible());
        Assert.assertTrue((String)"Grid lines should be visible", (boolean)table.getLinesVisible());
    }

    public static void checkVisible(Control control, String name) {
        TestUtilities.checkVisible(control, name, true);
    }

    public static void checkNotVisible(Control control, String name) {
        TestUtilities.checkVisible(control, name, false);
    }

    public static void checkVisible(Control control, String name, boolean visible) {
        Assert.assertNotNull((String)("Control " + name + " should not be null"), (Object)control);
        if (visible) {
            Assert.assertTrue((String)("Control " + name + " should  be visible"), (boolean)control.isVisible());
            Assert.assertTrue((String)("Control " + name + " should not be disposed"), (!control.isDisposed() ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((String)("Control " + name + " should not be visible"), (control.isDisposed() || !control.isVisible() ? 1 : 0) != 0);
        }
    }

    public static void setupJavaProject(IProject project) throws Exception {
        TestUtilities.setupBasicJavaProject((IProject)project);
        if (!project.hasNature("org.eclipse.stp.sc.jaxws.nature")) {
            ScNature.addToProject((IProject)project, (String)"JavaFrist");
        }
    }

    public static void setupTestRuntimeInfo(IProject project) {
        String runtimeId = TestUtilities.createTestRuntime();
        RuntimeCore.setRuntimeID((IProject)project, (String)runtimeId);
        RuntimeCore.setRuntimeType((IProject)project, (String)TEST_CXF_RUNTIME_TYPE);
    }

    public static String createTestRuntime() {
        try {
            IRuntime runtime = RuntimeCore.getRuntime((String)TEST_CXF_RUNTIME_ID);
            String runtimeId = null;
            if (runtime == null) {
                String kitLocation = System.getProperty("jaxws_kit_location");
                Path kitPath = new Path(kitLocation);
                runtimeId = RuntimeCore.creatRuntime((String)TEST_CXF_RUNTIME_TYPE, (String)TEST_CXF_RUNTIME_ID, (IPath)kitPath);
            } else {
                runtimeId = runtime.getId();
            }
            return runtimeId;
        }
        catch (Throwable th) {
            th.printStackTrace();
            return null;
        }
    }

    public static IProject createTestCeltixProject(String projectName) {
        IProject newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!newProject.exists()) {
            newProject = TestUtilities.createProject((String)projectName, null);
        } else {
            try {
                newProject.open(null);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        TestUtilities.setupTestRuntimeInfo(newProject);
        return newProject;
    }
}

