/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.wizards;

import java.lang.reflect.InvocationTargetException;
import javax.jws.WebService;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.stp.sc.common.utils.JDTUtils;
import org.eclipse.stp.sc.common.utils.SWTUtils;
import org.eclipse.stp.sc.common.workspace.WorkspaceManager;
import org.eclipse.stp.sc.jaxws.internal.wizards.RuntimeSelectionPage;
import org.eclipse.stp.sc.jaxws.properties.ScJaxWsPropertyConstants;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IWizardPageContentsBase;
import org.eclipse.stp.sc.jaxws.utils.TestUtilities;
import org.eclipse.stp.sc.jaxws.wizards.AbstractStartingPointPageContents;
import org.eclipse.stp.sc.jaxws.wizards.StartingPointWizardPage;
import org.eclipse.stp.sc.jaxws.wizards.WebServiceProjectWizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class WebServiceProjectWizardTest
extends TestCase {
    private static String TEST_PROJECT_NAME = "JAXWS-JavaFirst-TestProject";
    private static String TEMP_PROJECT_NAME = "tempProject";
    private static final String JAVA_RESOURCE = "HelloInterface.java_resource";
    private static final String LOCAL_JAVA = "src/HelloInterface.java";
    private static final String IMPORTED_JAVA = "src/com/iona/HelloInterface.java";

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
        IProject proj = WorkspaceManager.getProject((String)TEST_PROJECT_NAME);
        if (proj.exists()) {
            proj.delete(true, null);
        }
        if ((proj = WorkspaceManager.getProject((String)TEMP_PROJECT_NAME)).exists()) {
            proj.delete(true, null);
        }
    }

    public void testAddPages() throws Exception {
        WebServiceProjectWizard wizard = new WebServiceProjectWizard();
        wizard.init(PlatformUI.getWorkbench(), null);
        WebServiceProjectWizardTest.assertTrue((boolean)wizard.needsProgressMonitor());
        wizard.addPages();
        int count = wizard.getPageCount();
        WebServiceProjectWizardTest.assertEquals((String)"should have 3 pages", (int)3, (int)count);
    }

    public void testCreateJavaFirstProject() throws Exception {
        TestUtilities.createTestRuntime();
        MyWebServiceProjectWizard wizard = new MyWebServiceProjectWizard();
        wizard.addPages();
        wizard.init(PlatformUI.getWorkbench(), null);
        WizardNewProjectCreationPage genPage = (WizardNewProjectCreationPage)wizard.getPage("generalPage");
        genPage.createControl((Composite)PlatformUI.getWorkbench().getDisplay().getShells()[0]);
        Text txtProjectName = SWTUtils.getTextInCompositeByLabel((Composite)((Composite)genPage.getControl()), (String)"&Project name:");
        txtProjectName.setText(TEST_PROJECT_NAME);
        RuntimeSelectionPage runtimePage = (RuntimeSelectionPage)wizard.getPage("runtimePage");
        runtimePage.createControl((Composite)PlatformUI.getWorkbench().getDisplay().getShells()[0]);
        runtimePage.selectRuntimeByIndex(0);
        WebServiceProjectWizardTest.assertTrue((String)"should be starting point page", (boolean)(runtimePage.getNextPage() instanceof StartingPointWizardPage));
        IProject tempProject = TestUtilities.createTestCeltixProject(TEMP_PROJECT_NAME);
        IFile testFile = TestUtilities.addFileResourceToTestProject((IProject)tempProject, (String)LOCAL_JAVA, ((Object)((Object)this)).getClass(), (String)"/resources/HelloInterface.java_resource");
        StartingPointWizardPage startPointPage = (StartingPointWizardPage)runtimePage.getNextPage();
        startPointPage.setPageContents((IWizardPageContentsBase)new MyStartingPointPageContents(testFile.getLocation().toOSString()));
        startPointPage.createControl((Composite)PlatformUI.getWorkbench().getDisplay().getShells()[0]);
        try {
            wizard.performFinish();
        }
        catch (Exception e) {
            e.printStackTrace();
            WebServiceProjectWizardTest.fail((String)e.getMessage());
        }
        IProject proj = WorkspaceManager.getProject((String)TEST_PROJECT_NAME);
        WebServiceProjectWizardTest.assertTrue((String)"should  create project.", (boolean)proj.exists());
        WebServiceProjectWizardTest.assertTrue((String)"should have jax-ws nature", (boolean)proj.hasNature("org.eclipse.stp.sc.jaxws.nature"));
        WebServiceProjectWizardTest.assertTrue((String)"should have java first nature", (boolean)proj.hasNature("org.eclipse.stp.sc.jaxws.javaFirstNature"));
        WebServiceProjectWizardTest.assertTrue((String)"should has ann validatation builder", (boolean)WorkspaceManager.hasBuilder((IProject)proj, (String)"org.eclipse.stp.sc.annvalidator"));
        String mode = proj.getPersistentProperty(ScJaxWsPropertyConstants.PROPERTY_KEY_MODE);
        WebServiceProjectWizardTest.assertNotNull((Object)mode);
        WebServiceProjectWizardTest.assertTrue((String)"should set to java first mode.", (boolean)mode.equals("JavaFrist"));
        IFile importFile = proj.getFile(IMPORTED_JAVA);
        WebServiceProjectWizardTest.assertNotNull((Object)importFile);
        WebServiceProjectWizardTest.assertTrue((String)"should exist starting point file", (boolean)importFile.exists());
        proj.build(10, null);
        JDTUtils.hasAnnotationOnPrimaryType((IFile)importFile, WebService.class);
    }

    class MyStartingPointPageContents
    extends AbstractStartingPointPageContents {
        private String fileName;

        public MyStartingPointPageContents(String fileName) {
            this.fileName = fileName;
        }

        public Control createContents(Composite parent) {
            Control control = super.createContents(parent);
            this.txtStartingPoint.setText(this.fileName);
            return control;
        }
    }

    class MyWebServiceProjectWizard
    extends WebServiceProjectWizard {
        MyWebServiceProjectWizard() {
        }

        public boolean publicCreateProject() throws InvocationTargetException {
            return super.createProject(null);
        }
    }
}

