/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.wizards.annotations.webmethod;

import javax.jws.WebMethod;
import javax.jws.WebResult;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.stp.sc.common.utils.SWTUtils;
import org.eclipse.stp.sc.jaxws.ScJaxWsPlugin;
import org.eclipse.stp.sc.jaxws.utils.TestUtilities;
import org.eclipse.stp.sc.jaxws.wizards.ScWizardDialog;
import org.eclipse.stp.sc.jaxws.wizards.annotations.AnnotationAttributePage;
import org.eclipse.stp.sc.jaxws.wizards.annotations.webmethod.CreateWebMethodWizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class CreateWebMethodWizardForDefaultPackageTest
extends TestCase {
    private static final String TEST_PROJECT_NAME = "CreateWebMethodWizardForDefaultPackageTestProject";
    private static final String LOCAL_JAVA = "src/HelloWorld.java";
    private static final String JAVA_RESOURCE = "HelloWorld_in_default_package.java_resource";
    private IProject testProject = null;
    private IJavaElement javaFile;
    private IMember methodMember;
    private CreateWebMethodWizard wizard;
    private WizardDialog dialog;
    private AnnotationAttributePage methodAttributePage;
    private AnnotationAttributePage resultAttributePage;
    private AnnotationAttributePage requestWrapperAttributePage;
    private AnnotationAttributePage responseWrapperAttributePage;
    private IPreferenceStore preference_store;
    private String originalPrefFlag;
    IFile testFile;

    protected void setUp() throws Exception {
        this.preference_store = ScJaxWsPlugin.getDefault().getPreferenceStore();
        this.originalPrefFlag = this.preference_store.getString("annWizEnabled");
        this.preference_store.setValue("annWizEnabled", "enabled");
        this.testProject = TestUtilities.createTestCeltixProject(TEST_PROJECT_NAME);
        TestUtilities.setupJavaProject(this.testProject);
        this.testFile = TestUtilities.addFileResourceToTestProject((IProject)this.testProject, (String)LOCAL_JAVA, ((Object)((Object)this)).getClass(), (String)"/resources/HelloWorld_in_default_package.java_resource");
    }

    protected void tearDown() throws Exception {
        this.preference_store.setValue("annWizEnabled", this.originalPrefFlag);
        if (this.testProject.exists()) {
            this.testProject.delete(true, null);
        }
    }

    public void testDefaultPackageName() throws Exception {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        TestUtilities.openEditor((IWorkbenchWindow)window, (IFile)this.testFile);
        this.javaFile = JavaCore.create((IFile)this.testFile);
        CreateWebMethodWizardForDefaultPackageTest.assertTrue((boolean)(this.javaFile instanceof ICompilationUnit));
        IType[] types = ((ICompilationUnit)this.javaFile).getTypes();
        int i = 0;
        while (i < types.length) {
            if (types[i] instanceof IMember) {
                IType cfr_ignored_0 = types[i];
                this.methodMember = types[i].getMethod("sayHello", new String[0]);
                break;
            }
            ++i;
        }
        this.openMethodWizard(this.methodMember);
        this.setupPages();
        CreateWebMethodWizardForDefaultPackageTest.assertNotNull((Object)this.methodAttributePage);
        CreateWebMethodWizardForDefaultPackageTest.assertNotNull((Object)this.resultAttributePage);
        CreateWebMethodWizardForDefaultPackageTest.assertNotNull((Object)this.requestWrapperAttributePage);
        CreateWebMethodWizardForDefaultPackageTest.assertNotNull((Object)this.responseWrapperAttributePage);
        Composite composite = (Composite)this.requestWrapperAttributePage.getControl();
        Text txtClassName = SWTUtils.getTextInCompositeByLabel((Composite)composite, (String)"className");
        CreateWebMethodWizardForDefaultPackageTest.assertEquals((String)"should be default_package", (String)"default_package.SayHello", (String)txtClassName.getText());
        composite = (Composite)this.responseWrapperAttributePage.getControl();
        txtClassName = SWTUtils.getTextInCompositeByLabel((Composite)composite, (String)"className");
        CreateWebMethodWizardForDefaultPackageTest.assertEquals((String)"should be default_package", (String)"default_package.SayHelloResponse", (String)txtClassName.getText());
        this.closeMethodWizard();
    }

    private void openMethodWizard(IMember member) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        this.wizard = new CreateWebMethodWizard(member);
        this.dialog = new ScWizardDialog(window.getShell(), (IWizard)this.wizard);
        this.dialog.setBlockOnOpen(false);
        this.dialog.open();
    }

    private void closeMethodWizard() throws Exception {
        this.dialog.close();
        this.methodAttributePage = null;
        this.resultAttributePage = null;
        this.requestWrapperAttributePage = null;
        this.responseWrapperAttributePage = null;
        this.wizard = null;
    }

    private void setupPages() throws Exception {
        String name = AnnotationAttributePage.generatePageName(WebMethod.class);
        this.methodAttributePage = (AnnotationAttributePage)this.wizard.getPage(name);
        name = AnnotationAttributePage.generatePageName(WebResult.class);
        this.resultAttributePage = (AnnotationAttributePage)this.wizard.getPage(name);
        name = AnnotationAttributePage.generatePageName(RequestWrapper.class);
        this.requestWrapperAttributePage = (AnnotationAttributePage)this.wizard.getPage(name);
        name = AnnotationAttributePage.generatePageName(ResponseWrapper.class);
        this.responseWrapperAttributePage = (AnnotationAttributePage)this.wizard.getPage(name);
    }
}

