/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.jaxws.ScJaxWsResources;
import org.eclipse.stp.sc.jaxws.internal.wizards.RuntimeSelectionPage;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IPostProjectProcessor;
import org.eclipse.stp.sc.jaxws.runtimeprovider.RuntimeProviderManager;
import org.eclipse.stp.sc.jaxws.wizards.WsdlFirstProjectWizard;
import org.eclipse.stp.sc.jaxws.workspace.JaxWsWorkspaceManager;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public abstract class ProjectWizardBase
extends Wizard
implements INewWizard,
IExecutableExtension {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(WsdlFirstProjectWizard.class);
    public static final String GENERAL_PAGE = "generalPage";
    public static final String RUNTIME_PAGE = "runtimePage";
    protected IConfigurationElement fConfigElement;
    WizardNewProjectCreationPage genPage;
    RuntimeSelectionPage runtimePage;
    protected String projectMode;
    protected IProject project;

    public ProjectWizardBase() {
        String title = ScJaxWsResources.getString("CreateWebServiceProjectWizard.Title");
        this.setWindowTitle(title);
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.fConfigElement = cfig;
    }

    public void addPages() {
        this.genPage = new WizardNewProjectCreationPage(GENERAL_PAGE);
        this.genPage.setTitle(ScJaxWsResources.getString("WebServiceGeneralPage.Title"));
        this.genPage.setDescription(ScJaxWsResources.getString("WebServiceGeneralPage.Description"));
        ImageDescriptor banner = ScJaxWsResources.getImageDescriptor("wizban/jaxws_project_folder_wiz.jpg");
        this.genPage.setImageDescriptor(banner);
        this.addPage((IWizardPage)this.genPage);
        RuntimeProviderManager runtimeMgr = RuntimeProviderManager.getInstance();
        if (!runtimeMgr.getUseDefaultRuntime()) {
            this.runtimePage = new RuntimeSelectionPage(RUNTIME_PAGE, ScJaxWsResources.getString("runtimepage.title"), banner);
            this.addPage((IWizardPage)this.runtimePage);
        }
    }

    public boolean performFinish() {
        try {
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.getShell());
            IRunnableWithProgress rwp = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    ProjectWizardBase.this.createProject(monitor);
                }
            };
            pmd.run(false, false, rwp);
            if (this.isJaxwsProject()) {
                BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
            }
        }
        catch (InvocationTargetException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        catch (InterruptedException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    protected boolean isJaxwsProject() {
        try {
            String[] natures = this.project.getDescription().getNatureIds();
            return natures.length > 0 && "org.eclipse.stp.sc.jaxws.nature".equals(this.project.getDescription().getNatureIds()[0]);
        }
        catch (CoreException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setNeedsProgressMonitor(true);
    }

    protected boolean createProject(IProgressMonitor newMonitor) throws InvocationTargetException {
        IProgressMonitor checkedMonitor = newMonitor != null ? newMonitor : new NullProgressMonitor();
        checkedMonitor.beginTask("", 100);
        SubProgressMonitor createProjectMonitor = new SubProgressMonitor(checkedMonitor, 20);
        String runtimeType = this.getRuntimeType();
        String runtimeID = this.getRuntimeID();
        this.project = JaxWsWorkspaceManager.createProject((IProgressMonitor)createProjectMonitor, this.genPage.getProjectName(), this.genPage.getLocationPath(), this.projectMode, runtimeType, runtimeID);
        IPostProjectProcessor processor = RuntimeProviderManager.getInstance().getPostProjectProcessor(runtimeType);
        if (processor != null) {
            processor.postProcess(this.project);
        }
        try {
            try {
                this.project.refreshLocal(2, checkedMonitor);
            }
            catch (Exception ce) {
                LOG.error((Object)ce.getMessage(), (Throwable)ce);
                ce.printStackTrace();
                checkedMonitor.done();
            }
        }
        finally {
            checkedMonitor.done();
        }
        return true;
    }

    public String getProjectMode() {
        return this.projectMode;
    }

    protected void setProjectMode(String value) {
        this.projectMode = value;
    }

    private String getRuntimeType() {
        RuntimeProviderManager runtimeMgr = RuntimeProviderManager.getInstance();
        if (runtimeMgr.getUseDefaultRuntime()) {
            return runtimeMgr.getDefaultRuntimeType();
        }
        return this.runtimePage.getRuntimeType();
    }

    private String getRuntimeID() {
        RuntimeProviderManager runtimeMgr = RuntimeProviderManager.getInstance();
        if (runtimeMgr.getUseDefaultRuntime()) {
            return runtimeMgr.getDefaultRuntimeID();
        }
        return this.runtimePage.getRuntimeID();
    }
}

