/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.wizards.handler;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.AbstractList;
import javax.jws.HandlerChain;
import javax.jws.WebService;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.annotations.ScAnnotationSupportUtils;
import org.eclipse.stp.sc.common.utils.JDTUtils;
import org.eclipse.stp.sc.jaxws.ScJaxWsPlugin;
import org.eclipse.stp.sc.jaxws.ScJaxWsResources;
import org.eclipse.stp.sc.jaxws.wizards.WsdlFirstProjectWizard;
import org.eclipse.stp.sc.jaxws.wizards.handler.CreateXmlFileWizard;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class NewHandlerWizardPage
extends NewTypeWizardPage {
    private static final String HANDLER_CHAIN_FILE_EXTENSION = "xml";
    private static final String JAVA_FILE_EXTENSION = "java";
    private static final String PACKAGE_KEY_WORLD = "package";
    private static final LoggingProxy LOG = LoggingProxy.getlogger(WsdlFirstProjectWizard.class);
    private static final String LOGICAL_HANDLER_CLASS_TEMPLATE = "etc/templates/LogicalHandler.java_template";
    private static final String SOAP_HANDLER_CLASS_TEMPLATE = "etc/templates/SOAPHandler.java_template";
    private static final String PACKAGE_NAME_REPLACED = "$packageName";
    private static final String CLASS_NAME_REPLACED = "$className";
    private static final String USE_DEFAULT_PACKAGE = "//package default";
    private static final boolean IS_ASSOCIATED_WITH_SERVICE_DEFAULT = true;
    private static final boolean IS_ADDED_TO_CHAIN_DEFAULT = false;
    private static final boolean IS_CREATE_NEW_CHAIN_FILE_DEFAULT = true;
    private static final boolean IS_LOGICAL_HANDLER_TYPE_DEFAULT = true;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private Button btnLogicalType = null;
    private Button btnProtocalType = null;
    private Button btnIsAddedToChain = null;
    private Button btnIsAssociated = null;
    private Button btnIsCreateNewChainFile = null;
    private Button btnIsUseExistingChainFile = null;
    private Text txtExistingChainFilePath = null;
    private Text txtNewChainFilePath = null;
    private Text txtServiceClass = null;
    private Group grpHandlerClass = null;
    private Group grpHandlerChain = null;
    private Group grpHandlerType = null;
    private Composite cmpHandlerBinding = null;
    private Composite cmpExistingChain = null;
    private Composite cmpNewChain = null;
    private String errMessageHandlerChain = null;
    private String errMessageWebService = null;
    private static final String ERROR_MESSAGE_NOT_HAVE_WEBSERVICE_ANN = "The primary class of this java file doesn't have @WebService annotation.";
    private static final String ERROR_MESSAGE_NOT_A_JAVA_FILE = "This file should be a java file.";
    private static final String ERROR_MESSAGE_FILE_NOT_EXIST = "This file doesn't exist.";
    private static final String ERROR_MESSAGE_FILE_ALREADY_EXIST = "This file already exists.";
    private static final String ERROR_MESSAGE_NOT_A_XML_FILE = "This file is not an XML file.";
    private static final String ERROR_MESSAGE_INVALID_HANDLER_CHAIN_FILE = "This file is not an valid handler chain file.";
    private static final String ERROR_MESSAGE_INVALID_HANDLER_CHAIN_PREFIX = "Invalid handler chain file path. ";
    private static final String ERROR_MESSAGE_INVALID_SERVICE_CLASS_PREFIX = "Invalid service class file path. ";
    private boolean isHandlerChainFilePathValid = false;
    private boolean isServiceClassFilePathValid = false;
    private boolean isNewClassGroupValid = false;
    private IStructuredSelection curSelection = null;

    public NewHandlerWizardPage() {
        super(false, ScJaxWsResources.getString("JaxwsHandler.NewHandlerWizardPage.Title"));
        this.setTitle(ScJaxWsResources.getString("JaxwsHandler.NewHandlerWizardPage.Title"));
        this.setDescription(ScJaxWsResources.getString("JaxwsHandler.NewHandlerWizardPage.Description"));
    }

    public void init(IStructuredSelection selection) {
        IJavaElement jelem = this.getInitialJavaElement(selection);
        this.initContainerPage(jelem);
        this.initTypePage(jelem);
        this.doStatusUpdate();
        this.curSelection = selection;
    }

    private void doStatusUpdate() {
        IStatus[] status = new IStatus[]{this.fContainerStatus, this.fPackageStatus, this.fTypeNameStatus};
        this.updateStatus(status);
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        this.doStatusUpdate();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setFocus();
        }
    }

    protected void updateStatus(IStatus[] status) {
        super.updateStatus(status);
        if (this.isPageComplete()) {
            this.isNewClassGroupValid = true;
            this.validateHandlerCfgGroup();
        } else {
            this.isNewClassGroupValid = false;
        }
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 4);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        container.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 1;
        container.setLayoutData((Object)gridData);
        this.createNewHandlerClassGroup(container);
        this.createHandlerTypeGroup(container);
        this.createHandlerConfigurationGroup(container);
        this.initControls(this.curSelection);
        this.setControl((Control)container);
    }

    private void createNewHandlerClassGroup(Composite parent) {
        this.grpHandlerClass = new Group(parent, 0);
        this.grpHandlerClass.setText(ScJaxWsResources.getString("JaxwsHandler.NewHandlerWizardPage.HandlerClassGroup.Label"));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        this.grpHandlerClass.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        this.grpHandlerClass.setLayoutData((Object)gridData);
        this.createContainerControls((Composite)this.grpHandlerClass, 4);
        this.createPackageControls((Composite)this.grpHandlerClass, 4);
        this.createTypeNameControls((Composite)this.grpHandlerClass, 4);
    }

    private void createHandlerTypeGroup(Composite parent) {
        this.grpHandlerType = new Group(parent, 0);
        this.grpHandlerType.setText(ScJaxWsResources.getString("JaxwsHandler.NewHandlerWizardPage.HandlerTypeGroup.Label"));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.grpHandlerType.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        this.grpHandlerType.setLayoutData((Object)gridData);
        this.btnLogicalType = new Button((Composite)this.grpHandlerType, 16);
        this.btnLogicalType.setText(ScJaxWsResources.getString("JaxwsHandler.NewHandlerWizardPage.HandlerTypeGroup.LogicalButton.Label"));
        this.btnProtocalType = new Button((Composite)this.grpHandlerType, 16);
        this.btnProtocalType.setText(ScJaxWsResources.getString("JaxwsHandler.NewHandlerWizardPage.HandlerTypeGroup.ProtocolButton.Label"));
    }

    private void createHandlerConfigurationGroup(Composite parent) {
        Group grpHandlerConfiguration = new Group(parent, 0);
        grpHandlerConfiguration.setText(ScJaxWsResources.getString("JaxwsHandler.NewHandlerWizardPage.HandlerConfigurationGroup.Label"));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        grpHandlerConfiguration.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        grpHandlerConfiguration.setLayoutData((Object)gridData);
        this.btnIsAddedToChain = new Button((Composite)grpHandlerConfiguration, 32);
        this.btnIsAddedToChain.setText(ScJaxWsResources.getString("JaxwsHandler.NewHandlerWizardPage.HandlerConfigurationGroup.CheckButton.label"));
        this.btnIsAddedToChain.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NewHandlerWizardPage.this.grpHandlerChain != null) {
                    NewHandlerWizardPage.this.enableConfiguration(NewHandlerWizardPage.this.btnIsAddedToChain.getSelection());
                    NewHandlerWizardPage.this.validateHandlerCfgGroup();
                }
            }
        });
        this.grpHandlerChain = new Group((Composite)grpHandlerConfiguration, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.grpHandlerChain.setLayout((Layout)gridLayout);
        gridData = new GridData(256);
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        this.grpHandlerChain.setLayoutData((Object)gridData);
        this.btnIsCreateNewChainFile = new Button((Composite)this.grpHandlerChain, 16);
        gridData = new GridData(256);
        gridData.horizontalSpan = 3;
        this.btnIsCreateNewChainFile.setLayoutData((Object)gridData);
        this.btnIsCreateNewChainFile.setText(ScJaxWsResources.getString("JaxwsHandler.NewHandlerWizardPage.HandlerConfigurationGroup.NewChainButton.label"));
        this.btnIsCreateNewChainFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NewHandlerWizardPage.this.cmpNewChain != null) {
                    NewHandlerWizardPage.this.setCompositeEnable(NewHandlerWizardPage.this.cmpNewChain, NewHandlerWizardPage.this.btnIsCreateNewChainFile.getSelection());
                }
                NewHandlerWizardPage.this.updateHandlerChainFilePathValidStatus();
            }
        });
        this.cmpNewChain = new Composite((Composite)this.grpHandlerChain, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.cmpNewChain.setLayout((Layout)gridLayout);
        gridData = new GridData(256);
        gridData.horizontalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        this.cmpNewChain.setLayoutData((Object)gridData);
        new Label(this.cmpNewChain, 0).setText(ScJaxWsResources.getString("JaxwsHandler.NewHandlerWizardPage.HandlerConfigurationGroup.FilePathLabel"));
        this.txtNewChainFilePath = new Text(this.cmpNewChain, 2052);
        gridData = new GridData(768);
        this.txtNewChainFilePath.setLayoutData((Object)gridData);
        this.txtNewChainFilePath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                NewHandlerWizardPage.this.updateHandlerChainFilePathValidStatus();
            }
        });
        Button btnBrowseFile = new Button(this.cmpNewChain, 8);
        btnBrowseFile.setText(ScJaxWsResources.getString("JaxwsHandler.NewHandlerWizardPage.HandlerConfigurationGroup.CreateButton.label"));
        btnBrowseFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IFile tmpFile;
                CreateXmlFileWizard wizard = new CreateXmlFileWizard();
                wizard.init(PlatformUI.getWorkbench(), NewHandlerWizardPage.this.curSelection);
                wizard.setNeedsProgressMonitor(true);
                WizardDialog dialog = new WizardDialog(NewHandlerWizardPage.this.getShell(), (IWizard)wizard);
                dialog.create();
                int rtnCode = dialog.open();
                if (rtnCode == 0 && (tmpFile = NewHandlerWizardPage.this.getFileFromPath(wizard.getFilePath().toString())) != null) {
                    NewHandlerWizardPage.this.txtNewChainFilePath.setText(tmpFile.getLocation().toOSString());
                }
            }
        });
        this.btnIsUseExistingChainFile = new Button((Composite)this.grpHandlerChain, 16);
        gridData = new GridData(256);
        gridData.horizontalSpan = 3;
        this.btnIsUseExistingChainFile.setLayoutData((Object)gridData);
        this.btnIsUseExistingChainFile.setText(ScJaxWsResources.getString("Add this handler to an existing handler chain file"));
        this.btnIsUseExistingChainFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NewHandlerWizardPage.this.cmpExistingChain != null) {
                    NewHandlerWizardPage.this.setCompositeEnable(NewHandlerWizardPage.this.cmpExistingChain, NewHandlerWizardPage.this.btnIsUseExistingChainFile.getSelection());
                }
                NewHandlerWizardPage.this.updateHandlerChainFilePathValidStatus();
            }
        });
        this.cmpExistingChain = new Composite((Composite)this.grpHandlerChain, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.cmpExistingChain.setLayout((Layout)gridLayout);
        gridData = new GridData(256);
        gridData.horizontalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        this.cmpExistingChain.setLayoutData((Object)gridData);
        new Label(this.cmpExistingChain, 0).setText(ScJaxWsResources.getString("JaxwsHandler.NewHandlerWizardPage.HandlerConfigurationGroup.FilePathLabel"));
        this.txtExistingChainFilePath = new Text(this.cmpExistingChain, 2052);
        gridData = new GridData(768);
        this.txtExistingChainFilePath.setLayoutData((Object)gridData);
        this.txtExistingChainFilePath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                NewHandlerWizardPage.this.updateHandlerChainFilePathValidStatus();
            }
        });
        Button btnBrowseFile2 = new Button(this.cmpExistingChain, 8);
        btnBrowseFile2.setText(ScJaxWsResources.getString("JaxwsHandler.NewHandlerWizardPage.HandlerConfigurationGroup.BrowseButton.label"));
        btnBrowseFile2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object result;
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(NewHandlerWizardPage.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                dialog.setAllowMultiple(false);
                ViewerFilter filter = new ViewerFilter(){

                    public boolean select(Viewer viewer, Object parent, Object element) {
                        return !(element instanceof IFile) || ((IFile)element).getFileExtension().equalsIgnoreCase(NewHandlerWizardPage.HANDLER_CHAIN_FILE_EXTENSION);
                    }
                };
                dialog.addFilter(filter);
                ISelectionStatusValidator validator = new ISelectionStatusValidator(){

                    public IStatus validate(Object[] selection) {
                        if (selection != null && selection.length > 0 && selection[0] instanceof IFile && ((IFile)selection[0]).getFileExtension().equalsIgnoreCase(NewHandlerWizardPage.HANDLER_CHAIN_FILE_EXTENSION)) {
                            if (NewHandlerWizardPage.this.isValidHandlerChainFile(((IFile)selection[0]).getLocation().toFile())) {
                                return Status.OK_STATUS;
                            }
                            return new Status(4, "org.eclipse.stp.sc.jaxws", 4, "This file is not a valid handler chain file.", null);
                        }
                        return new Status(4, "org.eclipse.stp.sc.jaxws", 4, "Please chose a xml file.", null);
                    }
                };
                dialog.setValidator(validator);
                if (dialog.open() == 0 && (result = dialog.getFirstResult()) instanceof IFile) {
                    NewHandlerWizardPage.this.txtExistingChainFilePath.setText(((IFile)result).getLocation().toOSString());
                }
            }
        });
        gridData = new GridData(256);
        gridData.horizontalSpan = 3;
        new Label((Composite)this.grpHandlerChain, 258).setLayoutData((Object)gridData);
        this.btnIsAssociated = new Button((Composite)this.grpHandlerChain, 32);
        gridData = new GridData(256);
        gridData.horizontalSpan = 3;
        this.btnIsAssociated.setLayoutData((Object)gridData);
        this.btnIsAssociated.setText(ScJaxWsResources.getString("JaxwsHandler.NewHandlerWizardPage.HandlerConfigurationGroup.BindingServiceButton.label"));
        this.btnIsAssociated.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NewHandlerWizardPage.this.cmpHandlerBinding != null) {
                    NewHandlerWizardPage.this.setCompositeEnable(NewHandlerWizardPage.this.cmpHandlerBinding, NewHandlerWizardPage.this.btnIsAssociated.getSelection());
                }
                NewHandlerWizardPage.this.updateServiceClassFilePathValidStatus();
            }
        });
        this.cmpHandlerBinding = new Composite((Composite)this.grpHandlerChain, 32);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.cmpHandlerBinding.setLayout((Layout)gridLayout);
        gridData = new GridData(256);
        gridData.horizontalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        this.cmpHandlerBinding.setLayoutData((Object)gridData);
        new Label(this.cmpHandlerBinding, 0).setText(ScJaxWsResources.getString("JaxwsHandler.NewHandlerWizardPage.HandlerConfigurationGroup.ServiceClassLabel"));
        this.txtServiceClass = new Text(this.cmpHandlerBinding, 2052);
        gridData = new GridData(768);
        this.txtServiceClass.setLayoutData((Object)gridData);
        this.txtServiceClass.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                NewHandlerWizardPage.this.updateServiceClassFilePathValidStatus();
            }
        });
        Button btnBrowseServiceClass = new Button(this.cmpHandlerBinding, 8);
        btnBrowseServiceClass.setText(ScJaxWsResources.getString("JaxwsHandler.NewHandlerWizardPage.HandlerConfigurationGroup.BrowseButton.label"));
        btnBrowseServiceClass.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ICompilationUnit result;
                IFile tmpFile;
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(NewHandlerWizardPage.this.getShell(), (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT), (ITreeContentProvider)new StandardJavaElementContentProvider());
                dialog.setInput((Object)JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()));
                dialog.setAllowMultiple(false);
                Class[] acceptedClasses = null;
                acceptedClasses = new Class[]{IJavaModel.class, IPackageFragmentRoot.class, IJavaProject.class, IPackageFragment.class, IPackageFragment.class, ICompilationUnit.class};
                MyTypedViewerFilter filter = new MyTypedViewerFilter(NewHandlerWizardPage.this, acceptedClasses){

                    public boolean select(Viewer viewer, Object parent, Object element) {
                        if (element instanceof IPackageFragmentRoot) {
                            try {
                                return ((IPackageFragmentRoot)element).getKind() == 1;
                            }
                            catch (JavaModelException e) {
                                LOG.error((Object)e);
                                return false;
                            }
                        }
                        return super.select(viewer, parent, element);
                    }
                };
                dialog.addFilter((ViewerFilter)filter);
                ISelectionStatusValidator validator = new ISelectionStatusValidator(){

                    public IStatus validate(Object[] selection) {
                        if (selection != null && selection.length > 0 && selection[0] instanceof ICompilationUnit && NewHandlerWizardPage.this.hasWebServiceAnn((ICompilationUnit)selection[0])) {
                            return Status.OK_STATUS;
                        }
                        return new Status(4, "org.eclipse.stp.sc.jaxws", 4, "Please chose a web service java file.", null);
                    }
                };
                dialog.setValidator(validator);
                if (dialog.open() == 0 && (tmpFile = NewHandlerWizardPage.this.getFileFromPath((result = (ICompilationUnit)dialog.getFirstResult()).getPath().toString())) != null) {
                    NewHandlerWizardPage.this.txtServiceClass.setText(tmpFile.getLocation().toOSString());
                }
            }
        });
    }

    private void initControls(boolean isAddedToChain, boolean isNewChainFile, boolean isServiceBinding) {
        this.btnLogicalType.setSelection(true);
        this.btnProtocalType.setSelection(false);
        this.btnIsAddedToChain.setSelection(isAddedToChain);
        this.btnIsAssociated.setSelection(isServiceBinding);
        this.btnIsCreateNewChainFile.setSelection(isNewChainFile);
        this.btnIsUseExistingChainFile.setSelection(!isNewChainFile);
        this.enableConfiguration(isAddedToChain);
    }

    private void initControls(IStructuredSelection selection) {
        if (selection != null) {
            Object obj = selection.getFirstElement();
            IFile webServiceFile = null;
            IFile handlerChainFile = null;
            if (obj instanceof IFile) {
                if (((IFile)obj).getFileExtension().equalsIgnoreCase(JAVA_FILE_EXTENSION) && this.hasWebServiceAnn((IFile)obj)) {
                    webServiceFile = (IFile)obj;
                    handlerChainFile = this.getHandlerChainFilePathFromWebServiceFileAnn(webServiceFile);
                } else if (((IFile)obj).getFileExtension().equalsIgnoreCase(HANDLER_CHAIN_FILE_EXTENSION) && this.isValidHandlerChainFile(((IFile)obj).getLocation().toFile())) {
                    handlerChainFile = (IFile)obj;
                }
            } else if (obj instanceof ICompilationUnit && this.hasWebServiceAnn((ICompilationUnit)obj)) {
                webServiceFile = (IFile)((ICompilationUnit)obj).getResource();
                handlerChainFile = this.getHandlerChainFilePathFromWebServiceFileAnn(webServiceFile);
            }
            if (webServiceFile != null) {
                this.txtServiceClass.setText(webServiceFile.getLocation().toOSString());
                if (handlerChainFile == null) {
                    this.initControls(true, true, true);
                } else {
                    this.initControls(true, false, true);
                    if (handlerChainFile.exists()) {
                        this.txtExistingChainFilePath.setText(handlerChainFile.getLocation().toOSString());
                    }
                }
            } else if (handlerChainFile != null) {
                this.initControls(true, false, true);
                if (handlerChainFile.exists()) {
                    this.txtExistingChainFilePath.setText(handlerChainFile.getLocation().toOSString());
                }
            } else {
                this.initControls(false, true, true);
            }
        } else {
            this.initControls(false, true, true);
        }
        this.upateHandlerCfgGroupStatus();
    }

    private IFile getHandlerChainFilePathFromWebServiceFileAnn(IFile file) {
        AbstractList list;
        Annotation handlerChainNode;
        IFile rtnValue = null;
        if (file != null && (handlerChainNode = this.getHandlerChainAnn(file)) != null && handlerChainNode.isNormalAnnotation() && (list = (AbstractList)((NormalAnnotation)handlerChainNode).values()) != null && list.size() > 0) {
            int i = 0;
            while (i < list.size()) {
                String handlerChainFilePath;
                MemberValuePair valuePair = (MemberValuePair)list.get(i);
                if (valuePair.getName().getIdentifier().equalsIgnoreCase("file") && (handlerChainFilePath = valuePair.getValue().toString()) != null && handlerChainFilePath.length() > 0) {
                    handlerChainFilePath = handlerChainFilePath.replaceAll("\"", "");
                    Path path = null;
                    try {
                        URL url = new URL(handlerChainFilePath);
                        if (!url.getProtocol().equalsIgnoreCase("file")) break;
                        path = new Path(url.getFile());
                    }
                    catch (Exception exception) {
                        path = new Path(handlerChainFilePath);
                    }
                    if (path.isAbsolute()) {
                        rtnValue = this.getFileFromPath(path.toString());
                        break;
                    }
                    rtnValue = this.getFileFromPath(file.getFullPath().append((IPath)path).toString());
                    break;
                }
                ++i;
            }
        }
        return rtnValue;
    }

    private void setCompositeEnable(Composite composite, boolean isEnable) {
        if (composite != null) {
            Control[] children = composite.getChildren();
            if (children != null && children.length > 0) {
                int i = 0;
                while (i < children.length) {
                    if (children[i] instanceof Composite) {
                        this.setCompositeEnable((Composite)children[i], isEnable);
                    }
                    children[i].setEnabled(isEnable);
                    ++i;
                }
            }
            composite.setEnabled(isEnable);
        }
    }

    private void enableConfiguration(boolean isEnable) {
        if (this.grpHandlerChain != null) {
            if (isEnable) {
                this.setCompositeEnable((Composite)this.grpHandlerChain, true);
                if (this.btnIsCreateNewChainFile != null) {
                    this.setCompositeEnable(this.cmpNewChain, this.btnIsCreateNewChainFile.getSelection());
                }
                if (this.btnIsUseExistingChainFile != null) {
                    this.setCompositeEnable(this.cmpExistingChain, this.btnIsUseExistingChainFile.getSelection());
                }
                if (this.btnIsAssociated != null) {
                    this.setCompositeEnable(this.cmpHandlerBinding, this.btnIsAssociated.getSelection());
                }
            } else {
                this.setCompositeEnable((Composite)this.grpHandlerChain, false);
            }
        }
    }

    private String getHandlerClassContents(boolean isLogicalType) {
        String rtnValue;
        block18: {
            rtnValue = "";
            InputStream fis = null;
            try {
                try {
                    String packageName;
                    Path path = null;
                    path = isLogicalType ? new Path(LOGICAL_HANDLER_CLASS_TEMPLATE) : new Path(SOAP_HANDLER_CLASS_TEMPLATE);
                    fis = FileLocator.openStream((Bundle)ScJaxWsPlugin.getDefault().getBundle(), (IPath)path, (boolean)false);
                    StringBuffer sb = new StringBuffer();
                    BufferedReader in = new BufferedReader(new InputStreamReader(fis));
                    String line = null;
                    while ((line = in.readLine()) != null) {
                        sb.append(String.valueOf(line) + LINE_SEPARATOR);
                    }
                    int start = sb.indexOf(CLASS_NAME_REPLACED);
                    int end = start + CLASS_NAME_REPLACED.length();
                    if (start >= 0) {
                        sb.replace(start, end, this.getTypeName().trim());
                    }
                    if ((packageName = this.getPackageText()) == null || packageName.trim().length() == 0) {
                        start = sb.indexOf("package $packageName;");
                        end = "package $packageName;".length();
                        if (start >= 0) {
                            sb.replace(start, end, USE_DEFAULT_PACKAGE);
                        }
                    } else {
                        start = sb.indexOf(PACKAGE_NAME_REPLACED);
                        end = start + PACKAGE_NAME_REPLACED.length();
                        if (start >= 0) {
                            sb.replace(start, end, packageName.trim());
                        }
                    }
                    rtnValue = sb.toString();
                }
                catch (IOException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                    if (fis == null) break block18;
                    try {
                        fis.close();
                    }
                    catch (Exception e2) {
                        LOG.error((Object)e2.getMessage(), (Throwable)e2);
                    }
                }
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Exception e) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        return rtnValue;
    }

    private boolean isValidHandlerChainFile(File file) {
        boolean rtnValue = false;
        try {
            Element rootElement;
            String nodeName;
            DocumentBuilder db = null;
            Document doc = null;
            if (file != null) {
                db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            }
            if (file.exists() && (nodeName = (rootElement = (doc = db.parse(file)).getDocumentElement()).getNodeName()).endsWith("handler-chains")) {
                rtnValue = true;
            }
        }
        catch (Exception exception) {
            rtnValue = false;
        }
        return rtnValue;
    }

    private void updateHandlerChainFilePathValidStatus() {
        this.isHandlerChainFilePathValid = false;
        this.errMessageHandlerChain = null;
        String path = this.getHandlerChainFilePath();
        IFile file = this.getFileFromPath(path);
        if (file != null) {
            if (file.getFileExtension() != null && file.getFileExtension().equalsIgnoreCase(HANDLER_CHAIN_FILE_EXTENSION)) {
                if (!file.getName().equalsIgnoreCase(".xml")) {
                    if (this.getIsCreateNewChain()) {
                        if (file.exists()) {
                            this.errMessageHandlerChain = ERROR_MESSAGE_FILE_ALREADY_EXIST;
                        } else {
                            this.isHandlerChainFilePathValid = true;
                            this.errMessageHandlerChain = null;
                        }
                    } else if (this.getIsUseExistingChain()) {
                        if (file.exists()) {
                            if (this.isValidHandlerChainFile(file.getLocation().toFile())) {
                                this.isHandlerChainFilePathValid = true;
                                this.errMessageHandlerChain = null;
                            } else {
                                this.errMessageHandlerChain = ERROR_MESSAGE_INVALID_HANDLER_CHAIN_FILE;
                            }
                        } else {
                            this.errMessageHandlerChain = ERROR_MESSAGE_FILE_NOT_EXIST;
                        }
                    }
                }
            } else {
                this.errMessageHandlerChain = ERROR_MESSAGE_NOT_A_XML_FILE;
            }
        }
        if (!this.isHandlerChainFilePathValid) {
            this.errMessageHandlerChain = this.errMessageHandlerChain != null ? ERROR_MESSAGE_INVALID_HANDLER_CHAIN_PREFIX + this.errMessageHandlerChain : ERROR_MESSAGE_INVALID_HANDLER_CHAIN_PREFIX;
        }
        this.validateHandlerCfgGroup();
    }

    private void updateServiceClassFilePathValidStatus() {
        this.isServiceClassFilePathValid = false;
        this.errMessageWebService = null;
        if (this.getIsAssociated()) {
            IFile file = this.getFileFromPath(this.getServiceClassFilePath());
            if (file != null) {
                if (file.exists()) {
                    if (file.getFileExtension().equalsIgnoreCase(JAVA_FILE_EXTENSION)) {
                        if (this.hasWebServiceAnn(file)) {
                            this.isServiceClassFilePathValid = true;
                            this.errMessageWebService = null;
                        } else {
                            this.errMessageWebService = ERROR_MESSAGE_NOT_HAVE_WEBSERVICE_ANN;
                        }
                    } else {
                        this.errMessageWebService = ERROR_MESSAGE_NOT_A_JAVA_FILE;
                    }
                } else {
                    this.errMessageWebService = ERROR_MESSAGE_FILE_NOT_EXIST;
                }
            }
        } else {
            this.isServiceClassFilePathValid = true;
        }
        if (!this.isServiceClassFilePathValid) {
            this.errMessageWebService = this.errMessageWebService != null ? ERROR_MESSAGE_INVALID_SERVICE_CLASS_PREFIX + this.errMessageWebService : ERROR_MESSAGE_INVALID_SERVICE_CLASS_PREFIX;
        }
        this.validateHandlerCfgGroup();
    }

    private void upateHandlerCfgGroupStatus() {
        this.updateHandlerChainFilePathValidStatus();
        this.updateServiceClassFilePathValidStatus();
    }

    private void validateHandlerCfgGroup() {
        if (this.isNewClassGroupValid) {
            if (this.getIsHandlerConfigGroupValid()) {
                this.setPageComplete(true);
                this.setErrorMessage(null);
            } else {
                this.setPageComplete(false);
                this.setErrorMessage(this.getCfgErrorMessage());
            }
        }
    }

    public String getCfgErrorMessage() {
        if (this.errMessageHandlerChain != null) {
            return this.errMessageHandlerChain;
        }
        return this.errMessageWebService;
    }

    public IFile getFileFromPath(String path) {
        IFile rtnValue = null;
        try {
            if (path != null && path.length() > 0) {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IPath workspacePath = workspace.getRoot().getLocation();
                if (path.startsWith(workspacePath.toOSString())) {
                    path = path.substring(workspacePath.toOSString().length());
                } else if (path.startsWith(workspacePath.toString())) {
                    path = path.substring(workspacePath.toString().length());
                }
                Path newPath = new Path(path);
                rtnValue = workspace.getRoot().getFile((IPath)newPath);
                if (rtnValue == null) {
                    rtnValue = workspace.getRoot().getFileForLocation((IPath)newPath);
                }
            }
        }
        catch (Exception e) {
            rtnValue = null;
            LOG.debug((Object)e);
        }
        return rtnValue;
    }

    private boolean hasWebServiceAnn(IFile file) {
        ICompilationUnit cu;
        boolean rtnValue = false;
        if (file != null && file.exists() && file.getFileExtension().equalsIgnoreCase(JAVA_FILE_EXTENSION) && this.hasWebServiceAnn(cu = JDTUtils.getJavaUnitFromFile((IFile)file))) {
            rtnValue = true;
        }
        return rtnValue;
    }

    private boolean hasWebServiceAnn(ICompilationUnit cu) {
        CompilationUnit astRoot;
        Annotation node;
        IType targetMember;
        boolean rtnValue = false;
        if (cu != null && (targetMember = cu.findPrimaryType()) != null && JDTUtils.hasAnnotation((IMember)targetMember, (Annotation)(node = ScAnnotationSupportUtils.getDefaultedAnnotationNode(WebService.class, (CompilationUnit)(astRoot = JDTUtils.getDomRootCompilationUnit((IMember)targetMember)), (IMember)targetMember, null)))) {
            rtnValue = true;
        }
        return rtnValue;
    }

    private Annotation getHandlerChainAnn(IFile file) {
        IType targetMember;
        ICompilationUnit cu;
        Annotation rtnValue = null;
        if (file != null && file.exists() && file.getFileExtension().equalsIgnoreCase(JAVA_FILE_EXTENSION) && (cu = JDTUtils.getJavaUnitFromFile((IFile)file)) != null && (targetMember = cu.findPrimaryType()) != null) {
            CompilationUnit astRoot = JDTUtils.getDomRootCompilationUnit((IMember)targetMember);
            Annotation node = ScAnnotationSupportUtils.getDefaultedAnnotationNode(HandlerChain.class, (CompilationUnit)astRoot, (IMember)targetMember, null);
            rtnValue = JDTUtils.findAnnotation((CompilationUnit)astRoot, (IMember)targetMember, (Annotation)node);
        }
        return rtnValue;
    }

    private boolean getIsHandlerConfigGroupValid() {
        if (this.getIsAddedToChain()) {
            return this.isHandlerChainFilePathValid && this.isServiceClassFilePathValid;
        }
        return true;
    }

    public boolean getIsLogicalHandlerType() {
        return this.btnLogicalType.getSelection();
    }

    public boolean getIsAddedToChain() {
        return this.btnIsAddedToChain.getSelection();
    }

    public boolean getIsAssociated() {
        return this.btnIsAssociated.getSelection();
    }

    public boolean getIsCreateNewChain() {
        return this.btnIsCreateNewChainFile.getSelection();
    }

    public boolean getIsUseExistingChain() {
        return this.btnIsUseExistingChainFile.getSelection();
    }

    public String getHandlerChainFilePath() {
        String rtnValue = "";
        if (this.getIsAddedToChain()) {
            if (this.getIsCreateNewChain()) {
                if (this.txtNewChainFilePath.getText() != null && !(rtnValue = this.txtNewChainFilePath.getText().trim()).toLowerCase().endsWith(".xml")) {
                    rtnValue = String.valueOf(rtnValue) + "." + HANDLER_CHAIN_FILE_EXTENSION;
                }
            } else if (this.getIsUseExistingChain() && this.txtExistingChainFilePath.getText() != null) {
                rtnValue = this.txtExistingChainFilePath.getText().trim();
            }
        }
        return rtnValue;
    }

    public String getServiceClassFilePath() {
        String rtnValue = "";
        if (this.getIsAddedToChain() && this.getIsAssociated() && this.txtServiceClass.getText() != null) {
            rtnValue = this.txtServiceClass.getText().trim();
        }
        return rtnValue;
    }

    public String getHandlerChainFilePathAbsolute() {
        String rtnValue = this.getHandlerChainFilePath();
        IFile file = this.getFileFromPath(rtnValue);
        if (file != null) {
            rtnValue = file.getLocation().toString();
        }
        return rtnValue;
    }

    public void createHandlerClass(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            IPackageFragmentRoot root = this.getPackageFragmentRoot();
            IPackageFragment pack = this.getPackageFragment();
            if (pack == null) {
                pack = root.getPackageFragment("");
            }
            if (!pack.exists()) {
                String packName = pack.getElementName();
                pack = root.createPackageFragment(packName, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            } else {
                monitor.worked(1);
            }
            String typeName = this.getTypeName();
            String cuName = this.getCompilationUnitName(typeName);
            pack.createCompilationUnit(cuName, this.getHandlerClassContents(this.getIsLogicalHandlerType()), false, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
        }
        catch (CoreException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void setNewHandlerChainFilePath(String path) {
        if (path != null && path.length() > 0 && this.txtNewChainFilePath != null) {
            this.txtNewChainFilePath.setText(path);
        }
    }

    public void setExistingHandlerChainFilePath(String path) {
        if (path != null && path.length() > 0 && this.txtExistingChainFilePath != null) {
            this.txtExistingChainFilePath.setText(path);
        }
    }

    public void setWebServiceClassPath(String path) {
        if (path != null && path.length() > 0 && this.txtServiceClass != null) {
            this.txtServiceClass.setText(path);
        }
    }

    private class MyTypedViewerFilter
    extends ViewerFilter {
        private Class[] fAcceptedTypes;
        private Object[] fRejectedElements;

        public MyTypedViewerFilter(Class[] acceptedTypes) {
            this(acceptedTypes, null);
        }

        public MyTypedViewerFilter(Class[] acceptedTypes, Object[] rejectedElements) {
            Assert.isNotNull((Object)acceptedTypes);
            this.fAcceptedTypes = acceptedTypes;
            this.fRejectedElements = rejectedElements;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            int i;
            if (this.fRejectedElements != null) {
                i = 0;
                while (i < this.fRejectedElements.length) {
                    if (element.equals(this.fRejectedElements[i])) {
                        return false;
                    }
                    ++i;
                }
            }
            i = 0;
            while (i < this.fAcceptedTypes.length) {
                if (this.fAcceptedTypes[i].isInstance(element)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

