/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxwsri.generators;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.utils.JDTUtils;
import org.eclipse.stp.sc.common.utils.LaunchUtil;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IWsdlToJavaGenerator;
import org.eclipse.stp.sc.jaxwsri.JAXWSRIPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class JAXWSRIWsdlToJavaGenerator
implements IWsdlToJavaGenerator {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(JAXWSRIWsdlToJavaGenerator.class);
    private Hashtable toolParams = new Hashtable();

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof Hashtable) {
            this.toolParams = (Hashtable)data;
        }
    }

    public void run(IPath path, IProject project) throws CoreException {
        try {
            String url = path.toFile().toURL().toExternalForm();
            this.run(url, project);
        }
        catch (MalformedURLException e) {
            LOG.error((Object)e);
        }
    }

    public void run(String url, IProject project) throws CoreException {
        try {
            if (project == null || url == null) {
                LOG.error((Object)"wsdl to java generation error: the wsdl url or project is null");
                return;
            }
            IJavaProject javaProject = JDTUtils.findJavaProject((String)project.getName());
            if (javaProject == null || !javaProject.exists()) {
                LOG.error((Object)"wsdl to java generation error: the project cannot be found");
                return;
            }
            ArrayList<String> args = new ArrayList<String>();
            String outDir = (String)this.toolParams.get("GEN_OUTPUTDIR");
            LOG.debug((Object)("Wsdl to Java output dir: " + outDir));
            File file = new File(outDir);
            if (!file.exists()) {
                file.mkdirs();
            }
            args.add("-s");
            args.add(outDir);
            Map specificParams = (Map)this.toolParams.get("TOOL_SPECIFIC_OPS");
            String miscOps = (String)specificParams.get("-verbose");
            if (miscOps != null) {
                LOG.debug((Object)"The verbose option has been set");
                args.add("-verbose");
            }
            args.add(url);
            IVMInstall vmIns = JavaRuntime.getVMInstall((IJavaProject)javaProject);
            File insLocation = vmIns.getInstallLocation();
            File libFile = new File(String.valueOf(insLocation.getAbsolutePath()) + File.separator + "lib" + File.separator + "tools.jar");
            if (!libFile.exists()) {
                Display display = PlatformUI.getWorkbench().getDisplay();
                display.syncExec(new Runnable(){

                    public void run() {
                        try {
                            MessageDialog.openError((Shell)JAXWSRIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Missing library", (String)"Cannot find tools.jar in current JRE used by this project. Please use annother JRE that contains tools.jar for this project.");
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                });
                return;
            }
            LaunchUtil.launchJavaProgram((IJavaProject)javaProject, (String)"com.sun.tools.ws.WsImport", null, (String[])args.toArray(new String[0]), (String[])new String[]{libFile.getAbsolutePath()});
            project.refreshLocal(2, null);
        }
        catch (Exception e) {
            LOG.error((Object)"wsdl to java generation error", (Throwable)e);
        }
    }
}

