/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.core.wtpbridge.module;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.utils.JarUtils;
import org.eclipse.stp.soas.deploy.core.FilePackageOutputDescriptor;
import org.eclipse.stp.soas.deploy.core.IPackageOutputDescriptor;
import org.eclipse.stp.soas.internal.deploy.core.wtpbridge.module.ModuleFile;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.internal.ModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.util.ProjectModule;

public class ServiceModuleDelegate
extends ProjectModule
implements IWebModule {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(ServiceModuleDelegate.class);
    IPath ROOT = new Path("/");
    FilePackageOutputDescriptor fileDesc;
    IModule module;

    public ServiceModuleDelegate(IProject project, IPackageOutputDescriptor desc) {
        super(project);
        this.fileDesc = (FilePackageOutputDescriptor)desc;
    }

    public IModule[] getChildModules() {
        return null;
    }

    public IModuleResource[] members() throws CoreException {
        File[] files;
        String outputDirectory = "";
        if (this.fileDesc != null) {
            File file = this.fileDesc.getFile();
            String moduleName = file.getName();
            File folder = file.getParentFile();
            outputDirectory = String.valueOf(folder.getAbsolutePath()) + File.separator + moduleName + "_tmp";
            if (file.getName().endsWith(".war")) {
                try {
                    JarUtils.unJarFile((String)file.getAbsolutePath(), (String)outputDirectory);
                }
                catch (Exception e) {
                    Status status = new Status(4, "org.eclipse.stp.soas.deploy.core", 0, "Invalid package file: " + file.getAbsolutePath(), (Throwable)e);
                    throw new CoreException((IStatus)status);
                }
            }
            files = new File(outputDirectory).listFiles();
        } else {
            outputDirectory = this.getProject().getFolder("Webcontext").getLocation().toOSString();
            files = new File(outputDirectory).listFiles();
        }
        new File(outputDirectory);
        ArrayList<Object> reses = new ArrayList<Object>();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File member = fileArray[n2];
            if (member.isDirectory()) {
                ModuleFolder mFolder = this.getModuleFolderMembers(member, (IPath)Path.EMPTY);
                reses.add(mFolder);
            } else {
                ModuleFile mFile = new ModuleFile(member, member.getName(), (IPath)Path.EMPTY);
                reses.add(mFile);
            }
            ++n2;
        }
        return reses.toArray(new IModuleResource[reses.size()]);
    }

    private ModuleFolder getModuleFolderMembers(File folder, IPath path) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IContainer container = root.getContainerForLocation((IPath)new Path(folder.getAbsolutePath()));
        ModuleFolder mFolder = new ModuleFolder(container, folder.getName(), path);
        IModuleResource[] res = new IModuleResource[folder.listFiles().length];
        int i = 0;
        File[] fileArray = folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                ModuleFolder mf = this.getModuleFolderMembers(file, path.append(file.getParentFile().getName()));
                res[i] = mf;
            } else {
                ModuleFile mfile = new ModuleFile(file, file.getName(), path.append(file.getParentFile().getName()));
                res[i] = mfile;
            }
            ++i;
            ++n2;
        }
        mFolder.setMembers(res);
        return mFolder;
    }

    public IStatus validate() {
        return Status.OK_STATUS;
    }

    public String getContextRoot() {
        if (this.fileDesc != null) {
            String context = this.fileDesc.getFile().getName();
            if (context.lastIndexOf(".") > 0) {
                context = context.substring(0, context.lastIndexOf("."));
            }
            LOG.debug((Object)("getContextRoot return:" + context));
            return context;
        }
        return this.getProject().getName();
    }

    public void setModule(IModule mod) {
        this.module = mod;
    }

    public IModule[] getModules() {
        return new IModule[]{this.module};
    }

    public String getURI(IModule module) {
        LOG.debug((Object)("get url called for module:" + module));
        if (this.fileDesc != null) {
            return this.fileDesc.getLogicalName();
        }
        return String.valueOf(this.getProject().getName()) + ".war";
    }

    public IContainer[] getJavaOutputFolders() {
        return null;
    }

    public IContainer[] getResourceFolders() {
        return null;
    }

    public boolean isBinary() {
        return true;
    }
}

