/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.core.wtpbridge.module;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.soas.deploy.core.IPackageOutputDescriptor;
import org.eclipse.stp.soas.internal.deploy.core.wtpbridge.module.ServiceModuleDelegate;
import org.eclipse.stp.soas.internal.deploy.core.wtpbridge.module.StpModule;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.internal.Module;
import org.eclipse.wst.server.core.internal.ModuleFactory;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.model.ModuleDelegate;
import org.eclipse.wst.server.core.model.ModuleFactoryDelegate;

public class WTPServiceModuleFactory
extends ModuleFactoryDelegate {
    public static String FACET_PROJECT_NATURE = "org.eclipse.wst.common.project.facet.core.nature";
    public static String MODULE_TYPE = "jst.web";
    public static String MODULE_VERSION = "2.2";
    public static String MODULE_TYPE_JAXWS = "stp.jaxws.component";
    public static String MODULE_VERSION_JAXWS = "2.1";
    private Map<IProject, IModule> modules = new HashMap<IProject, IModule>();
    private static final LoggingProxy LOG = LoggingProxy.getlogger(WTPServiceModuleFactory.class);
    protected Map<IModule, ModuleDelegate> moduleDelegates = new HashMap<IModule, ModuleDelegate>(5);

    public ModuleDelegate getModuleDelegate(IModule module) {
        return this.moduleDelegates.get(module);
    }

    public IModule[] getModules() {
        this.cacheModules();
        return this.modules.values().toArray(new IModule[this.modules.values().size()]);
    }

    private final void cacheModules() {
        try {
            IProjectFacet jaxwsFacet = ProjectFacetsManager.getProjectFacet((String)MODULE_TYPE_JAXWS);
            Set fProjects = ProjectFacetsManager.getFacetedProjects((IProjectFacet)jaxwsFacet);
            for (IFacetedProject fprj : fProjects) {
                IProject project = fprj.getProject();
                if (!project.isAccessible()) continue;
                boolean cache = true;
                try {
                    IModule o = this.modules.get(project);
                    if (o != null) {
                        cache = false;
                    }
                }
                catch (Exception exception) {}
                if (!cache) continue;
                try {
                    IModule modules2 = this.createModule(project, null, MODULE_TYPE_JAXWS, MODULE_VERSION_JAXWS);
                    if (modules2 == null) continue;
                    this.modules.put(project, modules2);
                }
                catch (Throwable t) {
                    Trace.trace((int)3, (String)("Error creating module for " + project.getName()), (Throwable)t);
                }
            }
        }
        catch (Exception e) {
            Trace.trace((int)3, (String)"Error caching modules", (Throwable)e);
        }
    }

    private static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private void addFacetNature(IProject project) throws Exception {
        IProjectDescription projDesc = project.getDescription();
        String[] natures = projDesc.getNatureIds();
        String[] newNatures = new String[natures.length + 1];
        System.arraycopy(natures, 0, newNatures, 0, natures.length);
        newNatures[newNatures.length - 1] = FACET_PROJECT_NATURE;
        projDesc.setNatureIds(newNatures);
        project.setDescription(projDesc, null);
    }

    public IModule createModule(IProject project, IPackageOutputDescriptor desc) {
        return this.createModule(project, desc, MODULE_TYPE, MODULE_VERSION);
    }

    private IModule createModule(IProject project, IPackageOutputDescriptor desc, String moduleType, String version) {
        try {
            if (!project.hasNature(FACET_PROJECT_NATURE)) {
                this.addFacetNature(project);
            }
            IProjectFacet pf = ProjectFacetsManager.getProjectFacet((String)MODULE_TYPE);
            IProjectFacetVersion fv = pf.getVersion(MODULE_VERSION);
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
            if (!facetedProject.hasProjectFacet(pf)) {
                LOG.debug((Object)"install jst.web facet");
                facetedProject.installProjectFacet(fv, null, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error((Object)e);
        }
        IModule module = this.createStpModule(MODULE_TYPE, MODULE_VERSION, project);
        ServiceModuleDelegate moduleDelegate = new ServiceModuleDelegate(project, desc);
        moduleDelegate.setModule(module);
        this.moduleDelegates.put(module, (ModuleDelegate)moduleDelegate);
        ((Module)module).validate(null);
        return module;
    }

    public String getModuleName(IPackageOutputDescriptor desc) {
        String name = desc.getLogicalName();
        if (name.endsWith(".war")) {
            name = name.substring(0, name.indexOf(".war"));
        }
        return name;
    }

    protected IModule createStpModule(String type, String version, IProject project) {
        String factorId = this.getId();
        ModuleFactory factory = ServerPlugin.findModuleFactory((String)factorId);
        return new StpModule(factory, type, version, project);
    }
}

