/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.ui.xef.editor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.stp.ui.xef.editor.ChangePrefixAction;
import org.eclipse.stp.ui.xef.editor.ControlAccessor;
import org.eclipse.stp.ui.xef.editor.DeleteElementAction;
import org.eclipse.stp.ui.xef.editor.FilterRegistry;
import org.eclipse.stp.ui.xef.editor.SchemaSelectionDialog;
import org.eclipse.stp.ui.xef.editor.SelectionCategory;
import org.eclipse.stp.ui.xef.editor.ShadowEntry;
import org.eclipse.stp.ui.xef.editor.XMLProviderEditorInput;
import org.eclipse.stp.ui.xef.editor.XefDetailsPage;
import org.eclipse.stp.ui.xef.editor.XefEditMasterDetailsBlock;
import org.eclipse.stp.ui.xef.editor.XefEditor;
import org.eclipse.stp.ui.xef.schema.IContextProvider;
import org.eclipse.stp.ui.xef.schema.SchemaElement;
import org.eclipse.stp.ui.xef.schema.SchemaRegistry;
import org.eclipse.stp.xef.ISchemaProvider;
import org.eclipse.stp.xef.IShadowProvider;
import org.eclipse.stp.xef.IXMLProvider;
import org.eclipse.stp.xef.URLSchemaProvider;
import org.eclipse.stp.xef.XMLInstanceElement;
import org.eclipse.stp.xef.XMLModelFactory;
import org.eclipse.stp.xef.XMLSnippet;
import org.eclipse.stp.xef.util.InputStreamHelper;
import org.eclipse.stp.xef.util.TestProject;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorTest
extends TestCase {
    private TestProject testProject;

    protected synchronized void setUp() throws Exception {
        this.testProject = new TestProject();
        XMLModelFactory.interactive = false;
    }

    protected synchronized void tearDown() throws Exception {
        try {
            this.getPage().closeAllEditors(false);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        SchemaRegistry.getDefault().clear();
        this.testProject.dispose();
        XMLModelFactory.interactive = true;
    }

    private IWorkbenchPage getPage() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        return window.getActivePage();
    }

    public static void processUIEvents(Display display) {
        while (display.readAndDispatch()) {
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {}
        }
    }

    public void testGeneratedXML() throws Exception {
        IFile file = this.testProject.getProject().getFile((IPath)new Path("test.policy"));
        file.create((InputStream)new ByteArrayInputStream("".getBytes()), true, null);
        URL schemaURL0 = ((Object)((Object)this)).getClass().getClassLoader().getResource("/example_test_secure.xsd");
        SchemaElement se0 = (SchemaElement)SchemaRegistry.getDefault().resolveSchemaFromURL(schemaURL0.toString(), new ISchemaProvider[0]).get(0);
        XMLInstanceElement pi0 = new XMLInstanceElement(se0);
        URL schemaURL1 = ((Object)((Object)this)).getClass().getClassLoader().getResource("/example_test_logging.xsd");
        SchemaElement se1 = (SchemaElement)SchemaRegistry.getDefault().resolveSchemaFromURL(schemaURL1.toString(), new ISchemaProvider[0]).get(0);
        XMLInstanceElement pi1 = new XMLInstanceElement(se1);
        pi1.setAttribute("level", "Fatal");
        for (SchemaElement se : pi1.getTemplate().getNestedElements(new LinkedList())) {
            if (!se.getName().equals("FileLogger")) continue;
            XMLInstanceElement pi = new XMLInstanceElement(se, pi1);
            pi1.addChild(pi, true);
            pi.setAttribute("refreshRate", "123");
            for (SchemaElement se_sub : se.getNestedElements(new LinkedList())) {
                if (se_sub.getName().equals("LinePrefix")) continue;
                XMLInstanceElement pi_sub = new XMLInstanceElement(se_sub, pi);
                pi_sub.setText("Text content of " + se_sub.getName());
                pi.addChild(pi_sub, true);
            }
            pi.setAttribute("file", "c://myFile");
        }
        XefEditor editor = (XefEditor)IDE.openEditor((IWorkbenchPage)this.getPage(), (IEditorInput)new XMLProviderEditorInput("title", file.getProject(), (IXMLProvider)new XMLFileXMLProvider(file, "{http://schemas.xmlsoap.org/ws/2004/09/policy}All"), null, null), (String)"org.eclipse.stp.ui.xef.editor.XefEditor");
        XefEditMasterDetailsBlock block = editor.policyEditPage.block;
        block.policies.add(pi0);
        block.policies.add(pi1);
        EditorTest.assertEquals((String)EditorTest.normXML("<policy:All xmlns:policy=\"http://schemas.xmlsoap.org/ws/2004/09/policy\"><example:secure xmlns:example=\"http://www.example.com/xsd/2006/02/test_secure\"/><example:logging xmlns:example=\"http://www.example.com/xsd/2006/02/test_logging\" level=\"Fatal\"><example:FileLogger refreshRate=\"123\" file=\"c://myFile\"><Header>Text content of Header</Header><Footer>Text content of Footer</Footer></example:FileLogger></example:logging></policy:All>"), (String)EditorTest.normXML(block.getXML()));
    }

    public void testPolicyAttributeEditor() throws Exception {
        IFile file = this.testProject.getProject().getFile((IPath)new Path("test2.policy"));
        String initialContent = "<wsp:Policy xmlns:wsp=\"http://schemas.xmlsoap.org/ws/2004/09/policy\"><wsp:All/></wsp:Policy>";
        file.create((InputStream)new ByteArrayInputStream(initialContent.getBytes()), true, null);
        URL schemaURL1 = ((Object)((Object)this)).getClass().getClassLoader().getResource("/example_test_logging.xsd");
        SchemaElement se1 = (SchemaElement)SchemaRegistry.getDefault().resolveSchemaFromURL(schemaURL1.toString(), new ISchemaProvider[0]).get(0);
        XMLInstanceElement pi = new XMLInstanceElement(se1);
        XefEditor editor = (XefEditor)IDE.openEditor((IWorkbenchPage)this.getPage(), (IEditorInput)new XMLProviderEditorInput("title", file.getProject(), (IXMLProvider)new XMLFileXMLProvider(file, "{http://schemas.xmlsoap.org/ws/2004/09/policy}All"), null, null), (String)"org.eclipse.stp.ui.xef.editor.XefEditor");
        XefEditMasterDetailsBlock block = editor.policyEditPage.block;
        block.policies.add(pi);
        block.getViewer().expandAll();
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)pi));
        XefDetailsPage detailsPage = (XefDetailsPage)block.getDetailsPart().getCurrentPage();
        EditorTest.assertEquals((Object)pi, (Object)detailsPage.element);
        EditorTest.assertEquals((int)1, (int)detailsPage.values.size());
        Combo c = (Combo)this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("level"));
        EditorTest.assertFalse((boolean)"Debug".equals(pi.getAttribute("level")));
        c.setText("Debug");
        detailsPage.commit(false);
        EditorTest.assertEquals((String)"Debug", (String)pi.getAttribute("level"));
        EditorTest.assertEquals((String)EditorTest.normXML("<wsp:Policy xmlns:wsp=\"http://schemas.xmlsoap.org/ws/2004/09/policy\"><wsp:All><example:logging xmlns:example=\"http://www.example.com/xsd/2006/02/test_logging\" level=\"Debug\" /></wsp:All></wsp:Policy>"), (String)EditorTest.normXML(block.getXML()));
        SchemaElement fileSchema = pi.getTemplate().getNestedElement("FileLogger");
        XMLInstanceElement fileElement = new XMLInstanceElement(fileSchema, pi);
        pi.addChild(fileElement, true);
        block.getViewer().expandAll();
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)fileElement));
        detailsPage = (XefDetailsPage)block.getDetailsPart().getCurrentPage();
        EditorTest.assertEquals((Object)fileElement, (Object)detailsPage.element);
        EditorTest.assertEquals((int)3, (int)detailsPage.values.size());
        Text t = (Text)this.reverseGet(detailsPage.values, fileElement.getTemplate().getAttribute("file"));
        t.notifyListeners(3, new Event());
        t.setText("testFile");
        detailsPage.commit(true);
        EditorTest.assertEquals((String)EditorTest.normXML("<wsp:Policy xmlns:wsp=\"http://schemas.xmlsoap.org/ws/2004/09/policy\"><wsp:All><example:logging xmlns:example=\"http://www.example.com/xsd/2006/02/test_logging\" level=\"Debug\" ><example:FileLogger file=\"testFile\"/></example:logging></wsp:All></wsp:Policy>"), (String)EditorTest.normXML(block.getXML()));
    }

    private XefEditor openEditorWithUnknownSchemaXML(String loggingURI) throws CoreException, PartInitException, IOException {
        String initial = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><policies><example:logging xmlns:example=\"" + loggingURI + "\" level=\"Error\">" + "<example:FileLogger file=\"TestFile\" refreshRate=\"123\">" + "<LinePrefix>Prefix Text</LinePrefix>" + "</example:FileLogger>" + "</example:logging>" + "</policies>";
        IFile file = this.testProject.getProject().getFile((IPath)new Path("test2_6.policy"));
        file.create((InputStream)new ByteArrayInputStream(initial.getBytes()), true, null);
        return (XefEditor)IDE.openEditor((IWorkbenchPage)this.getPage(), (IEditorInput)new XMLProviderEditorInput("title", file.getProject(), (IXMLProvider)new XMLFileXMLProvider(file, "policies"), null, null), (String)"org.eclipse.stp.ui.xef.editor.XefEditor");
    }

    public void testOpenEditorOnXMLWithUnknownSchemaThrowsException() throws Exception {
        try {
            this.openEditorWithUnknownSchemaXML("http://www.example.com/xsd/2006/02/test_logging");
        }
        catch (Throwable throwable) {
            return;
        }
        EditorTest.fail((String)"Since we tried to edit an XML file of which the schema was unknown, we expect an exception to be thrown.");
    }

    public void testOpenEditorOnXMLWithUnknownSchemaTriesToLoadSchema() throws Exception {
        String loggingURI = ((Object)((Object)this)).getClass().getClassLoader().getResource("example_test_logging.xsd").toString();
        this.openEditorWithUnknownSchemaXML(loggingURI);
    }

    public void testFlipBackAndForthBetweenPages() throws Exception {
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        SchemaRegistry.getDefault().resolveSchemaFromURL(cl.getResource("example_test_audit.xsd").toString(), new ISchemaProvider[0]);
        SchemaRegistry.getDefault().resolveSchemaFromURL(cl.getResource("example_test_logging.xsd").toString(), new ISchemaProvider[0]);
        SchemaRegistry.getDefault().resolveSchemaFromURL(cl.getResource("example_test.xsd").toString(), new ISchemaProvider[0]);
        String initial = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><policies><example:logging xmlns:example=\"http://www.example.com/xsd/2006/02/test_logging\" level=\"Error\"><example:FileLogger file=\"TestFile\" refreshRate=\"123\"><LinePrefix>Prefix Text</LinePrefix></example:FileLogger></example:logging><example:Routing xmlns:example=\"http://www.example.com/xsd/2006/02/test\">Hello</example:Routing></policies>";
        IFile file = this.testProject.getProject().getFile((IPath)new Path("test3.policy"));
        file.create((InputStream)new ByteArrayInputStream("".getBytes()), true, null);
        XefEditor editor = (XefEditor)IDE.openEditor((IWorkbenchPage)this.getPage(), (IEditorInput)new XMLProviderEditorInput("title", file.getProject(), (IXMLProvider)new XMLFileXMLProvider(file, "policies"), null, null), (String)"org.eclipse.stp.ui.xef.editor.XefEditor");
        editor.setActivePage(editor.xmlEditPage.getId());
        IDocument doc = editor.xmlEditPage.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        try {
            doc.set(initial);
        }
        catch (RuntimeException re) {
            if (re.getClass().getName().equals("org.eclipse.jface.text.Assert$AssertionFailedException")) {
                re.printStackTrace();
            }
            throw re;
        }
        EditorTest.assertEquals((String)"precondition failed", (String)EditorTest.normXML(initial), (String)EditorTest.normXML(doc.get()));
        editor.setActivePage(editor.policyEditPage.getId());
        editor.setActivePage(editor.xmlEditPage.getId());
        EditorTest.assertEquals((String)"documents should still be the same", (String)EditorTest.normXML(initial), (String)EditorTest.normXML(doc.get()));
        editor.setActivePage(editor.policyEditPage.getId());
        TreeViewer viewer = editor.policyEditPage.block.getViewer();
        viewer.expandAll();
        XMLInstanceElement loggingEl = this.getElement(viewer.getExpandedElements(), "logging");
        viewer.setSelection((ISelection)new StructuredSelection((Object)loggingEl));
        XefDetailsPage detailsPage = (XefDetailsPage)editor.policyEditPage.block.getDetailsPart().getCurrentPage();
        Combo c = (Combo)this.reverseGet(detailsPage.values, loggingEl.getTemplate().getAttribute("level"));
        c.setText("Warning");
        XMLInstanceElement fileLoggingEl = this.getElement(loggingEl.getChildren().toArray(), "FileLogger");
        viewer.setSelection((ISelection)new StructuredSelection((Object)fileLoggingEl));
        XefDetailsPage detailsPage2 = (XefDetailsPage)editor.policyEditPage.block.getDetailsPart().getCurrentPage();
        Spinner r = (Spinner)this.reverseGet(detailsPage2.values, fileLoggingEl.getTemplate().getAttribute("refreshRate"));
        r.setSelection(321);
        XMLInstanceElement lpEl = this.getElement(fileLoggingEl.getChildren().toArray(), "LinePrefix");
        viewer.setSelection((ISelection)new StructuredSelection((Object)lpEl));
        XefDetailsPage detailsPage3 = (XefDetailsPage)editor.policyEditPage.block.getDetailsPart().getCurrentPage();
        Text lp = (Text)this.reverseGet(detailsPage3.values, lpEl.getTemplate());
        lp.setText("Modified Prefix Text");
        SchemaElement headerSchema = fileLoggingEl.getTemplate().getNestedElement("Header");
        XMLInstanceElement headerEl = new XMLInstanceElement(headerSchema, fileLoggingEl);
        fileLoggingEl.addChild(headerEl, true);
        viewer.refresh();
        viewer.expandAll();
        viewer.setSelection((ISelection)new StructuredSelection((Object)headerEl));
        XefDetailsPage detailsPage4 = (XefDetailsPage)editor.policyEditPage.block.getDetailsPart().getCurrentPage();
        Text h = (Text)this.reverseGet(detailsPage4.values, headerEl.getTemplate());
        h.setText("This is the header now");
        editor.setActivePage(editor.xmlEditPage.getId());
        String original = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><policies><example:logging xmlns:example=\"http://www.example.com/xsd/2006/02/test_logging\" level=\"Warning\"><example:FileLogger file=\"TestFile\" refreshRate=\"321\"><Header>This is the header now</Header><LinePrefix>Modified Prefix Text</LinePrefix></example:FileLogger></example:logging><example:Routing xmlns:example=\"http://www.example.com/xsd/2006/02/test\">Hello</example:Routing></policies>";
        EditorTest.assertEquals((String)"documents should still be the same", (String)EditorTest.normXML(original), (String)EditorTest.normXML(doc.get()));
        String modified = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><policies><example:audit xmlns:example=\"http://www.example.com/xsd/2006/02/test_audit\" every_call=\"true\"/><example:logging xmlns:example=\"http://www.example.com/xsd/2006/02/test_logging\" level=\"Fatal\"><example:FileLogger file=\"TestFile\" refreshRate=\"321\"><Header>Header Text</Header><Footer>Footer Text</Footer></example:FileLogger></example:logging></policies>";
        try {
            doc.set(modified);
        }
        catch (RuntimeException re) {
            if (re.getClass().getName().equals("org.eclipse.jface.text.Assert$AssertionFailedException")) {
                re.printStackTrace();
            }
            throw re;
        }
        editor.setActivePage(editor.policyEditPage.getId());
        viewer.refresh();
        viewer.expandAll();
        EditorTest.assertEquals((int)2, (int)viewer.getTree().getItems().length);
        EditorTest.assertEquals((String)"example:audit", (String)viewer.getTree().getItems()[0].getText());
        EditorTest.assertEquals((String)"example:logging", (String)viewer.getTree().getItems()[1].getText());
        List input = (List)viewer.getInput();
        EditorTest.assertEquals((int)2, (int)input.size());
        XMLInstanceElement auditEl = (XMLInstanceElement)input.get(0);
        EditorTest.assertEquals((String)"audit", (String)auditEl.getTemplate().getName());
        XMLInstanceElement logEl = (XMLInstanceElement)input.get(1);
        EditorTest.assertEquals((String)"logging", (String)logEl.getTemplate().getName());
        viewer.setSelection((ISelection)new StructuredSelection((Object)auditEl));
        XefDetailsPage auditDetailsPage = (XefDetailsPage)editor.policyEditPage.block.getDetailsPart().getCurrentPage();
        EditorTest.assertTrue((boolean)((Button)this.reverseGet(auditDetailsPage.values, auditEl.getTemplate().getAttribute("every_call"))).getSelection());
        EditorTest.assertFalse((boolean)((Button)this.reverseGet(auditDetailsPage.values, auditEl.getTemplate().getAttribute("every_client"))).getSelection());
        viewer.setSelection((ISelection)new StructuredSelection((Object)logEl));
        XefDetailsPage loggingDetailsPage = (XefDetailsPage)editor.policyEditPage.block.getDetailsPart().getCurrentPage();
        EditorTest.assertEquals((String)"Fatal", (String)((Combo)this.reverseGet(loggingDetailsPage.values, logEl.getTemplate().getAttribute("level"))).getText());
        EditorTest.assertEquals((int)1, (int)logEl.getChildren().size());
        XMLInstanceElement fileLoggerEl = (XMLInstanceElement)logEl.getChildren().get(0);
        EditorTest.assertEquals((int)2, (int)fileLoggerEl.getChildren().size());
        XMLInstanceElement headEl = (XMLInstanceElement)fileLoggerEl.getChildren().get(0);
        XMLInstanceElement footEl = (XMLInstanceElement)fileLoggerEl.getChildren().get(1);
        EditorTest.assertEquals((String)"Header Text", (String)headEl.getJDOMElement().getTextTrim());
        EditorTest.assertEquals((String)"Footer Text", (String)footEl.getJDOMElement().getTextTrim());
        editor.setActivePage(editor.xmlEditPage.getId());
        EditorTest.assertEquals((String)"documents should still be the same", (String)EditorTest.normXML(modified), (String)EditorTest.normXML(doc.get()));
    }

    public void testFlipBackAndForthBetweenPagesWithoutEditingShouldAvoidDirtyFlag() throws Exception {
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        SchemaRegistry.getDefault().resolveSchemaFromURL(cl.getResource("example_test_audit.xsd").toString(), new ISchemaProvider[0]);
        SchemaRegistry.getDefault().resolveSchemaFromURL(cl.getResource("example_test_logging.xsd").toString(), new ISchemaProvider[0]);
        SchemaRegistry.getDefault().resolveSchemaFromURL(cl.getResource("example_test.xsd").toString(), new ISchemaProvider[0]);
        String initial = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><policies><example:logging xmlns:example=\"http://www.example.com/xsd/2006/02/test_logging\" level=\"Error\"><example:FileLogger file=\"TestFile\" refreshRate=\"123\"><LinePrefix>Prefix Text</LinePrefix></example:FileLogger></example:logging><example:Routing xmlns:example=\"http://www.example.com/xsd/2006/02/test\">Hello</example:Routing></policies>";
        IFile file = this.testProject.getProject().getFile((IPath)new Path("test31.policy"));
        file.create((InputStream)new ByteArrayInputStream(initial.getBytes()), true, null);
        XefEditor editor = (XefEditor)IDE.openEditor((IWorkbenchPage)this.getPage(), (IEditorInput)new XMLProviderEditorInput("title", file.getProject(), (IXMLProvider)new XMLFileXMLProvider(file, "policies"), null, null), (String)"org.eclipse.stp.ui.xef.editor.XefEditor");
        EditorTest.assertFalse((boolean)editor.policyEditPage.isDirty());
        EditorTest.assertFalse((boolean)editor.xmlEditPage.isDirty());
        editor.setActivePage(editor.policyEditPage.getId());
        editor.setActivePage(editor.xmlEditPage.getId());
        IDocument doc = editor.xmlEditPage.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        EditorTest.assertEquals((String)"precondition failed", (String)EditorTest.normXML(initial), (String)EditorTest.normXML(doc.get()));
        EditorTest.assertFalse((boolean)editor.policyEditPage.isDirty());
        EditorTest.assertFalse((boolean)editor.xmlEditPage.isDirty());
    }

    public void testFlipBackAndForthBetweenPagesDoesNotChangeContent() throws Exception {
        IFile file = this.testProject.getProject().getFile((IPath)new Path("test32.policy"));
        file.create((InputStream)new ByteArrayInputStream("".getBytes()), true, null);
        URL schemaURL1 = ((Object)((Object)this)).getClass().getClassLoader().getResource("/example_test_logging2.xsd");
        SchemaElement se1 = (SchemaElement)SchemaRegistry.getDefault().resolveSchemaFromURL(schemaURL1.toString(), new ISchemaProvider[0]).get(0);
        XefEditor editor = (XefEditor)IDE.openEditor((IWorkbenchPage)this.getPage(), (IEditorInput)new XMLProviderEditorInput("title", file.getProject(), (IXMLProvider)new XMLFileXMLProvider(file, "policies"), null, null), (String)"org.eclipse.stp.ui.xef.editor.XefEditor");
        XefEditMasterDetailsBlock block = editor.policyEditPage.block;
        XMLInstanceElement pi1 = new XMLInstanceElement(se1);
        block.policies.add(pi1);
        pi1.addMinimalSubElements();
        block.getViewer().refresh();
        block.getViewer().expandAll();
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)pi1));
        XMLInstanceElement fPI = new XMLInstanceElement(pi1.getTemplate().getNestedElement("FileLogger"));
        pi1.addChild(fPI, true);
        fPI.addMinimalSubElements();
        block.getViewer().refresh();
        block.getViewer().expandAll();
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)fPI));
        XefDetailsPage detailsPage = (XefDetailsPage)editor.policyEditPage.block.getDetailsPart().getCurrentPage();
        Text t = (Text)this.reverseGet(detailsPage.values, fPI.getTemplate().getAttribute("file"));
        EditorTest.assertTrue((String)"Should be a password widget", ((t.getStyle() | 0x400000) > 0 ? 1 : 0) != 0);
        t.setText("Boo");
        EditorTest.assertEquals((String)new Integer("Boo".hashCode()).toString(), (String)((ControlAccessor)t.getData("Control Accessor")).getValue());
        XMLInstanceElement loggingEl = (XMLInstanceElement)((List)block.getViewer().getInput()).get(0);
        XMLInstanceElement fileLoggerEl = (XMLInstanceElement)loggingEl.getChildren().get(0);
        EditorTest.assertEquals((String)"Header", (String)((XMLInstanceElement)fileLoggerEl.getChildren().get(0)).toString());
        EditorTest.assertEquals((String)"LinePrefix", (String)((XMLInstanceElement)fileLoggerEl.getChildren().get(1)).toString());
        EditorTest.assertEquals((String)"Footer", (String)((XMLInstanceElement)fileLoggerEl.getChildren().get(2)).toString());
        EditorTest.assertEquals((int)3, (int)fileLoggerEl.getChildren().size());
        editor.setActivePage(editor.xmlEditPage.getId());
        IDocument doc = editor.xmlEditPage.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        String initial = doc.get();
        editor.setActivePage(editor.policyEditPage.getId());
        TreeViewer viewer = editor.policyEditPage.block.getViewer();
        viewer.refresh();
        viewer.expandAll();
        XMLInstanceElement fPI2 = (XMLInstanceElement)((XMLInstanceElement)((List)viewer.getInput()).get(0)).getChildren().get(0);
        viewer.setSelection((ISelection)new StructuredSelection((Object)fPI2));
        XefDetailsPage detailsPage2 = (XefDetailsPage)editor.policyEditPage.block.getDetailsPart().getCurrentPage();
        Text t1 = (Text)this.reverseGet(detailsPage2.values, fPI2.getTemplate().getAttribute("file"));
        Control[] passWordControls = (Control[])t1.getData("The actual controls");
        Text t2 = (Text)passWordControls[passWordControls.length - 1];
        EditorTest.assertEquals((String)"Password controls should contain the same value", (String)t1.getText(), (String)t2.getText());
        editor.setActivePage(editor.xmlEditPage.getId());
        EditorTest.assertEquals((String)EditorTest.normXML(initial), (String)EditorTest.normXML(doc.get()));
    }

    public void testPasswordFieldCheckingHappensWhenSwitchingPoliciesOrSaving() throws Exception {
        XefDetailsPage.interactive = false;
        try {
            IFile file = this.testProject.getProject().getFile((IPath)new Path("test33.policy"));
            file.create((InputStream)new ByteArrayInputStream("".getBytes()), true, null);
            URL schemaURL1 = ((Object)((Object)this)).getClass().getClassLoader().getResource("/example_test_logging2.xsd");
            SchemaElement se1 = (SchemaElement)SchemaRegistry.getDefault().resolveSchemaFromURL(schemaURL1.toString(), new ISchemaProvider[0]).get(0);
            XefEditor editor = (XefEditor)IDE.openEditor((IWorkbenchPage)this.getPage(), (IEditorInput)new XMLProviderEditorInput("title", file.getProject(), (IXMLProvider)new XMLFileXMLProvider(file, "policies"), null, null), (String)"org.eclipse.stp.ui.xef.editor.XefEditor");
            XefEditMasterDetailsBlock block = editor.policyEditPage.block;
            XMLInstanceElement pi1 = new XMLInstanceElement(se1);
            block.policies.add(pi1);
            pi1.addMinimalSubElements();
            block.getViewer().refresh();
            block.getViewer().expandAll();
            block.getViewer().setSelection((ISelection)new StructuredSelection((Object)pi1));
            XefDetailsPage detailsPage0 = (XefDetailsPage)editor.policyEditPage.block.getDetailsPart().getCurrentPage();
            Control levelControl = this.reverseGet(detailsPage0.values, pi1.getTemplate().getAttribute("level"));
            ControlAccessor accessor = (ControlAccessor)levelControl.getData("Control Accessor");
            accessor.setValue("Error");
            XMLInstanceElement fPI = new XMLInstanceElement(pi1.getTemplate().getNestedElement("FileLogger"));
            pi1.addChild(fPI, true);
            fPI.addMinimalSubElements();
            block.getViewer().refresh();
            block.getViewer().expandAll();
            block.getViewer().setSelection((ISelection)new StructuredSelection((Object)fPI));
            XefDetailsPage detailsPage = (XefDetailsPage)editor.policyEditPage.block.getDetailsPart().getCurrentPage();
            Text t = (Text)this.reverseGet(detailsPage.values, fPI.getTemplate().getAttribute("file"));
            EditorTest.assertTrue((String)"Should be a password widget", ((t.getStyle() | 0x400000) > 0 ? 1 : 0) != 0);
            Control[] passWordControls = (Control[])t.getData("The actual controls");
            Text t2 = (Text)passWordControls[passWordControls.length - 1];
            t.setText("Boo");
            t2.setText("Baa");
            EditorTest.assertSame((String)"Precondition failed", (Object)detailsPage, (Object)editor.policyEditPage.block.getDetailsPart().getCurrentPage());
            block.getViewer().setSelection((ISelection)new StructuredSelection((Object)pi1));
            EditorTest.assertSame((String)"The page that is currently active should be the password page as the passwords don't match", (Object)detailsPage, (Object)editor.policyEditPage.block.getDetailsPart().getCurrentPage());
            EditorTest.assertEquals((String)"Should have removed the entered value", (String)"", (String)t.getText());
            EditorTest.assertEquals((String)"Should have removed the entered value", (String)"", (String)t2.getText());
            t.setText("Boo");
            t2.setText("Baa");
            EditorTest.assertTrue((String)"Precondition failed", (boolean)detailsPage.isDirty());
            editor.doSave((IProgressMonitor)new NullProgressMonitor());
            EditorTest.assertTrue((String)"Save shouldn't have happened, as the passwords are different", (boolean)detailsPage.isDirty());
            EditorTest.assertEquals((String)"Should have removed the entered value", (String)"", (String)t.getText());
            EditorTest.assertEquals((String)"Should have removed the entered value", (String)"", (String)t2.getText());
        }
        finally {
            XefDetailsPage.interactive = true;
        }
    }

    public void testAlternativePasswordFilter() throws Exception {
        IFile file = this.testProject.getProject().getFile((IPath)new Path("test34.policy"));
        file.create((InputStream)new ByteArrayInputStream("".getBytes()), true, null);
        EditorTest.assertFalse((String)"Precondition failed", (boolean)FilterRegistry.filters.containsKey("ReverseTextFilter"));
        URL schemaURL = ((Object)((Object)this)).getClass().getClassLoader().getResource("/example_test_secure2.xsd");
        SchemaElement se = (SchemaElement)SchemaRegistry.getDefault().resolveSchemaFromURL(schemaURL.toString(), new ISchemaProvider[0]).get(0);
        XMLInstanceElement pi = new XMLInstanceElement(se);
        XefEditor editor = (XefEditor)IDE.openEditor((IWorkbenchPage)this.getPage(), (IEditorInput)new XMLProviderEditorInput("title", file.getProject(), (IXMLProvider)new XMLFileXMLProvider(file, "{http://schemas.xmlsoap.org/ws/2004/09/policy}All"), null, null), (String)"org.eclipse.stp.ui.xef.editor.XefEditor");
        XefEditMasterDetailsBlock block = editor.policyEditPage.block;
        block.policies.add(pi);
        block.getViewer().expandAll();
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)pi));
        XefDetailsPage detailsPage = (XefDetailsPage)block.getDetailsPart().getCurrentPage();
        Text pwdCtrl = (Text)this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("pwd"));
        Control[] pwControls = (Control[])pwdCtrl.getData("The actual controls");
        Text pwdCtrl2 = (Text)pwControls[pwControls.length - 1];
        pwdCtrl.setText("Hello");
        pwdCtrl2.setText("Hello");
        detailsPage.commit(true);
        EditorTest.assertEquals((String)EditorTest.normXML("<policy:All xmlns:policy=\"http://schemas.xmlsoap.org/ws/2004/09/policy\"><example:security xmlns:example=\"http://www.example.com/xsd/2006/02/test_secure2\" pwd=\"olleH\"/></policy:All>"), (String)EditorTest.normXML(block.getXML()));
        EditorTest.assertTrue((String)"The new filter should be in the FilterRegistry cache now", (boolean)FilterRegistry.filters.containsKey("ReverseTextFilter"));
    }

    public void testWhatSubElementsAreAvailable() throws Exception {
        IFile file = this.testProject.getProject().getFile((IPath)new Path("test4.policy"));
        file.create((InputStream)new ByteArrayInputStream("".getBytes()), true, null);
        URL schemaURL1 = ((Object)((Object)this)).getClass().getClassLoader().getResource("/example_test_logging.xsd");
        SchemaElement se1 = (SchemaElement)SchemaRegistry.getDefault().resolveSchemaFromURL(schemaURL1.toString(), new ISchemaProvider[0]).get(0);
        XMLInstanceElement pi1 = new XMLInstanceElement(se1);
        XefEditor editor = (XefEditor)IDE.openEditor((IWorkbenchPage)this.getPage(), (IEditorInput)new XMLProviderEditorInput("title", file.getProject(), (IXMLProvider)new XMLFileXMLProvider(file, "policies"), null, null), (String)"org.eclipse.stp.ui.xef.editor.XefEditor");
        XefEditMasterDetailsBlock block = editor.policyEditPage.block;
        block.policies.add(pi1);
        block.getViewer().refresh();
        block.getViewer().expandAll();
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)pi1));
        TreeItem item = block.getViewer().getTree().getSelection()[0];
        Image imgPlus = item.getImage();
        List<String> items = this.getMenuItems(block);
        EditorTest.assertTrue((boolean)items.contains("Add ConsoleLogger"));
        EditorTest.assertTrue((boolean)items.contains("Add FileLogger"));
        EditorTest.assertTrue((boolean)items.contains("Change Prefix"));
        EditorTest.assertTrue((boolean)items.contains("Delete"));
        EditorTest.assertTrue((boolean)items.contains("Help"));
        EditorTest.assertEquals((int)5, (int)items.size());
        XMLInstanceElement cPI = new XMLInstanceElement(pi1.getTemplate().getNestedElement("ConsoleLogger"), pi1);
        pi1.addChild(cPI, true);
        block.getViewer().refresh();
        block.getViewer().expandAll();
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)pi1));
        TreeItem item2 = block.getViewer().getTree().getSelection()[0];
        Image img = item2.getImage();
        EditorTest.assertTrue((String)"Should have different images for when there is a subsection available", (img != imgPlus ? 1 : 0) != 0);
        List<String> items2 = this.getMenuItems(block);
        EditorTest.assertTrue((boolean)items2.contains("Change Prefix"));
        EditorTest.assertTrue((boolean)items2.contains("Delete"));
        EditorTest.assertTrue((boolean)items2.contains("Help"));
        EditorTest.assertEquals((int)3, (int)items2.size());
    }

    public void testSequenceInChoice() throws Exception {
        IFile file = this.testProject.getProject().getFile((IPath)new Path("test4a.policy"));
        file.create((InputStream)new ByteArrayInputStream("".getBytes()), true, null);
        URL schemaURL1 = ((Object)((Object)this)).getClass().getClassLoader().getResource("/test_seq_in_choice.xsd");
        SchemaElement se1 = (SchemaElement)SchemaRegistry.getDefault().resolveSchemaFromURL(schemaURL1.toString(), new ISchemaProvider[0]).get(0);
        XMLInstanceElement pi1 = new XMLInstanceElement(se1);
        XefEditor editor = (XefEditor)IDE.openEditor((IWorkbenchPage)this.getPage(), (IEditorInput)new XMLProviderEditorInput("title", file.getProject(), (IXMLProvider)new XMLFileXMLProvider(file, "policies"), null, null), (String)"org.eclipse.stp.ui.xef.editor.XefEditor");
        XefEditMasterDetailsBlock block = editor.policyEditPage.block;
        block.policies.add(pi1);
        block.getViewer().refresh();
        block.getViewer().expandAll();
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)pi1));
        List<String> items = this.getMenuItems(block);
        EditorTest.assertEquals((int)6, (int)items.size());
        EditorTest.assertTrue((boolean)items.contains("Add foo"));
        EditorTest.assertTrue((boolean)items.contains("Add bar"));
        EditorTest.assertTrue((boolean)items.contains("Add spam"));
        EditorTest.assertTrue((boolean)items.contains("Change Prefix"));
        EditorTest.assertTrue((boolean)items.contains("Delete"));
        EditorTest.assertTrue((boolean)items.contains("Help"));
        XMLInstanceElement cPI = new XMLInstanceElement(pi1.getTemplate().getNestedElement("spam"), pi1);
        pi1.addChild(cPI, true);
        block.getViewer().refresh();
        block.getViewer().expandAll();
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)pi1));
        items = this.getMenuItems(block);
        EditorTest.assertEquals((int)4, (int)items.size());
        EditorTest.assertTrue((boolean)items.contains("Add spam"));
        EditorTest.assertTrue((boolean)items.contains("Change Prefix"));
        EditorTest.assertTrue((boolean)items.contains("Delete"));
        EditorTest.assertTrue((boolean)items.contains("Help"));
        pi1.removeChild(cPI);
        block.getViewer().refresh();
        block.getViewer().expandAll();
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)pi1));
        items = this.getMenuItems(block);
        EditorTest.assertEquals((int)6, (int)items.size());
        cPI = new XMLInstanceElement(pi1.getTemplate().getNestedElement("foo"), pi1);
        pi1.addChild(cPI, true);
        block.getViewer().refresh();
        block.getViewer().expandAll();
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)pi1));
        items = this.getMenuItems(block);
        EditorTest.assertEquals((int)4, (int)items.size());
        EditorTest.assertTrue((boolean)items.contains("Add bar"));
        EditorTest.assertTrue((boolean)items.contains("Change Prefix"));
        EditorTest.assertTrue((boolean)items.contains("Delete"));
        EditorTest.assertTrue((boolean)items.contains("Help"));
        pi1.removeChild(cPI);
        block.getViewer().refresh();
        block.getViewer().expandAll();
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)pi1));
        items = this.getMenuItems(block);
        EditorTest.assertEquals((int)6, (int)items.size());
        cPI = new XMLInstanceElement(pi1.getTemplate().getNestedElement("bar"), pi1);
        pi1.addChild(cPI, true);
        block.getViewer().refresh();
        block.getViewer().expandAll();
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)pi1));
        items = this.getMenuItems(block);
        EditorTest.assertEquals((int)3, (int)items.size());
        EditorTest.assertTrue((boolean)items.contains("Change Prefix"));
        EditorTest.assertTrue((boolean)items.contains("Delete"));
        EditorTest.assertTrue((boolean)items.contains("Help"));
    }

    public void disabletestSchemaImportOccursCorrectly() throws Exception {
        IFile file = this.testProject.getProject().getFile((IPath)new Path("test4b.policy"));
        file.create((InputStream)new ByteArrayInputStream("".getBytes()), true, null);
        URL schemaURL1 = ((Object)((Object)this)).getClass().getClassLoader().getResource("/example_test_importer.xsd");
        SchemaElement cfr_ignored_0 = (SchemaElement)SchemaRegistry.getDefault().resolveSchemaFromURL(schemaURL1.toString(), new ISchemaProvider[0]).get(0);
        EditorTest.fail((String)"Test not complete");
    }

    public void testChoiceInSequence() throws Exception {
        IFile file = this.testProject.getProject().getFile((IPath)new Path("test4b.policy"));
        file.create((InputStream)new ByteArrayInputStream("".getBytes()), true, null);
        URL schemaURL1 = ((Object)((Object)this)).getClass().getClassLoader().getResource("/test_choice_in_seq.xsd");
        SchemaElement se1 = (SchemaElement)SchemaRegistry.getDefault().resolveSchemaFromURL(schemaURL1.toString(), new ISchemaProvider[0]).get(0);
        XMLInstanceElement pi1 = new XMLInstanceElement(se1);
        XefEditor editor = (XefEditor)IDE.openEditor((IWorkbenchPage)this.getPage(), (IEditorInput)new XMLProviderEditorInput("title", file.getProject(), (IXMLProvider)new XMLFileXMLProvider(file, "policies"), null, null), (String)"org.eclipse.stp.ui.xef.editor.XefEditor");
        XefEditMasterDetailsBlock block = editor.policyEditPage.block;
        block.policies.add(pi1);
        block.getViewer().refresh();
        block.getViewer().expandAll();
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)pi1));
        List<String> items = this.getMenuItems(block);
        EditorTest.assertEquals((int)6, (int)items.size());
        EditorTest.assertTrue((boolean)items.contains("Add foo"));
        EditorTest.assertTrue((boolean)items.contains("Add bar"));
        EditorTest.assertTrue((boolean)items.contains("Add spam"));
        EditorTest.assertTrue((boolean)items.contains("Change Prefix"));
        EditorTest.assertTrue((boolean)items.contains("Delete"));
        EditorTest.assertTrue((boolean)items.contains("Help"));
        XMLInstanceElement cPI = new XMLInstanceElement(pi1.getTemplate().getNestedElement("foo"), pi1);
        pi1.addChild(cPI, true);
        block.getViewer().refresh();
        block.getViewer().expandAll();
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)pi1));
        items = this.getMenuItems(block);
        EditorTest.assertEquals((int)5, (int)items.size());
        EditorTest.assertTrue((boolean)items.contains("Add foo"));
        EditorTest.assertTrue((boolean)items.contains("Add spam"));
        EditorTest.assertTrue((boolean)items.contains("Change Prefix"));
        EditorTest.assertTrue((boolean)items.contains("Delete"));
        EditorTest.assertTrue((boolean)items.contains("Help"));
        pi1.removeChild(cPI);
        block.getViewer().refresh();
        block.getViewer().expandAll();
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)pi1));
        items = this.getMenuItems(block);
        EditorTest.assertEquals((int)6, (int)items.size());
        cPI = new XMLInstanceElement(pi1.getTemplate().getNestedElement("bar"), pi1);
        pi1.addChild(cPI, true);
        block.getViewer().refresh();
        block.getViewer().expandAll();
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)pi1));
        items = this.getMenuItems(block);
        EditorTest.assertEquals((int)4, (int)items.size());
        EditorTest.assertTrue((boolean)items.contains("Add spam"));
        EditorTest.assertTrue((boolean)items.contains("Change Prefix"));
        EditorTest.assertTrue((boolean)items.contains("Delete"));
        EditorTest.assertTrue((boolean)items.contains("Help"));
        pi1.removeChild(cPI);
        block.getViewer().refresh();
        block.getViewer().expandAll();
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)pi1));
        items = this.getMenuItems(block);
        EditorTest.assertEquals((int)6, (int)items.size());
        cPI = new XMLInstanceElement(pi1.getTemplate().getNestedElement("spam"), pi1);
        pi1.addChild(cPI, true);
        block.getViewer().refresh();
        block.getViewer().expandAll();
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)pi1));
        items = this.getMenuItems(block);
        EditorTest.assertEquals((int)5, (int)items.size());
        EditorTest.assertTrue((boolean)items.contains("Add foo"));
        EditorTest.assertTrue((boolean)items.contains("Add bar"));
        EditorTest.assertTrue((boolean)items.contains("Change Prefix"));
        EditorTest.assertTrue((boolean)items.contains("Delete"));
        EditorTest.assertTrue((boolean)items.contains("Help"));
    }

    public void testNestedChoiceAndSequence() throws Exception {
        IFile file = this.testProject.getProject().getFile((IPath)new Path("test4c.policy"));
        file.create((InputStream)new ByteArrayInputStream("".getBytes()), true, null);
        URL schemaURL1 = ((Object)((Object)this)).getClass().getClassLoader().getResource("/test_nested_choice_seq.xsd");
        SchemaElement se1 = (SchemaElement)SchemaRegistry.getDefault().resolveSchemaFromURL(schemaURL1.toString(), new ISchemaProvider[0]).get(0);
        XMLInstanceElement pi1 = new XMLInstanceElement(se1);
        XefEditor editor = (XefEditor)IDE.openEditor((IWorkbenchPage)this.getPage(), (IEditorInput)new XMLProviderEditorInput("title", file.getProject(), (IXMLProvider)new XMLFileXMLProvider(file, "policies"), null, null), (String)"org.eclipse.stp.ui.xef.editor.XefEditor");
        XefEditMasterDetailsBlock block = editor.policyEditPage.block;
        block.policies.add(pi1);
        block.getViewer().refresh();
        block.getViewer().expandAll();
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)pi1));
        List<String> items = this.getMenuItems(block);
        EditorTest.assertEquals((int)7, (int)items.size());
        EditorTest.assertTrue((boolean)items.contains("Add foo"));
        EditorTest.assertTrue((boolean)items.contains("Add bar"));
        EditorTest.assertTrue((boolean)items.contains("Add spam"));
        EditorTest.assertTrue((boolean)items.contains("Add eggs"));
        EditorTest.assertTrue((boolean)items.contains("Change Prefix"));
        EditorTest.assertTrue((boolean)items.contains("Delete"));
        EditorTest.assertTrue((boolean)items.contains("Help"));
        XMLInstanceElement cPI = new XMLInstanceElement(pi1.getTemplate().getNestedElement("foo"), pi1);
        pi1.addChild(cPI, true);
        block.getViewer().refresh();
        block.getViewer().expandAll();
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)pi1));
        items = this.getMenuItems(block);
        EditorTest.assertEquals((int)5, (int)items.size());
        EditorTest.assertTrue((boolean)items.contains("Add foo"));
        EditorTest.assertTrue((boolean)items.contains("Add spam"));
        EditorTest.assertTrue((boolean)items.contains("Change Prefix"));
        EditorTest.assertTrue((boolean)items.contains("Delete"));
        EditorTest.assertTrue((boolean)items.contains("Help"));
        pi1.removeChild(cPI);
        block.getViewer().refresh();
        block.getViewer().expandAll();
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)pi1));
        items = this.getMenuItems(block);
        EditorTest.assertEquals((int)7, (int)items.size());
        cPI = new XMLInstanceElement(pi1.getTemplate().getNestedElement("bar"), pi1);
        pi1.addChild(cPI, true);
        block.getViewer().refresh();
        block.getViewer().expandAll();
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)pi1));
        items = this.getMenuItems(block);
        EditorTest.assertEquals((int)4, (int)items.size());
        EditorTest.assertTrue((boolean)items.contains("Add spam"));
        EditorTest.assertTrue((boolean)items.contains("Change Prefix"));
        EditorTest.assertTrue((boolean)items.contains("Delete"));
        EditorTest.assertTrue((boolean)items.contains("Help"));
        pi1.removeChild(cPI);
        block.getViewer().refresh();
        block.getViewer().expandAll();
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)pi1));
        items = this.getMenuItems(block);
        EditorTest.assertEquals((int)7, (int)items.size());
        cPI = new XMLInstanceElement(pi1.getTemplate().getNestedElement("spam"), pi1);
        pi1.addChild(cPI, true);
        block.getViewer().refresh();
        block.getViewer().expandAll();
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)pi1));
        items = this.getMenuItems(block);
        EditorTest.assertEquals((int)5, (int)items.size());
        EditorTest.assertTrue((boolean)items.contains("Add foo"));
        EditorTest.assertTrue((boolean)items.contains("Add bar"));
        EditorTest.assertTrue((boolean)items.contains("Change Prefix"));
        EditorTest.assertTrue((boolean)items.contains("Delete"));
        EditorTest.assertTrue((boolean)items.contains("Help"));
        pi1.removeChild(cPI);
        block.getViewer().refresh();
        block.getViewer().expandAll();
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)pi1));
        items = this.getMenuItems(block);
        EditorTest.assertEquals((int)7, (int)items.size());
        cPI = new XMLInstanceElement(pi1.getTemplate().getNestedElement("eggs"), pi1);
        pi1.addChild(cPI, true);
        block.getViewer().refresh();
        block.getViewer().expandAll();
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)pi1));
        items = this.getMenuItems(block);
        EditorTest.assertEquals((int)4, (int)items.size());
        EditorTest.assertTrue((boolean)items.contains("Add eggs"));
        EditorTest.assertTrue((boolean)items.contains("Change Prefix"));
        EditorTest.assertTrue((boolean)items.contains("Delete"));
        EditorTest.assertTrue((boolean)items.contains("Help"));
    }

    public void testSequenceSubElements() throws Exception {
        IFile file = this.testProject.getProject().getFile((IPath)new Path("test5.policy"));
        file.create((InputStream)new ByteArrayInputStream("".getBytes()), true, null);
        URL schemaURL1 = ((Object)((Object)this)).getClass().getClassLoader().getResource("/example_test.xsd");
        SchemaElement se1 = (SchemaElement)SchemaRegistry.getDefault().resolveSchemaFromURL(schemaURL1.toString(), new ISchemaProvider[0]).get(0);
        XefEditor editor = (XefEditor)IDE.openEditor((IWorkbenchPage)this.getPage(), (IEditorInput)new XMLProviderEditorInput("title", file.getProject(), (IXMLProvider)new XMLFileXMLProvider(file, "policies"), null, null), (String)"org.eclipse.stp.ui.xef.editor.XefEditor");
        XefEditMasterDetailsBlock block = editor.policyEditPage.block;
        block.deleteAction.interactive = false;
        class PolicySelectionDialogSubclass
        extends SchemaSelectionDialog {
            private final /* synthetic */ SchemaElement val$se1;

            PolicySelectionDialogSubclass(SchemaElement schemaElement) {
                this.val$se1 = schemaElement;
                super(null, null, new IShadowProvider[0]);
            }

            public Object getFirstResult() {
                return this.val$se1;
            }

            public int open() {
                return 0;
            }
        }
        block.addButtonListener.widgetSelected((SchemaSelectionDialog)new PolicySelectionDialogSubclass(se1), null);
        XMLInstanceElement pi = (XMLInstanceElement)((IStructuredSelection)block.getViewer().getSelection()).getFirstElement();
        EditorTest.assertEquals((int)1, (int)pi.getChildren().size());
        EditorTest.assertEquals((String)"example:Routing", (String)pi.toString());
        XMLInstanceElement sub2PI = (XMLInstanceElement)pi.getChildren().get(0);
        EditorTest.assertEquals((String)"sub2", (String)sub2PI.getTemplate().getName());
        EditorTest.assertEquals((int)1, (int)sub2PI.getChildren().size());
        EditorTest.assertEquals((String)"sub2_1", (String)((XMLInstanceElement)sub2PI.getChildren().get(0)).getTemplate().getName());
        IAction sub1Action = this.getMenuItemAction(block, "Add sub1");
        sub1Action.run();
        XMLInstanceElement sub1PI = (XMLInstanceElement)((IStructuredSelection)block.getViewer().getSelection()).getFirstElement();
        EditorTest.assertEquals((String)"sub1", (String)sub1PI.getTemplate().getName());
        TreeItem item = block.getViewer().getTree().getSelection()[0];
        TreeItem[] children = item.getItems();
        EditorTest.assertEquals((int)sub1PI.getChildren().size(), (int)children.length);
        EditorTest.assertTrue((children.length > 0 ? 1 : 0) != 0);
        EditorTest.assertEquals((String)"sub1_1", (String)((XMLInstanceElement)sub1PI.getChildren().get(0)).getTemplate().getName());
        EditorTest.assertEquals((String)"sub1_3", (String)((XMLInstanceElement)sub1PI.getChildren().get(1)).getTemplate().getName());
        EditorTest.assertEquals((String)"sub1_4", (String)((XMLInstanceElement)sub1PI.getChildren().get(2)).getTemplate().getName());
        EditorTest.assertEquals((String)"sub1_4", (String)((XMLInstanceElement)sub1PI.getChildren().get(3)).getTemplate().getName());
        EditorTest.assertEquals((String)"sub1_5", (String)((XMLInstanceElement)sub1PI.getChildren().get(4)).getTemplate().getName());
        EditorTest.assertEquals((String)"sub1_5", (String)((XMLInstanceElement)sub1PI.getChildren().get(5)).getTemplate().getName());
        EditorTest.assertEquals((String)"sub1_5", (String)((XMLInstanceElement)sub1PI.getChildren().get(6)).getTemplate().getName());
        EditorTest.assertEquals((int)7, (int)sub1PI.getChildren().size());
        EditorTest.assertEquals(Arrays.asList("Add sub1_2", "Add sub1_4", "Add sub1_5", "Delete", "Change Prefix", "Help"), this.getMenuItems(block));
        IAction addSub1_5Action = this.getMenuItemAction(block, "Add sub1_5");
        addSub1_5Action.run();
        XMLInstanceElement sub1_5PI = (XMLInstanceElement)((IStructuredSelection)block.getViewer().getSelection()).getFirstElement();
        EditorTest.assertEquals((String)"sub1_5", (String)sub1_5PI.getTemplate().getName());
        EditorTest.assertEquals(Arrays.asList("Delete", "Change Prefix", "Help"), this.getMenuItems(block));
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)sub1PI));
        EditorTest.assertEquals(Arrays.asList("Add sub1_2", "Add sub1_4", "Delete", "Change Prefix", "Help"), this.getMenuItems(block));
        IAction addSub1_2Action = this.getMenuItemAction(block, "Add sub1_2");
        addSub1_2Action.run();
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)sub1PI));
        EditorTest.assertEquals(Arrays.asList("Add sub1_2", "Add sub1_4", "Delete", "Change Prefix", "Help"), this.getMenuItems(block));
        addSub1_2Action.run();
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)sub1PI));
        EditorTest.assertEquals(Arrays.asList("Add sub1_4", "Delete", "Change Prefix", "Help"), this.getMenuItems(block));
        EditorTest.assertEquals((String)"sub1_1", (String)((XMLInstanceElement)sub1PI.getChildren().get(0)).getTemplate().getName());
        EditorTest.assertEquals((String)"sub1_2", (String)((XMLInstanceElement)sub1PI.getChildren().get(1)).getTemplate().getName());
        EditorTest.assertEquals((String)"sub1_2", (String)((XMLInstanceElement)sub1PI.getChildren().get(2)).getTemplate().getName());
        EditorTest.assertEquals((String)"sub1_3", (String)((XMLInstanceElement)sub1PI.getChildren().get(3)).getTemplate().getName());
        EditorTest.assertEquals((String)"sub1_4", (String)((XMLInstanceElement)sub1PI.getChildren().get(4)).getTemplate().getName());
        EditorTest.assertEquals((String)"sub1_4", (String)((XMLInstanceElement)sub1PI.getChildren().get(5)).getTemplate().getName());
        EditorTest.assertEquals((String)"sub1_5", (String)((XMLInstanceElement)sub1PI.getChildren().get(6)).getTemplate().getName());
        EditorTest.assertEquals((String)"sub1_5", (String)((XMLInstanceElement)sub1PI.getChildren().get(7)).getTemplate().getName());
        EditorTest.assertEquals((String)"sub1_5", (String)((XMLInstanceElement)sub1PI.getChildren().get(8)).getTemplate().getName());
        EditorTest.assertEquals((String)"sub1_5", (String)((XMLInstanceElement)sub1PI.getChildren().get(9)).getTemplate().getName());
        EditorTest.assertEquals((int)10, (int)sub1PI.getChildren().size());
        block.getViewer().setSelection((ISelection)new StructuredSelection(sub1PI.getChildren().get(1)));
        block.deleteButton.notifyListeners(13, new Event());
        EditorTest.assertEquals((String)"sub1_1", (String)((XMLInstanceElement)sub1PI.getChildren().get(0)).getTemplate().getName());
        EditorTest.assertEquals((String)"sub1_2", (String)((XMLInstanceElement)sub1PI.getChildren().get(1)).getTemplate().getName());
        EditorTest.assertEquals((String)"sub1_3", (String)((XMLInstanceElement)sub1PI.getChildren().get(2)).getTemplate().getName());
        EditorTest.assertEquals((String)"sub1_4", (String)((XMLInstanceElement)sub1PI.getChildren().get(3)).getTemplate().getName());
        EditorTest.assertEquals((String)"sub1_4", (String)((XMLInstanceElement)sub1PI.getChildren().get(4)).getTemplate().getName());
        EditorTest.assertEquals((String)"sub1_5", (String)((XMLInstanceElement)sub1PI.getChildren().get(5)).getTemplate().getName());
        EditorTest.assertEquals((String)"sub1_5", (String)((XMLInstanceElement)sub1PI.getChildren().get(6)).getTemplate().getName());
        EditorTest.assertEquals((String)"sub1_5", (String)((XMLInstanceElement)sub1PI.getChildren().get(7)).getTemplate().getName());
        EditorTest.assertEquals((String)"sub1_5", (String)((XMLInstanceElement)sub1PI.getChildren().get(8)).getTemplate().getName());
        EditorTest.assertEquals((int)9, (int)sub1PI.getChildren().size());
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)sub1PI));
        EditorTest.assertEquals((String)"The add sub1_2 should reappear since we've deleted one", Arrays.asList("Add sub1_2", "Add sub1_4", "Delete", "Change Prefix", "Help"), this.getMenuItems(block));
        EditorTest.assertTrue((block.getViewer().getExpandedElements().length > 0 ? 1 : 0) != 0);
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)pi));
        block.deleteAction.interactive = false;
        block.deleteButton.notifyListeners(13, new Event());
        block.getViewer().expandAll();
        EditorTest.assertEquals((int)0, (int)block.getViewer().getExpandedElements().length);
    }

    public void testDisplayNameOnElements() throws Exception {
        IFile file = this.testProject.getProject().getFile((IPath)new Path("test6.policy"));
        file.create((InputStream)new ByteArrayInputStream("".getBytes()), true, null);
        URL schemaURL1 = ((Object)((Object)this)).getClass().getClassLoader().getResource("/example_test.xsd");
        SchemaElement se1 = (SchemaElement)SchemaRegistry.getDefault().resolveSchemaFromURL(schemaURL1.toString(), new ISchemaProvider[0]).get(0);
        XefEditor editor = (XefEditor)IDE.openEditor((IWorkbenchPage)this.getPage(), (IEditorInput)new XMLProviderEditorInput("title", file.getProject(), (IXMLProvider)new XMLFileXMLProvider(file, "policies"), null, null), (String)"org.eclipse.stp.ui.xef.editor.XefEditor");
        XefEditMasterDetailsBlock block = editor.policyEditPage.block;
        class PolicySelectionDialogSubclass
        extends SchemaSelectionDialog {
            private final /* synthetic */ SchemaElement val$se1;

            PolicySelectionDialogSubclass(SchemaElement schemaElement) {
                this.val$se1 = schemaElement;
                super(null, null, new IShadowProvider[0]);
            }

            public Object getFirstResult() {
                return this.val$se1;
            }

            public int open() {
                return 0;
            }
        }
        block.addButtonListener.widgetSelected((SchemaSelectionDialog)new PolicySelectionDialogSubclass(se1), null);
        XMLInstanceElement pi = (XMLInstanceElement)((IStructuredSelection)block.getViewer().getSelection()).getFirstElement();
        EditorTest.assertEquals((int)1, (int)pi.getChildren().size());
        EditorTest.assertEquals((String)"example:Routing", (String)pi.toString());
        IAction namedElemAction = this.getMenuItemAction(block, "Add Explicitly Named Element");
        namedElemAction.run();
        XMLInstanceElement namedElemPI = (XMLInstanceElement)((IStructuredSelection)block.getViewer().getSelection()).getFirstElement();
        EditorTest.assertEquals((String)"rawElementName", (String)namedElemPI.getTemplate().getName());
        EditorTest.assertEquals((Object)pi, (Object)namedElemPI.getParent());
        EditorTest.assertEquals((int)0, (int)namedElemPI.getChildren().size());
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)namedElemPI));
        EditorTest.assertEquals(Arrays.asList("Add Sub Elem 4 Part 1", "Add Sub Elem 4 Part 2", "Add Sub Elem 4 Part 3", "Delete", "Change Prefix", "Help"), this.getMenuItems(block));
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)namedElemPI));
        EditorTest.assertEquals(Arrays.asList("Add Sub Elem 4 Part 1", "Add Sub Elem 4 Part 2", "Add Sub Elem 4 Part 3", "Delete", "Change Prefix", "Help"), this.getMenuItems(block));
        EditorTest.assertTrue((namedElemPI == ((IStructuredSelection)block.getViewer().getSelection()).getFirstElement() ? 1 : 0) != 0);
    }

    public void testDisplayNameOnRootElement() throws Exception {
        IFile file = this.testProject.getProject().getFile((IPath)new Path("test11.policy"));
        file.create((InputStream)new ByteArrayInputStream("".getBytes()), true, null);
        URL schemaURL1 = ((Object)((Object)this)).getClass().getClassLoader().getResource("/example_test2.xsd");
        SchemaElement se1 = (SchemaElement)SchemaRegistry.getDefault().resolveSchemaFromURL(schemaURL1.toString(), new ISchemaProvider[0]).get(0);
        XefEditor editor = (XefEditor)IDE.openEditor((IWorkbenchPage)this.getPage(), (IEditorInput)new XMLProviderEditorInput("title", file.getProject(), (IXMLProvider)new XMLFileXMLProvider(file, "policies"), null, null), (String)"org.eclipse.stp.ui.xef.editor.XefEditor");
        XefEditMasterDetailsBlock block = editor.policyEditPage.block;
        class PolicySelectionDialogSubclass
        extends SchemaSelectionDialog {
            private final /* synthetic */ SchemaElement val$se1;

            PolicySelectionDialogSubclass(SchemaElement schemaElement) {
                this.val$se1 = schemaElement;
                super(null, null, new IShadowProvider[0]);
            }

            public Object getFirstResult() {
                return this.val$se1;
            }

            public int open() {
                return 0;
            }
        }
        block.addButtonListener.widgetSelected((SchemaSelectionDialog)new PolicySelectionDialogSubclass(se1), null);
        XMLInstanceElement pi = (XMLInstanceElement)((IStructuredSelection)block.getViewer().getSelection()).getFirstElement();
        EditorTest.assertEquals((String)"Routing2 Explicitly Named Root Element", (String)pi.getLabel());
    }

    public void testChoiceSubElements() throws Exception {
        IFile file = this.testProject.getProject().getFile((IPath)new Path("test6.policy"));
        file.create((InputStream)new ByteArrayInputStream("".getBytes()), true, null);
        URL schemaURL1 = ((Object)((Object)this)).getClass().getClassLoader().getResource("/example_test.xsd");
        SchemaElement se1 = (SchemaElement)SchemaRegistry.getDefault().resolveSchemaFromURL(schemaURL1.toString(), new ISchemaProvider[0]).get(0);
        XefEditor editor = (XefEditor)IDE.openEditor((IWorkbenchPage)this.getPage(), (IEditorInput)new XMLProviderEditorInput("title", file.getProject(), (IXMLProvider)new XMLFileXMLProvider(file, "policies"), null, null), (String)"org.eclipse.stp.ui.xef.editor.XefEditor");
        XefEditMasterDetailsBlock block = editor.policyEditPage.block;
        class PolicySelectionDialogSubclass
        extends SchemaSelectionDialog {
            private final /* synthetic */ SchemaElement val$se1;

            PolicySelectionDialogSubclass(SchemaElement schemaElement) {
                this.val$se1 = schemaElement;
                super(null, null, new IShadowProvider[0]);
            }

            public Object getFirstResult() {
                return this.val$se1;
            }

            public int open() {
                return 0;
            }
        }
        block.addButtonListener.widgetSelected((SchemaSelectionDialog)new PolicySelectionDialogSubclass(se1), null);
        XMLInstanceElement pi = (XMLInstanceElement)((IStructuredSelection)block.getViewer().getSelection()).getFirstElement();
        EditorTest.assertEquals((int)1, (int)pi.getChildren().size());
        EditorTest.assertEquals((String)"example:Routing", (String)pi.toString());
        IAction sub3Action = this.getMenuItemAction(block, "Add sub3");
        sub3Action.run();
        XMLInstanceElement sub3PI = (XMLInstanceElement)((IStructuredSelection)block.getViewer().getSelection()).getFirstElement();
        EditorTest.assertEquals((String)"sub3", (String)sub3PI.getTemplate().getName());
        EditorTest.assertEquals((Object)pi, (Object)sub3PI.getParent());
        EditorTest.assertEquals((int)0, (int)sub3PI.getChildren().size());
        EditorTest.assertEquals(Arrays.asList("Add sub3_1", "Add sub3_2", "Add sub3_3", "Delete", "Change Prefix", "Help"), this.getMenuItems(block));
        IAction sub3_2Action = this.getMenuItemAction(block, "Add sub3_2");
        sub3_2Action.run();
        EditorTest.assertEquals((int)1, (int)sub3PI.getChildren().size());
        EditorTest.assertEquals((String)"sub3_2", (String)((XMLInstanceElement)sub3PI.getChildren().get(0)).getTemplate().getName());
        XMLInstanceElement sub3_2PI = (XMLInstanceElement)((IStructuredSelection)block.getViewer().getSelection()).getFirstElement();
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)sub3PI));
        EditorTest.assertEquals(Arrays.asList("Delete", "Change Prefix", "Help"), this.getMenuItems(block));
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)sub3_2PI));
        IAction deleteAction = this.getMenuItemAction(block, "Delete");
        ((DeleteElementAction)deleteAction).interactive = false;
        deleteAction.run();
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)sub3PI));
        EditorTest.assertEquals(Arrays.asList("Add sub3_1", "Add sub3_2", "Add sub3_3", "Delete", "Change Prefix", "Help"), this.getMenuItems(block));
        EditorTest.assertTrue((sub3PI == ((IStructuredSelection)block.getViewer().getSelection()).getFirstElement() ? 1 : 0) != 0);
    }

    public void testAddingPolicyMakesEditorDirty() throws Exception {
        IFile file = this.testProject.getProject().getFile((IPath)new Path("test7.policy"));
        file.create((InputStream)new ByteArrayInputStream("".getBytes()), true, null);
        URL schemaURL1 = ((Object)((Object)this)).getClass().getClassLoader().getResource("/test_seq_in_choice.xsd");
        SchemaElement se1 = (SchemaElement)SchemaRegistry.getDefault().resolveSchemaFromURL(schemaURL1.toString(), new ISchemaProvider[0]).get(0);
        XefEditor editor = (XefEditor)IDE.openEditor((IWorkbenchPage)this.getPage(), (IEditorInput)new XMLProviderEditorInput("title", file.getProject(), (IXMLProvider)new XMLFileXMLProvider(file, "policies"), null, null), (String)"org.eclipse.stp.ui.xef.editor.XefEditor");
        XefEditMasterDetailsBlock block = editor.policyEditPage.block;
        EditorTest.assertFalse((boolean)editor.isDirty());
        class PolicySelectionDialogSubclass
        extends SchemaSelectionDialog {
            private final /* synthetic */ SchemaElement val$se1;

            PolicySelectionDialogSubclass(SchemaElement schemaElement) {
                this.val$se1 = schemaElement;
                super(null, null, new IShadowProvider[0]);
            }

            public Object getFirstResult() {
                return this.val$se1;
            }

            public int open() {
                return 0;
            }
        }
        block.addButtonListener.widgetSelected((SchemaSelectionDialog)new PolicySelectionDialogSubclass(se1), null);
        XMLInstanceElement pi = (XMLInstanceElement)((IStructuredSelection)block.getViewer().getSelection()).getFirstElement();
        EditorTest.assertEquals((int)0, (int)pi.getChildren().size());
        EditorTest.assertEquals((String)"example:Test", (String)pi.toString());
        EditorTest.assertTrue((String)"The editor should be dirty since we added a policy", (boolean)editor.isDirty());
        editor.doSave((IProgressMonitor)new NullProgressMonitor());
        EditorTest.assertFalse((boolean)editor.isDirty());
        IAction addConsoleLoggerAction = this.getMenuItemAction(block, "Add spam");
        addConsoleLoggerAction.run();
        EditorTest.assertTrue((String)"The editor should be dirty since we added a subnode", (boolean)editor.isDirty());
    }

    public void testAddingSnippetSetsDerivedComments() throws Exception {
        IFile file = this.testProject.getProject().getFile((IPath)new Path("test71.policy"));
        file.create((InputStream)new ByteArrayInputStream("<policy/>".getBytes()), true, null);
        XMLSnippet se = new XMLSnippet("Top Snippet", "<example:audit xmlns:example=\"http://www.example.com/xsd/2006/02/test_audit\"/><example:Routing xmlns:example=\"http://www.example.com/xsd/2006/02/test_routing\"><Destination target_service=\"hahaha\"/></example:Routing>");
        URL auditURL = ((Object)((Object)this)).getClass().getClassLoader().getResource("example_test_audit.xsd");
        URL routingURL = ((Object)((Object)this)).getClass().getClassLoader().getResource("example_test_routing.xsd");
        URLSchemaProvider urlSchemaProvider = new URLSchemaProvider(new URL[]{auditURL, routingURL}, new XMLSnippet[]{se});
        XefEditor editor = (XefEditor)IDE.openEditor((IWorkbenchPage)this.getPage(), (IEditorInput)new XMLProviderEditorInput("title", file.getProject(), (IXMLProvider)new XMLFileXMLProvider(file, "policy"), (ISchemaProvider)urlSchemaProvider, null), (String)"org.eclipse.stp.ui.xef.editor.XefEditor");
        XefEditMasterDetailsBlock block = editor.policyEditPage.block;
        EditorTest.assertFalse((boolean)editor.isDirty());
        class PolicySelectionDialogSubclass
        extends SchemaSelectionDialog {
            private final /* synthetic */ XMLSnippet val$se;

            PolicySelectionDialogSubclass(XMLSnippet xMLSnippet) {
                this.val$se = xMLSnippet;
                super(null, null, new IShadowProvider[0]);
            }

            public Object getFirstResult() {
                return this.val$se;
            }

            public int open() {
                return 0;
            }
        }
        block.addButtonListener.widgetSelected((SchemaSelectionDialog)new PolicySelectionDialogSubclass(se), null);
        TreeViewer viewer = block.getViewer();
        viewer.expandAll();
        TreeItem[] topItems = viewer.getTree().getItems();
        EditorTest.assertEquals((int)1, (int)topItems.length);
        EditorTest.assertEquals((String)"Top Snippet", (String)topItems[0].getText());
        TreeItem[] subItems = topItems[0].getItems();
        EditorTest.assertEquals((int)2, (int)subItems.length);
        XMLInstanceElement pi0 = (XMLInstanceElement)subItems[0].getData();
        EditorTest.assertEquals((int)0, (int)pi0.getChildren().size());
        EditorTest.assertEquals((String)"example:audit", (String)pi0.toString());
        XMLInstanceElement pi = (XMLInstanceElement)subItems[1].getData();
        EditorTest.assertEquals((int)1, (int)pi.getChildren().size());
        EditorTest.assertEquals((String)"example:Routing", (String)pi.toString());
        EditorTest.assertTrue((String)"The editor should be dirty since we added a policy", (boolean)editor.isDirty());
    }

    public void testRenameNamespacePrefix() throws Exception {
        IFile file = this.testProject.getProject().getFile((IPath)new Path("test8.policy"));
        file.create((InputStream)new ByteArrayInputStream("<policies/>".getBytes()), true, null);
        URL schemaURL1 = ((Object)((Object)this)).getClass().getClassLoader().getResource("/example_test_audit.xsd");
        SchemaElement se1 = (SchemaElement)SchemaRegistry.getDefault().resolveSchemaFromURL(schemaURL1.toString(), new ISchemaProvider[0]).get(0);
        XMLInstanceElement pi1 = new XMLInstanceElement(se1);
        XefEditor editor = (XefEditor)IDE.openEditor((IWorkbenchPage)this.getPage(), (IEditorInput)new XMLProviderEditorInput("title", file.getProject(), (IXMLProvider)new XMLFileXMLProvider(file, "policies"), null, null), (String)"org.eclipse.stp.ui.xef.editor.XefEditor");
        XefEditMasterDetailsBlock block = editor.policyEditPage.block;
        block.policies.add(pi1);
        block.getViewer().refresh();
        block.getViewer().expandAll();
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)pi1));
        XefDetailsPage detailsPage = (XefDetailsPage)block.getDetailsPart().getCurrentPage();
        Button b = (Button)this.reverseGet(detailsPage.values, pi1.getTemplate().getAttribute("every_call"));
        b.notifyListeners(3, new Event());
        b.notifyListeners(13, new Event());
        b.setSelection(true);
        EditorTest.assertTrue((String)"A policy has been added so the editor should be dirty", (boolean)editor.isDirty());
        editor.doSave((IProgressMonitor)new NullProgressMonitor());
        EditorTest.assertFalse((boolean)editor.isDirty());
        TreeItem item = block.getViewer().getTree().getSelection()[0];
        EditorTest.assertEquals((String)"example:audit", (String)item.getText());
        editor.setActivePage(editor.xmlEditPage.getId());
        EditorTest.assertEquals((String)EditorTest.normXML("<policies>  <example:audit xmlns:example=\"http://www.example.com/xsd/2006/02/test_audit\" every_call=\"true\"/></policies>"), (String)EditorTest.normXML(editor.xmlEditPage.getDocumentProvider().getDocument((Object)editor.getEditorInput()).get()));
        editor.setActivePage(editor.policyEditPage.getId());
        block.getViewer().refresh();
        block.getViewer().expandAll();
        block.getViewer().setSelection((ISelection)new StructuredSelection(((List)block.getViewer().getInput()).get(0)));
        List<String> items = this.getMenuItems(block);
        EditorTest.assertTrue((boolean)items.contains("Change Prefix"));
        EditorTest.assertTrue((boolean)items.contains("Delete"));
        EditorTest.assertTrue((boolean)items.contains("Help"));
        EditorTest.assertEquals((int)3, (int)items.size());
        EditorTest.assertFalse((String)"Precondition failed", (boolean)editor.isDirty());
        block.changePrefixAction.nonInteractiveNewValue = "ns1";
        block.changePrefixAction.run();
        TreeItem item2 = block.getViewer().getTree().getSelection()[0];
        EditorTest.assertEquals((String)"ns1:audit", (String)item2.getText());
        EditorTest.assertTrue((String)"The editor is dirty since we changed the prefix", (boolean)editor.isDirty());
        editor.setActivePage(editor.xmlEditPage.getId());
        EditorTest.assertEquals((String)EditorTest.normXML("<policies><ns1:audit xmlns:ns1=\"http://www.example.com/xsd/2006/02/test_audit\" every_call=\"true\"/></policies>"), (String)EditorTest.normXML(editor.xmlEditPage.getDocumentProvider().getDocument((Object)editor.getEditorInput()).get()));
    }

    public void testNameSpacePrefixInputValidator() {
        ChangePrefixAction.NameSpacePrefixInputValidator v = new ChangePrefixAction.NameSpacePrefixInputValidator();
        EditorTest.assertNull((Object)v.isValid("x"));
        EditorTest.assertNull((Object)v.isValid("ns1"));
        EditorTest.assertNull((Object)v.isValid("example"));
        EditorTest.assertNull((Object)v.isValid("ns2"));
        EditorTest.assertNotNull((Object)v.isValid("x y"));
        EditorTest.assertNotNull((Object)v.isValid(""));
        EditorTest.assertNotNull((Object)v.isValid("nIa"));
        EditorTest.assertNotNull((Object)v.isValid("a&b"));
        EditorTest.assertNotNull((Object)v.isValid("@"));
    }

    public void testInitSnippet() throws Exception {
        IFile file = this.testProject.getProject().getFile((IPath)new Path("test9.policy"));
        String initialContent = "<wsp:Policy xmlns:wsp=\"http://schemas.xmlsoap.org/ws/2004/09/policy\"><wsp:All><example:audit xmlns:example=\"http://www.example.com/xsd/2006/02/test_audit\"> <!--#auditsnippet#--></example:audit></wsp:All></wsp:Policy>";
        file.create((InputStream)new ByteArrayInputStream(initialContent.getBytes()), true, null);
        XMLSnippet auditSnippet = new XMLSnippet("auditsnippet", "<example:audit xmlns:example=\"http://www.example.com/xsd/2006/02/test_audit\"/>");
        URL schemaURL = ((Object)((Object)this)).getClass().getClassLoader().getResource("/example_test_audit.xsd");
        URLSchemaProvider schemaProvider = new URLSchemaProvider(new URL[]{schemaURL}, new XMLSnippet[]{auditSnippet});
        XefEditor editor = (XefEditor)IDE.openEditor((IWorkbenchPage)this.getPage(), (IEditorInput)new XMLProviderEditorInput("title", file.getProject(), (IXMLProvider)new XMLFileXMLProvider(file, "{http://schemas.xmlsoap.org/ws/2004/09/policy}All"), (ISchemaProvider)schemaProvider, null), (String)"org.eclipse.stp.ui.xef.editor.XefEditor");
        XefEditMasterDetailsBlock block = editor.policyEditPage.block;
        block.getViewer().expandAll();
        List policies = (List)block.getViewer().getInput();
        EditorTest.assertEquals((int)1, (int)policies.size());
        XMLInstanceElement pi = (XMLInstanceElement)policies.get(0);
        EditorTest.assertEquals((String)"example:audit", (String)pi.toString());
        EditorTest.assertFalse((boolean)editor.isDirty());
        editor.setActivePage(editor.xmlEditPage.getId());
        editor.setActivePage(editor.policyEditPage.getId());
        EditorTest.assertFalse((boolean)editor.isDirty());
        List p2 = (List)block.getViewer().getInput();
        EditorTest.assertEquals((int)1, (int)p2.size());
        XMLInstanceElement pi2 = (XMLInstanceElement)p2.get(0);
        block.decorateSnippets(block.getViewer(), new XMLInstanceElement[]{pi2});
        block.getViewer().expandAll();
        Tree tree = block.getViewer().getTree();
        TreeItem ti2 = this.findTreeItem(tree, pi2);
        EditorTest.assertEquals((String)"example:audit (verified)", (String)ti2.getText());
        EditorTest.assertTrue((pi2 != pi ? 1 : 0) != 0);
    }

    public void testModifiedSnippet() throws Exception {
        IFile file = this.testProject.getProject().getFile((IPath)new Path("test10.policy"));
        String initialContent = "<wsp:Policy xmlns:wsp=\"http://schemas.xmlsoap.org/ws/2004/09/policy\"><wsp:All><example:audit xmlns:example=\"http://www.example.com/xsd/2006/02/test_audit\" every_call=\"true\" > <!--#auditsnippet#--></example:audit></wsp:All></wsp:Policy>";
        file.create((InputStream)new ByteArrayInputStream(initialContent.getBytes()), true, null);
        XMLSnippet auditSnippet = new XMLSnippet("auditsnippet", "<example:audit xmlns:example=\"http://www.example.com/xsd/2006/02/test_audit\"/>");
        URL schemaURL = ((Object)((Object)this)).getClass().getClassLoader().getResource("/example_test_audit.xsd");
        URLSchemaProvider schemaProvider = new URLSchemaProvider(new URL[]{schemaURL}, new XMLSnippet[]{auditSnippet});
        XefEditor editor = (XefEditor)IDE.openEditor((IWorkbenchPage)this.getPage(), (IEditorInput)new XMLProviderEditorInput("title", file.getProject(), (IXMLProvider)new XMLFileXMLProvider(file, "{http://schemas.xmlsoap.org/ws/2004/09/policy}All"), (ISchemaProvider)schemaProvider, null), (String)"org.eclipse.stp.ui.xef.editor.XefEditor");
        XefEditMasterDetailsBlock block = editor.policyEditPage.block;
        List policies = (List)block.getViewer().getInput();
        EditorTest.assertEquals((int)1, (int)policies.size());
        XMLInstanceElement pi = (XMLInstanceElement)policies.get(0);
        block.decorateSnippets(block.getViewer(), new XMLInstanceElement[]{pi});
        block.getViewer().expandAll();
        Tree tree = block.getViewer().getTree();
        TreeItem ti = this.findTreeItem(tree, pi);
        EditorTest.assertEquals((String)"example:audit (customized)", (String)ti.getText());
        EditorTest.assertFalse((boolean)editor.isDirty());
    }

    public void testSnippetsShownInSubElements() throws Exception {
        IFile file = this.testProject.getProject().getFile((IPath)new Path("test10.policy"));
        String initialContent = "<wsp:Policy xmlns:wsp=\"http://schemas.xmlsoap.org/ws/2004/09/policy\"><wsp:All><example:Routing xmlns:example=\"http://www.example.com/xsd/2006/02/test\">Hello</example:Routing><example:audit xmlns:example=\"http://www.example.com/xsd/2006/02/test_audit\" every_call=\"true\" > <!--#mysnippet#--></example:audit><example:logging xmlns:example=\"http://www.example.com/xsd/2006/02/test_logging\" level=\"Error\"><!--#mysnippet#--></example:logging></wsp:All></wsp:Policy>";
        file.create((InputStream)new ByteArrayInputStream(initialContent.getBytes()), true, null);
        URL auditSchemaURL = ((Object)((Object)this)).getClass().getClassLoader().getResource("/example_test_audit.xsd");
        URL loggingSchemaURL = ((Object)((Object)this)).getClass().getClassLoader().getResource("/example_test_logging.xsd");
        URL routingSchemaURL = ((Object)((Object)this)).getClass().getClassLoader().getResource("/example_test.xsd");
        URLSchemaProvider schemaProvider = new URLSchemaProvider(new URL[]{auditSchemaURL, loggingSchemaURL, routingSchemaURL}, new XMLSnippet[0]);
        XefEditor editor = (XefEditor)IDE.openEditor((IWorkbenchPage)this.getPage(), (IEditorInput)new XMLProviderEditorInput("title", file.getProject(), (IXMLProvider)new XMLFileXMLProvider(file, "{http://schemas.xmlsoap.org/ws/2004/09/policy}All"), (ISchemaProvider)schemaProvider, null), (String)"org.eclipse.stp.ui.xef.editor.XefEditor");
        XefEditMasterDetailsBlock block = editor.policyEditPage.block;
        block.getViewer().expandAll();
        Tree tree = block.getViewer().getTree();
        EditorTest.assertEquals((int)2, (int)tree.getItems().length);
        EditorTest.assertEquals((String)"example:Routing", (String)tree.getItem(0).getText());
        EditorTest.assertEquals((String)"mysnippet", (String)tree.getItem(1).getText());
    }

    public void testAttributeDependencies() throws Exception {
        TestContextProvider ctxProvider = this.setupContextProvider();
        IFile file = this.testProject.getProject().getFile((IPath)new Path("test35.policy"));
        file.create((InputStream)new ByteArrayInputStream("".getBytes()), true, null);
        XefEditor editor = (XefEditor)IDE.openEditor((IWorkbenchPage)this.getPage(), (IEditorInput)new XMLProviderEditorInput("title", file.getProject(), (IXMLProvider)new XMLFileXMLProvider(file, "{http://schemas.xmlsoap.org/ws/2004/09/policy}All"), null, (IContextProvider)ctxProvider), (String)"org.eclipse.stp.ui.xef.editor.XefEditor");
        XefEditMasterDetailsBlock block = editor.policyEditPage.block;
        URL schemaURL = ((Object)((Object)this)).getClass().getClassLoader().getResource("/example_test_depends.xsd");
        SchemaElement se = (SchemaElement)SchemaRegistry.getDefault().resolveSchemaFromURL(schemaURL.toString(), new ISchemaProvider[0]).get(1);
        XMLInstanceElement pi = new XMLInstanceElement(se);
        block.policies.add(pi);
        TreeViewer viewer = block.getViewer();
        viewer.expandAll();
        viewer.setSelection((ISelection)new StructuredSelection((Object)pi));
        XefDetailsPage detailsPage = (XefDetailsPage)block.getDetailsPart().getCurrentPage();
        Combo svcCtrl = (Combo)this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("service"));
        Control[] svcControls = (Control[])svcCtrl.getData("The actual controls");
        Combo actualSvcCtrl = (Combo)svcControls[0];
        EditorTest.assertEquals((int)3, (int)actualSvcCtrl.getItemCount());
        Combo endptCtrl = (Combo)this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("port"));
        Control[] endptControls = (Control[])endptCtrl.getData("The actual controls");
        Combo actualEndptCtrl = (Combo)endptControls[0];
        EditorTest.assertEquals((int)0, (int)actualEndptCtrl.getItemCount());
        Combo operCtrl = (Combo)this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("operation"));
        Control[] operControls = (Control[])operCtrl.getData("The actual controls");
        Combo actualOperCtrl = (Combo)operControls[0];
        EditorTest.assertEquals((int)0, (int)actualOperCtrl.getItemCount());
        actualSvcCtrl.select(0);
        actualSvcCtrl.notifyListeners(24, new Event());
        EditorTest.assertEquals((int)3, (int)actualEndptCtrl.getItemCount());
        EditorTest.assertEquals((int)2, (int)actualOperCtrl.getItemCount());
        actualSvcCtrl.select(1);
        actualSvcCtrl.notifyListeners(24, new Event());
        EditorTest.assertEquals((int)2, (int)actualEndptCtrl.getItemCount());
        EditorTest.assertEquals((int)3, (int)actualOperCtrl.getItemCount());
    }

    public void testNoDuplicatePolicies() throws Exception {
        XefEditMasterDetailsBlock.interactive = false;
        try {
            IFile file = this.testProject.getProject().getFile((IPath)new Path("test36.policy"));
            file.create((InputStream)new ByteArrayInputStream("<policy/>".getBytes()), true, null);
            URL auditURL = ((Object)((Object)this)).getClass().getClassLoader().getResource("example_test_audit.xsd");
            URL routingURL = ((Object)((Object)this)).getClass().getClassLoader().getResource("example_test_routing.xsd");
            URLSchemaProvider urlSchemaProvider = new URLSchemaProvider(new URL[]{auditURL, routingURL});
            XefEditor editor = (XefEditor)IDE.openEditor((IWorkbenchPage)this.getPage(), (IEditorInput)new XMLProviderEditorInput("title", file.getProject(), (IXMLProvider)new XMLFileXMLProvider(file, "policy"), (ISchemaProvider)urlSchemaProvider, null), (String)"org.eclipse.stp.ui.xef.editor.XefEditor");
            XefEditMasterDetailsBlock block = editor.policyEditPage.block;
            SchemaElement auditSchema = null;
            block.addButtonListener.widgetSelected(null);
            SchemaSelectionDialog dialog1 = block.addButtonListener.currentDialog;
            EditorTest.assertTrue((String)"Precondition failed", (boolean)dialog1.getShell().isVisible());
            try {
                dialog1.getTreeViewer().expandAll();
                SelectionCategory otherCat = (SelectionCategory)dialog1.categories.get("Uncategorized");
                ArrayList schemas = new ArrayList(otherCat.getEntries());
                EditorTest.assertEquals((int)2, (int)schemas.size());
                EditorTest.assertEquals((String)"audit", (String)((SchemaElement)schemas.get(0)).getName());
                EditorTest.assertEquals((String)"Routing", (String)((SchemaElement)schemas.get(1)).getName());
                auditSchema = (SchemaElement)schemas.get(0);
            }
            finally {
                dialog1.close();
            }
            XMLInstanceElement pi = new XMLInstanceElement(auditSchema);
            block.policies.add(pi);
            block.addButtonListener.widgetSelected(null);
            SchemaSelectionDialog dialog2 = block.addButtonListener.currentDialog;
            EditorTest.assertTrue((String)"Should be a different dialog instance", (dialog1 != dialog2 ? 1 : 0) != 0);
            EditorTest.assertTrue((String)"Precondition failed", (boolean)dialog2.getShell().isVisible());
            try {
                dialog2.getTreeViewer().expandAll();
                SelectionCategory otherCat = (SelectionCategory)dialog2.categories.get("Uncategorized");
                ArrayList entries = new ArrayList(otherCat.getEntries());
                int numberOfActualsSchemas = 0;
                for (Object o : entries) {
                    if (!(o instanceof SchemaElement)) continue;
                    EditorTest.assertEquals((String)"Routing", (String)((SchemaElement)o).getName());
                    ++numberOfActualsSchemas;
                }
                EditorTest.assertEquals((int)1, (int)numberOfActualsSchemas);
            }
            finally {
                dialog2.close();
            }
        }
        finally {
            XefEditMasterDetailsBlock.interactive = true;
        }
    }

    public void testNoDuplicatePoliciesSnippets() throws Exception {
        XefEditMasterDetailsBlock.interactive = false;
        try {
            IFile file = this.testProject.getProject().getFile((IPath)new Path("test37.policy"));
            file.create((InputStream)new ByteArrayInputStream("<policy/>".getBytes()), true, null);
            XMLSnippet se = new XMLSnippet("Top Snippet", "<example:audit xmlns:example=\"http://www.example.com/xsd/2006/02/test_audit\"/><example:Routing xmlns:example=\"http://www.example.com/xsd/2006/02/test_routing\"><Destination target_service=\"hahaha\"/></example:Routing>");
            XMLSnippet se2 = new XMLSnippet("Audit Snippet", "<example:audit xmlns:example=\"http://www.example.com/xsd/2006/02/test_audit\"/>");
            XMLSnippet se3 = new XMLSnippet("Unrelated", "<example:secure xmlns:example=\"http://www.example.com/xsd/2006/02/test_secure\"/><example:Routing xmlns:example=\"http://www.example.com/xsd/2006/02/test_routing\"><Destination target_service=\"hahaha\"/></example:Routing>");
            URL auditURL = ((Object)((Object)this)).getClass().getClassLoader().getResource("example_test_audit.xsd");
            URL routingURL = ((Object)((Object)this)).getClass().getClassLoader().getResource("example_test_routing.xsd");
            URL secureURL = ((Object)((Object)this)).getClass().getClassLoader().getResource("/example_test_secure.xsd");
            URLSchemaProvider urlSchemaProvider = new URLSchemaProvider(new URL[]{auditURL, routingURL, secureURL}, new XMLSnippet[]{se, se2, se3});
            XefEditor editor = (XefEditor)IDE.openEditor((IWorkbenchPage)this.getPage(), (IEditorInput)new XMLProviderEditorInput("title", file.getProject(), (IXMLProvider)new XMLFileXMLProvider(file, "policy"), (ISchemaProvider)urlSchemaProvider, null), (String)"org.eclipse.stp.ui.xef.editor.XefEditor");
            XefEditMasterDetailsBlock block = editor.policyEditPage.block;
            SchemaElement auditSchema = null;
            block.addButtonListener.widgetSelected(null);
            SchemaSelectionDialog dialog1 = block.addButtonListener.currentDialog;
            EditorTest.assertTrue((String)"Precondition failed", (boolean)dialog1.getShell().isVisible());
            try {
                dialog1.getTreeViewer().expandAll();
                SelectionCategory otherCat = (SelectionCategory)dialog1.categories.get("Uncategorized");
                ArrayList schemas = new ArrayList(otherCat.getEntries());
                EditorTest.assertEquals((int)3, (int)schemas.size());
                EditorTest.assertEquals((String)"audit", (String)((SchemaElement)schemas.get(0)).getName());
                EditorTest.assertEquals((String)"Routing", (String)((SchemaElement)schemas.get(1)).getName());
                EditorTest.assertEquals((String)"secure", (String)((SchemaElement)schemas.get(2)).getName());
                auditSchema = (SchemaElement)schemas.get(0);
                SelectionCategory predefinedCat = (SelectionCategory)dialog1.categories.get("Composite Policies");
                ArrayList snippets = new ArrayList(predefinedCat.getEntries());
                EditorTest.assertEquals((int)3, (int)snippets.size());
                EditorTest.assertEquals((String)"Audit Snippet", (String)((XMLSnippet)snippets.get(0)).getName());
                EditorTest.assertEquals((String)"Top Snippet", (String)((XMLSnippet)snippets.get(1)).getName());
                EditorTest.assertEquals((String)"Unrelated", (String)((XMLSnippet)snippets.get(2)).getName());
            }
            finally {
                dialog1.close();
            }
            XMLInstanceElement pi = new XMLInstanceElement(auditSchema);
            block.policies.add(pi);
            block.addButtonListener.widgetSelected(null);
            SchemaSelectionDialog dialog2 = block.addButtonListener.currentDialog;
            EditorTest.assertTrue((String)"Precondition failed", (boolean)dialog2.getShell().isVisible());
            try {
                dialog2.getTreeViewer().expandAll();
                SelectionCategory otherCat = (SelectionCategory)dialog2.categories.get("Uncategorized");
                ArrayList elements = new ArrayList(otherCat.getEntries());
                int actualSchemas = 0;
                for (Object o : elements) {
                    if (!(o instanceof SchemaElement)) continue;
                    if (++actualSchemas == 1) {
                        EditorTest.assertEquals((String)"Routing", (String)((SchemaElement)o).getName());
                        continue;
                    }
                    if (actualSchemas != 2) continue;
                    EditorTest.assertEquals((String)"secure", (String)((SchemaElement)o).getName());
                }
                EditorTest.assertEquals((int)2, (int)actualSchemas);
                SelectionCategory predefinedCat = (SelectionCategory)dialog2.categories.get("Composite Policies");
                ArrayList snippets = new ArrayList(predefinedCat.getEntries());
                int shadowEntries = 0;
                int snippetEntries = 0;
                for (Object o : snippets) {
                    if (o instanceof XMLSnippet) {
                        ++snippetEntries;
                        EditorTest.assertEquals((String)"Unrelated", (String)((XMLSnippet)o).getName());
                        continue;
                    }
                    ++shadowEntries;
                    ShadowEntry shadow = (ShadowEntry)o;
                    EditorTest.assertTrue((boolean)shadow.toString().endsWith("already applied)"));
                }
                EditorTest.assertEquals((int)1, (int)snippetEntries);
                EditorTest.assertEquals((int)2, (int)shadowEntries);
            }
            finally {
                dialog2.close();
            }
        }
        finally {
            XefEditMasterDetailsBlock.interactive = true;
        }
    }

    public void testDeleteMakesEditorDirty() throws Exception {
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        SchemaRegistry.getDefault().resolveSchemaFromURL(cl.getResource("example_test_audit.xsd").toString(), new ISchemaProvider[0]);
        SchemaRegistry.getDefault().resolveSchemaFromURL(cl.getResource("example_test_logging.xsd").toString(), new ISchemaProvider[0]);
        SchemaRegistry.getDefault().resolveSchemaFromURL(cl.getResource("example_test.xsd").toString(), new ISchemaProvider[0]);
        String initial = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><policies><example:logging xmlns:example=\"http://www.example.com/xsd/2006/02/test_logging\" level=\"Error\"><example:FileLogger file=\"TestFile\" refreshRate=\"123\"><LinePrefix>Prefix Text</LinePrefix></example:FileLogger></example:logging><example:audit xmlns:example=\"http://www.example.com/xsd/2006/02/test_audit\" every_call=\"true\"/></policies>";
        IFile file = this.testProject.getProject().getFile((IPath)new Path("test38.policy"));
        file.create((InputStream)new ByteArrayInputStream("".getBytes()), true, null);
        XefEditor editor = (XefEditor)IDE.openEditor((IWorkbenchPage)this.getPage(), (IEditorInput)new XMLProviderEditorInput("title", file.getProject(), (IXMLProvider)new XMLFileXMLProvider(file, "policies"), null, null), (String)"org.eclipse.stp.ui.xef.editor.XefEditor");
        editor.setActivePage(editor.xmlEditPage.getId());
        IDocument doc = editor.xmlEditPage.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        try {
            doc.set(initial);
        }
        catch (RuntimeException re) {
            if (re.getClass().getName().equals("org.eclipse.jface.text.Assert$AssertionFailedException")) {
                re.printStackTrace();
            }
            throw re;
        }
        editor.setActivePage(editor.policyEditPage.getId());
        XefEditMasterDetailsBlock block = editor.policyEditPage.block;
        TreeViewer viewer = block.getViewer();
        viewer.expandAll();
        editor.doSave((IProgressMonitor)new NullProgressMonitor());
        XMLInstanceElement auditEl = (XMLInstanceElement)this.getTreeItem(viewer.getTree(), "example:audit").getData();
        viewer.setSelection((ISelection)new StructuredSelection((Object)auditEl));
        EditorTest.assertFalse((String)"Precondition failed", (boolean)editor.isDirty());
        block.deleteAction.interactive = false;
        block.deleteButton.notifyListeners(13, new Event());
        EditorTest.assertTrue((String)"Editor should be dirty as we deleted an item", (boolean)editor.isDirty());
        editor.doSave((IProgressMonitor)new NullProgressMonitor());
        EditorTest.assertFalse((String)"Editor should not be dirty any more as we saved", (boolean)editor.isDirty());
    }

    public void testDeleteSnippets() throws Exception {
        IFile file = this.testProject.getProject().getFile((IPath)new Path("test39.policy"));
        String initialContent = "<wsp:Policy xmlns:wsp=\"http://schemas.xmlsoap.org/ws/2004/09/policy\"><wsp:All><example:audit xmlns:example=\"http://www.example.com/xsd/2006/02/test_audit\" every_call=\"true\" > <!--#mysnippet#--></example:audit><example:logging xmlns:example=\"http://www.example.com/xsd/2006/02/test_logging\" level=\"Error\"><!--#mysnippet#--></example:logging><example:Routing xmlns:example=\"http://www.example.com/xsd/2006/02/test\">Hello</example:Routing></wsp:All></wsp:Policy>";
        file.create((InputStream)new ByteArrayInputStream(initialContent.getBytes()), true, null);
        URL auditSchemaURL = ((Object)((Object)this)).getClass().getClassLoader().getResource("/example_test_audit.xsd");
        URL loggingSchemaURL = ((Object)((Object)this)).getClass().getClassLoader().getResource("/example_test_logging.xsd");
        URL routingSchemaURL = ((Object)((Object)this)).getClass().getClassLoader().getResource("/example_test.xsd");
        URLSchemaProvider schemaProvider = new URLSchemaProvider(new URL[]{auditSchemaURL, loggingSchemaURL, routingSchemaURL}, new XMLSnippet[0]);
        XefEditor editor = (XefEditor)IDE.openEditor((IWorkbenchPage)this.getPage(), (IEditorInput)new XMLProviderEditorInput("title", file.getProject(), (IXMLProvider)new XMLFileXMLProvider(file, "{http://schemas.xmlsoap.org/ws/2004/09/policy}All"), (ISchemaProvider)schemaProvider, null), (String)"org.eclipse.stp.ui.xef.editor.XefEditor");
        XefEditMasterDetailsBlock block = editor.policyEditPage.block;
        block.deleteAction.interactive = false;
        block.getViewer().expandAll();
        Object[] el = block.getViewer().getExpandedElements();
        block.getViewer().setSelection((ISelection)new StructuredSelection(el[0]));
        List<String> items = this.getMenuItems(block);
        EditorTest.assertEquals((String)"Delete", (String)items.get(0));
        EditorTest.assertEquals((int)1, (int)items.size());
        block.deleteAction.run();
        editor.setActivePage(editor.xmlEditPage.getId());
        String ultimateContent = "<wsp:Policy xmlns:wsp=\"http://schemas.xmlsoap.org/ws/2004/09/policy\"><wsp:All><example:Routing xmlns:example=\"http://www.example.com/xsd/2006/02/test\">Hello</example:Routing></wsp:All></wsp:Policy>";
        EditorTest.assertEquals((String)EditorTest.normXML(ultimateContent), (String)EditorTest.normXML(editor.xmlEditPage.getDocumentProvider().getDocument((Object)editor.getEditorInput()).get()));
    }

    private TestContextProvider setupContextProvider() {
        HashMap<String, Map<String, String[]>> contextVals = new HashMap<String, Map<String, String[]>>();
        HashMap<Object, String[]> ctxTargetServiceMap = new HashMap<Object, String[]>();
        String[] ctxTargetServiceData = new String[]{"{http://www.example.com/test}TestService1", "{http://www.example.com/test}TestService2", "{http://www.example.com/test2}TestService"};
        ctxTargetServiceMap.put(null, ctxTargetServiceData);
        contextVals.put("target_service", ctxTargetServiceMap);
        HashMap<String, String[]> ctxEndPtMap = new HashMap<String, String[]>();
        String[] ctxEndPtData1 = new String[]{"PortA_1", "PortB_1", "PortC_1"};
        String[] ctxEndPtData2 = new String[]{"PortB_1", "PortB_2"};
        ctxEndPtMap.put("{http://www.example.com/test}TestService1", ctxEndPtData1);
        ctxEndPtMap.put("{http://www.example.com/test}TestService2", ctxEndPtData2);
        contextVals.put("endpoint", ctxEndPtMap);
        HashMap<String, String[]> ctxOperationMap = new HashMap<String, String[]>();
        String[] ctxOperationData1 = new String[]{"greetMe", "sayHi"};
        String[] ctxOperationData2 = new String[]{"greetMe2", "sayHi2", "soLong2"};
        ctxOperationMap.put("{http://www.example.com/test}TestService1", ctxOperationData1);
        ctxOperationMap.put("{http://www.example.com/test}TestService2", ctxOperationData2);
        contextVals.put("operation", ctxOperationMap);
        return new TestContextProvider(contextVals);
    }

    private List<String> getMenuItems(XefEditMasterDetailsBlock block) {
        block.menuManager.removeAll();
        block.fillContextMenu(block.getViewer(), (IMenuManager)block.menuManager);
        LinkedList<String> items = new LinkedList<String>();
        IContributionItem[] iContributionItemArray = block.menuManager.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof ActionContributionItem) {
                items.add(((ActionContributionItem)item).getAction().getText());
            }
            ++n2;
        }
        return items;
    }

    private IAction getMenuItemAction(XefEditMasterDetailsBlock block, String text) {
        block.menuManager.removeAll();
        block.fillContextMenu(block.getViewer(), (IMenuManager)block.menuManager);
        IContributionItem[] iContributionItemArray = block.menuManager.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAction action;
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof ActionContributionItem && (action = ((ActionContributionItem)item).getAction()).getText().equals(text)) {
                return action;
            }
            ++n2;
        }
        return null;
    }

    private TreeItem getTreeItem(Tree t, String label) {
        return this.getTreeItem(t.getItems(), label);
    }

    private TreeItem getTreeItem(TreeItem[] items, String label) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem ti = treeItemArray[n2];
            if (ti.getText().equals(label)) {
                return ti;
            }
            TreeItem s = this.getTreeItem(ti.getItems(), label);
            if (s != null) {
                return s;
            }
            ++n2;
        }
        return null;
    }

    private XMLInstanceElement getElement(Object[] elements, String name) {
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            XMLInstanceElement pie = (XMLInstanceElement)element;
            if (name.equals(pie.getTemplate().getName())) {
                return pie;
            }
            ++n2;
        }
        return null;
    }

    private static String normXML(String s) throws JDOMException, IOException {
        String s2 = EditorTest.stripComment(s);
        String s3 = EditorTest.stripProlog(s2);
        Document d = new SAXBuilder().build((InputStream)new ByteArrayInputStream(s3.getBytes()));
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        return outputter.outputString(d);
    }

    private static String stripComment(String s) {
        return s.replaceAll("<!--(.*?)-->", "");
    }

    private static String stripProlog(String s) {
        return s.replaceAll("<\\?(.*?)\\?>", "");
    }

    private Control reverseGet(Map<Control, Object> map, Object value) {
        for (Map.Entry<Control, Object> entry : map.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return entry.getKey();
        }
        return null;
    }

    private TreeItem findTreeItem(Tree t, XMLInstanceElement xi) {
        return this.findTreeItem(t.getItems(), xi);
    }

    private TreeItem findTreeItem(TreeItem[] items, XMLInstanceElement xi) {
        if (items == null) {
            return null;
        }
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem ti = treeItemArray[n2];
            if (ti.getData() == xi) {
                return ti;
            }
            TreeItem foundInSub = this.findTreeItem(ti.getItems(), xi);
            if (foundInSub != null) {
                return foundInSub;
            }
            ++n2;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TestContextProvider
    implements IContextProvider {
        private Map<String, Map<String, String[]>> retVals;
        private List<String> callVals = new LinkedList<String>();

        TestContextProvider(Map<String, Map<String, String[]>> vals) {
            this.retVals = vals;
        }

        public String[] getValues(String id, String filter) {
            LinkedList<String> values = new LinkedList<String>();
            this.callVals.add(id);
            if (this.retVals.get(id) != null && this.retVals.get(id).get(filter) != null) {
                String[] stringArray = this.retVals.get(id).get(filter);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String str = stringArray[n2];
                    values.add(str);
                    ++n2;
                }
            }
            return values.toArray(new String[0]);
        }

        public Object getData(String id) {
            return null;
        }

        public List<String> getCallVals() {
            return this.callVals;
        }
    }

    private static class XMLFileXMLProvider
    implements IXMLProvider {
        private final IFile file;
        private final String root;

        public XMLFileXMLProvider(IFile f, String rootQName) {
            this.file = f;
            this.root = rootQName;
        }

        public String getRootElementQName() {
            return this.root;
        }

        public String getXML() {
            block6: {
                String string;
                InputStream is = this.file.getContents();
                try {
                    string = new String(InputStreamHelper.drain((InputStream)is));
                }
                catch (Throwable throwable) {
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                        break block6;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                is.close();
                return string;
            }
            return null;
        }

        public void setXML(String xml) {
            try {
                this.file.setContents((InputStream)new ByteArrayInputStream(xml.getBytes()), true, false, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

