/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.ui.xef.editor;

import junit.framework.TestCase;
import org.eclipse.stp.ui.xef.editor.XMLEditDialog;

public class XMLEditDialogTest
extends TestCase {
    public void testSingleRoot() {
        String initial = "<hi/>";
        XMLEditDialog dlg = new XMLEditDialog(null, initial);
        try {
            dlg.setBlockOnOpen(false);
            dlg.open();
            XMLEditDialogTest.assertEquals((String)initial, (String)dlg.xmlTxt.getText());
            String newXML = "<hello name='hi'> <howdy/> </hello>";
            dlg.xmlTxt.setText(newXML);
            XMLEditDialogTest.assertFalse((String)"Precondition failed", (boolean)dlg.getShell().isDisposed());
            dlg.okPressed();
            XMLEditDialogTest.assertTrue((String)"Dialog should be closed", (dlg.getShell() == null || dlg.getShell().isDisposed() ? 1 : 0) != 0);
            XMLEditDialogTest.assertEquals((String)newXML, (String)dlg.getXML());
        }
        finally {
            if (dlg.getShell() != null && !dlg.getShell().isDisposed()) {
                dlg.close();
            }
        }
    }

    public void testMalformedSingleRoot() {
        String initial = "<hi/>";
        XMLEditDialog dlg = new XMLEditDialog(null, initial);
        XMLEditDialog.interactive = false;
        try {
            dlg.setBlockOnOpen(false);
            dlg.open();
            XMLEditDialogTest.assertEquals((String)initial, (String)dlg.xmlTxt.getText());
            String newXML = "<hello name='hi'/> <howdy/>";
            dlg.xmlTxt.setText(newXML);
            XMLEditDialogTest.assertFalse((String)"Precondition failed", (boolean)dlg.getShell().isDisposed());
            dlg.okPressed();
            XMLEditDialogTest.assertFalse((String)"Dialog should not have been closed as the XML is malformed", (boolean)dlg.getShell().isDisposed());
            XMLEditDialogTest.assertNull((Object)dlg.getXML());
        }
        finally {
            if (dlg.getShell() != null && !dlg.getShell().isDisposed()) {
                dlg.close();
            }
            XMLEditDialog.interactive = true;
        }
    }

    public void testMultiRoot() {
        String initial = "<hi/><hi/>";
        XMLEditDialog dlg = new XMLEditDialog(null, initial, "my-root");
        try {
            dlg.setBlockOnOpen(false);
            dlg.open();
            XMLEditDialogTest.assertEquals((String)initial, (String)dlg.xmlTxt.getText());
            String newXML = "<hello name='hi'/> <howdy/>";
            dlg.xmlTxt.setText(newXML);
            XMLEditDialogTest.assertFalse((String)"Precondition failed", (boolean)dlg.getShell().isDisposed());
            dlg.okPressed();
            XMLEditDialogTest.assertTrue((String)"Dialog should be closed", (dlg.getShell() == null || dlg.getShell().isDisposed() ? 1 : 0) != 0);
            XMLEditDialogTest.assertEquals((String)newXML, (String)dlg.getXML());
        }
        finally {
            if (dlg.getShell() != null && !dlg.getShell().isDisposed()) {
                dlg.close();
            }
        }
    }

    public void testMalformedMultiRoot() {
        String initial = "<hi/><hi/>";
        XMLEditDialog dlg = new XMLEditDialog(null, initial, "my-root");
        XMLEditDialog.interactive = false;
        try {
            dlg.setBlockOnOpen(false);
            dlg.open();
            XMLEditDialogTest.assertEquals((String)initial, (String)dlg.xmlTxt.getText());
            String newXML = "<hello name='hi'/> </hello> <howdy/>";
            dlg.xmlTxt.setText(newXML);
            XMLEditDialogTest.assertFalse((String)"Precondition failed", (boolean)dlg.getShell().isDisposed());
            dlg.okPressed();
            XMLEditDialogTest.assertFalse((String)"Dialog should not be closed since the xml was malformed", (boolean)dlg.getShell().isDisposed());
            XMLEditDialogTest.assertNull((Object)dlg.getXML());
        }
        finally {
            if (dlg.getShell() != null && !dlg.getShell().isDisposed()) {
                dlg.close();
            }
            XMLEditDialog.interactive = true;
        }
    }
}

