/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.ui.xef.editor;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.stp.ui.xef.editor.AddElementAction;
import org.eclipse.stp.ui.xef.editor.ControlAccessor;
import org.eclipse.stp.ui.xef.editor.XMLProviderEditorInput;
import org.eclipse.stp.ui.xef.editor.XefDetailsPage;
import org.eclipse.stp.ui.xef.editor.XefEditMasterDetailsBlock;
import org.eclipse.stp.ui.xef.editor.XefEditor;
import org.eclipse.stp.ui.xef.help.XefHelpView;
import org.eclipse.stp.ui.xef.schema.IContextProvider;
import org.eclipse.stp.ui.xef.schema.SchemaAttribute;
import org.eclipse.stp.ui.xef.schema.SchemaElement;
import org.eclipse.stp.ui.xef.schema.SchemaRegistry;
import org.eclipse.stp.xef.ISchemaProvider;
import org.eclipse.stp.xef.IXMLProvider;
import org.eclipse.stp.xef.XMLInstanceElement;
import org.eclipse.stp.xef.util.InputStreamHelper;
import org.eclipse.stp.xef.util.TestProject;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.ide.IDE;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XefDetailsPageTest
extends TestCase {
    private TestProject testProject;

    protected void setUp() throws Exception {
        this.testProject = new TestProject();
    }

    protected void tearDown() throws Exception {
        try {
            this.getPage().closeAllEditors(false);
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
        this.testProject.dispose();
    }

    private IWorkbenchPage getPage() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        return window.getActivePage();
    }

    public void testPolicyAttributes() throws Exception {
        IFile file = this.testProject.getProject().getFile((IPath)new Path("test.policy"));
        file.create((InputStream)new ByteArrayInputStream("<policies/>".getBytes()), true, null);
        URL schemaURL1 = ((Object)((Object)this)).getClass().getClassLoader().getResource("/example_test.xsd");
        SchemaElement se1 = (SchemaElement)SchemaRegistry.getDefault().resolveSchemaFromURL(schemaURL1.toString(), new ISchemaProvider[0]).get(0);
        XMLInstanceElement pi = new XMLInstanceElement(se1);
        HashMap<String, Map<String, String[]>> contextVals = new HashMap<String, Map<String, String[]>>();
        HashMap<Object, String[]> ctxTargetServiceMap = new HashMap<Object, String[]>();
        String[] ctxTargetServiceData = new String[]{"{http://www.example.com/test}TestService1", "{http://www.example.com/test}TestService2", "{http://www.example.com/test2}TestService"};
        ctxTargetServiceMap.put(null, ctxTargetServiceData);
        contextVals.put("target_service", ctxTargetServiceMap);
        HashMap<String, String[]> ctxOperationMap = new HashMap<String, String[]>();
        String[] ctxOperationData1 = new String[]{"greetMe", "sayHi"};
        String[] ctxOperationData2 = new String[]{"greetMe2", "sayHi2"};
        ctxOperationMap.put("{http://www.example.com/test}TestService1", ctxOperationData1);
        ctxOperationMap.put("{http://www.example.com/test}TestService2", ctxOperationData2);
        contextVals.put("operation", ctxOperationMap);
        TestContextProvider ctxProvider = new TestContextProvider(contextVals);
        XefEditor editor = (XefEditor)IDE.openEditor((IWorkbenchPage)this.getPage(), (IEditorInput)new XMLProviderEditorInput("title", file.getProject(), (IXMLProvider)new XMLFileXMLProvider(file, "policies"), null, (IContextProvider)ctxProvider), (String)"org.eclipse.stp.ui.xef.editor.XefEditor");
        XefEditMasterDetailsBlock block = editor.policyEditPage.block;
        block.policies.add(pi);
        block.getViewer().expandAll();
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)pi), true);
        XefDetailsPage detailsPage = (XefDetailsPage)block.getDetailsPart().getCurrentPage();
        XefDetailsPageTest.assertEquals((Object)pi, (Object)detailsPage.element);
        this.testOptionalText(this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("optionalText")));
        this.testRequiredText(this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("requiredText")));
        this.testRequiredTextWithExample(this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("requiredTextWithExample")));
        this.testProhibitedText(detailsPage.values, pi.getTemplate().getAttribute("prohibitedText"));
        this.testDefaultedText(this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("defaultedText")));
        this.testFixedText(this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("fixedText")));
        this.testPatternedText(this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("patternedText")));
        this.testPasswordText(this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("passwordText")));
        this.testPasswordText2(this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("passwordText2")));
        this.testNCNameText(this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("ncnameText")));
        this.testQName(this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("qnameText")));
        this.testOperationName(this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("operationText")));
        this.testEnumText(this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("enumeratedText")));
        this.testEditableEnumText(this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("editableEnumeratedText")));
        this.testDecimalVal(this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("decimalVal")));
        this.testIntegerVal(this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("integerVal")));
        this.testNegativeIntegerVal(this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("negativeIntegerVal")));
        this.testNonNegativeIntegerVal(this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("nonNegativeIntegerVal")));
        this.testPositiveIntegerVal(this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("positiveIntegerVal")));
        this.testNonPositiveIntegerVal(this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("nonPositiveIntegerVal")));
        this.testLongVal(this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("longVal")));
        this.testIntVal(this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("intVal")));
        this.testShortVal(this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("shortVal")));
        this.testByteVal(this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("byteVal")));
        this.testUnsignedLongVal(this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("unsignedLongVal")));
        this.testUnsignedShortVal(this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("unsignedShortVal")));
        this.testUnsignedIntVal(this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("unsignedIntVal")));
        this.testUnsignedByteVal(this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("unsignedByteVal")));
        this.testDefaultBooleanVal(this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("defaultBooleanVal")));
        this.testRequiredBooleanVal(this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("requiredBooleanVal")));
        this.testCheckBooleanVal(this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("checkBooleanVal")));
        this.testMultilineText(this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("checkMultiline")));
        this.testTextContent(this.reverseGet(detailsPage.values, pi.getTemplate()));
        detailsPage.commit(true);
        String sep = this.getLineSeparatorString();
        XefDetailsPageTest.assertEquals((String)XefDetailsPageTest.normXML("<policies><example:Routing xmlns:example='http://www.example.com/xsd/2006/02/test' xmlns:ns1='http://www.example.com/test' byteVal='123' checkMultiline='hi" + sep + "there' " + "decimalVal='-99999' " + "defaultedText='Hello' " + "editableEnumeratedText='custom' " + "enumeratedText='one and a half' " + "intVal='123' " + "integerVal='123' " + "longVal='-99999' " + "ncnameText='a-5' " + "negativeIntegerVal='-99999' " + "nonNegativeIntegerVal='123' " + "nonPositiveIntegerVal='-99999' " + "operationText='sayHi2' " + "optionalText='hi' " + "passwordText='3329' " + "passwordText2='hi' " + "patternedText='abc' " + "positiveIntegerVal='123' " + "qnameText='ns1:TestService2' " + "requiredBooleanVal='false' " + "requiredText='Hello there' " + "requiredTextWithExample='Hi guys' " + "shortVal='123' " + "unsignedByteVal='123' " + "unsignedIntVal='123' " + "unsignedLongVal='-99999' " + "unsignedShortVal='123'>" + "Hola Halo" + "</example:Routing>" + "</policies>"), (String)XefDetailsPageTest.normXML(block.getXML()));
    }

    private String getLineSeparatorString() {
        return System.getProperty("line.separator").replaceAll("\\n", "&#xA;").replaceAll("\\r", "&#xD;");
    }

    private void testOptionalText(Control c) {
        ToolItem b = (ToolItem)c.getData("Default Button");
        Control[] controls = (Control[])c.getData("The actual controls");
        Text actualControl = (Text)controls[0];
        ControlAccessor accessor = (ControlAccessor)c.getData("Control Accessor");
        XefDetailsPageTest.assertTrue((boolean)actualControl.getEnabled());
        Color disabledColor = actualControl.getForeground();
        XefDetailsPageTest.assertEquals((String)"", (String)accessor.getValue());
        XefDetailsPageTest.assertTrue((boolean)b.getSelection());
        b.setSelection(false);
        b.notifyListeners(13, new Event());
        XefDetailsPageTest.assertTrue((boolean)actualControl.getEnabled());
        Color enabledColor = actualControl.getForeground();
        XefDetailsPageTest.assertTrue((String)"The disabled color should be different from the enabled color", (!disabledColor.equals((Object)enabledColor) ? 1 : 0) != 0);
        actualControl.setText("hi");
        XefDetailsPageTest.assertEquals((String)"hi", (String)accessor.getValue());
        XefDetailsPageTest.assertFalse((boolean)b.getSelection());
        b.setSelection(true);
        b.notifyListeners(13, new Event());
        XefDetailsPageTest.assertEquals((Object)disabledColor, (Object)actualControl.getForeground());
        XefDetailsPageTest.assertEquals((String)"", (String)accessor.getValue());
        XefDetailsPageTest.assertEquals((String)"", (String)actualControl.getText());
        actualControl.notifyListeners(3, new Event());
        XefDetailsPageTest.assertEquals((Object)enabledColor, (Object)actualControl.getForeground());
        XefDetailsPageTest.assertEquals((String)"hi", (String)accessor.getValue());
        XefDetailsPageTest.assertEquals((String)"hi", (String)actualControl.getText());
        XefDetailsPageTest.assertEquals((String)"This is the tooltip.", (String)actualControl.getToolTipText());
    }

    private void testRequiredText(Control c) {
        XefDetailsPageTest.assertNull((String)"There should not be a default button here", (Object)c.getData("Default Button"));
        Control[] controls = (Control[])c.getData("The actual controls");
        Text actualControl = (Text)controls[0];
        ControlAccessor accessor = (ControlAccessor)c.getData("Control Accessor");
        XefDetailsPageTest.assertTrue((boolean)actualControl.getEnabled());
        XefDetailsPageTest.assertEquals((String)"", (String)accessor.getValue());
        actualControl.setText("hi");
        XefDetailsPageTest.assertEquals((String)"hi", (String)accessor.getValue());
        accessor.setValue("Hello there");
        XefDetailsPageTest.assertEquals((String)"Hello there", (String)actualControl.getText());
    }

    private void testRequiredTextWithExample(Control c) {
        XefDetailsPageTest.assertNull((String)"There should not be a default button here", (Object)c.getData("Default Button"));
        Control[] controls = (Control[])c.getData("The actual controls");
        Text actualControl = (Text)controls[0];
        ControlAccessor accessor = (ControlAccessor)c.getData("Control Accessor");
        XefDetailsPageTest.assertTrue((boolean)actualControl.getEnabled());
        XefDetailsPageTest.assertEquals((String)"deftext", (String)accessor.getValue());
        actualControl.setText("hi");
        XefDetailsPageTest.assertEquals((String)"hi", (String)accessor.getValue());
        accessor.setValue("Hi guys");
        XefDetailsPageTest.assertEquals((String)"Hi guys", (String)actualControl.getText());
        XefDetailsPageTest.assertEquals((String)"Tool tip", (String)actualControl.getToolTipText());
    }

    private void testProhibitedText(Map<Control, Object> values, SchemaAttribute attribute) {
        XefDetailsPageTest.assertNull((String)"The attribute should not have a dedicated control", (Object)this.reverseGet(values, attribute));
    }

    private void testDefaultedText(Control c) {
        ToolItem b = (ToolItem)c.getData("Default Button");
        Control[] controls = (Control[])c.getData("The actual controls");
        Text actualControl = (Text)controls[0];
        ControlAccessor accessor = (ControlAccessor)c.getData("Control Accessor");
        XefDetailsPageTest.assertEquals((String)"Default should be selected, as no value specified", (boolean)true, (boolean)b.getSelection());
        XefDetailsPageTest.assertTrue((boolean)actualControl.getEnabled());
        XefDetailsPageTest.assertEquals((String)"this is the default", (String)accessor.getValue());
        b.setSelection(false);
        b.notifyListeners(13, new Event());
        XefDetailsPageTest.assertTrue((boolean)actualControl.getEnabled());
        accessor.setValue("Hello");
        XefDetailsPageTest.assertEquals((String)"Hello", (String)actualControl.getText());
        b.setSelection(true);
        b.notifyListeners(13, new Event());
        XefDetailsPageTest.assertTrue((boolean)actualControl.getEnabled());
        XefDetailsPageTest.assertEquals((String)"this is the default", (String)accessor.getValue());
        b.setSelection(false);
        b.notifyListeners(13, new Event());
        XefDetailsPageTest.assertEquals((String)"Hello", (String)actualControl.getText());
        XefDetailsPageTest.assertEquals((String)"The tool tip, yes", (String)actualControl.getToolTipText());
    }

    private void testFixedText(Control c) {
        Control[] controls = (Control[])c.getData("The actual controls");
        Text actualControl = (Text)controls[0];
        ControlAccessor accessor = (ControlAccessor)c.getData("Control Accessor");
        XefDetailsPageTest.assertFalse((boolean)actualControl.getEnabled());
        XefDetailsPageTest.assertEquals((String)"this is fixed", (String)accessor.getValue());
        XefDetailsPageTest.assertNull((Object)c.getData("Default Button"));
    }

    private void testPatternedText(Control c) {
        Control[] controls = (Control[])c.getData("The actual controls");
        Text actualControl = (Text)controls[0];
        ControlAccessor accessor = (ControlAccessor)c.getData("Control Accessor");
        XefDetailsPageTest.assertTrue((boolean)actualControl.getEnabled());
        XefDetailsPageTest.assertEquals((String)"", (String)accessor.getValue());
        actualControl.notifyListeners(3, new Event());
        Event event = new Event();
        event.doit = true;
        event.character = (char)97;
        event.text = "a";
        event.keyCode = 1;
        event.start = actualControl.getText().length();
        event.end = actualControl.getText().length();
        actualControl.notifyListeners(25, event);
        XefDetailsPageTest.assertTrue((boolean)event.doit);
        actualControl.setText("a");
        XefDetailsPageTest.assertEquals((String)"a", (String)actualControl.getText());
        event.character = (char)98;
        event.text = "b";
        event.keyCode = 1;
        event.start = actualControl.getText().length();
        event.end = actualControl.getText().length();
        actualControl.notifyListeners(25, event);
        XefDetailsPageTest.assertTrue((boolean)event.doit);
        actualControl.setText("ab");
        XefDetailsPageTest.assertEquals((String)"ab", (String)actualControl.getText());
        event.character = (char)99;
        event.text = "c";
        event.keyCode = 1;
        event.start = actualControl.getText().length();
        event.end = actualControl.getText().length();
        actualControl.notifyListeners(25, event);
        XefDetailsPageTest.assertTrue((boolean)event.doit);
        actualControl.setText("abc");
        XefDetailsPageTest.assertEquals((String)"abc", (String)actualControl.getText());
        event.character = (char)52;
        event.text = "4";
        event.keyCode = 1;
        event.start = actualControl.getText().length();
        event.end = actualControl.getText().length();
        actualControl.notifyListeners(25, event);
        XefDetailsPageTest.assertFalse((boolean)event.doit);
        XefDetailsPageTest.assertEquals((String)"abc", (String)accessor.getValue());
        XefDetailsPageTest.assertEquals((String)"abc", (String)actualControl.getText());
    }

    private void testPasswordText(Control c) {
        ToolItem b = (ToolItem)c.getData("Default Button");
        Control[] controls = (Control[])c.getData("The actual controls");
        Text actualControl = (Text)controls[0];
        ControlAccessor accessor = (ControlAccessor)c.getData("Control Accessor");
        XefDetailsPageTest.assertTrue((boolean)actualControl.getEnabled());
        Color disabledColor = actualControl.getForeground();
        XefDetailsPageTest.assertEquals((String)"", (String)accessor.getValue());
        XefDetailsPageTest.assertTrue((boolean)b.getSelection());
        b.setSelection(false);
        b.notifyListeners(13, new Event());
        XefDetailsPageTest.assertTrue((boolean)actualControl.getEnabled());
        Color enabledColor = actualControl.getForeground();
        XefDetailsPageTest.assertTrue((String)"The disabled color should be different from the enabled color", (!disabledColor.equals((Object)enabledColor) ? 1 : 0) != 0);
        actualControl.setText("hi");
        XefDetailsPageTest.assertEquals((String)new Integer("hi".hashCode()).toString(), (String)accessor.getValue());
        XefDetailsPageTest.assertFalse((boolean)b.getSelection());
        b.setSelection(true);
        b.notifyListeners(13, new Event());
        XefDetailsPageTest.assertEquals((Object)disabledColor, (Object)actualControl.getForeground());
        XefDetailsPageTest.assertEquals((String)"", (String)accessor.getValue());
        XefDetailsPageTest.assertEquals((String)"", (String)actualControl.getText());
        actualControl.notifyListeners(3, new Event());
        XefDetailsPageTest.assertEquals((Object)enabledColor, (Object)actualControl.getForeground());
        XefDetailsPageTest.assertEquals((String)new Integer("hi".hashCode()).toString(), (String)accessor.getValue());
        XefDetailsPageTest.assertEquals((String)new Integer("hi".hashCode()).toString(), (String)actualControl.getText());
        accessor.setValue("Hello");
        XefDetailsPageTest.assertEquals((String)"Hello", (String)accessor.getValue());
        actualControl.setText("hi");
    }

    private void testPasswordText2(Control c) {
        ToolItem b = (ToolItem)c.getData("Default Button");
        Control[] controls = (Control[])c.getData("The actual controls");
        Text actualControl = (Text)controls[0];
        ControlAccessor accessor = (ControlAccessor)c.getData("Control Accessor");
        XefDetailsPageTest.assertTrue((boolean)actualControl.getEnabled());
        Color disabledColor = actualControl.getForeground();
        XefDetailsPageTest.assertEquals((String)"", (String)accessor.getValue());
        XefDetailsPageTest.assertTrue((boolean)b.getSelection());
        b.setSelection(false);
        b.notifyListeners(13, new Event());
        XefDetailsPageTest.assertTrue((boolean)actualControl.getEnabled());
        Color enabledColor = actualControl.getForeground();
        XefDetailsPageTest.assertTrue((String)"The disabled color should be different from the enabled color", (!disabledColor.equals((Object)enabledColor) ? 1 : 0) != 0);
        actualControl.setText("hi");
        XefDetailsPageTest.assertEquals((String)"hi", (String)accessor.getValue());
        XefDetailsPageTest.assertFalse((boolean)b.getSelection());
        b.setSelection(true);
        b.notifyListeners(13, new Event());
        XefDetailsPageTest.assertEquals((Object)disabledColor, (Object)actualControl.getForeground());
        XefDetailsPageTest.assertEquals((String)"", (String)accessor.getValue());
        XefDetailsPageTest.assertEquals((String)"", (String)actualControl.getText());
        actualControl.notifyListeners(3, new Event());
        XefDetailsPageTest.assertEquals((Object)enabledColor, (Object)actualControl.getForeground());
        XefDetailsPageTest.assertEquals((String)"hi", (String)accessor.getValue());
        XefDetailsPageTest.assertEquals((String)"hi", (String)actualControl.getText());
        accessor.setValue("Hello");
        XefDetailsPageTest.assertEquals((String)"Hello", (String)accessor.getValue());
        actualControl.setText("hi");
    }

    private void testNCNameText(Control c) {
        Control[] controls = (Control[])c.getData("The actual controls");
        Text actualControl = (Text)controls[0];
        ControlAccessor accessor = (ControlAccessor)c.getData("Control Accessor");
        XefDetailsPageTest.assertTrue((boolean)actualControl.getEnabled());
        XefDetailsPageTest.assertEquals((String)"", (String)accessor.getValue());
        actualControl.notifyListeners(3, new Event());
        Event event = new Event();
        event.doit = true;
        event.character = (char)97;
        event.text = "a";
        event.keyCode = 1;
        event.start = actualControl.getText().length();
        event.end = actualControl.getText().length();
        actualControl.notifyListeners(25, event);
        XefDetailsPageTest.assertTrue((boolean)event.doit);
        actualControl.setText("a");
        XefDetailsPageTest.assertEquals((String)"a", (String)actualControl.getText());
        actualControl.setText("");
        event.character = (char)53;
        event.text = "5";
        event.keyCode = 1;
        event.start = actualControl.getText().length();
        event.end = actualControl.getText().length();
        actualControl.notifyListeners(25, event);
        XefDetailsPageTest.assertFalse((boolean)event.doit);
        XefDetailsPageTest.assertEquals((String)"", (String)actualControl.getText());
        event.doit = true;
        event.character = (char)95;
        event.text = "_";
        event.keyCode = 1;
        event.start = actualControl.getText().length();
        event.end = actualControl.getText().length();
        actualControl.notifyListeners(25, event);
        XefDetailsPageTest.assertTrue((boolean)event.doit);
        actualControl.setText("_");
        XefDetailsPageTest.assertEquals((String)"_", (String)actualControl.getText());
        actualControl.setText("");
        event.character = (char)97;
        event.text = "a";
        event.keyCode = 1;
        event.start = actualControl.getText().length();
        event.end = actualControl.getText().length();
        actualControl.notifyListeners(25, event);
        XefDetailsPageTest.assertTrue((boolean)event.doit);
        actualControl.setText("a");
        XefDetailsPageTest.assertEquals((String)"a", (String)actualControl.getText());
        event.character = (char)45;
        event.text = "-";
        event.keyCode = 1;
        event.start = actualControl.getText().length();
        event.end = actualControl.getText().length();
        actualControl.notifyListeners(25, event);
        XefDetailsPageTest.assertTrue((boolean)event.doit);
        actualControl.setText("a-");
        XefDetailsPageTest.assertEquals((String)"a-", (String)actualControl.getText());
        event.character = (char)53;
        event.text = "5";
        event.keyCode = 1;
        event.start = actualControl.getText().length();
        event.end = actualControl.getText().length();
        actualControl.notifyListeners(25, event);
        XefDetailsPageTest.assertTrue((boolean)event.doit);
        actualControl.setText("a-5");
        XefDetailsPageTest.assertEquals((String)"a-5", (String)actualControl.getText());
        event.character = (char)36;
        event.text = "$";
        event.keyCode = 1;
        event.start = actualControl.getText().length();
        event.end = actualControl.getText().length();
        actualControl.notifyListeners(25, event);
        XefDetailsPageTest.assertFalse((boolean)event.doit);
        XefDetailsPageTest.assertEquals((String)"a-5", (String)actualControl.getText());
    }

    private void testQName(Control c) {
        Control[] controls = (Control[])c.getData("The actual controls");
        Combo actualControl = (Combo)controls[0];
        ControlAccessor accessor = (ControlAccessor)c.getData("Control Accessor");
        XefDetailsPageTest.assertTrue((boolean)actualControl.getEnabled());
        XefDetailsPageTest.assertEquals((String)"", (String)accessor.getValue());
        Event event = new Event();
        event.doit = true;
        XefDetailsPageTest.assertEquals((int)3, (int)actualControl.getItemCount());
        XefDetailsPageTest.assertEquals((String)"Should default to an empty value when one is not yet selected", (String)"", (String)accessor.getValue());
        XefDetailsPageTest.assertEquals((String)"", (String)actualControl.getText());
        actualControl.select(0);
        actualControl.notifyListeners(13, new Event());
        XefDetailsPageTest.assertEquals((String)"ns1:TestService1", (String)accessor.getValue());
        XefDetailsPageTest.assertEquals((String)"ns1:TestService1", (String)actualControl.getText());
        XefDetailsPageTest.assertEquals((String)"{http://www.example.com/test}TestService1", (String)actualControl.getToolTipText());
        actualControl.select(1);
        actualControl.notifyListeners(13, new Event());
        XefDetailsPageTest.assertEquals((String)"ns1:TestService2", (String)accessor.getValue());
        XefDetailsPageTest.assertEquals((String)"ns1:TestService2", (String)actualControl.getText());
        XefDetailsPageTest.assertEquals((String)"{http://www.example.com/test}TestService2", (String)actualControl.getToolTipText());
        actualControl.notifyListeners(3, new Event());
        XefDetailsPageTest.assertEquals((String)"ns1:TestService2", (String)actualControl.getText());
        accessor.setValue(actualControl.getText());
    }

    private void testOperationName(Control c) {
        Control[] controls = (Control[])c.getData("The actual controls");
        Combo actualControl = (Combo)controls[0];
        ControlAccessor accessor = (ControlAccessor)c.getData("Control Accessor");
        XefDetailsPageTest.assertTrue((boolean)actualControl.getEnabled());
        XefDetailsPageTest.assertEquals((String)"", (String)accessor.getValue());
        Event event = new Event();
        event.doit = true;
        XefDetailsPageTest.assertEquals((int)2, (int)actualControl.getItemCount());
        XefDetailsPageTest.assertEquals((String)"Should default to an empty value when one is not yet selected", (String)"", (String)accessor.getValue());
        XefDetailsPageTest.assertEquals((String)"", (String)actualControl.getText());
        actualControl.notifyListeners(3, new Event());
        actualControl.select(0);
        actualControl.notifyListeners(13, new Event());
        XefDetailsPageTest.assertEquals((String)"greetMe2", (String)accessor.getValue());
        XefDetailsPageTest.assertEquals((String)"greetMe2", (String)actualControl.getText());
        actualControl.select(1);
        actualControl.notifyListeners(13, new Event());
        XefDetailsPageTest.assertEquals((String)"sayHi2", (String)accessor.getValue());
        XefDetailsPageTest.assertEquals((String)"sayHi2", (String)actualControl.getText());
    }

    private void testEnumText(Control c) {
        ToolItem b = (ToolItem)c.getData("Default Button");
        Control[] controls = (Control[])c.getData("The actual controls");
        Combo actualControl = (Combo)controls[0];
        ControlAccessor accessor = (ControlAccessor)c.getData("Control Accessor");
        XefDetailsPageTest.assertTrue((boolean)actualControl.getEnabled());
        Color disabledColor = actualControl.getForeground();
        XefDetailsPageTest.assertEquals((String)"two", (String)accessor.getValue());
        XefDetailsPageTest.assertEquals((String)"two", (String)actualControl.getText());
        XefDetailsPageTest.assertTrue((boolean)b.getSelection());
        b.setSelection(false);
        b.notifyListeners(13, new Event());
        XefDetailsPageTest.assertTrue((boolean)actualControl.getEnabled());
        Color enabledColor = actualControl.getForeground();
        XefDetailsPageTest.assertTrue((String)"The disabled color should be different from the enabled color", (!disabledColor.equals((Object)enabledColor) ? 1 : 0) != 0);
        XefDetailsPageTest.assertEquals((String)"Should default to the first enum value when one is not yet specified", (String)"one", (String)accessor.getValue());
        XefDetailsPageTest.assertEquals((String)"one", (String)actualControl.getText());
        actualControl.setText("one and a half");
        XefDetailsPageTest.assertEquals((String)"one and a half", (String)accessor.getValue());
        XefDetailsPageTest.assertEquals((String)"one and a half", (String)actualControl.getText());
        XefDetailsPageTest.assertFalse((boolean)b.getSelection());
        b.setSelection(true);
        b.notifyListeners(13, new Event());
        XefDetailsPageTest.assertEquals((Object)disabledColor, (Object)actualControl.getForeground());
        XefDetailsPageTest.assertEquals((String)"two", (String)accessor.getValue());
        XefDetailsPageTest.assertEquals((String)"two", (String)actualControl.getText());
        actualControl.notifyListeners(3, new Event());
        XefDetailsPageTest.assertEquals((Object)enabledColor, (Object)actualControl.getForeground());
        XefDetailsPageTest.assertEquals((String)"one and a half", (String)accessor.getValue());
        XefDetailsPageTest.assertEquals((String)"one and a half", (String)actualControl.getText());
        actualControl.setText("custom");
        XefDetailsPageTest.assertEquals((String)"one and a half", (String)accessor.getValue());
        XefDetailsPageTest.assertEquals((String)"one and a half", (String)actualControl.getText());
        XefDetailsPageTest.assertEquals((String)"Combo tooltip.", (String)actualControl.getToolTipText());
    }

    private void testEditableEnumText(Control c) {
        ToolItem b = (ToolItem)c.getData("Default Button");
        Control[] controls = (Control[])c.getData("The actual controls");
        Combo actualControl = (Combo)controls[0];
        ControlAccessor accessor = (ControlAccessor)c.getData("Control Accessor");
        XefDetailsPageTest.assertTrue((boolean)actualControl.getEnabled());
        Color disabledColor = actualControl.getForeground();
        XefDetailsPageTest.assertEquals((String)"", (String)accessor.getValue());
        XefDetailsPageTest.assertEquals((String)"", (String)actualControl.getText());
        XefDetailsPageTest.assertTrue((boolean)b.getSelection());
        b.setSelection(false);
        b.notifyListeners(13, new Event());
        XefDetailsPageTest.assertTrue((boolean)actualControl.getEnabled());
        Color enabledColor = actualControl.getForeground();
        XefDetailsPageTest.assertTrue((String)"The disabled color should be different from the enabled color", (!disabledColor.equals((Object)enabledColor) ? 1 : 0) != 0);
        XefDetailsPageTest.assertEquals((String)"Should default to the first enum value when one is not yet specified", (String)"first", (String)accessor.getValue());
        XefDetailsPageTest.assertEquals((String)"first", (String)actualControl.getText());
        actualControl.setText("second");
        XefDetailsPageTest.assertEquals((String)"second", (String)accessor.getValue());
        XefDetailsPageTest.assertEquals((String)"second", (String)actualControl.getText());
        XefDetailsPageTest.assertFalse((boolean)b.getSelection());
        b.setSelection(true);
        b.notifyListeners(13, new Event());
        XefDetailsPageTest.assertEquals((Object)disabledColor, (Object)actualControl.getForeground());
        XefDetailsPageTest.assertEquals((String)"", (String)accessor.getValue());
        XefDetailsPageTest.assertEquals((String)"", (String)actualControl.getText());
        actualControl.notifyListeners(3, new Event());
        XefDetailsPageTest.assertEquals((Object)enabledColor, (Object)actualControl.getForeground());
        XefDetailsPageTest.assertEquals((String)"second", (String)accessor.getValue());
        XefDetailsPageTest.assertEquals((String)"second", (String)actualControl.getText());
        actualControl.setText("custom");
        XefDetailsPageTest.assertEquals((String)"custom", (String)accessor.getValue());
        XefDetailsPageTest.assertEquals((String)"custom", (String)actualControl.getText());
        XefDetailsPageTest.assertEquals((String)"Editable Combo tooltip.", (String)actualControl.getToolTipText());
    }

    private void testDecimalVal(Control c) {
        ToolItem b = (ToolItem)c.getData("Default Button");
        Control[] controls = (Control[])c.getData("The actual controls");
        Text actualControl = (Text)controls[0];
        ControlAccessor accessor = (ControlAccessor)c.getData("Control Accessor");
        XefDetailsPageTest.assertTrue((boolean)b.getSelection());
        XefDetailsPageTest.assertTrue((boolean)actualControl.getEnabled());
        XefDetailsPageTest.assertEquals((String)"", (String)accessor.getValue());
        Color disabledColor = actualControl.getForeground();
        actualControl.notifyListeners(3, new Event());
        Color enabledColor = actualControl.getForeground();
        XefDetailsPageTest.assertTrue((String)"Should have different colors for default/non default", (!enabledColor.equals((Object)disabledColor) ? 1 : 0) != 0);
        accessor.setValue("123");
        XefDetailsPageTest.assertEquals((String)"123", (String)actualControl.getText());
        XefDetailsPageTest.assertFalse((String)"The default button should not be selected any more", (boolean)b.getSelection());
        accessor.setValue("-99999");
        XefDetailsPageTest.assertEquals((String)"-99999", (String)actualControl.getText());
    }

    private void testIntegerVal(Control c, int defVal, int min, int max) {
        ToolItem b = (ToolItem)c.getData("Default Button");
        Control[] controls = (Control[])c.getData("The actual controls");
        Spinner actualControl = (Spinner)controls[0];
        ControlAccessor accessor = (ControlAccessor)c.getData("Control Accessor");
        XefDetailsPageTest.assertTrue((boolean)b.getSelection());
        XefDetailsPageTest.assertTrue((boolean)actualControl.getEnabled());
        XefDetailsPageTest.assertEquals((String)("" + defVal), (String)accessor.getValue());
        Color disabledColor = actualControl.getForeground();
        actualControl.notifyListeners(3, new Event());
        Color enabledColor = actualControl.getForeground();
        XefDetailsPageTest.assertTrue((String)"Should have different colors for default/non default", (!enabledColor.equals((Object)disabledColor) ? 1 : 0) != 0);
        XefDetailsPageTest.assertEquals((int)max, (int)actualControl.getMaximum());
        accessor.setValue("123");
        XefDetailsPageTest.assertEquals((int)123, (int)actualControl.getSelection());
        XefDetailsPageTest.assertFalse((String)"The default button should not be selected any more", (boolean)b.getSelection());
    }

    private void testShortVal(Control control) {
        this.testIntegerVal(control, 0, Short.MIN_VALUE, Short.MAX_VALUE);
    }

    private void testIntegerVal(Control control) {
        this.testIntegerVal(control, 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    private void testNegativeIntegerVal(Control control) {
        this.testDecimalVal(control);
    }

    private void testNonNegativeIntegerVal(Control control) {
        this.testIntegerVal(control, 0, 0, Integer.MAX_VALUE);
    }

    private void testPositiveIntegerVal(Control control) {
        this.testIntegerVal(control, 7, 1, Integer.MAX_VALUE);
    }

    private void testNonPositiveIntegerVal(Control control) {
        this.testDecimalVal(control);
    }

    private void testLongVal(Control control) {
        this.testDecimalVal(control);
    }

    private void testIntVal(Control control) {
        this.testIntegerVal(control, 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    private void testByteVal(Control control) {
        this.testIntegerVal(control, 0, -128, 127);
    }

    private void testUnsignedLongVal(Control control) {
        this.testDecimalVal(control);
    }

    private void testUnsignedShortVal(Control control) {
        this.testIntegerVal(control, 0, 0, 65535);
    }

    private void testUnsignedIntVal(Control control) {
        this.testIntegerVal(control, 0, 0, Integer.MAX_VALUE);
    }

    private void testUnsignedByteVal(Control control) {
        this.testIntegerVal(control, 0, 0, 255);
    }

    private void testDefaultBooleanVal(Control c) {
        ToolItem b = (ToolItem)c.getData("Default Button");
        Button trueBtn = (Button)c.getData(Boolean.TRUE.toString());
        Button falseBtn = (Button)c.getData(Boolean.FALSE.toString());
        ControlAccessor accessor = (ControlAccessor)c.getData("Control Accessor");
        XefDetailsPageTest.assertEquals((String)"Default should be selected, as no value specified", (boolean)true, (boolean)b.getSelection());
        XefDetailsPageTest.assertTrue((boolean)trueBtn.getEnabled());
        XefDetailsPageTest.assertTrue((boolean)falseBtn.getEnabled());
        Color disabledColor = trueBtn.getForeground();
        XefDetailsPageTest.assertEquals((Object)disabledColor, (Object)falseBtn.getForeground());
        XefDetailsPageTest.assertEquals((String)"true", (String)accessor.getValue());
        XefDetailsPageTest.assertTrue((boolean)trueBtn.getSelection());
        XefDetailsPageTest.assertFalse((boolean)falseBtn.getSelection());
        b.setSelection(false);
        b.notifyListeners(13, new Event());
        XefDetailsPageTest.assertTrue((boolean)trueBtn.getEnabled());
        XefDetailsPageTest.assertTrue((boolean)falseBtn.getEnabled());
        Color enabledColor = trueBtn.getForeground();
        XefDetailsPageTest.assertEquals((Object)enabledColor, (Object)falseBtn.getForeground());
        XefDetailsPageTest.assertTrue((String)"Should have different colors for default/non default", (!enabledColor.equals((Object)disabledColor) ? 1 : 0) != 0);
        accessor.setValue("false");
        XefDetailsPageTest.assertFalse((boolean)trueBtn.getSelection());
        XefDetailsPageTest.assertTrue((boolean)falseBtn.getSelection());
        b.setSelection(true);
        b.notifyListeners(13, new Event());
        XefDetailsPageTest.assertTrue((boolean)trueBtn.getEnabled());
        XefDetailsPageTest.assertTrue((boolean)falseBtn.getEnabled());
        XefDetailsPageTest.assertEquals((Object)disabledColor, (Object)trueBtn.getForeground());
        XefDetailsPageTest.assertEquals((Object)disabledColor, (Object)falseBtn.getForeground());
        XefDetailsPageTest.assertEquals((String)"true", (String)accessor.getValue());
        XefDetailsPageTest.assertTrue((boolean)trueBtn.getSelection());
        XefDetailsPageTest.assertFalse((boolean)falseBtn.getSelection());
        b.setSelection(false);
        b.notifyListeners(13, new Event());
        accessor.setValue("false");
        XefDetailsPageTest.assertFalse((boolean)trueBtn.getSelection());
        XefDetailsPageTest.assertTrue((boolean)falseBtn.getSelection());
        b.setSelection(true);
        b.notifyListeners(13, new Event());
    }

    private void testRequiredBooleanVal(Control c) {
        XefDetailsPageTest.assertNull((String)"There should not be a default button here", (Object)c.getData("Default Button"));
        Button trueBtn = (Button)c.getData(Boolean.TRUE.toString());
        Button falseBtn = (Button)c.getData(Boolean.FALSE.toString());
        ControlAccessor accessor = (ControlAccessor)c.getData("Control Accessor");
        trueBtn.setSelection(true);
        falseBtn.setSelection(false);
        XefDetailsPageTest.assertEquals((String)"true", (String)accessor.getValue());
        accessor.setValue("false");
        XefDetailsPageTest.assertFalse((boolean)trueBtn.getSelection());
        XefDetailsPageTest.assertTrue((boolean)falseBtn.getSelection());
        XefDetailsPageTest.assertEquals((String)"A boolean with a tooltip", (String)trueBtn.getToolTipText());
        XefDetailsPageTest.assertEquals((String)"A boolean with a tooltip", (String)falseBtn.getToolTipText());
    }

    private void testCheckBooleanVal(Control c) {
        ToolItem b = (ToolItem)c.getData("Default Button");
        Control[] controls = (Control[])c.getData("The actual controls");
        Button check = (Button)controls[0];
        XefDetailsPageTest.assertTrue((String)"Should be a check box button", ((check.getStyle() & 0x20) > 0 ? 1 : 0) != 0);
        ControlAccessor accessor = (ControlAccessor)c.getData("Control Accessor");
        XefDetailsPageTest.assertEquals((String)"Default should be selected, as no value specified", (boolean)true, (boolean)b.getSelection());
        XefDetailsPageTest.assertTrue((boolean)check.getEnabled());
        Color disabledColor = check.getForeground();
        XefDetailsPageTest.assertEquals((String)"false", (String)accessor.getValue());
        XefDetailsPageTest.assertFalse((String)"The checkbox should not be checked as by default the value is false", (boolean)check.getSelection());
        b.setSelection(false);
        b.notifyListeners(13, new Event());
        XefDetailsPageTest.assertTrue((boolean)check.getEnabled());
        Color enabledColor = check.getForeground();
        XefDetailsPageTest.assertTrue((String)"Should have different colors for default/non default", (!enabledColor.equals((Object)disabledColor) ? 1 : 0) != 0);
        accessor.setValue("true");
        XefDetailsPageTest.assertTrue((boolean)check.getSelection());
        b.setSelection(true);
        b.notifyListeners(13, new Event());
        XefDetailsPageTest.assertTrue((boolean)check.getEnabled());
        XefDetailsPageTest.assertEquals((Object)disabledColor, (Object)check.getForeground());
        XefDetailsPageTest.assertEquals((String)"false", (String)accessor.getValue());
        b.setSelection(false);
        b.notifyListeners(13, new Event());
        XefDetailsPageTest.assertEquals((String)"true", (String)accessor.getValue());
        XefDetailsPageTest.assertTrue((boolean)check.getSelection());
        b.setSelection(true);
        b.notifyListeners(13, new Event());
    }

    private void testMultilineText(Control c) {
        ToolItem b = (ToolItem)c.getData("Default Button");
        Control[] controls = (Control[])c.getData("The actual controls");
        Text actualControl = (Text)controls[0];
        XefDetailsPageTest.assertTrue((String)"Should be a multiline text", ((actualControl.getStyle() & 0x302) > 0 ? 1 : 0) != 0);
        ControlAccessor accessor = (ControlAccessor)c.getData("Control Accessor");
        XefDetailsPageTest.assertTrue((boolean)actualControl.getEnabled());
        Color disabledColor = actualControl.getForeground();
        XefDetailsPageTest.assertEquals((String)"", (String)accessor.getValue());
        XefDetailsPageTest.assertTrue((boolean)b.getSelection());
        b.setSelection(false);
        b.notifyListeners(13, new Event());
        XefDetailsPageTest.assertTrue((boolean)actualControl.getEnabled());
        Color enabledColor = actualControl.getForeground();
        XefDetailsPageTest.assertTrue((String)"The disabled color should be different from the enabled color", (!disabledColor.equals((Object)enabledColor) ? 1 : 0) != 0);
        String testStr = "hi" + System.getProperty("line.separator") + "there";
        actualControl.setText(testStr);
        XefDetailsPageTest.assertEquals((String)testStr, (String)accessor.getValue());
        XefDetailsPageTest.assertFalse((boolean)b.getSelection());
        b.setSelection(true);
        b.notifyListeners(13, new Event());
        XefDetailsPageTest.assertEquals((Object)disabledColor, (Object)actualControl.getForeground());
        XefDetailsPageTest.assertEquals((String)"", (String)accessor.getValue());
        XefDetailsPageTest.assertEquals((String)"", (String)actualControl.getText());
        actualControl.notifyListeners(3, new Event());
        XefDetailsPageTest.assertEquals((Object)enabledColor, (Object)actualControl.getForeground());
        XefDetailsPageTest.assertEquals((String)testStr, (String)accessor.getValue());
        XefDetailsPageTest.assertEquals((String)testStr, (String)actualControl.getText());
    }

    private void testTextContent(Control c) {
        XefDetailsPageTest.assertNull((Object)c.getData("Default Button"));
        Control[] controls = (Control[])c.getData("The actual controls");
        Text actualControl = (Text)controls[0];
        ControlAccessor accessor = (ControlAccessor)c.getData("Control Accessor");
        XefDetailsPageTest.assertTrue((boolean)actualControl.getEnabled());
        XefDetailsPageTest.assertEquals((String)"", (String)actualControl.getText());
        XefDetailsPageTest.assertEquals((String)"", (String)accessor.getValue());
        String s = "Huhuhu " + System.getProperty("line.separator") + " Hohoho";
        accessor.setValue(s);
        XefDetailsPageTest.assertEquals((String)s, (String)actualControl.getText());
        String s2 = "Hola Halo";
        actualControl.setText(s2);
        XefDetailsPageTest.assertEquals((String)s2, (String)accessor.getValue());
    }

    public void testLoadSave() throws Exception {
        URL schemaURL1 = ((Object)((Object)this)).getClass().getClassLoader().getResource("/example_test.xsd");
        SchemaRegistry.getDefault().resolveSchemaFromURL(schemaURL1.toString(), new ISchemaProvider[0]);
        IFile file = this.testProject.getProject().getFile((IPath)new Path("test2.policy"));
        String initial = "<policies><example:Routing xmlns:example=\"http://www.example.com/xsd/2006/02/test\" requiredBooleanVal=\"true\" shortVal=\"991199\" enumeratedText=\"one and a half\" requiredText=\"Some Text\">Howdy there</example:Routing></policies>";
        file.create((InputStream)new ByteArrayInputStream(initial.getBytes()), true, null);
        XefEditor editor = (XefEditor)IDE.openEditor((IWorkbenchPage)this.getPage(), (IEditorInput)new XMLProviderEditorInput("title", file.getProject(), (IXMLProvider)new XMLFileXMLProvider(file, "policies"), null, null), (String)"org.eclipse.stp.ui.xef.editor.XefEditor");
        XefEditMasterDetailsBlock block = editor.policyEditPage.block;
        block.getViewer().expandAll();
        block.getViewer().setSelection((ISelection)new StructuredSelection(block.policies.get(0)));
        IStructuredSelection sel = (IStructuredSelection)block.getViewer().getSelection();
        XMLInstanceElement pi = (XMLInstanceElement)sel.getFirstElement();
        XefDetailsPageTest.assertEquals((String)"Routing", (String)pi.getTemplate().getName());
        XefDetailsPageTest.assertEquals((String)"example", (String)pi.getTemplate().getShortNameSpace());
        XefDetailsPageTest.assertEquals((String)"http://www.example.com/xsd/2006/02/test", (String)pi.getTemplate().getNameSpace());
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)pi));
        XefDetailsPage detailsPage = (XefDetailsPage)block.getDetailsPart().getCurrentPage();
        XefDetailsPageTest.assertTrue((boolean)detailsPage.isDirty());
        editor.doSave((IProgressMonitor)new NullProgressMonitor());
        XefDetailsPageTest.assertFalse((boolean)detailsPage.isDirty());
        Control required = this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("requiredBooleanVal"));
        Button trueBtn = (Button)required.getData(Boolean.TRUE.toString());
        Button falseBtn = (Button)required.getData(Boolean.FALSE.toString());
        XefDetailsPageTest.assertTrue((boolean)trueBtn.getSelection());
        XefDetailsPageTest.assertFalse((boolean)falseBtn.getSelection());
        falseBtn.notifyListeners(3, new Event());
        trueBtn.setSelection(false);
        falseBtn.setSelection(true);
        falseBtn.notifyListeners(13, new Event());
        XefDetailsPageTest.assertTrue((boolean)detailsPage.isDirty());
        editor.doSave((IProgressMonitor)new NullProgressMonitor());
        XefDetailsPageTest.assertFalse((boolean)detailsPage.isDirty());
        Spinner integerText = (Spinner)this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("integerVal"));
        integerText.notifyListeners(3, new Event());
        integerText.setSelection(991199);
        integerText.notifyListeners(24, new Event());
        XefDetailsPageTest.assertTrue((boolean)detailsPage.isDirty());
        editor.doSave((IProgressMonitor)new NullProgressMonitor());
        XefDetailsPageTest.assertFalse((boolean)detailsPage.isDirty());
        Combo enumCombo = (Combo)this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("enumeratedText"));
        enumCombo.notifyListeners(3, new Event());
        enumCombo.setText("two");
        XefDetailsPageTest.assertTrue((boolean)detailsPage.isDirty());
        editor.doSave((IProgressMonitor)new NullProgressMonitor());
        XefDetailsPageTest.assertFalse((boolean)detailsPage.isDirty());
        Text defaultedText = (Text)this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("defaultedText"));
        defaultedText.notifyListeners(3, new Event());
        defaultedText.setText("this is the default");
        XefDetailsPageTest.assertTrue((boolean)detailsPage.isDirty());
        editor.doSave((IProgressMonitor)new NullProgressMonitor());
        XefDetailsPageTest.assertFalse((boolean)detailsPage.isDirty());
        Text optionalText = (Text)this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("optionalText"));
        optionalText.notifyListeners(3, new Event());
        optionalText.setText("");
        XefDetailsPageTest.assertTrue((boolean)detailsPage.isDirty());
        editor.doSave((IProgressMonitor)new NullProgressMonitor());
        XefDetailsPageTest.assertFalse((boolean)detailsPage.isDirty());
        Control shortControl = this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("shortVal"));
        ToolItem shortBtn = (ToolItem)shortControl.getData("Default Button");
        shortBtn.setSelection(true);
        shortBtn.notifyListeners(13, new Event());
        XefDetailsPageTest.assertTrue((boolean)detailsPage.isDirty());
        editor.doSave((IProgressMonitor)new NullProgressMonitor());
        XefDetailsPageTest.assertFalse((boolean)detailsPage.isDirty());
        Text valueText = (Text)this.reverseGet(detailsPage.values, pi.getTemplate());
        valueText.notifyListeners(3, new Event());
        valueText.setText("The text value has changed too...");
        XefDetailsPageTest.assertTrue((boolean)detailsPage.isDirty());
        editor.doSave((IProgressMonitor)new NullProgressMonitor());
        XefDetailsPageTest.assertFalse((boolean)detailsPage.isDirty());
        FileInputStream fis = new FileInputStream(file.getLocation().toOSString());
        try {
            String actualFileContents = new String(InputStreamHelper.drain((InputStream)fis));
            String ultimate = "<policies><example:Routing xmlns:example=\"http://www.example.com/xsd/2006/02/test\" requiredBooleanVal=\"false\" integerVal=\"991199\" enumeratedText=\"two\" defaultedText=\"this is the default\" optionalText=\"\" requiredText=\"Some Text\" requiredTextWithExample='deftext'>The text value has changed too...</example:Routing></policies>";
            XefDetailsPageTest.assertEquals((String)XefDetailsPageTest.normXML(ultimate), (String)XefDetailsPageTest.normXML(actualFileContents));
        }
        finally {
            fis.close();
        }
    }

    public void testHelpView() throws Exception {
        if (File.separatorChar == '/') {
            System.out.println("Skipping this test on this platform: " + this.getName());
            return;
        }
        IFile file = this.testProject.getProject().getFile((IPath)new Path("test.policy"));
        file.create((InputStream)new ByteArrayInputStream("<policy/>".getBytes()), true, null);
        SchemaElement se0 = (SchemaElement)SchemaRegistry.getDefault().resolveSchemaFromURL(((Object)((Object)this)).getClass().getClassLoader().getResource("/example_test_reliable.xsd").toString(), new ISchemaProvider[0]).get(0);
        XMLInstanceElement pi0 = new XMLInstanceElement(se0);
        SchemaElement se1 = (SchemaElement)SchemaRegistry.getDefault().resolveSchemaFromURL(((Object)((Object)this)).getClass().getClassLoader().getResource("/example_test.xsd").toString(), new ISchemaProvider[0]).get(0);
        XMLInstanceElement pi1 = new XMLInstanceElement(se1);
        XefEditor editor = (XefEditor)IDE.openEditor((IWorkbenchPage)this.getPage(), (IEditorInput)new XMLProviderEditorInput("title", file.getProject(), (IXMLProvider)new XMLFileXMLProvider(file, "policy"), null, null), (String)"org.eclipse.stp.ui.xef.editor.XefEditor");
        XefEditMasterDetailsBlock block = editor.policyEditPage.block;
        block.asyncUpdate = false;
        block.policies.add(pi0);
        block.policies.add(pi1);
        XefHelpView help = (XefHelpView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.stp.ui.xef.help.XefHelpView");
        block.getViewer().expandAll();
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)pi1));
        XefDetailsPage detailsPage = (XefDetailsPage)block.getDetailsPart().getCurrentPage();
        XefDetailsPageTest.assertEquals((Object)pi1, (Object)detailsPage.element);
        XefDetailsPageTest.assertTrue((boolean)help.getTitle().contains("example:Routing"));
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)pi0));
        XefDetailsPageTest.assertTrue((String)("Expected to contain 'example:Reliable' but was: " + help.getTitle()), (boolean)help.getTitle().contains("example:Reliable"));
        AddElementAction addSub3 = new AddElementAction("sub3", pi1, pi1.getTemplate().getNestedElement("sub3"), block.getViewer(), block);
        addSub3.run();
        XefDetailsPageTest.assertTrue((boolean)help.getTitle().contains("example:Routing/sub3"));
        AddElementAction addSub2 = new AddElementAction("sub2", pi1, pi1.getTemplate().getNestedElement("sub2"), block.getViewer(), block);
        addSub2.run();
        XefDetailsPageTest.assertTrue((String)("Expected to contain 'example:Routing' but was: " + help.getTitle()), (boolean)help.getTitle().contains("example:Routing"));
        XefDetailsPageTest.assertFalse((String)"This item does not have individual help, so do't mention the item", (boolean)help.getTitle().contains("sub2"));
        XefDetailsPageTest.assertFalse((String)"No brackets, since we only show the root guy", (boolean)help.getTitle().contains("("));
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)pi1));
        XefDetailsPageTest.assertTrue((boolean)help.getTitle().contains("example:Routing"));
        XefDetailsPage detailsPage2 = (XefDetailsPage)block.getDetailsPart().getCurrentPage();
        Control rtControl = this.reverseGet(detailsPage2.values, detailsPage2.element.getTemplate().getAttribute("requiredText"));
        Control rtweControl = this.reverseGet(detailsPage2.values, detailsPage2.element.getTemplate().getAttribute("requiredTextWithExample"));
        Text rtweText = (Text)((Control[])rtweControl.getData("The actual controls"))[0];
        rtweText.notifyListeners(15, new Event());
        XefDetailsPageTest.assertTrue((String)"Should be displaying the attribute help", (boolean)help.getTitle().contains("Required text with Example"));
        Text rtText = (Text)((Control[])rtControl.getData("The actual controls"))[0];
        rtText.notifyListeners(15, new Event());
        XefDetailsPageTest.assertTrue((String)"Should now be displaying the element's help", (boolean)help.getTitle().contains("example:Routing"));
        help.dispose();
    }

    public void testPolicyMultiBooleanAttributes() throws Exception {
        IFile file = this.testProject.getProject().getFile((IPath)new Path("test.policy"));
        file.create((InputStream)new ByteArrayInputStream("<policy/>".getBytes()), true, null);
        URL schemaURL1 = ((Object)((Object)this)).getClass().getClassLoader().getResource("/example_test_audit.xsd");
        SchemaElement se1 = (SchemaElement)SchemaRegistry.getDefault().resolveSchemaFromURL(schemaURL1.toString(), new ISchemaProvider[0]).get(0);
        XMLInstanceElement pi = new XMLInstanceElement(se1);
        XefEditor editor = (XefEditor)IDE.openEditor((IWorkbenchPage)this.getPage(), (IEditorInput)new XMLProviderEditorInput("title", file.getProject(), (IXMLProvider)new XMLFileXMLProvider(file, "policy"), null, null), (String)"org.eclipse.stp.ui.xef.editor.XefEditor");
        XefEditMasterDetailsBlock block = editor.policyEditPage.block;
        block.policies.add(pi);
        block.getViewer().expandAll();
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)pi), true);
        XefDetailsPage detailsPage = (XefDetailsPage)block.getDetailsPart().getCurrentPage();
        XefDetailsPageTest.assertEquals((Object)pi, (Object)detailsPage.element);
        Control c = this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("every_client"));
        Control[] controls = (Control[])c.getData("The actual controls");
        Button actualControl = (Button)controls[0];
        XefDetailsPageTest.assertTrue((String)"Should be a checkbox", ((actualControl.getStyle() & 0x20) > 0 ? 1 : 0) != 0);
        Label l = (Label)c.getData("Label");
        XefDetailsPageTest.assertEquals((String)"Every Client:", (String)l.getText());
        c = this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("system_health_sample_interval"));
        l = (Label)c.getData("Units");
        XefDetailsPageTest.assertEquals((String)"(sec)", (String)l.getText());
    }

    public void testAttributeContributions() throws Exception {
        IFile file = this.testProject.getProject().getFile((IPath)new Path("test.policy"));
        file.create((InputStream)new ByteArrayInputStream("<policy/>".getBytes()), true, null);
        URL schemaURL1 = ((Object)((Object)this)).getClass().getClassLoader().getResource("/example_test_contributions.xsd");
        SchemaElement se1 = (SchemaElement)SchemaRegistry.getDefault().resolveSchemaFromURL(schemaURL1.toString(), new ISchemaProvider[0]).get(0);
        XMLInstanceElement pi = new XMLInstanceElement(se1);
        XMLFileXMLProvider xmlProvider = new XMLFileXMLProvider(file, "policy");
        Object[] ctxProviderData = new String[]{"test", "data"};
        HashMap<Object, Object[]> contextVals = new HashMap<Object, Object[]>();
        contextVals.put(null, ctxProviderData);
        HashMap<String, Map<String, String[]>> contextMap = new HashMap<String, Map<String, String[]>>();
        contextMap.put("my_context", contextVals);
        TestContextProvider ctxProvider = new TestContextProvider(contextMap);
        XefEditor editor = (XefEditor)IDE.openEditor((IWorkbenchPage)this.getPage(), (IEditorInput)new XMLProviderEditorInput("title", file.getProject(), (IXMLProvider)xmlProvider, null, (IContextProvider)ctxProvider), (String)"org.eclipse.stp.ui.xef.editor.XefEditor");
        XefEditMasterDetailsBlock block = editor.policyEditPage.block;
        block.policies.add(pi);
        block.getViewer().expandAll();
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)pi), true);
        XefDetailsPage detailsPage = (XefDetailsPage)block.getDetailsPart().getCurrentPage();
        XefDetailsPageTest.assertEquals((Object)pi, (Object)detailsPage.element);
        Control c = this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("attrib1"));
        Control[] controls = (Control[])c.getData("The actual controls");
        XefDetailsPageTest.assertTrue((String)"Should be a Combo box", (boolean)(controls[0] instanceof Combo));
        Combo combo = (Combo)controls[0];
        Object[] items = combo.getItems();
        this.assertArrayEquals(ctxProviderData, items);
        c = this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("attrib2"));
        controls = (Control[])c.getData("The actual controls");
        XefDetailsPageTest.assertTrue((String)"Should be a Text Field", (boolean)(controls[0] instanceof Text));
        List<String> calledCtxVals = ctxProvider.getCallVals();
        XefDetailsPageTest.assertEquals((String)"Wrong call count", (int)2, (int)calledCtxVals.size());
        XefDetailsPageTest.assertEquals((String)"Wrong context", (String)"my_context", (String)calledCtxVals.get(0));
        XefDetailsPageTest.assertEquals((String)"Wrong context", null, (String)calledCtxVals.get(1));
    }

    public void testDetailsPageValidation() throws Exception {
        XefDetailsPage.interactive = false;
        XefEditMasterDetailsBlock.interactive = false;
        try {
            IFile file = this.testProject.getProject().getFile((IPath)new Path("test_val.policy"));
            file.create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
            URL schemaURL = ((Object)((Object)this)).getClass().getClassLoader().getResource("/example_test_logging.xsd");
            SchemaElement se = (SchemaElement)SchemaRegistry.getDefault().resolveSchemaFromURL(schemaURL.toString(), new ISchemaProvider[0]).get(0);
            XMLInstanceElement pi = new XMLInstanceElement(se);
            XefEditor editor = (XefEditor)IDE.openEditor((IWorkbenchPage)this.getPage(), (IEditorInput)new XMLProviderEditorInput("title", file.getProject(), (IXMLProvider)new XMLFileXMLProvider(file, "policy"), null, null), (String)"org.eclipse.stp.ui.xef.editor.XefEditor");
            XefEditMasterDetailsBlock block = editor.policyEditPage.block;
            block.policies.add(pi);
            block.getViewer().expandAll();
            block.getViewer().setSelection((ISelection)new StructuredSelection((Object)pi));
            XefDetailsPage detailsPage = (XefDetailsPage)block.getDetailsPart().getCurrentPage();
            Control c = this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("level"));
            XefDetailsPageTest.assertFalse((String)"Precondition failed", (boolean)c.isFocusControl());
            XefDetailsPageTest.assertFalse((boolean)block.validate());
            ControlAccessor accessor = (ControlAccessor)c.getData("Control Accessor");
            accessor.setValue("Warning");
            detailsPage.commit(true);
            XefDetailsPageTest.assertTrue((boolean)block.validate());
        }
        finally {
            XefDetailsPage.interactive = true;
            XefEditMasterDetailsBlock.interactive = true;
        }
    }

    public void testBlockValidation() throws Exception {
        XefDetailsPage.interactive = false;
        XefEditMasterDetailsBlock.interactive = false;
        try {
            IFile file = this.testProject.getProject().getFile((IPath)new Path("test_val2.policy"));
            file.create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
            URL schemaURL = ((Object)((Object)this)).getClass().getClassLoader().getResource("/example_test_logging.xsd");
            SchemaElement se = (SchemaElement)SchemaRegistry.getDefault().resolveSchemaFromURL(schemaURL.toString(), new ISchemaProvider[0]).get(0);
            XMLInstanceElement pi = new XMLInstanceElement(se);
            XefEditor editor = (XefEditor)IDE.openEditor((IWorkbenchPage)this.getPage(), (IEditorInput)new XMLProviderEditorInput("title", file.getProject(), (IXMLProvider)new XMLFileXMLProvider(file, "policy"), null, null), (String)"org.eclipse.stp.ui.xef.editor.XefEditor");
            XefEditMasterDetailsBlock block = editor.policyEditPage.block;
            block.policies.add(pi);
            XMLInstanceElement spi = null;
            for (SchemaElement subEl : pi.getTemplate().getNestedElements(new LinkedList())) {
                if (!subEl.getName().equals("FileLogger")) continue;
                spi = new XMLInstanceElement(subEl, pi);
                pi.addChild(spi, true);
            }
            block.getViewer().expandAll();
            block.getViewer().setSelection((ISelection)new StructuredSelection((Object)pi));
            XefDetailsPage detailsPage = (XefDetailsPage)block.getDetailsPart().getCurrentPage();
            XefDetailsPageTest.assertFalse((boolean)block.validate());
            Control c = this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("level"));
            ControlAccessor accessor = (ControlAccessor)c.getData("Control Accessor");
            accessor.setValue("Warning");
            detailsPage.commit(true);
            XefDetailsPageTest.assertFalse((String)"Should still not validate as we haven't yet provided the value for the File Name in the FileLogger", (boolean)block.validate());
            XefDetailsPage flDetailsPage = (XefDetailsPage)block.getDetailsPart().getCurrentPage();
            XefDetailsPageTest.assertTrue((String)"Should be looking at a different details page now, as the problem is on another element", (detailsPage != flDetailsPage ? 1 : 0) != 0);
            Control c2 = this.reverseGet(flDetailsPage.values, spi.getTemplate().getAttribute("file"));
            ControlAccessor accessor2 = (ControlAccessor)c2.getData("Control Accessor");
            accessor2.setValue("somefile.log");
            flDetailsPage.commit(true);
            XefDetailsPageTest.assertTrue((boolean)block.validate());
        }
        finally {
            XefDetailsPage.interactive = true;
            XefEditMasterDetailsBlock.interactive = true;
        }
    }

    public void testMultiElementsInBlockValidation() throws Exception {
        XefDetailsPage.interactive = false;
        XefEditMasterDetailsBlock.interactive = false;
        try {
            IFile file = this.testProject.getProject().getFile((IPath)new Path("test_val3.policy"));
            file.create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
            URL logSchemaURL = ((Object)((Object)this)).getClass().getClassLoader().getResource("/example_test_logging.xsd");
            URL relSchemaURL = ((Object)((Object)this)).getClass().getClassLoader().getResource("/example_test_reliable.xsd");
            SchemaElement logSE = (SchemaElement)SchemaRegistry.getDefault().resolveSchemaFromURL(logSchemaURL.toString(), new ISchemaProvider[0]).get(0);
            SchemaElement relSE = (SchemaElement)SchemaRegistry.getDefault().resolveSchemaFromURL(relSchemaURL.toString(), new ISchemaProvider[0]).get(0);
            XMLInstanceElement logPI = new XMLInstanceElement(logSE);
            XMLInstanceElement relPI = new XMLInstanceElement(relSE);
            XefEditor editor = (XefEditor)IDE.openEditor((IWorkbenchPage)this.getPage(), (IEditorInput)new XMLProviderEditorInput("title", file.getProject(), (IXMLProvider)new XMLFileXMLProvider(file, "policy"), null, null), (String)"org.eclipse.stp.ui.xef.editor.XefEditor");
            XefEditMasterDetailsBlock block = editor.policyEditPage.block;
            block.policies.add(logPI);
            block.policies.add(relPI);
            block.getViewer().expandAll();
            block.getViewer().setSelection((ISelection)new StructuredSelection((Object)relPI));
            XefDetailsPage relDetails = (XefDetailsPage)block.getDetailsPart().getCurrentPage();
            XefDetailsPageTest.assertTrue((relDetails.element == relPI ? 1 : 0) != 0);
            XefDetailsPageTest.assertFalse((String)"Should be false since we still have to fill in the severity in the log policy", (boolean)block.validate());
            XefDetailsPage logDetails = (XefDetailsPage)block.getDetailsPart().getCurrentPage();
            XefDetailsPageTest.assertTrue((logDetails != relDetails ? 1 : 0) != 0);
            XefDetailsPageTest.assertTrue((logDetails.element == logPI ? 1 : 0) != 0);
        }
        finally {
            XefDetailsPage.interactive = true;
            XefEditMasterDetailsBlock.interactive = true;
        }
    }

    public void testMultiSection() throws Exception {
        IFile file = this.testProject.getProject().getFile((IPath)new Path("another_test.policy"));
        file.create((InputStream)new ByteArrayInputStream("<policy/>".getBytes()), true, null);
        URL schemaURL1 = ((Object)((Object)this)).getClass().getClassLoader().getResource("/example_test_audit.xsd");
        SchemaElement se1 = (SchemaElement)SchemaRegistry.getDefault().resolveSchemaFromURL(schemaURL1.toString(), new ISchemaProvider[0]).get(0);
        XMLInstanceElement pi = new XMLInstanceElement(se1);
        XefEditor editor = (XefEditor)IDE.openEditor((IWorkbenchPage)this.getPage(), (IEditorInput)new XMLProviderEditorInput("title", file.getProject(), (IXMLProvider)new XMLFileXMLProvider(file, "policy"), null, null), (String)"org.eclipse.stp.ui.xef.editor.XefEditor");
        XefEditMasterDetailsBlock block = editor.policyEditPage.block;
        block.policies.add(pi);
        block.getViewer().expandAll();
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)pi), true);
        XefDetailsPage detailsPage = (XefDetailsPage)block.getDetailsPart().getCurrentPage();
        XefDetailsPageTest.assertEquals((Object)pi, (Object)detailsPage.element);
        Control everyCallControl = this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("every_call"));
        XefDetailsPageTest.assertTrue((String)"The every call variable should be in the main section of the edit portion", (!(everyCallControl.getParent().getParent() instanceof Section) ? 1 : 0) != 0);
        Control systemHealthControl = this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("system_health"));
        XefDetailsPageTest.assertTrue((String)"The system health variable should be in the main section of the edit portion", (!(systemHealthControl.getParent().getParent() instanceof Section) ? 1 : 0) != 0);
        Control sysHealthIntControl = this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("system_health_sample_interval"));
        Section advancedSection = (Section)sysHealthIntControl.getParent().getParent();
        XefDetailsPageTest.assertEquals((String)"Advanced", (String)advancedSection.getText());
        Control rediculousControl = this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("use_hyper_quadratic_functor"));
        Section ridiculousSection = (Section)rediculousControl.getParent().getParent();
        XefDetailsPageTest.assertEquals((String)"Ridiculous", (String)ridiculousSection.getText());
    }

    public void testSequenceOfAnyInPolicy() throws Exception {
        IFile file = this.testProject.getProject().getFile((IPath)new Path("any_test.policy"));
        file.create((InputStream)new ByteArrayInputStream("<policy/>".getBytes()), true, null);
        URL schemaURL1 = ((Object)((Object)this)).getClass().getClassLoader().getResource("/example_test_any.xsd");
        SchemaElement se1 = (SchemaElement)SchemaRegistry.getDefault().resolveSchemaFromURL(schemaURL1.toString(), new ISchemaProvider[0]).get(0);
        XMLInstanceElement pi = new XMLInstanceElement(se1);
        XefEditor editor = (XefEditor)IDE.openEditor((IWorkbenchPage)this.getPage(), (IEditorInput)new XMLProviderEditorInput("title", file.getProject(), (IXMLProvider)new XMLFileXMLProvider(file, "policy"), null, null), (String)"org.eclipse.stp.ui.xef.editor.XefEditor");
        XefEditMasterDetailsBlock block = editor.policyEditPage.block;
        block.policies.add(pi);
        block.getViewer().expandAll();
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)pi), true);
        XefDetailsPage detailsPage = (XefDetailsPage)block.getDetailsPart().getCurrentPage();
        XefDetailsPageTest.assertEquals((Object)pi, (Object)detailsPage.element);
        Text txt = (Text)this.reverseGet(detailsPage.values, pi.getTemplate());
        String xml = "<blah attr='test'><boo/></blah><blah>burp</blah>";
        txt.setText(xml);
        Button check = (Button)this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("every_client"));
        ToolItem defTI = (ToolItem)check.getData("Default Button");
        defTI.setSelection(false);
        defTI.notifyListeners(13, new Event());
        check.setSelection(true);
        check.notifyListeners(13, new Event());
        editor.policyEditPage.getManagedForm().commit(true);
        String targetXML = "<policy><example:any_policy xmlns:example='http://www.example.com/xsd/2006/02/test_any' every_client='true'>" + xml + "</example:any_policy>" + "</policy>";
        String actualXML = editor.policyEditPage.getXML();
        XefDetailsPageTest.assertEquals((String)XefDetailsPageTest.normXML(targetXML), (String)XefDetailsPageTest.normXML(actualXML));
    }

    public void testSequenceOfAnyInPolicyAdditionalAttrs() throws Exception {
        IFile file = this.testProject.getProject().getFile((IPath)new Path("any_test.policy"));
        file.create((InputStream)new ByteArrayInputStream("<policy/>".getBytes()), true, null);
        URL schemaURL1 = ((Object)((Object)this)).getClass().getClassLoader().getResource("/example_test_any.xsd");
        SchemaElement se1 = (SchemaElement)SchemaRegistry.getDefault().resolveSchemaFromURL(schemaURL1.toString(), new ISchemaProvider[0]).get(0);
        XMLInstanceElement pi = new XMLInstanceElement(se1);
        XefHelpView help = (XefHelpView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.stp.ui.xef.help.XefHelpView");
        XefEditor editor = (XefEditor)IDE.openEditor((IWorkbenchPage)this.getPage(), (IEditorInput)new XMLProviderEditorInput("title", file.getProject(), (IXMLProvider)new XMLFileXMLProvider(file, "policy"), null, null), (String)"org.eclipse.stp.ui.xef.editor.XefEditor");
        XefEditMasterDetailsBlock block = editor.policyEditPage.block;
        block.policies.add(pi);
        block.getViewer().expandAll();
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)pi), true);
        XefDetailsPage detailsPage = (XefDetailsPage)block.getDetailsPart().getCurrentPage();
        XefDetailsPageTest.assertEquals((Object)pi, (Object)detailsPage.element);
        Text txt = (Text)this.reverseGet(detailsPage.values, pi.getTemplate());
        txt.setFocus();
        txt.notifyListeners(15, new Event());
        XefDetailsPageTest.assertEquals((String)"Any Embedded Content:", (String)((Label)txt.getData("Label")).getText());
        XefDetailsPageTest.assertEquals((String)"Enter Embedded XML", (String)((Label)txt.getData("Label")).getToolTipText());
        XefDetailsPageTest.assertEquals((String)"Enter Embedded XML", (String)txt.getToolTipText());
        XefDetailsPageTest.assertEquals((String)"Please enter some embedded XML.", (String)help.getText());
        help.dispose();
    }

    public void testSequenceOfAnyInitializeEmbeddedXML() throws Exception {
        URL schemaURL = ((Object)((Object)this)).getClass().getClassLoader().getResource("/example_test_any.xsd");
        SchemaRegistry.getDefault().resolveSchemaFromURL(schemaURL.toString(), new ISchemaProvider[0]);
        IFile file = this.testProject.getProject().getFile((IPath)new Path("testAny2.policy"));
        String xml = "<blah attr='test'><boo/></blah><blah>burp</blah>";
        String initial = "<policy><example:any_policy xmlns:example='http://www.example.com/xsd/2006/02/test_any' every_client='true'>" + xml + "</example:any_policy>" + "</policy>";
        file.create((InputStream)new ByteArrayInputStream(initial.getBytes()), true, null);
        XefEditor editor = (XefEditor)IDE.openEditor((IWorkbenchPage)this.getPage(), (IEditorInput)new XMLProviderEditorInput("title", file.getProject(), (IXMLProvider)new XMLFileXMLProvider(file, "policy"), null, null), (String)"org.eclipse.stp.ui.xef.editor.XefEditor");
        XefEditMasterDetailsBlock block = editor.policyEditPage.block;
        block.getViewer().expandAll();
        block.getViewer().setSelection((ISelection)new StructuredSelection(block.policies.get(0)));
        IStructuredSelection sel = (IStructuredSelection)block.getViewer().getSelection();
        XMLInstanceElement pi = (XMLInstanceElement)sel.getFirstElement();
        XefDetailsPageTest.assertEquals((String)"any_policy", (String)pi.getTemplate().getName());
        block.getViewer().setSelection((ISelection)new StructuredSelection((Object)pi));
        XefDetailsPage detailsPage = (XefDetailsPage)block.getDetailsPart().getCurrentPage();
        XefDetailsPageTest.assertFalse((String)"No changes made yet", (boolean)detailsPage.isDirty());
        Text txt = (Text)this.reverseGet(detailsPage.values, pi.getTemplate());
        String text = txt.getText();
        String expectedText = "<blah attr=\"test\">" + System.getProperty("line.separator") + "  <boo />" + System.getProperty("line.separator") + "</blah>" + System.getProperty("line.separator") + "<blah>burp</blah>";
        Button check = (Button)this.reverseGet(detailsPage.values, pi.getTemplate().getAttribute("every_client"));
        XefDetailsPageTest.assertTrue((boolean)check.getSelection());
        XefDetailsPageTest.assertEquals((String)expectedText.trim(), (String)text.trim());
    }

    public void testSequenceOfAnyMalformattedEmbeddedXML() throws Exception {
        XefDetailsPage.interactive = false;
        try {
            IFile file = this.testProject.getProject().getFile((IPath)new Path("any_test.policy"));
            file.create((InputStream)new ByteArrayInputStream("<policy/>".getBytes()), true, null);
            URL schemaURL1 = ((Object)((Object)this)).getClass().getClassLoader().getResource("/example_test_any.xsd");
            SchemaElement se1 = (SchemaElement)SchemaRegistry.getDefault().resolveSchemaFromURL(schemaURL1.toString(), new ISchemaProvider[0]).get(0);
            XMLInstanceElement pi = new XMLInstanceElement(se1);
            XefEditor editor = (XefEditor)IDE.openEditor((IWorkbenchPage)this.getPage(), (IEditorInput)new XMLProviderEditorInput("title", file.getProject(), (IXMLProvider)new XMLFileXMLProvider(file, "policy"), null, null), (String)"org.eclipse.stp.ui.xef.editor.XefEditor");
            XefEditMasterDetailsBlock block = editor.policyEditPage.block;
            block.policies.add(pi);
            block.getViewer().expandAll();
            block.getViewer().setSelection((ISelection)new StructuredSelection((Object)pi), true);
            XefDetailsPage detailsPage = (XefDetailsPage)block.getDetailsPart().getCurrentPage();
            XefDetailsPageTest.assertEquals((Object)pi, (Object)detailsPage.element);
            XefDetailsPageTest.assertTrue((String)"Precondition failed", (boolean)block.validate());
            Text txt = (Text)this.reverseGet(detailsPage.values, pi.getTemplate());
            txt.setText("<hi>some malformatted XML</ho>");
            XefDetailsPageTest.assertFalse((String)"The malformatted XML should fail the validation", (boolean)block.validate());
            txt.setText("<haha/><hoho/>");
            XefDetailsPageTest.assertTrue((String)"The well formatted XML should be accepted, even multiple roots should be ok.", (boolean)block.validate());
        }
        finally {
            XefDetailsPage.interactive = true;
        }
    }

    private static String normXML(String s) throws JDOMException, IOException {
        String s2 = XefDetailsPageTest.stripComment(s);
        String s3 = XefDetailsPageTest.stripProlog(s2);
        Document d = new SAXBuilder().build((InputStream)new ByteArrayInputStream(s3.getBytes()));
        XefDetailsPageTest.sortAttributes(d.getRootElement());
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        return outputter.outputString(d);
    }

    private static void sortAttributes(Element element) {
        TreeMap<String, Attribute> m = new TreeMap<String, Attribute>();
        ArrayList copy = new ArrayList(element.getAttributes());
        for (Attribute attr : copy) {
            m.put(attr.getName(), (Attribute)attr.clone());
            element.removeAttribute(attr);
        }
        for (Attribute attr : m.values()) {
            element.setAttribute(attr);
        }
        for (Element child : element.getChildren()) {
            XefDetailsPageTest.sortAttributes(child);
        }
    }

    private static String stripComment(String s) {
        return s.replaceAll("<!--(.*?)-->", "");
    }

    private static String stripProlog(String s) {
        return s.replaceAll("<\\?(.*?)\\?>", "");
    }

    private void assertArrayEquals(Object[] o1, Object[] o2) {
        XefDetailsPageTest.assertEquals((String)"Arrays not equal length", (int)o1.length, (int)o2.length);
        int i = 0;
        while (i < o1.length) {
            XefDetailsPageTest.assertEquals((String)("Element " + i + " not equal"), (Object)o1[i], (Object)o2[i]);
            ++i;
        }
    }

    private Control reverseGet(Map<Control, Object> map, Object value) {
        for (Map.Entry<Control, Object> entry : map.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return entry.getKey();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TestContextProvider
    implements IContextProvider {
        private Map<String, Map<String, String[]>> retVals;
        private List<String> callVals = new LinkedList<String>();

        TestContextProvider(Map<String, Map<String, String[]>> vals) {
            this.retVals = vals;
        }

        public String[] getValues(String id, String filter) {
            this.callVals.add(id);
            if (this.retVals.get(id) != null) {
                LinkedList<String> values = new LinkedList<String>();
                if (this.retVals.get(id).get(filter) != null) {
                    String[] stringArray = this.retVals.get(id).get(filter);
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String str = stringArray[n2];
                        values.add(str);
                        ++n2;
                    }
                }
                return values.toArray(new String[0]);
            }
            return null;
        }

        public Object getData(String id) {
            return null;
        }

        public List<String> getCallVals() {
            return this.callVals;
        }
    }

    private static class XMLFileXMLProvider
    implements IXMLProvider {
        private final IFile file;
        private final String root;

        public XMLFileXMLProvider(IFile f, String rootQName) {
            this.file = f;
            this.root = rootQName;
        }

        public String getRootElementQName() {
            return this.root;
        }

        public String getXML() {
            block6: {
                String string;
                InputStream is = this.file.getContents();
                try {
                    string = new String(InputStreamHelper.drain((InputStream)is));
                }
                catch (Throwable throwable) {
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                        break block6;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                is.close();
                return string;
            }
            return null;
        }

        public void setXML(String xml) {
            try {
                this.file.setContents((InputStream)new ByteArrayInputStream(xml.getBytes()), true, false, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

