/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.xef;

import java.util.Arrays;
import junit.framework.TestCase;
import org.eclipse.stp.xef.IXMLProvider;
import org.eclipse.stp.xef.MultiXMLProvider;
import org.eclipse.stp.xef.XMLUtil;

public class MultiXMLProviderTest
extends TestCase {
    private static final String PR1_XML = "<root><el1/><el2/><el2/><el3/><el3/><el3/><el4/></root>";
    private static final String PR2_XML = "<root><el1/><el2/><el2/><el3/><el3/></root>";
    private static final String PR3_XML = "<root><el1/><el3/><el3/><el3/><el4/><el4/><el5/></root>";
    private static final String PR4_XML = "<roott><el1/><el2/><el2/><el3/><el3/></roott>";
    private static final String PR5_XML = "<root><el1>Content1</el1><el1>Content2</el1><el1>Content3</el1></root>";
    private static final String PR6_XML = "<root><el>Content1</el><el1>Content2</el1><el1>Content4</el1></root>";
    private static final String PR7_XML = "<root><el attr=\"foo\"/><el name=\"bar\"/><el attr=\"foo\" name=\"bar\"/><elx><ely a='b' b='c'>Content!!!</ely></elx></root>";
    private static final String PR8_XML = "<root><el name=\"bar\"/><el name=\"bar\" attr=\"foo\"/><elx><ely b=\"c\"         a='b' >Content!!!</ely></elx></root>";
    private static final String PR9_XML = "<root><el1><sub1>Content1</sub1></el1><el1><sub0/><sub1><sub11>Content2</sub11></sub1></el1><el1><sub/><sub/><sub/></el1></root>";
    private static final String PR10_XML = "<root><el1><sub1><sub11>Content2</sub11></sub1></el1><el1><sub/><sub/><sub/></el1></root>";
    private static final String PR11_XML = "<root><el attr=\"foo\">blah</el></root>";
    private static final String PR12_XML = "<root><el attr=\"foo\">booh</el></root>";
    private static final String PR13_XML = "<root><nsx:el xmlns:nsx=\"http://hihaho\"/><ns1:el xmlns:ns1=\"http://hahaha\" attr=\"foo\">booh</ns1:el></root>";
    private static final String PR14_XML = "<root><ns1:el xmlns:ns1=\"http://hahaha\" attr=\"foo\">booh</ns1:el><nsx:el2 xmlns:nsx=\"http://hihaho\"/></root>";
    private static final String PR15_XML = "<r:root xmlns:r='http://so_and_so'><e:el xmlns:e='http://eeeee'>blah</e:el></r:root>";
    private static final String PR16_XML = "<r:root xmlns:r='http://so_and_so' xmlns:e='http://eeeee'><e:el>blah</e:el></r:root>";
    private TestXMLProvider provider1;
    private TestXMLProvider provider2;
    private TestXMLProvider provider3;
    private TestXMLProvider provider4;
    private TestXMLProvider provider5;
    private TestXMLProvider provider6;
    private TestXMLProvider provider7;
    private TestXMLProvider provider8;
    private TestXMLProvider provider9;
    private TestXMLProvider provider10;
    private TestXMLProvider provider11;
    private TestXMLProvider provider12;
    private TestXMLProvider provider13;
    private TestXMLProvider provider14;
    private TestXMLProvider provider15;
    private TestXMLProvider provider16;

    protected void setUp() throws Exception {
        this.provider1 = new TestXMLProvider(PR1_XML);
        this.provider2 = new TestXMLProvider(PR2_XML);
        this.provider3 = new TestXMLProvider(PR3_XML);
        this.provider4 = new TestXMLProvider(PR4_XML);
        this.provider5 = new TestXMLProvider(PR5_XML);
        this.provider6 = new TestXMLProvider(PR6_XML);
        this.provider7 = new TestXMLProvider(PR7_XML);
        this.provider8 = new TestXMLProvider(PR8_XML);
        this.provider9 = new TestXMLProvider(PR9_XML);
        this.provider10 = new TestXMLProvider(PR10_XML);
        this.provider11 = new TestXMLProvider(PR11_XML);
        this.provider12 = new TestXMLProvider(PR12_XML);
        this.provider13 = new TestXMLProvider(PR13_XML);
        this.provider14 = new TestXMLProvider(PR14_XML);
        this.provider15 = new TestXMLProvider(PR15_XML);
        this.provider16 = new TestXMLProvider(PR16_XML);
    }

    public void testSingleXMLProvider() throws Exception {
        MultiXMLProvider provider = new MultiXMLProvider(Arrays.asList(this.provider1));
        MultiXMLProviderTest.assertEquals((String)XMLUtil.normalizeXML((String)PR1_XML), (String)XMLUtil.normalizeXML((String)provider.getXML()));
        String setXML = "<root><el99/></root>";
        provider.setXML(setXML);
        MultiXMLProviderTest.assertEquals((String)XMLUtil.normalizeXML((String)setXML), (String)XMLUtil.normalizeXML((String)this.provider1.getXML()));
    }

    public void testTwoProviders1() throws Exception {
        MultiXMLProvider provider = new MultiXMLProvider(Arrays.asList(this.provider1, this.provider2));
        this.testTwoProviders((IXMLProvider)provider);
    }

    public void testTwoProviders2() throws Exception {
        MultiXMLProvider provider = new MultiXMLProvider(Arrays.asList(this.provider2, this.provider1));
        this.testTwoProviders((IXMLProvider)provider);
    }

    private void testTwoProviders(IXMLProvider provider) throws Exception {
        MultiXMLProviderTest.assertEquals((String)"Should receive the Provider2 XML, since that is actually the intersection of the two", (String)XMLUtil.normalizeXML((String)PR2_XML), (String)XMLUtil.normalizeXML((String)provider.getXML()));
        String setXML = "<root><el1/><el1/><el3/></root>";
        provider.setXML(setXML);
        MultiXMLProviderTest.assertEquals((String)XMLUtil.normalizeXML((String)setXML), (String)XMLUtil.normalizeXML((String)this.provider2.getXML()));
        String pr1XML = "<root><el1/><el1/><el3/><el3/><el4/></root>";
        MultiXMLProviderTest.assertEquals((String)XMLUtil.normalizeXML((String)pr1XML), (String)XMLUtil.normalizeXML((String)this.provider1.getXML()));
    }

    public void testThreeProviders1() throws Exception {
        MultiXMLProvider provider = new MultiXMLProvider(Arrays.asList(this.provider1, this.provider2, this.provider3));
        this.testThreeProviders((IXMLProvider)provider);
    }

    public void testThreeProviders2() throws Exception {
        MultiXMLProvider provider = new MultiXMLProvider(Arrays.asList(this.provider2, this.provider1, this.provider3));
        this.testThreeProviders((IXMLProvider)provider);
    }

    public void testThreeProviders3() throws Exception {
        MultiXMLProvider provider = new MultiXMLProvider(Arrays.asList(this.provider3, this.provider2, this.provider1));
        this.testThreeProviders((IXMLProvider)provider);
    }

    private void testThreeProviders(IXMLProvider provider) throws Exception {
        String intersection = "<root><el1/><el3/><el3/></root>";
        MultiXMLProviderTest.assertEquals((String)XMLUtil.normalizeXML((String)intersection), (String)XMLUtil.normalizeXML((String)provider.getXML()));
        String setXML = "<root><el1/><el4/><el6/></root>";
        provider.setXML(setXML);
        String pr1XML = "<root><el1/><el2/><el2/><el3/><el4/><el4/><el6/></root>";
        MultiXMLProviderTest.assertEquals((String)XMLUtil.normalizeXML((String)pr1XML), (String)XMLUtil.normalizeXML((String)this.provider1.getXML()));
        String pr2XML = "<root><el1/><el2/><el2/><el4/><el6/></root>";
        MultiXMLProviderTest.assertEquals((String)XMLUtil.normalizeXML((String)pr2XML), (String)XMLUtil.normalizeXML((String)this.provider2.getXML()));
        String pr3XML = "<root><el1/><el3/><el4/><el4/><el4/><el5/><el6/></root>";
        MultiXMLProviderTest.assertEquals((String)XMLUtil.normalizeXML((String)pr3XML), (String)XMLUtil.normalizeXML((String)this.provider3.getXML()));
    }

    public void testVaryingRoots1() throws Exception {
        MultiXMLProvider provider = new MultiXMLProvider(Arrays.asList(this.provider2, this.provider4));
        MultiXMLProviderTest.assertEquals((String)"Should receive nothing, as the intersection is empty when the roots are different", (String)"", (String)provider.getXML());
    }

    public void testVaryingRoots2() throws Exception {
        MultiXMLProvider provider = new MultiXMLProvider(Arrays.asList(this.provider4, this.provider2));
        MultiXMLProviderTest.assertEquals((String)"Should receive nothing, as the intersection is empty when the roots are different", (String)"", (String)provider.getXML());
    }

    public void testTagContent1() throws Exception {
        MultiXMLProvider provider = new MultiXMLProvider(Arrays.asList(this.provider5, this.provider6));
        this.testTagContent((IXMLProvider)provider);
    }

    public void testTagContent2() throws Exception {
        MultiXMLProvider provider = new MultiXMLProvider(Arrays.asList(this.provider6, this.provider5));
        this.testTagContent((IXMLProvider)provider);
    }

    private void testTagContent(IXMLProvider provider) throws Exception {
        String intersection = "<root><el1>Content2</el1></root>";
        MultiXMLProviderTest.assertEquals((String)XMLUtil.normalizeXML((String)intersection), (String)XMLUtil.normalizeXML((String)provider.getXML()));
        String setXML = "<root><el0>Content0</el0><el1>Content2</el1><el1>Content2</el1><el5>Content5</el5></root>";
        provider.setXML(setXML);
        String pr5XML = "<root><el0>Content0</el0><el1>Content1</el1><el1>Content3</el1><el1>Content2</el1><el1>Content2</el1><el5>Content5</el5></root>";
        MultiXMLProviderTest.assertEquals((String)XMLUtil.normalizeXML((String)pr5XML), (String)XMLUtil.normalizeXML((String)this.provider5.getXML()));
        String pr6XML = "<root><el>Content1</el><el0>Content0</el0><el1>Content4</el1><el1>Content2</el1><el1>Content2</el1><el5>Content5</el5></root>";
        MultiXMLProviderTest.assertEquals((String)XMLUtil.normalizeXML((String)pr6XML), (String)XMLUtil.normalizeXML((String)this.provider6.getXML()));
    }

    public void testSubTagContent1() throws Exception {
        MultiXMLProvider provider = new MultiXMLProvider(Arrays.asList(this.provider9, this.provider10));
        this.testSubTagContent((IXMLProvider)provider);
    }

    public void testSubTagContent2() throws Exception {
        MultiXMLProvider provider = new MultiXMLProvider(Arrays.asList(this.provider10, this.provider9));
        this.testSubTagContent((IXMLProvider)provider);
    }

    private void testSubTagContent(IXMLProvider provider) throws Exception {
        String intersection = "<root><el1><sub/><sub/><sub/></el1></root>";
        MultiXMLProviderTest.assertEquals((String)XMLUtil.normalizeXML((String)intersection), (String)XMLUtil.normalizeXML((String)provider.getXML()));
        String setXML = "<root><el1><sub/><sub/><sub/></el1><el1><sub/><sub/><sub/></el1><el1><sub><sub2/></sub></el1></root>";
        provider.setXML(setXML);
        String pr9XML = "<root><el1><sub1>Content1</sub1></el1><el1><sub0/><sub1><sub11>Content2</sub11></sub1></el1><el1><sub/><sub/><sub/></el1><el1><sub/><sub/><sub/></el1><el1><sub><sub2/></sub></el1></root>";
        MultiXMLProviderTest.assertEquals((String)XMLUtil.normalizeXML((String)pr9XML), (String)XMLUtil.normalizeXML((String)this.provider9.getXML()));
        String pr10XML = "<root><el1><sub1><sub11>Content2</sub11></sub1></el1><el1><sub/><sub/><sub/></el1><el1><sub/><sub/><sub/></el1><el1><sub><sub2/></sub></el1></root>";
        MultiXMLProviderTest.assertEquals((String)XMLUtil.normalizeXML((String)pr10XML), (String)XMLUtil.normalizeXML((String)this.provider10.getXML()));
    }

    public void testAttributes1() throws Exception {
        MultiXMLProvider provider = new MultiXMLProvider(Arrays.asList(this.provider7, this.provider8));
        this.testAttributes((IXMLProvider)provider);
    }

    public void testAttributes2() throws Exception {
        MultiXMLProvider provider = new MultiXMLProvider(Arrays.asList(this.provider8, this.provider7));
        this.testAttributes((IXMLProvider)provider);
    }

    private void testAttributes(IXMLProvider provider) throws Exception {
        String intersection = "<root><el name=\"bar\"/><el attr=\"foo\" name=\"bar\"/><elx><ely a=\"b\" b=\"c\">Content!!!</ely></elx></root>";
        MultiXMLProviderTest.assertEquals((String)XMLUtil.normalizeXML((String)intersection), (String)XMLUtil.normalizeXML((String)provider.getXML()));
        String setXML = "<root><el attr=\"foo\" name=\"bare\"/><el2 name=\"bar\"><sub/>Data</el2><elx x='y'><ely a=\"b\" b=\"c\">Content2!</ely></elx></root>";
        provider.setXML(setXML);
        String pr7XML = "<root><el attr=\"foo\"/><el attr=\"foo\" name=\"bare\"/><el2 name=\"bar\"><sub/>Data</el2><elx x='y'><ely a=\"b\" b=\"c\">Content2!</ely></elx></root>";
        MultiXMLProviderTest.assertEquals((String)XMLUtil.normalizeXML((String)pr7XML), (String)XMLUtil.normalizeXML((String)this.provider7.getXML()));
        MultiXMLProviderTest.assertEquals((String)XMLUtil.normalizeXML((String)setXML), (String)XMLUtil.normalizeXML((String)this.provider8.getXML()));
    }

    public void testSameAttributesWithDifferentContent1() throws Exception {
        MultiXMLProvider provider = new MultiXMLProvider(Arrays.asList(this.provider11, this.provider12));
        this.testSameAttributesWithDifferentContent((IXMLProvider)provider);
    }

    public void testSameAttributesWithDifferentContent2() throws Exception {
        MultiXMLProvider provider = new MultiXMLProvider(Arrays.asList(this.provider12, this.provider11));
        this.testSameAttributesWithDifferentContent((IXMLProvider)provider);
    }

    private void testSameAttributesWithDifferentContent(IXMLProvider provider) throws Exception {
        String intersection = "<root/>";
        MultiXMLProviderTest.assertEquals((String)XMLUtil.normalizeXML((String)intersection), (String)XMLUtil.normalizeXML((String)provider.getXML()));
        String setXML = "<root><el attr=\"foo\">new!</el></root>";
        provider.setXML(setXML);
        String pr11XML = "<root><el attr=\"foo\">blah</el><el attr=\"foo\">new!</el></root>";
        MultiXMLProviderTest.assertEquals((String)XMLUtil.normalizeXML((String)pr11XML), (String)XMLUtil.normalizeXML((String)this.provider11.getXML()));
        String pr12XML = "<root><el attr=\"foo\">booh</el><el attr=\"foo\">new!</el></root>";
        MultiXMLProviderTest.assertEquals((String)XMLUtil.normalizeXML((String)pr12XML), (String)XMLUtil.normalizeXML((String)this.provider12.getXML()));
    }

    public void testVaryingLocalNamespaces1() throws Exception {
        MultiXMLProvider provider = new MultiXMLProvider(Arrays.asList(this.provider13, this.provider14));
        this.testVaryingLocalNamespaces((IXMLProvider)provider);
    }

    public void testVaryingLocalNamespaces2() throws Exception {
        MultiXMLProvider provider = new MultiXMLProvider(Arrays.asList(this.provider14, this.provider13));
        this.testVaryingLocalNamespaces((IXMLProvider)provider);
    }

    private void testVaryingLocalNamespaces(IXMLProvider provider) throws Exception {
        String intersection = "<root><ns1:el xmlns:ns1=\"http://hahaha\" attr=\"foo\">booh</ns1:el></root>";
        MultiXMLProviderTest.assertEquals((String)XMLUtil.normalizeXML((String)intersection), (String)XMLUtil.normalizeXML((String)provider.getXML()));
        String setXML = "<root><ans:el xmlns:ans=\"http://huhhuh\">hello</ans:el><ns1:el xmlns:ns1=\"http://hahaha\" attr=\"foo\">booh</ns1:el></root>";
        provider.setXML(setXML);
        String pr13XML = "<root><nsx:el xmlns:nsx=\"http://hihaho\"/><ans:el xmlns:ans=\"http://huhhuh\">hello</ans:el><ns1:el xmlns:ns1=\"http://hahaha\" attr=\"foo\">booh</ns1:el></root>";
        String pr14XML = "<root><ans:el xmlns:ans=\"http://huhhuh\">hello</ans:el><ns1:el xmlns:ns1=\"http://hahaha\" attr=\"foo\">booh</ns1:el><nsx:el2 xmlns:nsx=\"http://hihaho\"/></root>";
        MultiXMLProviderTest.assertEquals((String)XMLUtil.normalizeXML((String)pr13XML), (String)XMLUtil.normalizeXML((String)this.provider13.getXML()));
        MultiXMLProviderTest.assertEquals((String)XMLUtil.normalizeXML((String)pr14XML), (String)XMLUtil.normalizeXML((String)this.provider14.getXML()));
    }

    public void testRootWithNameSpaces1() throws Exception {
        MultiXMLProvider provider = new MultiXMLProvider(Arrays.asList(this.provider15, this.provider16));
        this.testRootWithNameSpaces((IXMLProvider)provider);
    }

    public void testRootWithNameSpaces2() throws Exception {
        MultiXMLProvider provider = new MultiXMLProvider(Arrays.asList(this.provider16, this.provider15));
        this.testRootWithNameSpaces((IXMLProvider)provider);
    }

    private void testRootWithNameSpaces(IXMLProvider provider) throws Exception {
        String intersection = "<r:root xmlns:r='http://so_and_so'><e:el xmlns:e=\"http://eeeee\">blah</e:el></r:root>";
        MultiXMLProviderTest.assertEquals((String)XMLUtil.normalizeXML((String)intersection), (String)XMLUtil.normalizeXML((String)provider.getXML()));
        String setXML = "<r:root xmlns:r='http://so_and_so'><e:el xmlns:e=\"http://eeeee\">blah</e:el><e2:el xmlns:e2='http://hohoho'/></r:root>";
        provider.setXML(setXML);
        String pr15XML = "<r:root xmlns:r='http://so_and_so'><e:el xmlns:e='http://eeeee'>blah</e:el><e2:el xmlns:e2='http://hohoho'/></r:root>";
        String pr16XML = "<r:root xmlns:r='http://so_and_so' xmlns:e='http://eeeee'><e:el>blah</e:el><e2:el xmlns:e2='http://hohoho'/></r:root>";
        MultiXMLProviderTest.assertEquals((String)XMLUtil.normalizeXML((String)pr15XML), (String)XMLUtil.normalizeXML((String)this.provider15.getXML()));
        MultiXMLProviderTest.assertEquals((String)XMLUtil.normalizeXML((String)pr16XML), (String)XMLUtil.normalizeXML((String)this.provider16.getXML()));
    }

    private static class TestXMLProvider
    implements IXMLProvider {
        public String xml;

        public TestXMLProvider(String x) {
            this.xml = x;
        }

        public String getRootElementQName() {
            return "root";
        }

        public String getXML() {
            return this.xml;
        }

        public void setXML(String newXML) {
            this.xml = newXML;
        }
    }
}

