/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.ui.xef.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.xs.XSAnnotation;
import org.eclipse.stp.ui.xef.schema.AnnotatedElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractAnnotatedElement
implements AnnotatedElement {
    String displayName;
    String docShort;
    String documentation;
    String category;
    Map<String, Boolean> qualifiers = new HashMap<String, Boolean>();
    List<List<String>> requires = new ArrayList<List<String>>();

    void handleAnnotations(XSAnnotation annotation) {
        if (annotation == null) {
            return;
        }
        this.documentation = AbstractAnnotatedElement.getDocumentation(annotation);
        DocumentImpl domDoc = new DocumentImpl();
        annotation.writeAnnotation((Object)domDoc, (short)3);
        NodeList catNodes = domDoc.getElementsByTagNameNS("http://schemas.eclipse.org/stp/xsd/2006/05/xef", "category");
        this.category = AbstractAnnotatedElement.getTextValue(catNodes);
        NodeList displayNameNodes = domDoc.getElementsByTagNameNS("http://schemas.eclipse.org/stp/xsd/2006/05/xef", "displayName");
        this.displayName = AbstractAnnotatedElement.getI18nTextValue(displayNameNodes);
        NodeList shortDocNodes = domDoc.getElementsByTagNameNS("http://schemas.eclipse.org/stp/xsd/2006/05/xef", "docShort");
        this.docShort = AbstractAnnotatedElement.getI18nTextValue(shortDocNodes);
        NodeList qualifierNodes = domDoc.getElementsByTagNameNS("http://schemas.eclipse.org/stp/xsd/2006/05/xef", "qualifier");
        int i = 0;
        while (i < qualifierNodes.getLength()) {
            Node n = qualifierNodes.item(i);
            String val = AbstractAnnotatedElement.getTextValue(n);
            boolean allowMultiple = "true".equalsIgnoreCase(AbstractAnnotatedElement.getAttributeValue(n, null, "multiple"));
            this.qualifiers.put(val, allowMultiple);
            ++i;
        }
        NodeList requiresNodes = domDoc.getElementsByTagNameNS("http://schemas.eclipse.org/stp/xsd/2006/05/xef", "requires");
        int i2 = 0;
        while (i2 < requiresNodes.getLength()) {
            ArrayList<String> conjunction = new ArrayList<String>();
            Node n = requiresNodes.item(i2);
            NodeList children = n.getChildNodes();
            int j = 0;
            while (j < children.getLength()) {
                Node c = children.item(j);
                if ("http://schemas.eclipse.org/stp/xsd/2006/05/xef".equals(c.getNamespaceURI()) && "element_qname".equals(c.getLocalName())) {
                    conjunction.add(AbstractAnnotatedElement.getTextValue(c));
                }
                ++j;
            }
            if (conjunction.size() > 0) {
                this.requires.add(conjunction);
            }
            ++i2;
        }
    }

    static String getDocumentation(XSAnnotation annotation) {
        if (annotation == null) {
            return null;
        }
        String annotationText = annotation.getAnnotationString();
        if (annotationText == null) {
            return null;
        }
        String docString = AbstractAnnotatedElement.getLanguageDocumentation(annotationText, Locale.getDefault().getISO3Language());
        if (docString == null) {
            docString = AbstractAnnotatedElement.getLanguageDocumentation(annotationText, Locale.getDefault().getLanguage());
        }
        if (docString == null) {
            docString = AbstractAnnotatedElement.getDefaultDocumentation(annotationText);
        }
        return docString;
    }

    static String getDefaultDocumentation(String annotationText) {
        String x = ".*<[^/][a-z]+?:documentation\\s*>(.*?)</[a-z]+?:documentation\\s*>.*";
        return AbstractAnnotatedElement.getPatternMatch(annotationText, x, 1);
    }

    static String getLanguageDocumentation(String annotationText, String langCode) {
        String x = ".*<[^/][a-z]+?:documentation\\s+xml:lang\\s*=\\s*[\"']" + langCode + "[\"']\\s*>(.*?)</[a-z]+?:documentation\\s*>.*";
        return AbstractAnnotatedElement.getPatternMatch(annotationText, x, 1);
    }

    static String getPatternMatch(String text, String pattern, int refNr) {
        Pattern p = Pattern.compile(pattern, 32);
        Matcher m = p.matcher(text);
        if (m.matches()) {
            return m.replaceFirst("$" + refNr);
        }
        return null;
    }

    static String getAttributeValue(Node node, String ns_uri, String attr) {
        Node attrNode = node.getAttributes().getNamedItemNS(ns_uri, attr);
        if (attrNode != null) {
            return attrNode.getTextContent();
        }
        return null;
    }

    static String getTextValue(NodeList nodes) {
        if (nodes.getLength() > 0) {
            return AbstractAnnotatedElement.getTextValue(nodes.item(0));
        }
        return null;
    }

    static String getTextValue(Node node) {
        Node cur = node.getFirstChild();
        while (cur != null) {
            String text;
            if (cur.getNodeType() == 3 && !"".equals(text = cur.getTextContent().trim())) {
                return text;
            }
            cur = cur.getNextSibling();
        }
        return null;
    }

    static String getI18nTextValue(NodeList nodes) {
        Node node = AbstractAnnotatedElement.getI18nNode(nodes, Locale.getDefault().getISO3Language());
        if (node == null) {
            node = AbstractAnnotatedElement.getI18nNode(nodes, Locale.getDefault().getLanguage());
        }
        if (node == null) {
            node = AbstractAnnotatedElement.getI18nNode(nodes, null);
        }
        if (node == null) {
            return null;
        }
        return AbstractAnnotatedElement.getTextValue(node);
    }

    static Node getI18nNode(NodeList nodes, String language) {
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            String lang = AbstractAnnotatedElement.getAttributeValue(node, "http://www.w3.org/XML/1998/namespace", "lang");
            if (language == null && lang == null) {
                return node;
            }
            if (language != null && language.equalsIgnoreCase(lang)) {
                return node;
            }
            ++i;
        }
        return null;
    }

    public String getCategory() {
        return this.category;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDocShort() {
        return this.docShort;
    }

    public String getDocumentation() {
        return this.documentation;
    }
}

