/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.common.utils;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class ResourceUtils {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(ResourceUtils.class);

    protected ResourceUtils() {
    }

    public static IProject getActiveProject() {
        IResource selResource = ResourceUtils.getSelectedResource();
        if (selResource != null) {
            return selResource.getProject();
        }
        return null;
    }

    public static IResource getSelectedResource() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IResource selResource = ResourceUtils.getSelectedResource(page);
        return selResource;
    }

    public static IResource getSelectedResource(IWorkbenchPage page) {
        IResource selResource = null;
        ISelection sel = page.getSelection();
        selResource = ResourceUtils.getSelectedResource(page, sel);
        return selResource;
    }

    public static IResource getSelectedResource(IWorkbenchPage page, ISelection sel) {
        IResource selResource = null;
        if (sel instanceof StructuredSelection) {
            IEditorPart activeEditor;
            IAdaptable adaptable;
            StructuredSelection ssel = (StructuredSelection)sel;
            Object element = ssel.getFirstElement();
            if (element instanceof IResource) {
                selResource = (IResource)element;
            } else if (element instanceof IAdaptable && (selResource = (IResource)(adaptable = (IAdaptable)element).getAdapter(IResource.class)) == null && (activeEditor = page.getActiveEditor()) != null) {
                selResource = (IResource)activeEditor.getAdapter(IResource.class);
            }
        } else if (sel instanceof TextSelection) {
            IEditorPart editor = page.getActiveEditor();
            if (editor == null) {
                return null;
            }
            IEditorInput input = editor.getEditorInput();
            if (input instanceof IFileEditorInput) {
                selResource = ((IFileEditorInput)input).getFile();
            }
        }
        return selResource;
    }

    public static String getFileNameWithoutExt(IPath filePath) {
        String path = filePath.toOSString();
        String fileName = path.substring(path.lastIndexOf(File.separator) + 1, path.length());
        int idx = fileName.indexOf(".");
        if (idx >= 0) {
            return fileName.substring(0, idx);
        }
        return fileName;
    }

    public static void selectAndOpenResource(final IFile resource) {
        Display display;
        final IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (activePage != null && (display = Display.getCurrent()) != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    try {
                        BasicNewResourceWizard.selectAndReveal((IResource)resource, (IWorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                        IEditorPart editor = IDE.openEditor((IWorkbenchPage)activePage, (IFile)resource, (boolean)true);
                        if (editor != null && editor.isDirty()) {
                            editor.doSave(null);
                        }
                    }
                    catch (PartInitException e) {
                        LOG.error((Object)e);
                    }
                }
            });
        }
    }

    public static IFile getFileFromPath(String path) {
        IFile rtnValue = null;
        try {
            if (path != null && path.length() > 0) {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IPath workspacePath = workspace.getRoot().getLocation();
                if (path.startsWith(workspacePath.toOSString())) {
                    path = path.substring(workspacePath.toOSString().length());
                } else if (path.startsWith(workspacePath.toString())) {
                    path = path.substring(workspacePath.toString().length());
                }
                Path newPath = new Path(path);
                rtnValue = workspace.getRoot().getFile((IPath)newPath);
                if (rtnValue == null) {
                    rtnValue = workspace.getRoot().getFileForLocation((IPath)newPath);
                }
            }
        }
        catch (Exception e) {
            rtnValue = null;
            LOG.debug((Object)e);
        }
        return rtnValue;
    }
}

