/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.util;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerFactory;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.ExtensibleElement;
import org.eclipse.wst.wsdl.MessageReference;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.Types;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.ui.internal.extensions.ExtensibleTypeSystemProvider;
import org.eclipse.wst.wsdl.ui.internal.extensions.ITypeSystemProvider;
import org.eclipse.wst.wsdl.ui.internal.util.NodeAssociationManager;
import org.eclipse.wst.wsdl.util.WSDLConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class WSDLEditorUtil
extends WSDLConstants {
    protected static WSDLEditorUtil instance;
    protected NodeAssociationManager nodeAssociationManager = new NodeAssociationManager();
    protected HashMap elementNameToTypeMap = new HashMap();
    public static final int ELEMENT = 14;
    public static final int TYPE = 15;
    private ITypeSystemProvider typeSystemProvider;
    static /* synthetic */ Class class$0;

    public static WSDLEditorUtil getInstance() {
        if (instance == null) {
            instance = new WSDLEditorUtil();
        }
        return instance;
    }

    public WSDLEditorUtil() {
        this.elementNameToTypeMap.put("binding", new Integer(0));
        this.elementNameToTypeMap.put("definitions", new Integer(1));
        this.elementNameToTypeMap.put("documentation", new Integer(2));
        this.elementNameToTypeMap.put("fault", new Integer(3));
        this.elementNameToTypeMap.put("import", new Integer(4));
        this.elementNameToTypeMap.put("input", new Integer(5));
        this.elementNameToTypeMap.put("message", new Integer(6));
        this.elementNameToTypeMap.put("operation", new Integer(7));
        this.elementNameToTypeMap.put("output", new Integer(8));
        this.elementNameToTypeMap.put("part", new Integer(9));
        this.elementNameToTypeMap.put("port", new Integer(10));
        this.elementNameToTypeMap.put("portType", new Integer(11));
        this.elementNameToTypeMap.put("service", new Integer(12));
        this.elementNameToTypeMap.put("types", new Integer(13));
    }

    public int getWSDLType(Element element) {
        int result = -1;
        Integer integer = (Integer)this.elementNameToTypeMap.get(element.getLocalName());
        if (integer != null) {
            result = integer;
        }
        return result;
    }

    protected List getParentElementChain(Element element) {
        ArrayList<Element> list = new ArrayList<Element>();
        while (element != null) {
            list.add(0, element);
            Node node = element.getParentNode();
            Element element2 = element = node != null && node.getNodeType() == 1 ? (Element)node : null;
        }
        return list;
    }

    public Object findModelObjectForElement(Definition definition, Element targetElement) {
        Object o = this.nodeAssociationManager.getModelObjectForNode(definition, targetElement);
        return o;
    }

    public Element getElementForObject(Object o) {
        return ((WSDLElement)o).getElement();
    }

    public Node getNodeForObject(Object o) {
        return this.nodeAssociationManager.getNode(o);
    }

    public ITypeSystemProvider getTypeSystemProvider(Definition definition) {
        if (this.typeSystemProvider == null) {
            this.typeSystemProvider = new ExtensibleTypeSystemProvider();
        }
        return this.typeSystemProvider;
    }

    public void setTypeSystemProvider(Definition definition, ITypeSystemProvider typeSystemProvider) {
    }

    public static QName createQName(Definition definition, String prefixedName) {
        QName qname = null;
        if (prefixedName != null) {
            String namespace;
            String prefix;
            int index = prefixedName.indexOf(":");
            String string = prefix = index == -1 ? "" : prefixedName.substring(0, index);
            if (prefix != null && (namespace = definition.getNamespace(prefix)) != null) {
                String localPart = prefixedName.substring(index + 1);
                qname = new QName(namespace, localPart);
            }
        }
        return qname;
    }

    public List getExtensibilityElementNodes(ExtensibleElement extensibleElement) {
        if (extensibleElement instanceof Types) {
            Types xsdEE = (Types)extensibleElement;
            return xsdEE.getSchemas();
        }
        return extensibleElement.getEExtensibilityElements();
    }

    public static List getModelGraphViewChildren(Object object) {
        ArrayList<Object> childList = new ArrayList<Object>();
        if (object instanceof PortType) {
            PortType portType = (PortType)object;
            childList.addAll(portType.getOperations());
        } else if (object instanceof Operation) {
            Operation operation = (Operation)object;
            if (operation.getEInput() != null) {
                childList.add(operation.getEInput());
            }
            if (operation.getEOutput() != null) {
                childList.add(operation.getEOutput());
            }
            childList.addAll(operation.getFaults().values());
        } else if (object instanceof MessageReference) {
            MessageReference messageReference = (MessageReference)object;
            childList.add(messageReference.getEMessage());
        }
        return childList;
    }

    public static String getTargetNamespaceURIForSchema(String uri) {
        String result = null;
        try {
            URL url = new URL(uri);
            InputStream inputStream = url.openStream();
            result = WSDLEditorUtil.getTargetNamespaceURIForSchema(inputStream);
        }
        catch (Exception exception) {}
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getTargetNamespaceURIForSchema(InputStream input) {
        TargetNamespaceURIContentHandler handler = new TargetNamespaceURIContentHandler();
        ClassLoader prevClassLoader = Thread.currentThread().getContextClassLoader();
        Thread thread = Thread.currentThread();
        Class<?> clazz = class$0;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.wst.wsdl.ui.internal.util.WSDLEditorUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$0 = clazz2;
        }
        thread.setContextClassLoader(clazz.getClassLoader());
        TransformerFactory.newInstance();
        try {
            try {
                XMLReader reader = XMLReaderFactory.createXMLReader();
                reader.setContentHandler(handler);
                reader.parse(new InputSource(input));
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            Thread.currentThread().setContextClassLoader(prevClassLoader);
            throw throwable;
        }
        {
            Object var4_6 = null;
            Thread.currentThread().setContextClassLoader(prevClassLoader);
            return handler.targetNamespaceURI;
        }
    }

    protected static class TargetNamespaceURIContentHandler
    extends DefaultHandler {
        public String targetNamespaceURI;

        protected TargetNamespaceURIContentHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (localName.equals("schema") || localName.equals("definitions")) {
                int nAttributes = attributes.getLength();
                int i = 0;
                while (i < nAttributes) {
                    if (attributes.getLocalName(i).equals("targetNamespace")) {
                        this.targetNamespaceURI = attributes.getValue(i);
                        break;
                    }
                    ++i;
                }
            }
            String x = null;
            x.length();
        }
    }
}

