/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jpt.core.internal.mappings.IMultiRelationshipMapping;
import org.eclipse.jpt.core.internal.mappings.IOneToMany;
import org.eclipse.jpt.ui.internal.details.BaseJpaComposite;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.mappings.details.CascadeComposite;
import org.eclipse.jpt.ui.internal.mappings.details.CommonWidgets;
import org.eclipse.jpt.ui.internal.mappings.details.EnumComboViewer;
import org.eclipse.jpt.ui.internal.mappings.details.JoinTableComposite;
import org.eclipse.jpt.ui.internal.mappings.details.MappedByCombo;
import org.eclipse.jpt.ui.internal.mappings.details.OrderingComposite;
import org.eclipse.jpt.ui.internal.mappings.details.TargetEntityChooser;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class OneToManyComposite
extends BaseJpaComposite {
    private IOneToMany oneToMany;
    private EnumComboViewer fetchTypeComboViewer;
    private TargetEntityChooser targetEntityChooser;
    private MappedByCombo mappedByCombo;
    private CascadeComposite cascadeComposite;
    private OrderingComposite orderingComposite;
    private JoinTableComposite joinTableComposite;

    public OneToManyComposite(Composite parent, CommandStack commandStack, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(parent, 0, commandStack, widgetFactory);
    }

    protected void initializeLayout(Composite composite) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        Control generalControl = this.buildGeneralControl(composite);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        generalControl.setLayoutData((Object)gridData);
        Control joinTableControl = this.buildJoinTableControl(composite);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        joinTableControl.setLayoutData((Object)gridData);
    }

    private Control buildGeneralControl(Composite composite) {
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        Composite generalComposite = this.getWidgetFactory().createComposite(composite);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        generalComposite.setLayout((Layout)layout);
        this.targetEntityChooser = CommonWidgets.buildTargetEntityChooser(generalComposite, this.commandStack, this.getWidgetFactory());
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        this.targetEntityChooser.getControl().setLayoutData((Object)gridData);
        CommonWidgets.buildFetchLabel(generalComposite, this.getWidgetFactory());
        this.fetchTypeComboViewer = CommonWidgets.buildFetchTypeComboViewer(generalComposite, this.commandStack, this.getWidgetFactory());
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        this.fetchTypeComboViewer.getControl().setLayoutData((Object)gridData);
        helpSystem.setHelp(this.fetchTypeComboViewer.getControl(), "org.eclipse.jpt.ui.mapping_fetchType");
        CommonWidgets.buildMappedByLabel(generalComposite, this.getWidgetFactory());
        this.mappedByCombo = new MappedByCombo(generalComposite, this.commandStack, this.getWidgetFactory());
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        this.mappedByCombo.getControl().setLayoutData((Object)gridData);
        helpSystem.setHelp(this.mappedByCombo.getControl(), "org.eclipse.jpt.ui.mapping_mappedBy");
        this.cascadeComposite = new CascadeComposite(generalComposite, this.commandStack, this.getWidgetFactory());
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.cascadeComposite.getControl().setLayoutData((Object)gridData);
        this.orderingComposite = new OrderingComposite(generalComposite, this.commandStack, this.getWidgetFactory());
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.orderingComposite.getControl().setLayoutData((Object)gridData);
        return generalComposite;
    }

    private Control buildJoinTableControl(Composite composite) {
        Section section = this.getWidgetFactory().createSection(composite, 8388866);
        section.setText(JptUiMappingsMessages.MultiRelationshipMappingComposite_joinTable);
        Composite joinTableClient = this.getWidgetFactory().createComposite((Composite)section);
        section.setClient((Control)joinTableClient);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        joinTableClient.setLayout((Layout)layout);
        this.joinTableComposite = new JoinTableComposite(joinTableClient, this.commandStack, this.getWidgetFactory());
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.joinTableComposite.getControl().setLayoutData((Object)gridData);
        return section;
    }

    public void doPopulate(EObject obj) {
        this.oneToMany = (IOneToMany)obj;
        this.fetchTypeComboViewer.populate(CommonWidgets.buildMultiRelationshipMappingFetchEnumHolder((IMultiRelationshipMapping)this.oneToMany));
        this.targetEntityChooser.populate((EObject)this.oneToMany);
        this.mappedByCombo.populate((EObject)this.oneToMany);
        this.cascadeComposite.populate((EObject)this.oneToMany);
        if (this.oneToMany != null) {
            this.joinTableComposite.populate((EObject)this.oneToMany.getJoinTable());
            this.orderingComposite.populate((EObject)this.oneToMany);
        } else {
            this.joinTableComposite.populate(null);
            this.orderingComposite.populate(null);
        }
    }

    public void doPopulate() {
        this.fetchTypeComboViewer.populate();
        this.targetEntityChooser.populate();
        this.mappedByCombo.populate();
        this.cascadeComposite.populate();
        this.joinTableComposite.populate();
        this.orderingComposite.populate();
    }

    protected void engageListeners() {
    }

    protected void disengageListeners() {
    }

    public void dispose() {
        this.fetchTypeComboViewer.dispose();
        this.targetEntityChooser.dispose();
        this.mappedByCombo.dispose();
        this.cascadeComposite.dispose();
        this.joinTableComposite.dispose();
        this.orderingComposite.dispose();
        super.dispose();
    }
}

