/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IDiagramPreferenceSupport;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IPrimaryEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.l10n.DiagramUIPluginImages;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramCommandStack;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequestFactory;
import org.eclipse.gmf.runtime.diagram.ui.util.SelectInDiagramHelper;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

public class ConnectionCreationTool
extends org.eclipse.gef.tools.ConnectionCreationTool {
    private boolean antiScroll = false;
    private IElementType elementType = null;
    private boolean avoidDeactivation = false;
    private boolean isCtrlKeyDown;
    private static Cursor CURSOR_CONNECTION = new Cursor((Device)Display.getDefault(), DiagramUIPluginImages.DESC_CONNECTION_CURSOR_SOURCE.getImageData(), DiagramUIPluginImages.DESC_CONNECTION_CURSOR_MASK.getImageData(), 0, 0);
    private static Cursor CURSOR_CONNECTION_NOT = new Cursor((Device)Display.getDefault(), DiagramUIPluginImages.DESC_NO_CONNECTION_CURSOR_SOURCE.getImageData(), DiagramUIPluginImages.DESC_NO_CONNECTION_CURSOR_MASK.getImageData(), 0, 0);
    private static Cursor CURSOR_TARGET_MENU = new Cursor((Device)Display.getDefault(), 21);

    public ConnectionCreationTool() {
        this.setUnloadWhenFinished(true);
        this.setDefaultCursor(CURSOR_CONNECTION);
        this.setDisabledCursor(CURSOR_CONNECTION_NOT);
    }

    public ConnectionCreationTool(IElementType elementType) {
        this();
        this.setSemanticRequestType(elementType);
    }

    protected IElementType getElementType() {
        return this.elementType;
    }

    protected void setSemanticRequestType(IElementType elementType) {
        this.elementType = elementType;
    }

    protected PreferencesHint getPreferencesHint() {
        RootEditPart rootEP;
        EditPartViewer viewer = this.getCurrentViewer();
        if (viewer != null && (rootEP = viewer.getRootEditPart()) instanceof IDiagramPreferenceSupport) {
            return ((IDiagramPreferenceSupport)rootEP).getPreferencesHint();
        }
        return PreferencesHint.USE_DEFAULTS;
    }

    protected Request createTargetRequest() {
        return CreateViewRequestFactory.getCreateConnectionRequest(this.getElementType(), this.getPreferencesHint());
    }

    public void deactivate() {
        if (!this.avoidDeactivation()) {
            super.deactivate();
            this.setTargetRequest(null);
        }
    }

    protected void eraseSourceFeedback() {
        if (!this.avoidDeactivation()) {
            super.eraseSourceFeedback();
        }
    }

    protected boolean handleButtonUp(int button) {
        this.setCtrlKeyDown(this.getCurrentInput().isControlKeyDown());
        if (this.isInState(64)) {
            this.handleCreateConnection();
        }
        this.setState(0x40000000);
        if (this.isInState(0x40000008)) {
            this.handleFinished();
        }
        return true;
    }

    protected void handleFinished() {
        if (!this.isCtrlKeyDown()) {
            super.handleFinished();
        } else {
            this.reactivate();
        }
    }

    protected void selectAddedObject(EditPartViewer viewer, Collection objects) {
        final ArrayList editparts = new ArrayList();
        final EditPart[] primaryEP = new EditPart[1];
        for (Object object : objects) {
            if (!(object instanceof IAdaptable)) continue;
            Object editPart = viewer.getEditPartRegistry().get(((IAdaptable)object).getAdapter(View.class));
            if (editPart instanceof IPrimaryEditPart) {
                editparts.add(editPart);
            }
            if (!(editPart instanceof ShapeEditPart)) continue;
            primaryEP[0] = (ShapeEditPart)editPart;
        }
        if (!editparts.isEmpty()) {
            viewer.setSelection((ISelection)new StructuredSelection(editparts));
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    if (primaryEP[0] == null) {
                        primaryEP[0] = (EditPart)editparts.get(0);
                    }
                    if (primaryEP[0].isActive()) {
                        primaryEP[0].performRequest(new Request((Object)"direct edit"));
                    }
                }
            });
        }
    }

    protected boolean handleDoubleClick(int button) {
        this.createConnection();
        return true;
    }

    protected void createConnection() {
        List selectedEditParts = this.getCurrentViewer().getSelectedEditParts();
        if (!selectedEditParts.isEmpty()) {
            IGraphicalEditPart sourceEditPart = (IGraphicalEditPart)selectedEditParts.get(0);
            IGraphicalEditPart targetEditPart = selectedEditParts.size() == 2 ? (IGraphicalEditPart)selectedEditParts.get(1) : sourceEditPart;
            CreateConnectionRequest connectionRequest = (CreateConnectionRequest)this.createTargetRequest();
            connectionRequest.setTargetEditPart((EditPart)sourceEditPart);
            connectionRequest.setType((Object)"connection start");
            connectionRequest.setLocation(new Point(0, 0));
            if (sourceEditPart.getCommand((Request)connectionRequest) != null) {
                connectionRequest.setSourceEditPart((EditPart)sourceEditPart);
                connectionRequest.setTargetEditPart((EditPart)targetEditPart);
                connectionRequest.setType((Object)"connection end");
                connectionRequest.setLocation(new Point(0, 0));
                Command command = targetEditPart.getCommand((Request)connectionRequest);
                if (command != null) {
                    this.setCurrentCommand(command);
                    this.antiScroll = true;
                    this.executeCurrentCommand();
                    this.antiScroll = false;
                    this.selectAddedObject(this.getCurrentViewer(), DiagramCommandStack.getReturnValues(command));
                }
            }
            this.deactivate();
        }
    }

    protected boolean handleKeyUp(KeyEvent e) {
        if (e.keyCode == 13) {
            this.setEditDomain(this.getCurrentViewer().getEditDomain());
            this.createConnection();
            return true;
        }
        return false;
    }

    protected boolean handleCreateConnection() {
        this.setAvoidDeactivation(true);
        EditPartViewer viewer = this.getCurrentViewer();
        Command endCommand = this.getCommand();
        this.setCurrentCommand(endCommand);
        this.antiScroll = true;
        this.executeCurrentCommand();
        this.antiScroll = false;
        this.selectAddedObject(viewer, DiagramCommandStack.getReturnValues(endCommand));
        this.setAvoidDeactivation(false);
        this.eraseSourceFeedback();
        this.deactivate();
        return true;
    }

    protected boolean avoidDeactivation() {
        return this.avoidDeactivation;
    }

    protected void setAvoidDeactivation(boolean avoidDeactivation) {
        this.avoidDeactivation = avoidDeactivation;
    }

    protected boolean isCtrlKeyDown() {
        return this.isCtrlKeyDown;
    }

    protected void setCtrlKeyDown(boolean isCtrlKeyDown) {
        this.isCtrlKeyDown = isCtrlKeyDown;
    }

    protected boolean handleMove() {
        if (!this.antiScroll) {
            boolean cont;
            boolean bool = super.handleMove();
            boolean bl = cont = this.getState() == 64 && (this.getCurrentCommand() == null || this.getCurrentCommand() != null && this.getCurrentCommand().canExecute());
            if (cont && this.getTargetEditPart() != null && this.getTargetEditPart().getViewer() instanceof ScrollingGraphicalViewer && this.getTargetEditPart().getViewer().getControl() instanceof FigureCanvas) {
                FigureCanvas figureCanvas = (FigureCanvas)((ScrollingGraphicalViewer)this.getTargetEditPart().getViewer()).getControl();
                Point location1 = this.getLocation().getCopy();
                SelectInDiagramHelper.exposeLocation(figureCanvas, location1);
            }
            return bool;
        }
        return false;
    }

    protected void doAutoexpose() {
        if (!this.antiScroll) {
            super.doAutoexpose();
        }
    }

    protected Command getCommand() {
        if (!this.antiScroll) {
            return super.getCommand();
        }
        return null;
    }

    protected Cursor calculateCursor() {
        EditPart ep;
        Command command = this.getCurrentCommand();
        if (command != null && command.canExecute() && ((ep = this.getTargetEditPart()) instanceof DiagramEditPart || ep instanceof CompartmentEditPart)) {
            return CURSOR_TARGET_MENU;
        }
        return super.calculateCursor();
    }
}

