/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.jsflibraryconfiguration.internal;

import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryInternalReference;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryRegistryUtil;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.PluginProvidedJSFLibrary;
import org.eclipse.jst.jsf.core.jsflibraryconfiguration.JSFLibraryConfigurationHelper;
import org.eclipse.jst.jsf.core.jsflibraryconfiguration.JSFLibraryReference;
import org.eclipse.jst.jsf.core.jsflibraryconfiguration.JSFLibraryReferenceServerSupplied;
import org.eclipse.jst.jsf.core.jsflibraryconfiguration.internal.JSFLibraryReferencePluginProvidedImpl;
import org.eclipse.jst.jsf.core.jsflibraryconfiguration.internal.JSFLibraryReferenceServerSuppliedImpl;
import org.eclipse.jst.jsf.core.jsflibraryconfiguration.internal.JSFLibraryReferenceUserDefinedImpl;

public class JSFLibraryReferenceFacadeFactory {
    public static JSFLibraryReference create(IClasspathEntry cpEntry) {
        if (JSFLibraryConfigurationHelper.isJSFLibraryContainer(cpEntry)) {
            return JSFLibraryReferenceFacadeFactory.createReference(cpEntry);
        }
        return null;
    }

    public static JSFLibraryReferenceServerSupplied createServerSuppliedJSFLibRef() {
        return new JSFLibraryReferenceServerSuppliedImpl();
    }

    private static JSFLibraryReference createReference(IClasspathEntry cpEntry) {
        String libID = cpEntry.getPath().segment(1).toString();
        JSFLibraryInternalReference libRef = JSFLibraryRegistryUtil.getInstance().getJSFLibraryReferencebyID(libID);
        if (libRef != null) {
            boolean isDeployed = JSFLibraryReferenceFacadeFactory.getJ2EEModuleDependency(cpEntry);
            if (libRef.getLibrary() != null && libRef.getLibrary() instanceof PluginProvidedJSFLibrary) {
                return new JSFLibraryReferencePluginProvidedImpl(libRef, isDeployed);
            }
            return new JSFLibraryReferenceUserDefinedImpl(libRef, isDeployed);
        }
        return null;
    }

    private static boolean getJ2EEModuleDependency(IClasspathEntry cpEntry) {
        IClasspathAttribute[] attrs = cpEntry.getExtraAttributes();
        int i = 0;
        while (i < attrs.length) {
            IClasspathAttribute attr = attrs[i];
            if (attr.getName().equals("org.eclipse.jst.component.dependency")) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

