/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.jsflibraryregistry.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.Messages;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.ArchiveFile;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibrary;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibraryRegistryFactory;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFVersion;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.PluginProvidedJSFLibrary;
import org.eclipse.jst.jsf.core.jsflibraryregistry.PluginProvidedJSFLibraryArchiveFilesDelegate;
import org.eclipse.osgi.util.NLS;

public final class PluginProvidedJSFLibraryCreationHelper2 {
    private PluginProvidedJSFLibrary newLib;
    private IConfigurationElement config_element;
    private String relativeDestLocation = "WEB-INF/lib";
    public static final String NAME = "name";
    public static final String IS_IMPL = "isImplementation";
    public static final String VERSION = "maxVersionSupported";
    public static final String DELEGATE = "archiveFilesDelegate";
    public static final String LABEL = "label";

    public PluginProvidedJSFLibraryCreationHelper2(IConfigurationElement jsfLibrary) {
        this.config_element = jsfLibrary;
    }

    public void addArchiveFile(String pluginRootRelativePath) {
        ArchiveFile jar = this.createArchiveFile(pluginRootRelativePath);
        if (!this.newLib.containsArchiveFile(jar.getSourceLocation())) {
            this.newLib.getArchiveFiles().add((Object)jar);
        }
    }

    public JSFLibrary create() {
        this.newLib = JSFLibraryRegistryFactory.eINSTANCE.createPluginProvidedJSFLibrary();
        this.newLib.setPluginID(this.getPluginID());
        this.newLib.setName(this.config_element.getAttribute(NAME));
        String label = this.config_element.getAttribute(LABEL);
        if (label != null && label.length() > 0) {
            this.newLib.setLabel(label);
        }
        this.newLib.setImplementation(this.config_element.getAttribute(IS_IMPL).equals("true"));
        this.newLib.setJSFVersion(JSFVersion.getJSFVersion(this.config_element.getAttribute(VERSION)));
        try {
            this.addArchives();
            return this.newLib;
        }
        catch (Exception e) {
            JSFCorePlugin.log(e, NLS.bind((String)Messages.PluginProvidedJSFLibraryCreationHelper_ErrorCreating, (Object)this.newLib.getName()));
            return null;
        }
    }

    private void addArchives() throws CoreException {
        PluginProvidedJSFLibraryArchiveFilesDelegate jarCol = null;
        jarCol = (PluginProvidedJSFLibraryArchiveFilesDelegate)this.config_element.createExecutableExtension(DELEGATE);
        if (jarCol != null) {
            jarCol.setCreationHelper(this);
            jarCol.getArchiveFiles();
        }
    }

    private ArchiveFile createArchiveFile(String pluginRootRelativePath) {
        ArchiveFile file = JSFLibraryRegistryFactory.eINSTANCE.createArchiveFile();
        file.setRelativeToWorkspace(false);
        file.setSourceLocation(pluginRootRelativePath);
        file.setRelativeDestLocation(this.relativeDestLocation);
        return file;
    }

    private String getPluginID() {
        return this.config_element.getDeclaringExtension().getContributor().getName();
    }
}

