/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.sca.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.introspection.FeatureAdapter;
import org.eclipse.stp.core.sca.SCAObject;

public class FeatureAwareList
implements EList {
    private final EStructuralFeature abstractFeature;
    private final FeatureMap.Internal featureMap;
    private final EList modelList;

    public FeatureAwareList(EStructuralFeature anAbstractFeature, FeatureMap.Internal aFeatureMap) {
        this.abstractFeature = anAbstractFeature;
        this.featureMap = aFeatureMap;
        this.modelList = this.featureMap.list(this.abstractFeature);
    }

    public void add(int index, Object o) {
        Assert.isTrue((boolean)(o instanceof SCAObject));
        SCAObject scaObj = (SCAObject)o;
        EStructuralFeature subfeature = FeatureAdapter.getFeature(scaObj);
        Assert.isNotNull((Object)subfeature);
        this.featureMap.list(subfeature).add(index, (Object)scaObj);
    }

    public boolean add(Object o) {
        Assert.isTrue((boolean)(o instanceof SCAObject));
        SCAObject scaObj = (SCAObject)o;
        EStructuralFeature subfeature = FeatureAdapter.getFeature(scaObj);
        Assert.isNotNull((Object)subfeature);
        return this.featureMap.list(subfeature).add((Object)scaObj);
    }

    public boolean addAll(Collection c) {
        return this.addAll(0, c);
    }

    public boolean addAll(int index, Collection c) {
        int initialSize = this.featureMap.size();
        for (Object o : c) {
            Assert.isTrue((boolean)(o instanceof SCAObject));
            SCAObject scaObj = (SCAObject)o;
            EStructuralFeature subfeature = FeatureAdapter.getFeature(scaObj);
            Assert.isNotNull((Object)subfeature);
            this.featureMap.list(subfeature).add(index, Collections.singletonList(scaObj));
        }
        return this.featureMap.size() > initialSize;
    }

    public void clear() {
        this.modelList.clear();
    }

    public boolean contains(Object o) {
        return this.modelList.contains(o);
    }

    public boolean containsAll(Collection c) {
        return this.modelList.containsAll(c);
    }

    public boolean equals(Object o) {
        return this.modelList.equals(o);
    }

    public Object get(int index) {
        return this.modelList.get(index);
    }

    public int hashCode() {
        return this.modelList.hashCode();
    }

    public int indexOf(Object o) {
        return this.modelList.indexOf(o);
    }

    public boolean isEmpty() {
        return this.modelList.isEmpty();
    }

    public Iterator iterator() {
        return this.modelList.iterator();
    }

    public int lastIndexOf(Object o) {
        return this.modelList.lastIndexOf(o);
    }

    public ListIterator listIterator() {
        return this.modelList.listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.modelList.listIterator(index);
    }

    public Object remove(int index) {
        return this.modelList.remove(index);
    }

    public boolean remove(Object o) {
        return this.modelList.remove(o);
    }

    public boolean removeAll(Collection c) {
        return this.modelList.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        return this.modelList.retainAll(c);
    }

    public Object set(int index, Object element) {
        return this.modelList.set(index, element);
    }

    public int size() {
        return this.modelList.size();
    }

    public List subList(int fromIndex, int toIndex) {
        return this.modelList.subList(fromIndex, toIndex);
    }

    public Object[] toArray() {
        return this.modelList.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.modelList.toArray(a);
    }

    public void move(int newPosition, Object object) {
        this.modelList.move(newPosition, object);
    }

    public Object move(int newPosition, int oldPosition) {
        return this.modelList.move(newPosition, oldPosition);
    }
}

