/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.query.ocl.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.query.ocl.internal.OCLDebugOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLPlugin
extends EMFPlugin {
    protected static final String PARENTHESIS_OPEN = "(";
    protected static final String PARENTHESIS_CLOSE = ")";
    protected static final String PREFIX_CHANGING = "CHANGING ";
    protected static final String PREFIX_CATCHING = "CAUGHT ";
    protected static final String PREFIX_THROWING = "THROWN ";
    protected static final String PREFIX_ENTERING = "ENTERING ";
    protected static final String PREFIX_EXITING = "EXITING ";
    protected static final String SEPARATOR_METHOD = "#";
    protected static final String SEPARATOR_PARAMETER = ", ";
    protected static final String SEPARATOR_RETURN = ":";
    protected static final String SEPARATOR_SPACE = " ";
    protected static final String LABEL_OLD_VALUE = "old=";
    protected static final String LABEL_NEW_VALUE = "new=";
    public static final OCLPlugin INSTANCE = new OCLPlugin();
    private static Implementation plugin;

    public OCLPlugin() {
        super(new ResourceLocator[0]);
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    public static void catching(Class<?> class1, String functionName, Throwable exception) {
        Tracing.catching(OCLDebugOptions.EXCEPTIONS_CATCHING, class1, functionName, exception);
    }

    public static void throwing(Class<?> class1, String functionName, Throwable exception) {
        Tracing.throwing(OCLDebugOptions.EXCEPTIONS_THROWING, class1, functionName, exception);
    }

    public static void log(int code, String message, Throwable exception) {
        Status s = new Status(1, plugin.getSymbolicName(), code, message != null ? message : "", exception);
        OCLPlugin.getPlugin().log(s);
    }

    public static void warning(int code, String message, Throwable exception) {
        Status s = new Status(2, plugin.getSymbolicName(), code, message != null ? message : "", exception);
        OCLPlugin.getPlugin().log(s);
    }

    public static class Implementation
    extends EMFPlugin.EclipsePlugin {
        public Implementation() {
            plugin = this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Tracing {
        private static final Map<String, Object> cachedOptions = new HashMap<String, Object>();

        protected static boolean shouldTrace() {
            return plugin.isDebugging();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean shouldTrace(String option) {
            if (Tracing.shouldTrace()) {
                Boolean value = null;
                Map<String, Object> map = cachedOptions;
                synchronized (map) {
                    value = (Boolean)cachedOptions.get(option);
                    if (value == null) {
                        value = new Boolean(Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)option)));
                        cachedOptions.put(option, value);
                    }
                }
                return value;
            }
            return false;
        }

        protected static String getArgumentString(Object argument) {
            return String.valueOf(argument);
        }

        protected static String getArgumentsString(Object[] arguments) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < arguments.length) {
                buffer.append(Tracing.getArgumentString(arguments[i]));
                if (i < arguments.length - 1) {
                    buffer.append(OCLPlugin.SEPARATOR_PARAMETER);
                }
                ++i;
            }
            return buffer.toString();
        }

        public static void trace(String message) {
            if (Tracing.shouldTrace()) {
                System.out.println(message);
            }
        }

        public static void trace(String option, String message) {
            if (Tracing.shouldTrace(option)) {
                Tracing.trace(message);
            }
        }

        public static void changing(String option, String valueDescription, Object oldValue, Object newValue) {
            if (Tracing.shouldTrace(option)) {
                Tracing.trace(OCLPlugin.PREFIX_CHANGING + valueDescription + OCLPlugin.SEPARATOR_SPACE + OCLPlugin.LABEL_OLD_VALUE + Tracing.getArgumentString(oldValue) + OCLPlugin.SEPARATOR_PARAMETER + OCLPlugin.LABEL_NEW_VALUE + Tracing.getArgumentString(newValue));
            }
        }

        public static void changing(String option, Class<?> clazz, String methodName, String valueDescription, Object oldValue, Object newValue) {
            if (Tracing.shouldTrace(option)) {
                Tracing.trace(OCLPlugin.PREFIX_CHANGING + valueDescription + OCLPlugin.SEPARATOR_SPACE + OCLPlugin.LABEL_OLD_VALUE + Tracing.getArgumentString(oldValue) + OCLPlugin.SEPARATOR_PARAMETER + OCLPlugin.LABEL_NEW_VALUE + Tracing.getArgumentString(newValue) + OCLPlugin.SEPARATOR_SPACE + OCLPlugin.PARENTHESIS_OPEN + clazz.getName() + OCLPlugin.SEPARATOR_METHOD + methodName + OCLPlugin.PARENTHESIS_CLOSE);
            }
        }

        public static void catching(String option, Class<?> clazz, String methodName, Throwable throwable) {
            if (Tracing.shouldTrace(option)) {
                Tracing.trace(OCLPlugin.PREFIX_CATCHING + throwable.getMessage() + OCLPlugin.SEPARATOR_SPACE + OCLPlugin.PARENTHESIS_OPEN + clazz.getName() + OCLPlugin.SEPARATOR_METHOD + methodName + OCLPlugin.PARENTHESIS_CLOSE);
                throwable.printStackTrace(System.err);
            }
        }

        public static void throwing(String option, Class<?> clazz, String methodName, Throwable throwable) {
            if (Tracing.shouldTrace(option)) {
                Tracing.trace(OCLPlugin.PREFIX_THROWING + throwable.getMessage() + OCLPlugin.SEPARATOR_SPACE + OCLPlugin.PARENTHESIS_OPEN + clazz.getName() + OCLPlugin.SEPARATOR_METHOD + methodName + OCLPlugin.PARENTHESIS_CLOSE);
                throwable.printStackTrace(System.err);
            }
        }

        public static void entering(String option, Class<?> clazz, String methodName) {
            if (Tracing.shouldTrace(option)) {
                Tracing.trace(OCLPlugin.PREFIX_ENTERING + clazz.getName() + OCLPlugin.SEPARATOR_METHOD + methodName);
            }
        }

        public static void entering(String option, Class<?> clazz, String methodName, Object parameter) {
            if (Tracing.shouldTrace(option)) {
                Tracing.trace(OCLPlugin.PREFIX_ENTERING + clazz.getName() + OCLPlugin.SEPARATOR_METHOD + methodName + OCLPlugin.PARENTHESIS_OPEN + Tracing.getArgumentString(parameter) + OCLPlugin.PARENTHESIS_CLOSE);
            }
        }

        public static void entering(String option, Class<?> clazz, String methodName, Object[] parameters) {
            if (Tracing.shouldTrace(option)) {
                Tracing.trace(OCLPlugin.PREFIX_ENTERING + clazz.getName() + OCLPlugin.SEPARATOR_METHOD + methodName + OCLPlugin.PARENTHESIS_OPEN + Tracing.getArgumentsString(parameters) + OCLPlugin.PARENTHESIS_CLOSE);
            }
        }

        public static void exiting(String option, Class<?> clazz, String methodName) {
            if (Tracing.shouldTrace(option)) {
                Tracing.trace(OCLPlugin.PREFIX_EXITING + clazz.getName() + OCLPlugin.SEPARATOR_METHOD + methodName);
            }
        }

        public static void exiting(String option, Class<?> clazz, String methodName, Object returnValue) {
            if (Tracing.shouldTrace(option)) {
                Tracing.trace(OCLPlugin.PREFIX_EXITING + clazz.getName() + OCLPlugin.SEPARATOR_METHOD + methodName + OCLPlugin.SEPARATOR_RETURN + Tracing.getArgumentString(returnValue));
            }
        }
    }
}

