/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.deploy.wtp;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerPort;

public final class WtpUtils {
    private static final String SEPARATOR = "/";
    private static final LoggingProxy LOG = LoggingProxy.getlogger(WtpUtils.class);
    private static final String PORT_NAME_HTTP = "HTTP";

    private WtpUtils() {
    }

    public static String getServerUrl(IFile wsdlFile) throws CoreException {
        IServer[] servers;
        IProject project = wsdlFile.getProject();
        String urlPattern = SEPARATOR + project.getName();
        urlPattern = String.valueOf(urlPattern) + "/celtix/";
        urlPattern = String.valueOf(urlPattern) + wsdlFile.getName().substring(0, wsdlFile.getName().lastIndexOf("."));
        IRuntime runtime = null;
        Set projects = ProjectFacetsManager.getFacetedProjects();
        for (IFacetedProject fProject : projects) {
            if (!fProject.getProject().getName().equals(project.getName())) continue;
            runtime = fProject.getPrimaryRuntime();
            break;
        }
        if (runtime == null) {
            LOG.debug((Object)"no primary runtime for this project, return null url");
            return null;
        }
        IServer[] iServerArray = servers = ServerCore.getServers();
        int n = servers.length;
        int n2 = 0;
        while (n2 < n) {
            IServer server = iServerArray[n2];
            if (server.getRuntime().getName().equals(runtime.getName())) {
                ServerPort[] ports;
                String url = "http://" + server.getHost();
                ServerPort[] serverPortArray = ports = server.getServerPorts(null);
                int n3 = ports.length;
                int n4 = 0;
                while (n4 < n3) {
                    ServerPort port = serverPortArray[n4];
                    if (port.getName().equals(PORT_NAME_HTTP)) {
                        url = String.valueOf(url) + ":" + Integer.toString(port.getPort());
                        url = String.valueOf(url) + urlPattern;
                        LOG.debug((Object)("server url:" + url));
                        return url;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }
}

